/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlFunctionalOperator;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.type.ArraySqlType;
import org.apache.calcite.sql.type.MultisetSqlType;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeName;

public class SqlUnnestOperator
extends SqlFunctionalOperator {
    public final boolean withOrdinality;
    public static final String ORDINALITY_COLUMN_NAME = "ORDINALITY";

    public SqlUnnestOperator(boolean withOrdinality) {
        super("UNNEST", SqlKind.UNNEST, 200, true, null, null, (SqlOperandTypeChecker)OperandTypes.SCALAR_OR_RECORD_COLLECTION);
        this.withOrdinality = withOrdinality;
    }

    @Override
    public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
        RelDataType type = opBinding.getOperandType(0);
        if (type.isStruct()) {
            type = type.getFieldList().get(0).getType();
        }
        assert (type instanceof ArraySqlType || type instanceof MultisetSqlType);
        if (this.withOrdinality) {
            RelDataTypeFactory.FieldInfoBuilder builder = opBinding.getTypeFactory().builder();
            if (type.getComponentType().isStruct()) {
                builder.addAll(type.getComponentType().getFieldList());
            } else {
                builder.add(SqlUtil.deriveAliasFromOrdinal(0), type.getComponentType());
            }
            return builder.add(ORDINALITY_COLUMN_NAME, SqlTypeName.INTEGER).build();
        }
        return type.getComponentType();
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        super.unparse(writer, call, leftPrec, rightPrec);
        if (this.withOrdinality) {
            writer.keyword("WITH ORDINALITY");
        }
    }

    @Override
    public boolean argumentMustBeScalar(int ordinal) {
        return false;
    }
}

