/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.type;

import java.util.Collections;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeComparability;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.type.SameOperandTypeChecker;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.flink.shaded.calcite.com.google.common.base.Preconditions;

public class ComparableOperandTypeChecker
extends SameOperandTypeChecker {
    private final RelDataTypeComparability requiredComparability;
    private final SqlOperandTypeChecker.Consistency consistency;

    @Deprecated
    public ComparableOperandTypeChecker(int nOperands, RelDataTypeComparability requiredComparability) {
        this(nOperands, requiredComparability, SqlOperandTypeChecker.Consistency.NONE);
    }

    public ComparableOperandTypeChecker(int nOperands, RelDataTypeComparability requiredComparability, SqlOperandTypeChecker.Consistency consistency) {
        super(nOperands);
        this.requiredComparability = requiredComparability;
        this.consistency = Preconditions.checkNotNull(consistency);
    }

    @Override
    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        boolean b = true;
        for (int i = 0; i < this.nOperands; ++i) {
            RelDataType type = callBinding.getOperandType(i);
            if (this.checkType(callBinding, throwOnFailure, type)) continue;
            b = false;
        }
        if (b && !(b = super.checkOperandTypes(callBinding, false)) && throwOnFailure) {
            throw callBinding.newValidationSignatureError();
        }
        return b;
    }

    private boolean checkType(SqlCallBinding callBinding, boolean throwOnFailure, RelDataType type) {
        if (type.getComparability().ordinal() < this.requiredComparability.ordinal()) {
            if (throwOnFailure) {
                throw callBinding.newValidationSignatureError();
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean checkOperandTypes(SqlOperatorBinding callBinding) {
        boolean b = true;
        for (int i = 0; i < this.nOperands; ++i) {
            RelDataType type = callBinding.getOperandType(i);
            boolean result = type.getComparability().ordinal() >= this.requiredComparability.ordinal();
            if (result) continue;
            b = false;
        }
        if (b) {
            b = super.checkOperandTypes(callBinding);
        }
        return b;
    }

    @Override
    public String getAllowedSignatures(SqlOperator op, String opName) {
        return SqlUtil.getAliasedSignature(op, opName, Collections.nCopies(this.nOperands, "COMPARABLE_TYPE"));
    }

    @Override
    public SqlOperandTypeChecker.Consistency getConsistency() {
        return this.consistency;
    }
}

