/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.validate;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.AbstractList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.calcite.config.NullCollation;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rel.type.RelRecordType;
import org.apache.calcite.runtime.CalciteContextException;
import org.apache.calcite.runtime.CalciteException;
import org.apache.calcite.runtime.Feature;
import org.apache.calcite.runtime.Resources;
import org.apache.calcite.schema.Table;
import org.apache.calcite.sql.JoinConditionType;
import org.apache.calcite.sql.JoinType;
import org.apache.calcite.sql.SqlAccessEnum;
import org.apache.calcite.sql.SqlAccessType;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlDelete;
import org.apache.calcite.sql.SqlDynamicParam;
import org.apache.calcite.sql.SqlExplain;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlInsert;
import org.apache.calcite.sql.SqlIntervalLiteral;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlJoin;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlMerge;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.SqlOrderBy;
import org.apache.calcite.sql.SqlSampleSpec;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.SqlSelectKeyword;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.sql.SqlUnresolvedFunction;
import org.apache.calcite.sql.SqlUpdate;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.SqlWindow;
import org.apache.calcite.sql.SqlWith;
import org.apache.calcite.sql.SqlWithItem;
import org.apache.calcite.sql.fun.SqlCase;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.AssignableOperandTypeChecker;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlOperandTypeInference;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.sql.util.SqlShuttle;
import org.apache.calcite.sql.util.SqlVisitor;
import org.apache.calcite.sql.validate.AggFinder;
import org.apache.calcite.sql.validate.AggregatingScope;
import org.apache.calcite.sql.validate.AggregatingSelectScope;
import org.apache.calcite.sql.validate.AliasNamespace;
import org.apache.calcite.sql.validate.CatalogScope;
import org.apache.calcite.sql.validate.CollectNamespace;
import org.apache.calcite.sql.validate.CollectScope;
import org.apache.calcite.sql.validate.DelegatingScope;
import org.apache.calcite.sql.validate.EmptyScope;
import org.apache.calcite.sql.validate.FieldNamespace;
import org.apache.calcite.sql.validate.IdentifierNamespace;
import org.apache.calcite.sql.validate.JoinNamespace;
import org.apache.calcite.sql.validate.JoinScope;
import org.apache.calcite.sql.validate.OrderByScope;
import org.apache.calcite.sql.validate.OverScope;
import org.apache.calcite.sql.validate.ParameterScope;
import org.apache.calcite.sql.validate.ProcedureNamespace;
import org.apache.calcite.sql.validate.SelectNamespace;
import org.apache.calcite.sql.validate.SelectScope;
import org.apache.calcite.sql.validate.SetopNamespace;
import org.apache.calcite.sql.validate.SqlConformance;
import org.apache.calcite.sql.validate.SqlIdentifierMoniker;
import org.apache.calcite.sql.validate.SqlModality;
import org.apache.calcite.sql.validate.SqlMoniker;
import org.apache.calcite.sql.validate.SqlMonikerImpl;
import org.apache.calcite.sql.validate.SqlMonikerType;
import org.apache.calcite.sql.validate.SqlMonotonicity;
import org.apache.calcite.sql.validate.SqlQualified;
import org.apache.calcite.sql.validate.SqlScopedShuttle;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorCatalogReader;
import org.apache.calcite.sql.validate.SqlValidatorException;
import org.apache.calcite.sql.validate.SqlValidatorNamespace;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.sql.validate.SqlValidatorTable;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.sql.validate.SqlValidatorWithHints;
import org.apache.calcite.sql.validate.TableConstructorNamespace;
import org.apache.calcite.sql.validate.TableNamespace;
import org.apache.calcite.sql.validate.UnnestNamespace;
import org.apache.calcite.sql.validate.WithItemNamespace;
import org.apache.calcite.sql.validate.WithNamespace;
import org.apache.calcite.sql.validate.WithScope;
import org.apache.calcite.util.BitString;
import org.apache.calcite.util.Litmus;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Static;
import org.apache.calcite.util.Util;
import org.apache.calcite.util.trace.CalciteTrace;
import org.apache.flink.shaded.calcite.com.google.common.annotations.VisibleForTesting;
import org.apache.flink.shaded.calcite.com.google.common.base.Function;
import org.apache.flink.shaded.calcite.com.google.common.base.Joiner;
import org.apache.flink.shaded.calcite.com.google.common.base.Preconditions;
import org.apache.flink.shaded.calcite.com.google.common.collect.ImmutableList;
import org.apache.flink.shaded.calcite.com.google.common.collect.Lists;
import org.apache.flink.shaded.calcite.com.google.common.collect.Sets;
import org.slf4j.Logger;

public class SqlValidatorImpl
implements SqlValidatorWithHints {
    public static final Logger TRACER = CalciteTrace.PARSER_LOGGER;
    public static final String UPDATE_SRC_ALIAS = "SYS$SRC";
    public static final String UPDATE_TGT_ALIAS = "SYS$TGT";
    public static final String UPDATE_ANON_PREFIX = "SYS$ANON";
    private SqlNode top;
    private final SqlOperatorTable opTab;
    final SqlValidatorCatalogReader catalogReader;
    protected final Map<String, IdInfo> idPositions = new HashMap<String, IdInfo>();
    protected final Map<SqlNode, SqlValidatorScope> scopes = new IdentityHashMap<SqlNode, SqlValidatorScope>();
    private final Map<SqlSelect, SqlValidatorScope> whereScopes = new IdentityHashMap<SqlSelect, SqlValidatorScope>();
    private final Map<SqlSelect, SqlValidatorScope> selectScopes = new IdentityHashMap<SqlSelect, SqlValidatorScope>();
    private final Map<SqlSelect, SqlValidatorScope> orderScopes = new IdentityHashMap<SqlSelect, SqlValidatorScope>();
    private final Map<SqlSelect, SqlValidatorScope> cursorScopes = new IdentityHashMap<SqlSelect, SqlValidatorScope>();
    protected final Map<SqlNode, SqlValidatorNamespace> namespaces = new IdentityHashMap<SqlNode, SqlValidatorNamespace>();
    private final Set<SqlNode> cursorSet = Sets.newIdentityHashSet();
    protected final Deque<FunctionParamInfo> functionCallStack = new ArrayDeque<FunctionParamInfo>();
    private int nextGeneratedId;
    protected final RelDataTypeFactory typeFactory;
    protected final RelDataType unknownType;
    private final RelDataType booleanType;
    private final Map<SqlNode, RelDataType> nodeToTypeMap = new IdentityHashMap<SqlNode, RelDataType>();
    private final AggFinder aggFinder;
    private final AggFinder aggOrOverFinder;
    private final SqlConformance conformance;
    private final Map<SqlNode, SqlNode> originalExprs = new HashMap<SqlNode, SqlNode>();
    protected boolean expandIdentifiers;
    protected boolean expandColumnReferences;
    private boolean rewriteCalls;
    private NullCollation nullCollation = NullCollation.HIGH;
    private boolean validatingSqlMerge;

    @VisibleForTesting
    public SqlValidatorScope getEmptyScope() {
        return new EmptyScope(this);
    }

    protected SqlValidatorImpl(SqlOperatorTable opTab, SqlValidatorCatalogReader catalogReader, RelDataTypeFactory typeFactory, SqlConformance conformance) {
        this.opTab = Preconditions.checkNotNull(opTab);
        this.catalogReader = Preconditions.checkNotNull(catalogReader);
        this.typeFactory = Preconditions.checkNotNull(typeFactory);
        this.conformance = Preconditions.checkNotNull(conformance);
        this.unknownType = typeFactory.createSqlType(SqlTypeName.NULL);
        this.booleanType = typeFactory.createSqlType(SqlTypeName.BOOLEAN);
        this.rewriteCalls = true;
        this.expandColumnReferences = true;
        this.aggFinder = new AggFinder(opTab, false);
        this.aggOrOverFinder = new AggFinder(opTab, true);
    }

    @Override
    public SqlConformance getConformance() {
        return this.conformance;
    }

    @Override
    public SqlValidatorCatalogReader getCatalogReader() {
        return this.catalogReader;
    }

    @Override
    public SqlOperatorTable getOperatorTable() {
        return this.opTab;
    }

    @Override
    public RelDataTypeFactory getTypeFactory() {
        return this.typeFactory;
    }

    @Override
    public RelDataType getUnknownType() {
        return this.unknownType;
    }

    @Override
    public SqlNodeList expandStar(SqlNodeList selectList, SqlSelect select2, boolean includeSystemVars) {
        ArrayList<SqlNode> list = new ArrayList<SqlNode>();
        ArrayList<Map.Entry<String, RelDataType>> types = new ArrayList<Map.Entry<String, RelDataType>>();
        for (int i = 0; i < selectList.size(); ++i) {
            SqlNode selectItem = selectList.get(i);
            this.expandSelectItem(selectItem, select2, list, new LinkedHashSet<String>(), types, includeSystemVars);
        }
        this.getRawSelectScope(select2).setExpandedSelectList(list);
        return new SqlNodeList(list, SqlParserPos.ZERO);
    }

    @Override
    public void declareCursor(SqlSelect select2, SqlValidatorScope parentScope) {
        this.cursorSet.add(select2);
        FunctionParamInfo funcParamInfo = this.functionCallStack.peek();
        Map<Integer, SqlSelect> cursorMap = funcParamInfo.cursorPosToSelectMap;
        int numCursors = cursorMap.size();
        cursorMap.put(numCursors, select2);
        SelectScope cursorScope = new SelectScope(parentScope, null, select2);
        this.cursorScopes.put(select2, cursorScope);
        SelectNamespace selectNs = this.createSelectNamespace(select2, select2);
        String alias2 = this.deriveAlias(select2, this.nextGeneratedId++);
        this.registerNamespace(cursorScope, alias2, selectNs, false);
    }

    @Override
    public void pushFunctionCall() {
        FunctionParamInfo funcInfo = new FunctionParamInfo();
        this.functionCallStack.push(funcInfo);
    }

    @Override
    public void popFunctionCall() {
        this.functionCallStack.pop();
    }

    @Override
    public String getParentCursor(String columnListParamName) {
        FunctionParamInfo funcParamInfo = this.functionCallStack.peek();
        Map<String, String> parentCursorMap = funcParamInfo.columnListParamToParentCursorMap;
        return parentCursorMap.get(columnListParamName);
    }

    private boolean expandSelectItem(SqlNode selectItem, SqlSelect select2, List<SqlNode> selectItems, Set<String> aliases, List<Map.Entry<String, RelDataType>> types, boolean includeSystemVars) {
        String newAlias;
        SelectScope scope = (SelectScope)this.getWhereScope(select2);
        if (this.expandStar(selectItems, aliases, types, includeSystemVars, scope, selectItem)) {
            return true;
        }
        SqlNode expanded = this.expand(selectItem, scope);
        String alias2 = this.deriveAlias(selectItem, aliases.size());
        SqlValidatorScope selectScope = this.getSelectScope(select2);
        if (expanded != selectItem && !(newAlias = this.deriveAlias(expanded, aliases.size())).equals(alias2)) {
            expanded = SqlStdOperatorTable.AS.createCall(selectItem.getParserPosition(), expanded, new SqlIdentifier(alias2, SqlParserPos.ZERO));
            this.deriveTypeImpl(selectScope, expanded);
        }
        selectItems.add(expanded);
        aliases.add(alias2);
        RelDataType type = this.deriveType(selectScope, expanded);
        this.setValidatedNodeTypeImpl(expanded, type);
        types.add(Pair.of(alias2, type));
        return false;
    }

    private boolean expandStar(List<SqlNode> selectItems, Set<String> aliases, List<Map.Entry<String, RelDataType>> types, boolean includeSystemVars, SelectScope scope, SqlNode node) {
        SqlValidatorNamespace fromNs;
        if (!(node instanceof SqlIdentifier)) {
            return false;
        }
        SqlIdentifier identifier = (SqlIdentifier)node;
        if (!identifier.isStar()) {
            return false;
        }
        SqlParserPos starPosition = identifier.getParserPosition();
        switch (identifier.names.size()) {
            case 1: {
                for (Pair p : scope.children) {
                    SqlNode from = ((SqlValidatorNamespace)p.right).getNode();
                    SqlValidatorNamespace fromNs2 = this.getNamespace(from, scope);
                    assert (fromNs2 != null);
                    RelDataType rowType = fromNs2.getRowType();
                    for (RelDataTypeField field : rowType.getFieldList()) {
                        String columnName = field.getName();
                        SqlIdentifier exp = new SqlIdentifier(ImmutableList.of(p.left, columnName), starPosition);
                        this.addToSelectList(selectItems, aliases, types, exp, scope, includeSystemVars);
                    }
                }
                return true;
            }
        }
        SqlIdentifier prefixId = identifier.skipLast(1);
        if (prefixId.names.size() == 1) {
            String tableName = (String)prefixId.names.get(0);
            SqlValidatorNamespace childNs = scope.getChild(tableName);
            if (childNs == null) {
                throw this.newValidationError(identifier.getComponent(0), Static.RESOURCE.unknownIdentifier(tableName));
            }
            SqlNode from = childNs.getNode();
            fromNs = this.getNamespace(from);
        } else {
            fromNs = scope.getChild(prefixId.names);
            if (fromNs == null) {
                throw this.newValidationError(prefixId, Static.RESOURCE.unknownIdentifier(prefixId.toString()));
            }
        }
        assert (fromNs != null);
        RelDataType rowType = fromNs.getRowType();
        for (RelDataTypeField field : rowType.getFieldList()) {
            String columnName = field.getName();
            this.addToSelectList(selectItems, aliases, types, prefixId.plus(columnName, starPosition), scope, includeSystemVars);
        }
        return true;
    }

    @Override
    public SqlNode validate(SqlNode topNode) {
        SqlValidatorScope scope = new EmptyScope(this);
        scope = new CatalogScope(scope, ImmutableList.of("CATALOG"));
        SqlNode topNode2 = this.validateScopedExpression(topNode, scope);
        RelDataType type = this.getValidatedNodeType(topNode2);
        Util.discard(type);
        return topNode2;
    }

    @Override
    public List<SqlMoniker> lookupHints(SqlNode topNode, SqlParserPos pos) {
        SqlValidatorNamespace ns;
        EmptyScope scope = new EmptyScope(this);
        SqlNode outermostNode = this.performUnconditionalRewrites(topNode, false);
        this.cursorSet.add(outermostNode);
        if (outermostNode.isA(SqlKind.TOP_LEVEL)) {
            this.registerQuery(scope, null, outermostNode, outermostNode, null, false);
        }
        if ((ns = this.getNamespace(outermostNode)) == null) {
            throw Util.newInternal("Not a query: " + outermostNode);
        }
        TreeSet<SqlMoniker> hintList = Sets.newTreeSet(SqlMoniker.COMPARATOR);
        this.lookupSelectHints(ns, pos, hintList);
        return ImmutableList.copyOf(hintList);
    }

    @Override
    public SqlMoniker lookupQualifiedName(SqlNode topNode, SqlParserPos pos) {
        String posString = pos.toString();
        IdInfo info = this.idPositions.get(posString);
        if (info != null) {
            SqlQualified qualified = info.scope.fullyQualify(info.id);
            return new SqlIdentifierMoniker(qualified.identifier);
        }
        return null;
    }

    void lookupSelectHints(SqlSelect select2, SqlParserPos pos, Collection<SqlMoniker> hintList) {
        IdInfo info = this.idPositions.get(pos.toString());
        if (info == null || info.scope == null) {
            SqlNode fromNode = select2.getFrom();
            SqlValidatorScope fromScope = this.getFromScope(select2);
            this.lookupFromHints(fromNode, fromScope, pos, hintList);
        } else {
            this.lookupNameCompletionHints(info.scope, info.id.names, info.id.getParserPosition(), hintList);
        }
    }

    private void lookupSelectHints(SqlValidatorNamespace ns, SqlParserPos pos, Collection<SqlMoniker> hintList) {
        SqlNode node = ns.getNode();
        if (node instanceof SqlSelect) {
            this.lookupSelectHints((SqlSelect)node, pos, hintList);
        }
    }

    private void lookupFromHints(SqlNode node, SqlValidatorScope scope, SqlParserPos pos, Collection<SqlMoniker> hintList) {
        SqlValidatorNamespace ns = this.getNamespace(node);
        if (ns.isWrapperFor(IdentifierNamespace.class)) {
            IdentifierNamespace idNs = ns.unwrap(IdentifierNamespace.class);
            SqlIdentifier id = idNs.getId();
            for (int i = 0; i < id.names.size(); ++i) {
                if (!pos.toString().equals(id.getComponent(i).getParserPosition().toString())) continue;
                ArrayList<SqlMoniker> objNames = new ArrayList<SqlMoniker>();
                SqlValidatorUtil.getSchemaObjectMonikers(this.getCatalogReader(), id.names.subList(0, i + 1), objNames);
                for (SqlMoniker objName : objNames) {
                    if (objName.getType() == SqlMonikerType.FUNCTION) continue;
                    hintList.add(objName);
                }
                return;
            }
        }
        switch (node.getKind()) {
            case JOIN: {
                this.lookupJoinHints((SqlJoin)node, scope, pos, hintList);
                break;
            }
            default: {
                this.lookupSelectHints(ns, pos, hintList);
            }
        }
    }

    private void lookupJoinHints(SqlJoin join, SqlValidatorScope scope, SqlParserPos pos, Collection<SqlMoniker> hintList) {
        SqlNode left = join.getLeft();
        SqlNode right = join.getRight();
        SqlNode condition = join.getCondition();
        this.lookupFromHints(left, scope, pos, hintList);
        if (hintList.size() > 0) {
            return;
        }
        this.lookupFromHints(right, scope, pos, hintList);
        if (hintList.size() > 0) {
            return;
        }
        JoinConditionType conditionType = join.getConditionType();
        SqlValidatorScope joinScope = this.scopes.get(join);
        switch (conditionType) {
            case ON: {
                condition.findValidOptions(this, joinScope, pos, hintList);
                return;
            }
        }
    }

    public final void lookupNameCompletionHints(SqlValidatorScope scope, List<String> names, SqlParserPos pos, Collection<SqlMoniker> hintList) {
        List<String> subNames = Util.skipLast(names);
        if (subNames.size() > 0) {
            SqlValidatorNamespace ns = null;
            for (String name : subNames) {
                if ((ns = ns == null ? scope.resolve(ImmutableList.of(name), null, null) : ns.lookupChild(name)) != null) continue;
                break;
            }
            if (ns != null) {
                RelDataType rowType = ns.getRowType();
                for (RelDataTypeField field : rowType.getFieldList()) {
                    hintList.add(new SqlMonikerImpl(field.getName(), SqlMonikerType.COLUMN));
                }
            }
            SqlValidatorImpl.findAllValidFunctionNames(names, this, hintList, pos);
        } else {
            scope.findAliases(hintList);
            SelectScope selectScope = SqlValidatorUtil.getEnclosingSelectScope(scope);
            if (selectScope != null && selectScope.getChildren().size() == 1) {
                RelDataType rowType = selectScope.getChildren().get(0).getRowType();
                for (RelDataTypeField field : rowType.getFieldList()) {
                    hintList.add(new SqlMonikerImpl(field.getName(), SqlMonikerType.COLUMN));
                }
            }
        }
        SqlValidatorImpl.findAllValidUdfNames(names, this, hintList);
    }

    private static void findAllValidUdfNames(List<String> names, SqlValidator validator, Collection<SqlMoniker> result) {
        ArrayList<SqlMoniker> objNames = new ArrayList<SqlMoniker>();
        SqlValidatorUtil.getSchemaObjectMonikers(validator.getCatalogReader(), names, objNames);
        for (SqlMoniker objName : objNames) {
            if (objName.getType() != SqlMonikerType.FUNCTION) continue;
            result.add(objName);
        }
    }

    private static void findAllValidFunctionNames(List<String> names, SqlValidator validator, Collection<SqlMoniker> result, SqlParserPos pos) {
        if (names.size() > 1) {
            return;
        }
        for (SqlOperator op : validator.getOperatorTable().getOperatorList()) {
            SqlIdentifier curOpId = new SqlIdentifier(op.getName(), pos);
            SqlCall call = SqlUtil.makeCall(validator.getOperatorTable(), curOpId);
            if (call != null) {
                result.add(new SqlMonikerImpl(op.getName(), SqlMonikerType.FUNCTION));
                continue;
            }
            if (op.getSyntax() != SqlSyntax.FUNCTION && op.getSyntax() != SqlSyntax.PREFIX) continue;
            if (op.getOperandTypeChecker() != null) {
                String sig = op.getAllowedSignatures();
                sig = sig.replaceAll("'", "");
                result.add(new SqlMonikerImpl(sig, SqlMonikerType.FUNCTION));
                continue;
            }
            result.add(new SqlMonikerImpl(op.getName(), SqlMonikerType.FUNCTION));
        }
    }

    @Override
    public SqlNode validateParameterizedExpression(SqlNode topNode, Map<String, RelDataType> nameToTypeMap) {
        ParameterScope scope = new ParameterScope(this, nameToTypeMap);
        return this.validateScopedExpression(topNode, scope);
    }

    private SqlNode validateScopedExpression(SqlNode topNode, SqlValidatorScope scope) {
        SqlNode outermostNode = this.performUnconditionalRewrites(topNode, false);
        this.cursorSet.add(outermostNode);
        this.top = outermostNode;
        TRACER.trace("After unconditional rewrite: " + outermostNode.toString());
        if (outermostNode.isA(SqlKind.TOP_LEVEL)) {
            this.registerQuery(scope, null, outermostNode, outermostNode, null, false);
        }
        outermostNode.validate(this, scope);
        if (!outermostNode.isA(SqlKind.TOP_LEVEL)) {
            this.deriveType(scope, outermostNode);
        }
        TRACER.trace("After validation: " + outermostNode.toString());
        return outermostNode;
    }

    @Override
    public void validateQuery(SqlNode node, SqlValidatorScope scope) {
        SqlValidatorNamespace ns = this.getNamespace(node, scope);
        if (node.getKind() == SqlKind.TABLESAMPLE) {
            List<SqlNode> operands = ((SqlCall)node).getOperandList();
            SqlSampleSpec sampleSpec = SqlLiteral.sampleValue(operands.get(1));
            if (sampleSpec instanceof SqlSampleSpec.SqlTableSampleSpec) {
                this.validateFeature(Static.RESOURCE.sQLFeature_T613(), node.getParserPosition());
            } else if (sampleSpec instanceof SqlSampleSpec.SqlSubstitutionSampleSpec) {
                this.validateFeature(Static.RESOURCE.sQLFeatureExt_T613_Substitution(), node.getParserPosition());
            }
        }
        this.validateNamespace(ns);
        if (node == this.top) {
            this.validateModality(node);
        }
        this.validateAccess(node, ns.getTable(), SqlAccessEnum.SELECT);
    }

    protected void validateNamespace(SqlValidatorNamespace namespace) {
        namespace.validate();
        if (namespace.getNode() != null) {
            this.setValidatedNodeType(namespace.getNode(), namespace.getType());
        }
    }

    public SqlValidatorScope getCursorScope(SqlSelect select2) {
        return this.cursorScopes.get(select2);
    }

    @Override
    public SqlValidatorScope getWhereScope(SqlSelect select2) {
        return this.whereScopes.get(select2);
    }

    @Override
    public SqlValidatorScope getSelectScope(SqlSelect select2) {
        return this.selectScopes.get(select2);
    }

    @Override
    public SelectScope getRawSelectScope(SqlSelect select2) {
        SqlValidatorScope scope = this.getSelectScope(select2);
        if (scope instanceof AggregatingSelectScope) {
            scope = ((AggregatingSelectScope)scope).getParent();
        }
        return (SelectScope)scope;
    }

    @Override
    public SqlValidatorScope getHavingScope(SqlSelect select2) {
        return this.selectScopes.get(select2);
    }

    @Override
    public SqlValidatorScope getGroupScope(SqlSelect select2) {
        return this.whereScopes.get(select2);
    }

    @Override
    public SqlValidatorScope getFromScope(SqlSelect select2) {
        return this.scopes.get(select2);
    }

    @Override
    public SqlValidatorScope getOrderScope(SqlSelect select2) {
        return this.orderScopes.get(select2);
    }

    @Override
    public SqlValidatorScope getJoinScope(SqlNode node) {
        return this.scopes.get(SqlUtil.stripAs(node));
    }

    @Override
    public SqlValidatorScope getOverScope(SqlNode node) {
        return this.scopes.get(node);
    }

    private SqlValidatorNamespace getNamespace(SqlNode node, SqlValidatorScope scope) {
        if (node instanceof SqlIdentifier && scope instanceof DelegatingScope) {
            SqlValidatorNamespace ns;
            SqlIdentifier id = (SqlIdentifier)node;
            SqlValidatorScope parentScope = ((DelegatingScope)scope).getParent();
            if (id.isSimple() && (ns = parentScope.resolve(id.names, null, null)) != null) {
                return ns;
            }
        }
        return this.getNamespace(node);
    }

    @Override
    public SqlValidatorNamespace getNamespace(SqlNode node) {
        switch (node.getKind()) {
            case AS: {
                SqlValidatorNamespace ns = this.namespaces.get(node);
                if (ns != null) {
                    return ns;
                }
            }
            case OVER: 
            case COLLECTION_TABLE: 
            case ORDER_BY: 
            case TABLESAMPLE: {
                return this.getNamespace((SqlNode)((SqlCall)node).operand(0));
            }
        }
        return this.namespaces.get(node);
    }

    protected SqlNode performUnconditionalRewrites(SqlNode node, boolean underFrom) {
        SqlNode newOperand;
        if (node == null) {
            return node;
        }
        if (node instanceof SqlCall) {
            if (node instanceof SqlMerge) {
                this.validatingSqlMerge = true;
            }
            SqlCall call = (SqlCall)node;
            SqlKind kind = call.getKind();
            List<SqlNode> operands = call.getOperandList();
            for (int i = 0; i < operands.size(); ++i) {
                boolean childUnderFrom;
                SqlNode operand = operands.get(i);
                newOperand = this.performUnconditionalRewrites(operand, childUnderFrom = kind == SqlKind.SELECT ? i == 2 : (kind == SqlKind.AS && i == 0 ? underFrom : false));
                if (newOperand == null || newOperand == operand) continue;
                call.setOperand(i, newOperand);
            }
            if (call.getOperator() instanceof SqlUnresolvedFunction) {
                assert (call instanceof SqlBasicCall);
                SqlUnresolvedFunction function = (SqlUnresolvedFunction)call.getOperator();
                ArrayList<SqlOperator> overloads = Lists.newArrayList();
                this.opTab.lookupOperatorOverloads(function.getNameAsId(), function.getFunctionType(), SqlSyntax.FUNCTION, overloads);
                if (overloads.size() == 1) {
                    ((SqlBasicCall)call).setOperator((SqlOperator)overloads.get(0));
                }
            }
            if (this.rewriteCalls) {
                node = call.getOperator().rewriteCall(this, call);
            }
        } else if (node instanceof SqlNodeList) {
            SqlNodeList list = (SqlNodeList)node;
            int count = list.size();
            for (int i = 0; i < count; ++i) {
                SqlNode operand = list.get(i);
                newOperand = this.performUnconditionalRewrites(operand, false);
                if (newOperand == null) continue;
                list.getList().set(i, newOperand);
            }
        }
        SqlKind kind = node.getKind();
        switch (kind) {
            case VALUES: {
                if (!underFrom) {
                    // empty if block
                }
                return node;
            }
            case ORDER_BY: {
                SqlNodeList orderList;
                SqlSelect select2;
                SqlOrderBy orderBy = (SqlOrderBy)node;
                if (orderBy.query instanceof SqlSelect && (select2 = (SqlSelect)orderBy.query).getOrderList() == null) {
                    select2.setOrderBy(orderBy.orderList);
                    select2.setOffset(orderBy.offset);
                    select2.setFetch(orderBy.fetch);
                    return select2;
                }
                if (orderBy.query instanceof SqlWith && ((SqlWith)orderBy.query).body instanceof SqlSelect) {
                    SqlWith with = (SqlWith)orderBy.query;
                    SqlSelect select3 = (SqlSelect)with.body;
                    if (select3.getOrderList() == null) {
                        select3.setOrderBy(orderBy.orderList);
                        select3.setOffset(orderBy.offset);
                        select3.setFetch(orderBy.fetch);
                        return with;
                    }
                }
                SqlNodeList selectList = new SqlNodeList(SqlParserPos.ZERO);
                selectList.add(SqlIdentifier.star(SqlParserPos.ZERO));
                if (this.getInnerSelect(node) != null && this.isAggregate(this.getInnerSelect(node))) {
                    orderList = orderBy.orderList.clone(orderBy.orderList.getParserPosition());
                    for (int i = 0; i < orderList.size(); ++i) {
                        SqlNode sqlNode = orderList.get(i);
                        SqlNodeList selectList2 = this.getInnerSelect(node).getSelectList();
                        for (Ord<SqlNode> sel : Ord.zip(selectList2)) {
                            if (!SqlUtil.stripAs((SqlNode)sel.e).equalsDeep(sqlNode, Litmus.IGNORE)) continue;
                            orderList.set(i, SqlLiteral.createExactNumeric(Integer.toString(sel.i + 1), SqlParserPos.ZERO));
                        }
                    }
                } else {
                    orderList = orderBy.orderList;
                }
                return new SqlSelect(SqlParserPos.ZERO, null, selectList, orderBy.query, null, null, null, null, orderList, orderBy.offset, orderBy.fetch);
            }
            case EXPLICIT_TABLE: {
                SqlCall call = (SqlCall)node;
                SqlNodeList selectList = new SqlNodeList(SqlParserPos.ZERO);
                selectList.add(SqlIdentifier.star(SqlParserPos.ZERO));
                return new SqlSelect(SqlParserPos.ZERO, null, selectList, (SqlNode)call.operand(0), null, null, null, null, null, null, null);
            }
            case DELETE: {
                SqlCall call = (SqlDelete)node;
                SqlSelect select2 = this.createSourceSelectForDelete((SqlDelete)call);
                ((SqlDelete)call).setSourceSelect(select2);
                break;
            }
            case UPDATE: {
                SqlNode selfJoinSrcExpr;
                SqlCall call = (SqlUpdate)node;
                SqlSelect select2 = this.createSourceSelectForUpdate((SqlUpdate)call);
                ((SqlUpdate)call).setSourceSelect(select2);
                if (this.validatingSqlMerge || (selfJoinSrcExpr = this.getSelfJoinExprForUpdate(((SqlUpdate)call).getTargetTable(), UPDATE_SRC_ALIAS)) == null) break;
                node = this.rewriteUpdateToMerge((SqlUpdate)call, selfJoinSrcExpr);
                break;
            }
            case MERGE: {
                SqlCall call = (SqlMerge)node;
                this.rewriteMerge((SqlMerge)call);
                break;
            }
        }
        return node;
    }

    private SqlSelect getInnerSelect(SqlNode node) {
        while (true) {
            if (node instanceof SqlSelect) {
                return (SqlSelect)node;
            }
            if (node instanceof SqlOrderBy) {
                node = ((SqlOrderBy)node).query;
                continue;
            }
            if (!(node instanceof SqlWith)) break;
            node = ((SqlWith)node).body;
        }
        return null;
    }

    private void rewriteMerge(SqlMerge call) {
        SqlNodeList selectList;
        SqlUpdate updateStmt = call.getUpdateCall();
        if (updateStmt != null) {
            selectList = (SqlNodeList)updateStmt.getSourceSelect().getSelectList().clone();
        } else {
            selectList = new SqlNodeList(SqlParserPos.ZERO);
            selectList.add(SqlIdentifier.star(SqlParserPos.ZERO));
        }
        SqlNode targetTable = call.getTargetTable();
        if (call.getAlias() != null) {
            targetTable = SqlValidatorUtil.addAlias(targetTable, call.getAlias().getSimple());
        }
        SqlNode sourceTableRef = call.getSourceTableRef();
        SqlInsert insertCall = call.getInsertCall();
        JoinType joinType = insertCall == null ? JoinType.INNER : JoinType.LEFT;
        SqlNode leftJoinTerm = (SqlNode)sourceTableRef.clone();
        SqlJoin outerJoin = new SqlJoin(SqlParserPos.ZERO, leftJoinTerm, SqlLiteral.createBoolean(false, SqlParserPos.ZERO), joinType.symbol(SqlParserPos.ZERO), targetTable, JoinConditionType.ON.symbol(SqlParserPos.ZERO), call.getCondition());
        SqlSelect select2 = new SqlSelect(SqlParserPos.ZERO, null, selectList, outerJoin, null, null, null, null, null, null, null);
        call.setSourceSelect(select2);
        if (insertCall != null) {
            SqlCall valuesCall = (SqlCall)insertCall.getSource();
            SqlCall rowCall = (SqlCall)valuesCall.operand(0);
            selectList = new SqlNodeList(rowCall.getOperandList(), SqlParserPos.ZERO);
            SqlNode insertSource = (SqlNode)sourceTableRef.clone();
            select2 = new SqlSelect(SqlParserPos.ZERO, null, selectList, insertSource, null, null, null, null, null, null, null);
            insertCall.setSource(select2);
        }
    }

    private SqlNode rewriteUpdateToMerge(SqlUpdate updateCall, SqlNode selfJoinSrcExpr) {
        if (updateCall.getAlias() == null) {
            updateCall.setAlias(new SqlIdentifier(UPDATE_TGT_ALIAS, SqlParserPos.ZERO));
        }
        SqlNode selfJoinTgtExpr = this.getSelfJoinExprForUpdate(updateCall.getTargetTable(), updateCall.getAlias().getSimple());
        assert (selfJoinTgtExpr != null);
        SqlNode condition = updateCall.getCondition();
        SqlCall selfJoinCond = SqlStdOperatorTable.EQUALS.createCall(SqlParserPos.ZERO, selfJoinSrcExpr, selfJoinTgtExpr);
        condition = condition == null ? selfJoinCond : SqlStdOperatorTable.AND.createCall(SqlParserPos.ZERO, selfJoinCond, condition);
        SqlNode target = updateCall.getTargetTable().clone(SqlParserPos.ZERO);
        IdentifierNamespace ns = new IdentifierNamespace(this, target, null, null);
        RelDataType rowType = ns.getRowType();
        SqlNode source = updateCall.getTargetTable().clone(SqlParserPos.ZERO);
        SqlNodeList selectList = new SqlNodeList(SqlParserPos.ZERO);
        int i = 1;
        for (RelDataTypeField field : rowType.getFieldList()) {
            SqlIdentifier col = new SqlIdentifier(field.getName(), SqlParserPos.ZERO);
            selectList.add(SqlValidatorUtil.addAlias(col, UPDATE_ANON_PREFIX + i));
            ++i;
        }
        source = new SqlSelect(SqlParserPos.ZERO, null, selectList, source, null, null, null, null, null, null, null);
        source = SqlValidatorUtil.addAlias(source, UPDATE_SRC_ALIAS);
        SqlMerge mergeCall = new SqlMerge(updateCall.getParserPosition(), target, condition, source, updateCall, null, null, updateCall.getAlias());
        this.rewriteMerge(mergeCall);
        return mergeCall;
    }

    protected SqlNode getSelfJoinExprForUpdate(SqlNode table, String alias2) {
        return null;
    }

    protected SqlSelect createSourceSelectForUpdate(SqlUpdate call) {
        SqlNodeList selectList = new SqlNodeList(SqlParserPos.ZERO);
        selectList.add(SqlIdentifier.star(SqlParserPos.ZERO));
        int ordinal = 0;
        for (SqlNode exp : call.getSourceExpressionList()) {
            String alias2 = SqlUtil.deriveAliasFromOrdinal(ordinal);
            selectList.add(SqlValidatorUtil.addAlias(exp, alias2));
            ++ordinal;
        }
        SqlNode sourceTable = call.getTargetTable();
        if (call.getAlias() != null) {
            sourceTable = SqlValidatorUtil.addAlias(sourceTable, call.getAlias().getSimple());
        }
        return new SqlSelect(SqlParserPos.ZERO, null, selectList, sourceTable, call.getCondition(), null, null, null, null, null, null);
    }

    protected SqlSelect createSourceSelectForDelete(SqlDelete call) {
        SqlNodeList selectList = new SqlNodeList(SqlParserPos.ZERO);
        selectList.add(SqlIdentifier.star(SqlParserPos.ZERO));
        SqlNode sourceTable = call.getTargetTable();
        if (call.getAlias() != null) {
            sourceTable = SqlValidatorUtil.addAlias(sourceTable, call.getAlias().getSimple());
        }
        return new SqlSelect(SqlParserPos.ZERO, null, selectList, sourceTable, call.getCondition(), null, null, null, null, null, null);
    }

    RelDataType getTableConstructorRowType(SqlCall values, SqlValidatorScope scope) {
        List<SqlNode> rows = values.getOperandList();
        assert (rows.size() >= 1);
        ArrayList<RelDataType> rowTypes = new ArrayList<RelDataType>();
        for (SqlNode row : rows) {
            assert (row.getKind() == SqlKind.ROW);
            SqlCall rowConstructor = (SqlCall)row;
            ArrayList<String> aliasList = new ArrayList<String>();
            ArrayList<RelDataType> typeList = new ArrayList<RelDataType>();
            for (Ord<SqlNode> column : Ord.zip(rowConstructor.getOperandList())) {
                String alias2 = this.deriveAlias((SqlNode)column.e, column.i);
                aliasList.add(alias2);
                RelDataType type = this.deriveType(scope, (SqlNode)column.e);
                typeList.add(type);
            }
            rowTypes.add(this.typeFactory.createStructType(typeList, aliasList));
        }
        if (rows.size() == 1) {
            return (RelDataType)rowTypes.get(0);
        }
        return this.typeFactory.leastRestrictive(rowTypes);
    }

    @Override
    public RelDataType getValidatedNodeType(SqlNode node) {
        RelDataType type = this.getValidatedNodeTypeIfKnown(node);
        if (type == null) {
            throw Util.needToImplement(node);
        }
        return type;
    }

    @Override
    public RelDataType getValidatedNodeTypeIfKnown(SqlNode node) {
        RelDataType type = this.nodeToTypeMap.get(node);
        if (type != null) {
            return type;
        }
        SqlValidatorNamespace ns = this.getNamespace(node);
        if (ns != null) {
            return ns.getType();
        }
        SqlNode original = this.originalExprs.get(node);
        if (original != null && original != node) {
            return this.getValidatedNodeType(original);
        }
        return null;
    }

    @Override
    public void setValidatedNodeType(SqlNode node, RelDataType type) {
        this.setValidatedNodeTypeImpl(node, type);
    }

    @Override
    public void removeValidatedNodeType(SqlNode node) {
        this.nodeToTypeMap.remove(node);
    }

    void setValidatedNodeTypeImpl(SqlNode node, RelDataType type) {
        Util.pre(type != null, "type != null");
        Util.pre(node != null, "node != null");
        if (type.equals(this.unknownType)) {
            return;
        }
        this.nodeToTypeMap.put(node, type);
    }

    @Override
    public RelDataType deriveType(SqlValidatorScope scope, SqlNode expr) {
        Util.pre(scope != null, "scope != null");
        Util.pre(expr != null, "expr != null");
        RelDataType type = this.nodeToTypeMap.get(expr);
        if (type != null) {
            return type;
        }
        SqlValidatorNamespace ns = this.getNamespace(expr);
        if (ns != null) {
            return ns.getType();
        }
        type = this.deriveTypeImpl(scope, expr);
        Util.permAssert(type != null, "SqlValidator.deriveTypeInternal returned null");
        this.setValidatedNodeTypeImpl(expr, type);
        return type;
    }

    RelDataType deriveTypeImpl(SqlValidatorScope scope, SqlNode operand) {
        DeriveTypeVisitor v = new DeriveTypeVisitor(scope);
        RelDataType type = operand.accept(v);
        return scope.nullifyType(operand, type);
    }

    @Override
    public RelDataType deriveConstructorType(SqlValidatorScope scope, SqlCall call, SqlFunction unresolvedConstructor, SqlFunction resolvedConstructor, List<RelDataType> argTypes) {
        SqlIdentifier sqlIdentifier = unresolvedConstructor.getSqlIdentifier();
        assert (sqlIdentifier != null);
        RelDataType type = this.catalogReader.getNamedType(sqlIdentifier);
        if (type == null) {
            throw this.newValidationError(sqlIdentifier, Static.RESOURCE.unknownDatatypeName(sqlIdentifier.toString()));
        }
        if (resolvedConstructor == null) {
            if (call.operandCount() > 0) {
                throw this.handleUnresolvedFunction(call, unresolvedConstructor, argTypes, null);
            }
        } else {
            SqlCall testCall = resolvedConstructor.createCall(call.getParserPosition(), call.getOperandList());
            RelDataType returnType = resolvedConstructor.validateOperands(this, scope, testCall);
            assert (type == returnType);
        }
        if (this.shouldExpandIdentifiers()) {
            if (resolvedConstructor != null) {
                ((SqlBasicCall)call).setOperator(resolvedConstructor);
            } else {
                ((SqlBasicCall)call).setOperator(new SqlFunction(type.getSqlIdentifier(), ReturnTypes.explicit(type), null, null, null, SqlFunctionCategory.USER_DEFINED_CONSTRUCTOR));
            }
        }
        return type;
    }

    @Override
    public CalciteException handleUnresolvedFunction(SqlCall call, SqlFunction unresolvedFunction, List<RelDataType> argTypes, List<String> argNames) {
        SqlFunction fun;
        ArrayList<SqlOperator> overloads = Lists.newArrayList();
        this.opTab.lookupOperatorOverloads(unresolvedFunction.getNameAsId(), null, SqlSyntax.FUNCTION, overloads);
        if (overloads.size() == 1 && (fun = (SqlFunction)overloads.get(0)).getSqlIdentifier() == null && fun.getSyntax() != SqlSyntax.FUNCTION_ID) {
            int expectedArgCount = fun.getOperandCountRange().getMin();
            throw this.newValidationError(call, Static.RESOURCE.invalidArgCount(call.getOperator().getName(), expectedArgCount));
        }
        AssignableOperandTypeChecker typeChecking = new AssignableOperandTypeChecker(argTypes, argNames);
        String signature = typeChecking.getAllowedSignatures(unresolvedFunction, unresolvedFunction.getName());
        throw this.newValidationError(call, Static.RESOURCE.validatorUnknownFunction(signature));
    }

    protected void inferUnknownTypes(RelDataType inferredType, SqlValidatorScope scope, SqlNode node) {
        block16: {
            block18: {
                block17: {
                    block15: {
                        SqlValidatorScope newScope = this.scopes.get(node);
                        if (newScope != null) {
                            scope = newScope;
                        }
                        boolean isNullLiteral = SqlUtil.isNullLiteral(node, false);
                        if (!(node instanceof SqlDynamicParam) && !isNullLiteral) break block15;
                        if (inferredType.equals(this.unknownType)) {
                            if (isNullLiteral) {
                                throw this.newValidationError(node, Static.RESOURCE.nullIllegal());
                            }
                            throw this.newValidationError(node, Static.RESOURCE.dynamicParamIllegal());
                        }
                        RelDataType newInferredType = this.typeFactory.createTypeWithNullability(inferredType, true);
                        if (SqlTypeUtil.inCharFamily(inferredType)) {
                            newInferredType = this.typeFactory.createTypeWithCharsetAndCollation(newInferredType, inferredType.getCharset(), inferredType.getCollation());
                        }
                        this.setValidatedNodeTypeImpl(node, newInferredType);
                        break block16;
                    }
                    if (!(node instanceof SqlNodeList)) break block17;
                    SqlNodeList nodeList = (SqlNodeList)node;
                    if (inferredType.isStruct() && inferredType.getFieldCount() != nodeList.size()) {
                        return;
                    }
                    int i = 0;
                    for (SqlNode child : nodeList) {
                        RelDataType type;
                        if (inferredType.isStruct()) {
                            type = inferredType.getFieldList().get(i).getType();
                            ++i;
                        } else {
                            type = inferredType;
                        }
                        this.inferUnknownTypes(type, scope, child);
                    }
                    break block16;
                }
                if (!(node instanceof SqlCase)) break block18;
                SqlCase caseCall = (SqlCase)node;
                RelDataType returnType = this.deriveType(scope, node);
                SqlNodeList whenList = caseCall.getWhenOperands();
                for (int i = 0; i < whenList.size(); ++i) {
                    SqlNode sqlNode = whenList.get(i);
                    this.inferUnknownTypes(this.unknownType, scope, sqlNode);
                }
                SqlNodeList thenList = caseCall.getThenOperands();
                for (int i = 0; i < thenList.size(); ++i) {
                    SqlNode sqlNode = thenList.get(i);
                    this.inferUnknownTypes(returnType, scope, sqlNode);
                }
                if (!SqlUtil.isNullLiteral(caseCall.getElseOperand(), false)) {
                    this.inferUnknownTypes(returnType, scope, caseCall.getElseOperand());
                } else {
                    this.setValidatedNodeTypeImpl(caseCall.getElseOperand(), returnType);
                }
                break block16;
            }
            if (!(node instanceof SqlCall)) break block16;
            SqlCall call = (SqlCall)node;
            SqlOperandTypeInference operandTypeInference = call.getOperator().getOperandTypeInference();
            SqlCallBinding callBinding = new SqlCallBinding(this, scope, call);
            List<SqlNode> operands = callBinding.operands();
            Object[] operandTypes = new RelDataType[operands.size()];
            if (operandTypeInference == null) {
                Arrays.fill(operandTypes, this.unknownType);
            } else {
                operandTypeInference.inferOperandTypes(callBinding, inferredType, (RelDataType[])operandTypes);
            }
            for (int i = 0; i < operands.size(); ++i) {
                this.inferUnknownTypes((RelDataType)operandTypes[i], scope, operands.get(i));
            }
        }
    }

    protected void addToSelectList(List<SqlNode> list, Set<String> aliases, List<Map.Entry<String, RelDataType>> fieldList, SqlNode exp, SqlValidatorScope scope, boolean includeSystemVars) {
        String uniqueAlias;
        String alias2 = SqlValidatorUtil.getAlias(exp, -1);
        if (!alias2.equals(uniqueAlias = SqlValidatorUtil.uniquify(alias2, aliases, SqlValidatorUtil.EXPR_SUGGESTER))) {
            exp = SqlValidatorUtil.addAlias(exp, uniqueAlias);
        }
        fieldList.add(Pair.of(uniqueAlias, this.deriveType(scope, exp)));
        list.add(exp);
    }

    @Override
    public String deriveAlias(SqlNode node, int ordinal) {
        return SqlValidatorUtil.getAlias(node, ordinal);
    }

    @Override
    public void setIdentifierExpansion(boolean expandIdentifiers) {
        this.expandIdentifiers = expandIdentifiers;
    }

    @Override
    public void setColumnReferenceExpansion(boolean expandColumnReferences) {
        this.expandColumnReferences = expandColumnReferences;
    }

    @Override
    public boolean getColumnReferenceExpansion() {
        return this.expandColumnReferences;
    }

    @Override
    public void setDefaultNullCollation(NullCollation nullCollation) {
        this.nullCollation = Preconditions.checkNotNull(nullCollation);
    }

    @Override
    public NullCollation getDefaultNullCollation() {
        return this.nullCollation;
    }

    @Override
    public void setCallRewrite(boolean rewriteCalls) {
        this.rewriteCalls = rewriteCalls;
    }

    @Override
    public boolean shouldExpandIdentifiers() {
        return this.expandIdentifiers;
    }

    protected boolean shouldAllowIntermediateOrderBy() {
        return true;
    }

    protected void registerNamespace(SqlValidatorScope usingScope, String alias2, SqlValidatorNamespace ns, boolean forceNullable) {
        if (forceNullable) {
            ns.makeNullable();
        }
        this.namespaces.put(ns.getNode(), ns);
        if (usingScope != null) {
            usingScope.addChild(ns, alias2);
        }
    }

    private SqlNode registerFrom(SqlValidatorScope parentScope, SqlValidatorScope usingScope, SqlNode node, SqlNode enclosingNode, String alias2, SqlNodeList extendList, boolean forceNullable) {
        SqlKind kind = node.getKind();
        SqlNode newNode = node;
        if (alias2 == null) {
            switch (kind) {
                case OVER: 
                case IDENTIFIER: {
                    alias2 = this.deriveAlias(node, -1);
                    if (alias2 == null) {
                        alias2 = this.deriveAlias(node, this.nextGeneratedId++);
                    }
                    if (!this.shouldExpandIdentifiers()) break;
                    newNode = SqlValidatorUtil.addAlias(node, alias2);
                    break;
                }
                case COLLECTION_TABLE: 
                case VALUES: 
                case SELECT: 
                case UNION: 
                case INTERSECT: 
                case EXCEPT: 
                case UNNEST: 
                case OTHER_FUNCTION: {
                    alias2 = this.deriveAlias(node, this.nextGeneratedId++);
                    if (!this.shouldExpandIdentifiers()) break;
                    newNode = SqlValidatorUtil.addAlias(node, alias2);
                }
            }
        }
        switch (kind) {
            case AS: {
                Object expr;
                SqlNode newExpr;
                SqlCall call = (SqlCall)node;
                if (alias2 == null) {
                    alias2 = ((SqlNode)call.operand(1)).toString();
                }
                SqlValidatorScope usingScope2 = usingScope;
                if (call.operandCount() > 2) {
                    usingScope2 = null;
                }
                if ((newExpr = this.registerFrom(parentScope, usingScope2, (SqlNode)(expr = call.operand(0)), enclosingNode, alias2, extendList, forceNullable)) != expr) {
                    call.setOperand(0, newExpr);
                }
                if (call.operandCount() > 2) {
                    this.registerNamespace(usingScope, alias2, new AliasNamespace(this, call, enclosingNode), false);
                }
                return node;
            }
            case TABLESAMPLE: {
                SqlCall call = (SqlCall)node;
                Object expr = call.operand(0);
                SqlNode newExpr = this.registerFrom(parentScope, usingScope, (SqlNode)expr, enclosingNode, alias2, extendList, forceNullable);
                if (newExpr != expr) {
                    call.setOperand(0, newExpr);
                }
                return node;
            }
            case JOIN: {
                SqlValidatorScope rightParentScope;
                SqlNode newRight;
                SqlJoin join = (SqlJoin)node;
                JoinScope joinScope = new JoinScope(parentScope, usingScope, join);
                this.scopes.put(join, joinScope);
                SqlNode left = join.getLeft();
                SqlNode right = join.getRight();
                boolean rightIsLateral = SqlValidatorImpl.isLateral(right);
                boolean forceLeftNullable = forceNullable;
                boolean forceRightNullable = forceNullable;
                switch (join.getJoinType()) {
                    case LEFT: {
                        forceRightNullable = true;
                        break;
                    }
                    case RIGHT: {
                        forceLeftNullable = true;
                        break;
                    }
                    case FULL: {
                        forceLeftNullable = true;
                        forceRightNullable = true;
                    }
                }
                SqlNode newLeft = this.registerFrom(parentScope, joinScope, left, left, null, null, forceLeftNullable);
                if (newLeft != left) {
                    join.setLeft(newLeft);
                }
                if ((newRight = this.registerFrom(rightParentScope = rightIsLateral ? joinScope : parentScope, joinScope, right, right, null, null, forceRightNullable)) != right) {
                    join.setRight(newRight);
                }
                this.registerSubqueries(joinScope, join.getCondition());
                JoinNamespace joinNamespace = new JoinNamespace(this, join);
                this.registerNamespace(null, null, joinNamespace, forceNullable);
                return join;
            }
            case IDENTIFIER: {
                SqlIdentifier id = (SqlIdentifier)node;
                IdentifierNamespace newNs = new IdentifierNamespace(this, id, extendList, enclosingNode, parentScope);
                this.registerNamespace(usingScope, alias2, newNs, forceNullable);
                return newNode;
            }
            case LATERAL: {
                return this.registerFrom(parentScope, usingScope, (SqlNode)((SqlCall)node).operand(0), enclosingNode, alias2, extendList, forceNullable);
            }
            case COLLECTION_TABLE: {
                SqlCall call = (SqlCall)node;
                Object operand = call.operand(0);
                SqlNode newOperand = this.registerFrom(parentScope, usingScope, (SqlNode)operand, enclosingNode, alias2, extendList, forceNullable);
                if (newOperand != operand) {
                    call.setOperand(0, newOperand);
                }
                return newNode;
            }
            case VALUES: 
            case SELECT: 
            case UNION: 
            case INTERSECT: 
            case EXCEPT: 
            case UNNEST: 
            case OTHER_FUNCTION: 
            case WITH: {
                if (alias2 == null) {
                    alias2 = this.deriveAlias(node, this.nextGeneratedId++);
                }
                this.registerQuery(parentScope, usingScope, node, enclosingNode, alias2, forceNullable);
                return newNode;
            }
            case OVER: {
                if (!this.shouldAllowOverRelation()) {
                    throw Util.unexpected(kind);
                }
                SqlCall call = (SqlCall)node;
                OverScope overScope = new OverScope(usingScope, call);
                this.scopes.put(call, overScope);
                Object operand = call.operand(0);
                SqlNode newOperand = this.registerFrom(parentScope, overScope, (SqlNode)operand, enclosingNode, alias2, extendList, forceNullable);
                if (newOperand != operand) {
                    call.setOperand(0, newOperand);
                }
                for (Pair p : overScope.children) {
                    this.registerNamespace(usingScope, (String)p.left, (SqlValidatorNamespace)p.right, forceNullable);
                }
                return newNode;
            }
            case EXTEND: {
                SqlCall extend = (SqlCall)node;
                return this.registerFrom(parentScope, usingScope, extend.getOperandList().get(0), extend, alias2, (SqlNodeList)extend.getOperandList().get(1), forceNullable);
            }
        }
        throw Util.unexpected(kind);
    }

    private static boolean isLateral(SqlNode node) {
        switch (node.getKind()) {
            case UNNEST: 
            case LATERAL: {
                return true;
            }
            case AS: {
                return SqlValidatorImpl.isLateral(((SqlCall)node).operand(0));
            }
        }
        return false;
    }

    protected boolean shouldAllowOverRelation() {
        return false;
    }

    protected SelectNamespace createSelectNamespace(SqlSelect select2, SqlNode enclosingNode) {
        return new SelectNamespace(this, select2, enclosingNode);
    }

    protected SetopNamespace createSetopNamespace(SqlCall call, SqlNode enclosingNode) {
        return new SetopNamespace(this, call, enclosingNode);
    }

    private void registerQuery(SqlValidatorScope parentScope, SqlValidatorScope usingScope, SqlNode node, SqlNode enclosingNode, String alias2, boolean forceNullable) {
        this.registerQuery(parentScope, usingScope, node, enclosingNode, alias2, forceNullable, true);
    }

    private void registerQuery(SqlValidatorScope parentScope, SqlValidatorScope usingScope, SqlNode node, SqlNode enclosingNode, String alias2, boolean forceNullable, boolean checkUpdate) {
        assert (node != null);
        assert (enclosingNode != null);
        assert (usingScope == null || alias2 != null) : usingScope;
        switch (node.getKind()) {
            case SELECT: {
                SqlNode agg;
                SqlSelect select2 = (SqlSelect)node;
                SelectNamespace selectNs = this.createSelectNamespace(select2, enclosingNode);
                this.registerNamespace(usingScope, alias2, selectNs, forceNullable);
                SqlValidatorScope windowParentScope = usingScope != null ? usingScope : parentScope;
                SelectScope selectScope = new SelectScope(parentScope, windowParentScope, select2);
                this.scopes.put(select2, selectScope);
                this.whereScopes.put(select2, selectScope);
                this.registerOperandSubqueries(selectScope, select2, 3);
                SqlNode from = select2.getFrom();
                SqlNode newFrom = this.registerFrom(parentScope, selectScope, from, from, null, null, false);
                if (newFrom != from) {
                    select2.setFrom(newFrom);
                }
                DelegatingScope aggScope = selectScope;
                if (this.isAggregate(select2)) {
                    aggScope = new AggregatingSelectScope(selectScope, select2, false);
                    this.selectScopes.put(select2, aggScope);
                } else {
                    this.selectScopes.put(select2, selectScope);
                }
                this.registerSubqueries(selectScope, select2.getGroup());
                this.registerOperandSubqueries(aggScope, select2, 5);
                this.registerSubqueries(aggScope, select2.getSelectList());
                SqlNodeList orderList = select2.getOrderList();
                if (orderList == null) break;
                if (select2.isDistinct()) {
                    aggScope = new AggregatingSelectScope(selectScope, select2, true);
                }
                OrderByScope orderScope = new OrderByScope(aggScope, orderList, select2);
                this.orderScopes.put(select2, orderScope);
                this.registerSubqueries(orderScope, orderList);
                if (this.isAggregate(select2) || (agg = this.aggFinder.findAgg(orderList)) == null) break;
                throw this.newValidationError(agg, Static.RESOURCE.aggregateIllegalInOrderBy());
            }
            case INTERSECT: {
                this.validateFeature(Static.RESOURCE.sQLFeature_F302(), node.getParserPosition());
                this.registerSetop(parentScope, usingScope, node, node, alias2, forceNullable);
                break;
            }
            case EXCEPT: {
                this.validateFeature(Static.RESOURCE.sQLFeature_E071_03(), node.getParserPosition());
                this.registerSetop(parentScope, usingScope, node, node, alias2, forceNullable);
                break;
            }
            case UNION: {
                this.registerSetop(parentScope, usingScope, node, node, alias2, forceNullable);
                break;
            }
            case WITH: {
                this.registerWith(parentScope, usingScope, (SqlWith)node, enclosingNode, alias2, forceNullable, checkUpdate);
                break;
            }
            case VALUES: {
                SqlCall call = (SqlCall)node;
                this.scopes.put(call, parentScope);
                TableConstructorNamespace tableConstructorNamespace = new TableConstructorNamespace(this, call, parentScope, enclosingNode);
                this.registerNamespace(usingScope, alias2, tableConstructorNamespace, forceNullable);
                List<SqlNode> operands = call.getOperandList();
                for (int i = 0; i < operands.size(); ++i) {
                    assert (operands.get(i).getKind() == SqlKind.ROW);
                    this.registerOperandSubqueries(parentScope, call, i);
                }
                break;
            }
            case INSERT: {
                SqlInsert insertCall = (SqlInsert)node;
                InsertNamespace insertNs = new InsertNamespace(this, insertCall, enclosingNode, parentScope);
                this.registerNamespace(usingScope, null, insertNs, forceNullable);
                this.registerQuery(parentScope, usingScope, insertCall.getSource(), enclosingNode, null, false);
                break;
            }
            case DELETE: {
                SqlDelete deleteCall = (SqlDelete)node;
                DeleteNamespace deleteNs = new DeleteNamespace(this, deleteCall, enclosingNode, parentScope);
                this.registerNamespace(usingScope, null, deleteNs, forceNullable);
                this.registerQuery(parentScope, usingScope, deleteCall.getSourceSelect(), enclosingNode, null, false);
                break;
            }
            case UPDATE: {
                if (checkUpdate) {
                    this.validateFeature(Static.RESOURCE.sQLFeature_E101_03(), node.getParserPosition());
                }
                SqlUpdate updateCall = (SqlUpdate)node;
                UpdateNamespace updateNs = new UpdateNamespace(this, updateCall, enclosingNode, parentScope);
                this.registerNamespace(usingScope, null, updateNs, forceNullable);
                this.registerQuery(parentScope, usingScope, updateCall.getSourceSelect(), enclosingNode, null, false);
                break;
            }
            case MERGE: {
                this.validateFeature(Static.RESOURCE.sQLFeature_F312(), node.getParserPosition());
                SqlMerge mergeCall = (SqlMerge)node;
                MergeNamespace mergeNs = new MergeNamespace(this, mergeCall, enclosingNode, parentScope);
                this.registerNamespace(usingScope, null, mergeNs, forceNullable);
                this.registerQuery(parentScope, usingScope, mergeCall.getSourceSelect(), enclosingNode, null, false);
                if (mergeCall.getUpdateCall() != null) {
                    this.registerQuery(this.whereScopes.get(mergeCall.getSourceSelect()), null, mergeCall.getUpdateCall(), enclosingNode, null, false, false);
                }
                if (mergeCall.getInsertCall() == null) break;
                this.registerQuery(parentScope, null, mergeCall.getInsertCall(), enclosingNode, null, false);
                break;
            }
            case UNNEST: {
                SqlCall call = (SqlCall)node;
                UnnestNamespace unnestNs = new UnnestNamespace(this, call, parentScope, enclosingNode);
                this.registerNamespace(usingScope, alias2, unnestNs, forceNullable);
                this.registerOperandSubqueries(parentScope, call, 0);
                break;
            }
            case OTHER_FUNCTION: {
                SqlCall call = (SqlCall)node;
                ProcedureNamespace procNs = new ProcedureNamespace(this, parentScope, call, enclosingNode);
                this.registerNamespace(usingScope, alias2, procNs, forceNullable);
                this.registerSubqueries(parentScope, call);
                break;
            }
            case MULTISET_QUERY_CONSTRUCTOR: 
            case MULTISET_VALUE_CONSTRUCTOR: {
                this.validateFeature(Static.RESOURCE.sQLFeature_S271(), node.getParserPosition());
                SqlCall call = (SqlCall)node;
                CollectScope cs = new CollectScope(parentScope, usingScope, call);
                CollectNamespace tableConstructorNs = new CollectNamespace(call, cs, enclosingNode);
                String alias22 = this.deriveAlias(node, this.nextGeneratedId++);
                this.registerNamespace(usingScope, alias22, tableConstructorNs, forceNullable);
                List<SqlNode> operands = call.getOperandList();
                for (int i = 0; i < operands.size(); ++i) {
                    this.registerOperandSubqueries(parentScope, call, i);
                }
                break;
            }
            default: {
                throw Util.unexpected(node.getKind());
            }
        }
    }

    private void registerSetop(SqlValidatorScope parentScope, SqlValidatorScope usingScope, SqlNode node, SqlNode enclosingNode, String alias2, boolean forceNullable) {
        SqlCall call = (SqlCall)node;
        SetopNamespace setopNamespace = this.createSetopNamespace(call, enclosingNode);
        this.registerNamespace(usingScope, alias2, setopNamespace, forceNullable);
        this.scopes.put(call, parentScope);
        for (SqlNode operand : call.getOperandList()) {
            this.registerQuery(parentScope, null, operand, operand, null, false);
        }
    }

    private void registerWith(SqlValidatorScope parentScope, SqlValidatorScope usingScope, SqlWith with, SqlNode enclosingNode, String alias2, boolean forceNullable, boolean checkUpdate) {
        WithNamespace withNamespace = new WithNamespace(this, with, enclosingNode);
        this.registerNamespace(usingScope, alias2, withNamespace, forceNullable);
        SqlValidatorScope scope = parentScope;
        for (SqlNode withItem_ : with.withList) {
            SqlWithItem withItem = (SqlWithItem)withItem_;
            WithScope withScope = new WithScope(scope, withItem);
            this.scopes.put(withItem, withScope);
            this.registerQuery(scope, null, withItem.query, with, withItem.name.getSimple(), false);
            this.registerNamespace(null, alias2, new WithItemNamespace(this, withItem, enclosingNode), false);
            scope = withScope;
        }
        this.registerQuery(scope, null, with.body, enclosingNode, alias2, forceNullable, checkUpdate);
    }

    @Override
    public boolean isAggregate(SqlSelect select2) {
        return this.getAggregate(select2) != null;
    }

    protected SqlNode getAggregate(SqlSelect select2) {
        SqlNode node = select2.getGroup();
        if (node != null) {
            return node;
        }
        node = select2.getHaving();
        if (node != null) {
            return node;
        }
        return this.getAgg(select2);
    }

    private SqlNode getAgg(SqlSelect select2) {
        List<SqlNode> selectList;
        SelectScope selectScope = this.getRawSelectScope(select2);
        if (selectScope != null && (selectList = selectScope.getExpandedSelectList()) != null) {
            return this.aggFinder.findAgg(selectList);
        }
        return this.aggFinder.findAgg(select2.getSelectList());
    }

    @Override
    public boolean isAggregate(SqlNode selectNode) {
        return this.aggFinder.findAgg(selectNode) != null;
    }

    private void validateNodeFeature(SqlNode node) {
        switch (node.getKind()) {
            case MULTISET_VALUE_CONSTRUCTOR: {
                this.validateFeature(Static.RESOURCE.sQLFeature_S271(), node.getParserPosition());
            }
        }
    }

    private void registerSubqueries(SqlValidatorScope parentScope, SqlNode node) {
        block5: {
            block6: {
                block4: {
                    if (node == null) {
                        return;
                    }
                    if (!node.getKind().belongsTo(SqlKind.QUERY) && node.getKind() != SqlKind.MULTISET_QUERY_CONSTRUCTOR && node.getKind() != SqlKind.MULTISET_VALUE_CONSTRUCTOR) break block4;
                    this.registerQuery(parentScope, null, node, node, null, false);
                    break block5;
                }
                if (!(node instanceof SqlCall)) break block6;
                this.validateNodeFeature(node);
                SqlCall call = (SqlCall)node;
                for (int i = 0; i < call.operandCount(); ++i) {
                    this.registerOperandSubqueries(parentScope, call, i);
                }
                break block5;
            }
            if (!(node instanceof SqlNodeList)) break block5;
            SqlNodeList list = (SqlNodeList)node;
            int count = list.size();
            for (int i = 0; i < count; ++i) {
                SqlNode listNode = list.get(i);
                if (listNode.getKind().belongsTo(SqlKind.QUERY)) {
                    listNode = SqlStdOperatorTable.SCALAR_QUERY.createCall(listNode.getParserPosition(), listNode);
                    list.set(i, listNode);
                }
                this.registerSubqueries(parentScope, listNode);
            }
        }
    }

    private void registerOperandSubqueries(SqlValidatorScope parentScope, SqlCall call, int operandOrdinal) {
        Object operand = call.operand(operandOrdinal);
        if (operand == null) {
            return;
        }
        if (((SqlNode)operand).getKind().belongsTo(SqlKind.QUERY) && call.getOperator().argumentMustBeScalar(operandOrdinal)) {
            operand = SqlStdOperatorTable.SCALAR_QUERY.createCall(((SqlNode)operand).getParserPosition(), new SqlNode[]{operand});
            call.setOperand(operandOrdinal, (SqlNode)operand);
        }
        this.registerSubqueries(parentScope, (SqlNode)operand);
    }

    @Override
    public void validateIdentifier(SqlIdentifier id, SqlValidatorScope scope) {
        SqlQualified fqId = scope.fullyQualify(id);
        if (this.expandColumnReferences) {
            id.assignNamesFrom(fqId.identifier);
        } else {
            Util.discard(fqId);
        }
    }

    @Override
    public void validateLiteral(SqlLiteral literal) {
        switch (literal.getTypeName()) {
            case DECIMAL: {
                BigDecimal bd = (BigDecimal)literal.getValue();
                BigInteger unscaled = bd.unscaledValue();
                long longValue = unscaled.longValue();
                if (BigInteger.valueOf(longValue).equals(unscaled)) break;
                throw this.newValidationError(literal, Static.RESOURCE.numberLiteralOutOfRange(bd.toString()));
            }
            case DOUBLE: {
                this.validateLiteralAsDouble(literal);
                break;
            }
            case BINARY: {
                BitString bitString = (BitString)literal.getValue();
                if (bitString.getBitCount() % 8 == 0) break;
                throw this.newValidationError(literal, Static.RESOURCE.binaryLiteralOdd());
            }
            case DATE: 
            case TIME: 
            case TIMESTAMP: {
                Calendar calendar = (Calendar)literal.getValue();
                int year = calendar.get(1);
                int era = calendar.get(0);
                if (year >= 1 && era != 0 && year <= 9999) break;
                throw this.newValidationError(literal, Static.RESOURCE.dateLiteralOutOfRange(literal.toString()));
            }
            case INTERVAL_YEAR_MONTH: 
            case INTERVAL_DAY_TIME: {
                if (!(literal instanceof SqlIntervalLiteral)) break;
                SqlIntervalLiteral.IntervalValue interval = (SqlIntervalLiteral.IntervalValue)literal.getValue();
                SqlIntervalQualifier intervalQualifier = interval.getIntervalQualifier();
                this.validateIntervalQualifier(intervalQualifier);
                String intervalStr = interval.getIntervalLiteral();
                int[] values = intervalQualifier.evaluateIntervalLiteral(intervalStr, literal.getParserPosition(), this.typeFactory.getTypeSystem());
                Util.discard(values);
                break;
            }
        }
    }

    private void validateLiteralAsDouble(SqlLiteral literal) {
        BigDecimal bd = (BigDecimal)literal.getValue();
        double d = bd.doubleValue();
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            throw this.newValidationError(literal, Static.RESOURCE.numberLiteralOutOfRange(Util.toScientificNotation(bd)));
        }
    }

    @Override
    public void validateIntervalQualifier(SqlIntervalQualifier qualifier) {
        assert (qualifier != null);
        boolean startPrecisionOutOfRange = false;
        boolean fractionalSecondPrecisionOutOfRange = false;
        RelDataTypeSystem typeSystem = this.typeFactory.getTypeSystem();
        int startPrecision = qualifier.getStartPrecision(typeSystem);
        int fracPrecision = qualifier.getFractionalSecondPrecision(typeSystem);
        int maxPrecision = typeSystem.getMaxPrecision(qualifier.typeName());
        int minPrecision = qualifier.typeName().getMinPrecision();
        int minScale = qualifier.typeName().getMinScale();
        int maxScale = typeSystem.getMaxScale(qualifier.typeName());
        if (qualifier.isYearMonth()) {
            if (startPrecision < minPrecision || startPrecision > maxPrecision) {
                startPrecisionOutOfRange = true;
            } else if (fracPrecision < minScale || fracPrecision > maxScale) {
                fractionalSecondPrecisionOutOfRange = true;
            }
        } else if (startPrecision < minPrecision || startPrecision > maxPrecision) {
            startPrecisionOutOfRange = true;
        } else if (fracPrecision < minScale || fracPrecision > maxScale) {
            fractionalSecondPrecisionOutOfRange = true;
        }
        if (startPrecisionOutOfRange) {
            throw this.newValidationError(qualifier, Static.RESOURCE.intervalStartPrecisionOutOfRange(startPrecision, "INTERVAL " + qualifier));
        }
        if (fractionalSecondPrecisionOutOfRange) {
            throw this.newValidationError(qualifier, Static.RESOURCE.intervalFractionalSecondPrecisionOutOfRange(fracPrecision, "INTERVAL " + qualifier));
        }
    }

    protected void validateFrom(SqlNode node, RelDataType targetRowType, SqlValidatorScope scope) {
        Util.pre(targetRowType != null, "targetRowType != null");
        switch (node.getKind()) {
            case AS: {
                this.validateFrom((SqlNode)((SqlCall)node).operand(0), targetRowType, scope);
                break;
            }
            case VALUES: {
                this.validateValues((SqlCall)node, targetRowType, scope);
                break;
            }
            case JOIN: {
                this.validateJoin((SqlJoin)node, scope);
                break;
            }
            case OVER: {
                this.validateOver((SqlCall)node, scope);
                break;
            }
            default: {
                this.validateQuery(node, scope);
            }
        }
        this.getNamespace(node, scope).validate();
    }

    protected void validateOver(SqlCall call, SqlValidatorScope scope) {
        throw Util.newInternal("OVER unexpected in this context");
    }

    protected void validateJoin(SqlJoin join, SqlValidatorScope scope) {
        SqlNode left = join.getLeft();
        SqlNode right = join.getRight();
        SqlNode condition = join.getCondition();
        boolean natural = join.isNatural();
        JoinType joinType = join.getJoinType();
        JoinConditionType conditionType = join.getConditionType();
        SqlValidatorScope joinScope = this.scopes.get(join);
        this.validateFrom(left, this.unknownType, joinScope);
        this.validateFrom(right, this.unknownType, joinScope);
        switch (conditionType) {
            case NONE: {
                Util.permAssert(condition == null, "condition == null");
                break;
            }
            case ON: {
                Util.permAssert(condition != null, "condition != null");
                this.validateWhereOrOn(joinScope, condition, "ON");
                break;
            }
            case USING: {
                SqlNodeList list = (SqlNodeList)condition;
                Util.permAssert(list.size() > 0, "Empty USING clause");
                for (int i = 0; i < list.size(); ++i) {
                    RelDataType rightColType;
                    SqlIdentifier id = (SqlIdentifier)list.get(i);
                    RelDataType leftColType = this.validateUsingCol(id, left);
                    if (SqlTypeUtil.isComparable(leftColType, rightColType = this.validateUsingCol(id, right))) continue;
                    throw this.newValidationError(id, Static.RESOURCE.naturalOrUsingColumnNotCompatible(id.getSimple(), leftColType.toString(), rightColType.toString()));
                }
                break;
            }
            default: {
                throw Util.unexpected(conditionType);
            }
        }
        if (natural) {
            if (condition != null) {
                throw this.newValidationError(condition, Static.RESOURCE.naturalDisallowsOnOrUsing());
            }
            RelDataType leftRowType = this.getNamespace(left).getRowType();
            RelDataType rightRowType = this.getNamespace(right).getRowType();
            List<String> naturalColumnNames = SqlValidatorUtil.deriveNaturalJoinColumnList(leftRowType, rightRowType);
            for (String name : naturalColumnNames) {
                RelDataType rightColType;
                RelDataType leftColType = this.catalogReader.field(leftRowType, name).getType();
                if (SqlTypeUtil.isComparable(leftColType, rightColType = this.catalogReader.field(rightRowType, name).getType())) continue;
                throw this.newValidationError(join, Static.RESOURCE.naturalOrUsingColumnNotCompatible(name, leftColType.toString(), rightColType.toString()));
            }
        }
        switch (joinType) {
            case LEFT: 
            case RIGHT: 
            case FULL: 
            case INNER: {
                if (condition != null || natural) break;
                throw this.newValidationError(join, Static.RESOURCE.joinRequiresCondition());
            }
            case COMMA: 
            case CROSS: {
                if (condition != null) {
                    throw this.newValidationError(join.getConditionTypeNode(), Static.RESOURCE.crossJoinDisallowsCondition());
                }
                if (!natural) break;
                throw this.newValidationError(join.getConditionTypeNode(), Static.RESOURCE.crossJoinDisallowsCondition());
            }
            default: {
                throw Util.unexpected(joinType);
            }
        }
    }

    private void validateNoAggs(SqlNode condition, String clause) {
        SqlNode agg = this.aggOrOverFinder.findAgg(condition);
        if (agg != null) {
            if (SqlUtil.isCallTo(agg, SqlStdOperatorTable.OVER)) {
                throw this.newValidationError(agg, Static.RESOURCE.windowedAggregateIllegalInClause(clause));
            }
            throw this.newValidationError(agg, Static.RESOURCE.aggregateIllegalInClause(clause));
        }
    }

    private RelDataType validateUsingCol(SqlIdentifier id, SqlNode leftOrRight) {
        if (id.names.size() == 1) {
            String name = (String)id.names.get(0);
            SqlValidatorNamespace namespace = this.getNamespace(leftOrRight);
            RelDataType rowType = namespace.getRowType();
            RelDataTypeField field = this.catalogReader.field(rowType, name);
            if (field != null) {
                if (Collections.frequency(rowType.getFieldNames(), name) > 1) {
                    throw this.newValidationError(id, Static.RESOURCE.columnInUsingNotUnique(id.toString()));
                }
                return field.getType();
            }
        }
        throw this.newValidationError(id, Static.RESOURCE.columnNotFound(id.toString()));
    }

    protected void validateSelect(SqlSelect select2, RelDataType targetRowType) {
        SqlIdentifier id;
        SqlNode selectItem;
        assert (targetRowType != null);
        SelectNamespace ns = this.getNamespace(select2).unwrap(SelectNamespace.class);
        assert (ns.rowType == null);
        if (select2.isDistinct()) {
            this.validateFeature(Static.RESOURCE.sQLFeature_E051_01(), select2.getModifierNode(SqlSelectKeyword.DISTINCT).getParserPosition());
        }
        SqlNodeList selectItems = select2.getSelectList();
        RelDataType fromType = this.unknownType;
        if (selectItems.size() == 1 && (selectItem = selectItems.get(0)) instanceof SqlIdentifier && (id = (SqlIdentifier)selectItem).isStar() && id.names.size() == 1) {
            fromType = targetRowType;
        }
        SqlValidatorScope fromScope = this.getFromScope(select2);
        List children = ((SelectScope)fromScope).children;
        int duplicateAliasOrdinal = Util.firstDuplicate(Pair.left(children));
        if (duplicateAliasOrdinal >= 0) {
            Pair child = (Pair)children.get(duplicateAliasOrdinal);
            throw this.newValidationError(((SqlValidatorNamespace)child.right).getEnclosingNode(), Static.RESOURCE.fromAliasDuplicate((String)child.left));
        }
        this.validateFrom(select2.getFrom(), fromType, fromScope);
        this.validateWhereClause(select2);
        this.validateGroupClause(select2);
        this.validateHavingClause(select2);
        this.validateWindowClause(select2);
        RelDataType rowType = this.validateSelectList(selectItems, select2, targetRowType);
        ns.setType(rowType);
        this.validateOrderList(select2);
    }

    private void validateModality(SqlNode query) {
        SqlModality modality = this.deduceModality(query);
        if (query instanceof SqlSelect) {
            SqlSelect select2 = (SqlSelect)query;
            this.validateModality(select2, modality, true);
        } else if (query.getKind() == SqlKind.VALUES) {
            switch (modality) {
                case STREAM: {
                    throw this.newValidationError(query, Static.RESOURCE.cannotStreamValues());
                }
            }
        } else {
            assert (query.isA(SqlKind.SET_QUERY));
            SqlCall call = (SqlCall)query;
            for (SqlNode operand : call.getOperandList()) {
                if (this.deduceModality(operand) != modality) {
                    throw this.newValidationError(operand, Static.RESOURCE.streamSetOpInconsistentInputs());
                }
                this.validateModality(operand);
            }
        }
    }

    private SqlModality deduceModality(SqlNode query) {
        if (query instanceof SqlSelect) {
            SqlSelect select2 = (SqlSelect)query;
            return select2.getModifierNode(SqlSelectKeyword.STREAM) != null ? SqlModality.STREAM : SqlModality.RELATION;
        }
        if (query.getKind() == SqlKind.VALUES) {
            return SqlModality.RELATION;
        }
        assert (query.isA(SqlKind.SET_QUERY));
        SqlCall call = (SqlCall)query;
        return this.deduceModality(call.getOperandList().get(0));
    }

    @Override
    public boolean validateModality(SqlSelect select2, SqlModality modality, boolean fail) {
        SqlNodeList orderList;
        SqlNode aggregateNode;
        SelectScope scope = this.getRawSelectScope(select2);
        switch (modality) {
            case STREAM: {
                if (scope.children.size() == 1) {
                    for (Pair namespace : scope.children) {
                        if (((SqlValidatorNamespace)namespace.right).supportsModality(modality)) continue;
                        if (fail) {
                            throw this.newValidationError(((SqlValidatorNamespace)namespace.right).getNode(), Static.RESOURCE.cannotConvertToStream((String)namespace.left));
                        }
                        return false;
                    }
                    break;
                }
                int supportsModalityCount = 0;
                for (Pair namespace : scope.children) {
                    if (!((SqlValidatorNamespace)namespace.right).supportsModality(modality)) continue;
                    ++supportsModalityCount;
                }
                if (supportsModalityCount != 0) break;
                if (fail) {
                    ArrayList inputList = new ArrayList();
                    for (Pair namespace : scope.children) {
                        inputList.add(namespace.left);
                    }
                    String inputs = Joiner.on(", ").join(inputList);
                    throw this.newValidationError(select2, Static.RESOURCE.cannotStreamResultsForNonStreamingInputs(inputs));
                }
                return false;
            }
            default: {
                for (Pair namespace : scope.children) {
                    if (((SqlValidatorNamespace)namespace.right).supportsModality(modality)) continue;
                    if (fail) {
                        throw this.newValidationError(((SqlValidatorNamespace)namespace.right).getNode(), Static.RESOURCE.cannotConvertToRelation((String)namespace.left));
                    }
                    return false;
                }
            }
        }
        if ((aggregateNode = this.getAggregate(select2)) != null) {
            switch (modality) {
                case STREAM: {
                    SqlNodeList groupList = select2.getGroup();
                    if (groupList != null && SqlValidatorUtil.containsMonotonic(scope, groupList)) break;
                    if (fail) {
                        throw this.newValidationError(aggregateNode, Static.RESOURCE.streamMustGroupByMonotonic());
                    }
                    return false;
                }
            }
        }
        if ((orderList = select2.getOrderList()) != null && orderList.size() > 0) {
            switch (modality) {
                case STREAM: {
                    if (this.hasSortedPrefix(scope, orderList)) break;
                    if (fail) {
                        throw this.newValidationError(orderList.get(0), Static.RESOURCE.streamMustOrderByMonotonic());
                    }
                    return false;
                }
            }
        }
        return true;
    }

    private boolean hasSortedPrefix(SelectScope scope, SqlNodeList orderList) {
        return this.isSortCompatible(scope, orderList.get(0), false);
    }

    private boolean isSortCompatible(SelectScope scope, SqlNode node, boolean descending) {
        switch (node.getKind()) {
            case DESCENDING: {
                return this.isSortCompatible(scope, ((SqlCall)node).getOperandList().get(0), true);
            }
        }
        SqlMonotonicity monotonicity = scope.getMonotonicity(node);
        switch (monotonicity) {
            case INCREASING: 
            case STRICTLY_INCREASING: {
                return !descending;
            }
            case DECREASING: 
            case STRICTLY_DECREASING: {
                return descending;
            }
        }
        return false;
    }

    protected void validateWindowClause(SqlSelect select2) {
        SqlNodeList windowList = select2.getWindowList();
        if (windowList == null || windowList.size() == 0) {
            return;
        }
        SelectScope windowScope = (SelectScope)this.getFromScope(select2);
        assert (windowScope != null);
        for (SqlNode node : windowList) {
            SqlWindow child = (SqlWindow)node;
            SqlIdentifier declName = child.getDeclName();
            if (!declName.isSimple()) {
                throw this.newValidationError(declName, Static.RESOURCE.windowNameMustBeSimple());
            }
            if (windowScope.existingWindowName(declName.toString())) {
                throw this.newValidationError(declName, Static.RESOURCE.duplicateWindowName());
            }
            windowScope.addWindowName(declName.toString());
        }
        for (int i = 0; i < windowList.size(); ++i) {
            SqlNode window1 = windowList.get(i);
            for (int j2 = i + 1; j2 < windowList.size(); ++j2) {
                SqlNode window2 = windowList.get(j2);
                if (!window1.equalsDeep(window2, Litmus.IGNORE)) continue;
                throw this.newValidationError(window2, Static.RESOURCE.dupWindowSpec());
            }
        }
        windowList.validate(this, windowScope);
    }

    @Override
    public void validateWith(SqlWith with, SqlValidatorScope scope) {
        SqlValidatorNamespace namespace = this.getNamespace(with);
        this.validateNamespace(namespace);
    }

    @Override
    public void validateWithItem(SqlWithItem withItem) {
        if (withItem.columnList != null) {
            RelDataType rowType = this.getValidatedNodeType(withItem.query);
            int fieldCount = rowType.getFieldCount();
            if (withItem.columnList.size() != fieldCount) {
                throw this.newValidationError(withItem.columnList, Static.RESOURCE.columnCountMismatch());
            }
            List<String> names = Lists.transform(withItem.columnList.getList(), new Function<SqlNode, String>(){

                @Override
                public String apply(SqlNode o) {
                    return ((SqlIdentifier)o).getSimple();
                }
            });
            int i = Util.firstDuplicate(names);
            if (i >= 0) {
                throw this.newValidationError(withItem.columnList.get(i), Static.RESOURCE.duplicateNameInColumnList(names.get(i)));
            }
        } else {
            List<String> fieldNames = this.getValidatedNodeType(withItem.query).getFieldNames();
            int i = Util.firstDuplicate(fieldNames);
            if (i >= 0) {
                throw this.newValidationError(withItem.query, Static.RESOURCE.duplicateColumnAndNoColumnList(fieldNames.get(i)));
            }
        }
    }

    @Override
    public void validateSequenceValue(SqlValidatorScope scope, SqlIdentifier id) {
        SqlValidatorNamespace ns = scope.getTableNamespace(id.names);
        if (ns == null) {
            throw this.newValidationError(id, Static.RESOURCE.tableNameNotFound(id.toString()));
        }
        if (!(ns instanceof TableNamespace)) {
            throw this.newValidationError(id, Static.RESOURCE.notASequence(id.toString()));
        }
        SqlValidatorTable table = ns.getTable();
        Table table1 = ((RelOptTable)((Object)table)).unwrap(Table.class);
        switch (table1.getJdbcTableType()) {
            case SEQUENCE: 
            case TEMPORARY_SEQUENCE: {
                break;
            }
            default: {
                throw this.newValidationError(id, Static.RESOURCE.notASequence(id.toString()));
            }
        }
    }

    @Override
    public SqlValidatorScope getWithScope(SqlNode withItem) {
        assert (withItem.getKind() == SqlKind.WITH_ITEM);
        return this.scopes.get(withItem);
    }

    protected void validateOrderList(SqlSelect select2) {
        SqlNodeList orderList = select2.getOrderList();
        if (orderList == null) {
            return;
        }
        if (!this.shouldAllowIntermediateOrderBy() && !this.cursorSet.contains(select2)) {
            throw this.newValidationError(select2, Static.RESOURCE.invalidOrderByPos());
        }
        SqlValidatorScope orderScope = this.getOrderScope(select2);
        Util.permAssert(orderScope != null, "orderScope != null");
        for (SqlNode orderItem : orderList) {
            this.validateOrderItem(select2, orderItem);
        }
    }

    private void validateOrderItem(SqlSelect select2, SqlNode orderItem) {
        if (SqlUtil.isCallTo(orderItem, SqlStdOperatorTable.DESC)) {
            this.validateFeature(Static.RESOURCE.sQLConformance_OrderByDesc(), orderItem.getParserPosition());
            this.validateOrderItem(select2, (SqlNode)((SqlCall)orderItem).operand(0));
            return;
        }
        SqlValidatorScope orderScope = this.getOrderScope(select2);
        this.validateExpr(orderItem, orderScope);
    }

    @Override
    public SqlNode expandOrderExpr(SqlSelect select2, SqlNode orderExpr) {
        return new OrderExpressionExpander(select2, orderExpr).go();
    }

    protected void validateGroupClause(SqlSelect select2) {
        SqlNodeList groupList = select2.getGroup();
        if (groupList == null) {
            return;
        }
        this.validateNoAggs(groupList, "GROUP BY");
        SqlValidatorScope groupScope = this.getGroupScope(select2);
        this.inferUnknownTypes(this.unknownType, groupScope, groupList);
        block3: for (SqlNode node : groupList) {
            switch (node.getKind()) {
                case GROUPING_SETS: 
                case ROLLUP: 
                case CUBE: {
                    node.validate(this, groupScope);
                    continue block3;
                }
            }
            node.validateExpr(this, groupScope);
        }
        SqlValidatorScope selectScope = this.getSelectScope(select2);
        AggregatingSelectScope aggregatingScope = null;
        if (selectScope instanceof AggregatingSelectScope) {
            aggregatingScope = (AggregatingSelectScope)selectScope;
        }
        for (SqlNode groupItem : groupList) {
            if (groupItem instanceof SqlNodeList && ((SqlNodeList)groupItem).size() == 0) continue;
            this.validateGroupItem(groupScope, aggregatingScope, groupItem);
        }
        SqlNode agg = this.aggFinder.findAgg(groupList);
        if (agg != null) {
            throw this.newValidationError(agg, Static.RESOURCE.aggregateIllegalInGroupBy());
        }
    }

    private void validateGroupItem(SqlValidatorScope groupScope, AggregatingSelectScope aggregatingScope, SqlNode groupItem) {
        switch (groupItem.getKind()) {
            case GROUPING_SETS: 
            case ROLLUP: 
            case CUBE: {
                this.validateGroupingSets(groupScope, aggregatingScope, (SqlCall)groupItem);
                break;
            }
            default: {
                if (groupItem instanceof SqlNodeList) break;
                RelDataType type = this.deriveType(groupScope, groupItem);
                this.setValidatedNodeTypeImpl(groupItem, type);
            }
        }
    }

    private void validateGroupingSets(SqlValidatorScope groupScope, AggregatingSelectScope aggregatingScope, SqlCall groupItem) {
        for (SqlNode node : groupItem.getOperandList()) {
            this.validateGroupItem(groupScope, aggregatingScope, node);
        }
    }

    protected void validateWhereClause(SqlSelect select2) {
        SqlNode where = select2.getWhere();
        if (where == null) {
            return;
        }
        SqlValidatorScope whereScope = this.getWhereScope(select2);
        this.validateWhereOrOn(whereScope, where, "WHERE");
    }

    protected void validateWhereOrOn(SqlValidatorScope scope, SqlNode condition, String keyword) {
        this.validateNoAggs(condition, keyword);
        this.inferUnknownTypes(this.booleanType, scope, condition);
        condition.validate(this, scope);
        RelDataType type = this.deriveType(scope, condition);
        if (!SqlTypeUtil.inBooleanFamily(type)) {
            throw this.newValidationError(condition, Static.RESOURCE.condMustBeBoolean(keyword));
        }
    }

    protected void validateHavingClause(SqlSelect select2) {
        SqlNode having = select2.getHaving();
        if (having == null) {
            return;
        }
        AggregatingScope havingScope = (AggregatingScope)this.getSelectScope(select2);
        havingScope.checkAggregateExpr(having, true);
        this.inferUnknownTypes(this.booleanType, havingScope, having);
        having.validate(this, havingScope);
        RelDataType type = this.deriveType(havingScope, having);
        if (!SqlTypeUtil.inBooleanFamily(type)) {
            throw this.newValidationError(having, Static.RESOURCE.havingMustBeBoolean());
        }
    }

    protected RelDataType validateSelectList(SqlNodeList selectItems, SqlSelect select2, RelDataType targetRowType) {
        SqlValidatorScope selectScope = this.getSelectScope(select2);
        ArrayList<SqlNode> expandedSelectItems = Lists.newArrayList();
        HashSet<String> aliases = Sets.newHashSet();
        ArrayList<Map.Entry<String, RelDataType>> fieldList = Lists.newArrayList();
        for (int i = 0; i < selectItems.size(); ++i) {
            SqlNode selectItem = selectItems.get(i);
            if (selectItem instanceof SqlSelect) {
                this.handleScalarSubQuery(select2, (SqlSelect)selectItem, expandedSelectItems, aliases, fieldList);
                continue;
            }
            this.expandSelectItem(selectItem, select2, expandedSelectItems, aliases, fieldList, false);
        }
        if (selectScope instanceof AggregatingScope) {
            AggregatingScope aggScope = (AggregatingScope)selectScope;
            for (SqlNode selectItem : expandedSelectItems) {
                boolean matches = aggScope.checkAggregateExpr(selectItem, true);
                Util.discard(matches);
            }
        }
        SqlNodeList newSelectList = new SqlNodeList(expandedSelectItems, selectItems.getParserPosition());
        if (this.shouldExpandIdentifiers()) {
            select2.setSelectList(newSelectList);
        }
        this.getRawSelectScope(select2).setExpandedSelectList(expandedSelectItems);
        this.inferUnknownTypes(targetRowType, selectScope, newSelectList);
        for (SqlNode selectItem : expandedSelectItems) {
            this.validateExpr(selectItem, selectScope);
        }
        assert (fieldList.size() >= aliases.size());
        return this.typeFactory.createStructType(fieldList);
    }

    private void validateExpr(SqlNode expr, SqlValidatorScope scope) {
        SqlCall sqlCall;
        if (expr instanceof SqlCall && (sqlCall = (SqlCall)expr).getOperator().isAggregator() && ((SqlAggFunction)sqlCall.getOperator()).requiresOver()) {
            throw this.newValidationError(expr, Static.RESOURCE.absentOverClause());
        }
        expr.validateExpr(this, scope);
        scope.validateExpr(expr);
    }

    private void handleScalarSubQuery(SqlSelect parentSelect, SqlSelect selectItem, List<SqlNode> expandedSelectItems, Set<String> aliasList, List<Map.Entry<String, RelDataType>> fieldList) {
        if (1 != selectItem.getSelectList().size()) {
            throw this.newValidationError(selectItem, Static.RESOURCE.onlyScalarSubqueryAllowed());
        }
        expandedSelectItems.add(selectItem);
        String alias2 = this.deriveAlias(selectItem, aliasList.size());
        aliasList.add(alias2);
        SelectScope scope = (SelectScope)this.getWhereScope(parentSelect);
        RelDataType type = this.deriveType(scope, selectItem);
        this.setValidatedNodeTypeImpl(selectItem, type);
        assert (type instanceof RelRecordType);
        RelRecordType rec = (RelRecordType)type;
        RelDataType nodeType = rec.getFieldList().get(0).getType();
        nodeType = this.typeFactory.createTypeWithNullability(nodeType, true);
        fieldList.add(Pair.of(alias2, nodeType));
    }

    protected RelDataType createTargetRowType(SqlValidatorTable table, SqlNodeList targetColumnList, boolean append) {
        RelDataType baseRowType = table.getRowType();
        if (targetColumnList == null) {
            return baseRowType;
        }
        List<RelDataTypeField> targetFields = baseRowType.getFieldList();
        ArrayList<Map.Entry<String, RelDataType>> types = new ArrayList<Map.Entry<String, RelDataType>>();
        if (append) {
            for (RelDataTypeField targetField : targetFields) {
                types.add(Pair.of(SqlUtil.deriveAliasFromOrdinal(types.size()), targetField.getType()));
            }
        }
        HashSet<Integer> assignedFields = new HashSet<Integer>();
        for (SqlNode node : targetColumnList) {
            SqlIdentifier id = (SqlIdentifier)node;
            String name = id.getSimple();
            RelDataTypeField targetField = this.catalogReader.field(baseRowType, name);
            if (targetField == null) {
                throw this.newValidationError(id, Static.RESOURCE.unknownTargetColumn(name));
            }
            if (!assignedFields.add(targetField.getIndex())) {
                throw this.newValidationError(id, Static.RESOURCE.duplicateTargetColumn(targetField.getName()));
            }
            types.add(targetField);
        }
        return this.typeFactory.createStructType(types);
    }

    @Override
    public void validateInsert(SqlInsert insert) {
        SqlValidatorNamespace targetNamespace = this.getNamespace(insert);
        this.validateNamespace(targetNamespace);
        SqlValidatorTable table = targetNamespace.getTable();
        RelDataType targetRowType = this.createTargetRowType(table, insert.getTargetColumnList(), false);
        SqlNode source = insert.getSource();
        if (source instanceof SqlSelect) {
            SqlSelect sqlSelect = (SqlSelect)source;
            this.validateSelect(sqlSelect, targetRowType);
        } else {
            SqlValidatorScope scope = this.scopes.get(source);
            this.validateQuery(source, scope);
        }
        RelDataType sourceRowType = this.getNamespace(source).getRowType();
        RelDataType logicalTargetRowType = this.getLogicalTargetRowType(targetRowType, insert);
        this.setValidatedNodeType(insert, logicalTargetRowType);
        RelDataType logicalSourceRowType = this.getLogicalSourceRowType(sourceRowType, insert);
        this.checkFieldCount(insert, logicalSourceRowType, logicalTargetRowType);
        this.checkTypeAssignment(logicalSourceRowType, logicalTargetRowType, insert);
        this.validateAccess(insert.getTargetTable(), table, SqlAccessEnum.INSERT);
    }

    private void checkFieldCount(SqlNode node, RelDataType logicalSourceRowType, RelDataType logicalTargetRowType) {
        int targetFieldCount;
        int sourceFieldCount = logicalSourceRowType.getFieldCount();
        if (sourceFieldCount != (targetFieldCount = logicalTargetRowType.getFieldCount())) {
            throw this.newValidationError(node, Static.RESOURCE.unmatchInsertColumn(targetFieldCount, sourceFieldCount));
        }
    }

    protected RelDataType getLogicalTargetRowType(RelDataType targetRowType, SqlInsert insert) {
        return targetRowType;
    }

    protected RelDataType getLogicalSourceRowType(RelDataType sourceRowType, SqlInsert insert) {
        return sourceRowType;
    }

    protected void checkTypeAssignment(RelDataType sourceRowType, RelDataType targetRowType, SqlNode query) {
        List<RelDataTypeField> sourceFields = sourceRowType.getFieldList();
        List<RelDataTypeField> targetFields = targetRowType.getFieldList();
        int sourceCount = sourceFields.size();
        for (int i = 0; i < sourceCount; ++i) {
            String targetTypeString;
            String sourceTypeString;
            RelDataType sourceType = sourceFields.get(i).getType();
            RelDataType targetType = targetFields.get(i).getType();
            if (SqlTypeUtil.canAssignFrom(targetType, sourceType)) continue;
            int iAdjusted = i;
            if (query instanceof SqlUpdate) {
                int nUpdateColumns = ((SqlUpdate)query).getTargetColumnList().size();
                assert (sourceFields.size() >= nUpdateColumns);
                iAdjusted -= sourceFields.size() - nUpdateColumns;
            }
            SqlNode node = this.getNthExpr(query, iAdjusted, sourceCount);
            if (SqlTypeUtil.areCharacterSetsMismatched(sourceType, targetType)) {
                sourceTypeString = sourceType.getFullTypeString();
                targetTypeString = targetType.getFullTypeString();
            } else {
                sourceTypeString = sourceType.toString();
                targetTypeString = targetType.toString();
            }
            throw this.newValidationError(node, Static.RESOURCE.typeNotAssignable(targetFields.get(i).getName(), targetTypeString, sourceFields.get(i).getName(), sourceTypeString));
        }
    }

    private SqlNode getNthExpr(SqlNode query, int ordinal, int sourceCount) {
        if (query instanceof SqlInsert) {
            SqlInsert insert = (SqlInsert)query;
            if (insert.getTargetColumnList() != null) {
                return insert.getTargetColumnList().get(ordinal);
            }
            return this.getNthExpr(insert.getSource(), ordinal, sourceCount);
        }
        if (query instanceof SqlUpdate) {
            SqlUpdate update = (SqlUpdate)query;
            if (update.getTargetColumnList() != null) {
                return update.getTargetColumnList().get(ordinal);
            }
            if (update.getSourceExpressionList() != null) {
                return update.getSourceExpressionList().get(ordinal);
            }
            return this.getNthExpr(update.getSourceSelect(), ordinal, sourceCount);
        }
        if (query instanceof SqlSelect) {
            SqlSelect select2 = (SqlSelect)query;
            if (select2.getSelectList().size() == sourceCount) {
                return select2.getSelectList().get(ordinal);
            }
            return query;
        }
        return query;
    }

    @Override
    public void validateDelete(SqlDelete call) {
        SqlSelect sqlSelect = call.getSourceSelect();
        this.validateSelect(sqlSelect, this.unknownType);
        IdentifierNamespace targetNamespace = this.getNamespace(call.getTargetTable()).unwrap(IdentifierNamespace.class);
        this.validateNamespace(targetNamespace);
        SqlValidatorTable table = targetNamespace.getTable();
        this.validateAccess(call.getTargetTable(), table, SqlAccessEnum.DELETE);
    }

    @Override
    public void validateUpdate(SqlUpdate call) {
        IdentifierNamespace targetNamespace = this.getNamespace(call.getTargetTable()).unwrap(IdentifierNamespace.class);
        this.validateNamespace(targetNamespace);
        SqlValidatorTable table = targetNamespace.getTable();
        RelDataType targetRowType = this.createTargetRowType(table, call.getTargetColumnList(), true);
        SqlSelect select2 = call.getSourceSelect();
        this.validateSelect(select2, targetRowType);
        RelDataType sourceRowType = this.getNamespace(select2).getRowType();
        this.checkTypeAssignment(sourceRowType, targetRowType, call);
        this.validateAccess(call.getTargetTable(), table, SqlAccessEnum.UPDATE);
    }

    @Override
    public void validateMerge(SqlMerge call) {
        SqlSelect sqlSelect = call.getSourceSelect();
        IdentifierNamespace targetNamespace = (IdentifierNamespace)this.getNamespace(call.getTargetTable());
        this.validateNamespace(targetNamespace);
        SqlValidatorTable table = targetNamespace.getTable();
        this.validateAccess(call.getTargetTable(), table, SqlAccessEnum.UPDATE);
        RelDataType targetRowType = this.unknownType;
        if (call.getUpdateCall() != null) {
            targetRowType = this.createTargetRowType(table, call.getUpdateCall().getTargetColumnList(), true);
        }
        if (call.getInsertCall() != null) {
            targetRowType = this.createTargetRowType(table, call.getInsertCall().getTargetColumnList(), false);
        }
        this.validateSelect(sqlSelect, targetRowType);
        if (call.getUpdateCall() != null) {
            this.validateUpdate(call.getUpdateCall());
        }
        if (call.getInsertCall() != null) {
            this.validateInsert(call.getInsertCall());
        }
    }

    private void validateAccess(SqlNode node, SqlValidatorTable table, SqlAccessEnum requiredAccess) {
        SqlAccessType access;
        if (table != null && !(access = table.getAllowedAccess()).allowsAccess(requiredAccess)) {
            throw this.newValidationError(node, Static.RESOURCE.accessNotAllowed(requiredAccess.name(), table.getQualifiedName().toString()));
        }
    }

    protected void validateValues(SqlCall node, RelDataType targetRowType, final SqlValidatorScope scope) {
        assert (node.getKind() == SqlKind.VALUES);
        final List<SqlNode> operands = node.getOperandList();
        for (SqlNode operand : operands) {
            if (operand.getKind() != SqlKind.ROW) {
                throw Util.needToImplement("Values function where operands are scalars");
            }
            SqlCall rowConstructor = (SqlCall)operand;
            if (targetRowType.isStruct() && rowConstructor.operandCount() != targetRowType.getFieldCount()) {
                return;
            }
            this.inferUnknownTypes(targetRowType, scope, rowConstructor);
        }
        for (SqlNode operand : operands) {
            operand.validate(this, scope);
        }
        int rowCount = operands.size();
        if (rowCount >= 2) {
            SqlCall firstRow = (SqlCall)operands.get(0);
            int columnCount = firstRow.operandCount();
            for (SqlNode operand : operands) {
                SqlCall thisRow = (SqlCall)operand;
                if (columnCount == thisRow.operandCount()) continue;
                throw this.newValidationError(node, Static.RESOURCE.incompatibleValueType(SqlStdOperatorTable.VALUES.getName()));
            }
            int col = 0;
            while (col < columnCount) {
                int c;
                RelDataType type;
                if (null != (type = this.typeFactory.leastRestrictive((List<RelDataType>)new AbstractList<RelDataType>(c = col++, rowCount){
                    final /* synthetic */ int val$c;
                    final /* synthetic */ int val$rowCount;
                    {
                        this.val$c = n;
                        this.val$rowCount = n2;
                    }

                    @Override
                    public RelDataType get(int row) {
                        SqlCall thisRow = (SqlCall)operands.get(row);
                        return SqlValidatorImpl.this.deriveType(scope, (SqlNode)thisRow.operand(this.val$c));
                    }

                    @Override
                    public int size() {
                        return this.val$rowCount;
                    }
                }))) continue;
                throw this.newValidationError(node, Static.RESOURCE.incompatibleValueType(SqlStdOperatorTable.VALUES.getName()));
            }
        }
    }

    @Override
    public void validateDataType(SqlDataTypeSpec dataType2) {
    }

    @Override
    public void validateDynamicParam(SqlDynamicParam dynamicParam) {
    }

    @Override
    public CalciteContextException newValidationError(SqlNode node, Resources.ExInst<SqlValidatorException> e) {
        assert (node != null);
        SqlParserPos pos = node.getParserPosition();
        return SqlUtil.newContextException(pos, e);
    }

    protected SqlWindow getWindowByName(SqlIdentifier id, SqlValidatorScope scope) {
        SqlWindow window = null;
        if (id.isSimple()) {
            String name = id.getSimple();
            window = scope.lookupWindow(name);
        }
        if (window == null) {
            throw this.newValidationError(id, Static.RESOURCE.windowNotFound(id.toString()));
        }
        return window;
    }

    @Override
    public SqlWindow resolveWindow(SqlNode windowOrRef, SqlValidatorScope scope, boolean populateBounds) {
        SqlIdentifier refId;
        SqlWindow window = windowOrRef instanceof SqlIdentifier ? this.getWindowByName((SqlIdentifier)windowOrRef, scope) : (SqlWindow)windowOrRef;
        while ((refId = window.getRefName()) != null) {
            String refName = refId.getSimple();
            SqlWindow refWindow = scope.lookupWindow(refName);
            if (refWindow == null) {
                throw this.newValidationError(refId, Static.RESOURCE.windowNotFound(refName));
            }
            window = window.overlay(refWindow, this);
        }
        if (populateBounds) {
            window.populateBounds();
        }
        return window;
    }

    public SqlNode getOriginal(SqlNode expr) {
        SqlNode original = this.originalExprs.get(expr);
        if (original == null) {
            original = expr;
        }
        return original;
    }

    public void setOriginal(SqlNode expr, SqlNode original) {
        if (this.originalExprs.get(expr) == null) {
            this.originalExprs.put(expr, original);
        }
    }

    SqlValidatorNamespace lookupFieldNamespace(RelDataType rowType, String name) {
        RelDataTypeField field = this.catalogReader.field(rowType, name);
        return new FieldNamespace(this, field.getType());
    }

    @Override
    public void validateWindow(SqlNode windowOrId, SqlValidatorScope scope, SqlCall call) {
        SqlWindow targetWindow;
        switch (windowOrId.getKind()) {
            case IDENTIFIER: {
                targetWindow = this.getWindowByName((SqlIdentifier)windowOrId, scope);
                break;
            }
            case WINDOW: {
                targetWindow = (SqlWindow)windowOrId;
                break;
            }
            default: {
                throw Util.unexpected(windowOrId.getKind());
            }
        }
        assert (targetWindow.getWindowCall() == null);
        targetWindow.setWindowCall(call);
        targetWindow.validate(this, scope);
        targetWindow.setWindowCall(null);
        call.validate(this, scope);
    }

    @Override
    public void validateAggregateParams(SqlCall aggCall, SqlNode filter, SqlValidatorScope scope) {
        for (SqlNode param : aggCall.getOperandList()) {
            if (this.aggOrOverFinder.findAgg(param) == null) continue;
            throw this.newValidationError(aggCall, Static.RESOURCE.nestedAggIllegal());
        }
        if (filter != null && this.aggOrOverFinder.findAgg(filter) != null) {
            throw this.newValidationError(filter, Static.RESOURCE.aggregateInFilterIllegal());
        }
    }

    @Override
    public void validateCall(SqlCall call, SqlValidatorScope scope) {
        SqlOperator operator = call.getOperator();
        if (call.operandCount() == 0 && operator.getSyntax() == SqlSyntax.FUNCTION_ID && !call.isExpanded()) {
            throw this.handleUnresolvedFunction(call, (SqlFunction)operator, ImmutableList.of(), null);
        }
        SqlValidatorScope operandScope = scope.getOperandScope(call);
        operator.validateCall(call, this, scope, operandScope);
    }

    protected void validateFeature(Feature feature, SqlParserPos context) {
        assert (feature.getProperties().get("FeatureDefinition") != null);
    }

    @Override
    public SqlNode expand(SqlNode expr, SqlValidatorScope scope) {
        Expander expander = new Expander(this, scope);
        SqlNode newExpr = expr.accept(expander);
        if (expr != newExpr) {
            this.setOriginal(newExpr, expr);
        }
        return newExpr;
    }

    @Override
    public boolean isSystemField(RelDataTypeField field) {
        return false;
    }

    @Override
    public List<List<String>> getFieldOrigins(SqlNode sqlQuery) {
        if (sqlQuery instanceof SqlExplain) {
            return Collections.emptyList();
        }
        RelDataType rowType = this.getValidatedNodeType(sqlQuery);
        int fieldCount = rowType.getFieldCount();
        if (!sqlQuery.isA(SqlKind.QUERY)) {
            return Collections.nCopies(fieldCount, null);
        }
        ArrayList<List<String>> list = new ArrayList<List<String>>();
        for (int i = 0; i < fieldCount; ++i) {
            List<String> origin = this.getFieldOrigin(sqlQuery, i);
            list.add(origin);
        }
        return list;
    }

    private List<String> getFieldOrigin(SqlNode sqlQuery, int i) {
        SqlSelect sqlSelect;
        SelectScope scope;
        List<SqlNode> selectList;
        SqlNode selectItem;
        if (sqlQuery instanceof SqlSelect && (selectItem = SqlUtil.stripAs((selectList = (scope = this.getRawSelectScope(sqlSelect = (SqlSelect)sqlQuery)).getExpandedSelectList()).get(i))) instanceof SqlIdentifier) {
            SqlQualified qualified = scope.fullyQualify((SqlIdentifier)selectItem);
            SqlValidatorNamespace namespace = qualified.namespace;
            SqlValidatorTable table = namespace.getTable();
            if (table == null) {
                return null;
            }
            ArrayList<String> origin = Lists.newArrayList(table.getQualifiedName());
            for (String name : qualified.suffix()) {
                if ((namespace = namespace.lookupChild(name)) == null) {
                    return null;
                }
                origin.add(name);
            }
            return origin;
        }
        return null;
    }

    @Override
    public RelDataType getParameterRowType(SqlNode sqlQuery) {
        final ArrayList<RelDataType> types = new ArrayList<RelDataType>();
        sqlQuery.accept(new SqlShuttle(){

            @Override
            public SqlNode visit(SqlDynamicParam param) {
                RelDataType type = SqlValidatorImpl.this.getValidatedNodeType(param);
                types.add(type);
                return param;
            }
        });
        return this.typeFactory.createStructType(types, (List<String>)new AbstractList<String>(){

            @Override
            public String get(int index) {
                return "?" + index;
            }

            @Override
            public int size() {
                return types.size();
            }
        });
    }

    @Override
    public void validateColumnListParams(SqlFunction function, List<RelDataType> argTypes, List<SqlNode> operands) {
        throw new UnsupportedOperationException();
    }

    protected static class FunctionParamInfo {
        public final Map<Integer, SqlSelect> cursorPosToSelectMap = new HashMap<Integer, SqlSelect>();
        public final Map<String, String> columnListParamToParentCursorMap = new HashMap<String, String>();
    }

    protected static class IdInfo {
        public final SqlValidatorScope scope;
        public final SqlIdentifier id;

        public IdInfo(SqlValidatorScope scope, SqlIdentifier id) {
            this.scope = scope;
            this.id = id;
        }
    }

    class OrderExpressionExpander
    extends SqlScopedShuttle {
        private final List<String> aliasList;
        private final SqlSelect select;
        private final SqlNode root;

        OrderExpressionExpander(SqlSelect select2, SqlNode root) {
            super(SqlValidatorImpl.this.getOrderScope(select2));
            this.select = select2;
            this.root = root;
            this.aliasList = SqlValidatorImpl.this.getNamespace(select2).getRowType().getFieldNames();
        }

        public SqlNode go() {
            return this.root.accept(this);
        }

        @Override
        public SqlNode visit(SqlLiteral literal) {
            if (literal == this.root && SqlValidatorImpl.this.getConformance().isSortByOrdinal()) {
                switch (literal.getTypeName()) {
                    case DECIMAL: 
                    case DOUBLE: {
                        int intValue = literal.intValue(false);
                        if (intValue < 0) break;
                        if (intValue < 1 || intValue > this.aliasList.size()) {
                            throw SqlValidatorImpl.this.newValidationError(literal, Static.RESOURCE.orderByOrdinalOutOfRange());
                        }
                        int ordinal = intValue - 1;
                        return this.nthSelectItem(ordinal, literal.getParserPosition());
                    }
                }
            }
            return super.visit(literal);
        }

        private SqlNode nthSelectItem(int ordinal, SqlParserPos pos) {
            SqlNodeList expandedSelectList = SqlValidatorImpl.this.expandStar(this.select.getSelectList(), this.select, false);
            SqlNode expr = expandedSelectList.get(ordinal);
            if ((expr = SqlUtil.stripAs(expr)) instanceof SqlIdentifier) {
                expr = this.getScope().fullyQualify((SqlIdentifier)((SqlIdentifier)expr)).identifier;
            }
            return expr.clone(pos);
        }

        @Override
        public SqlNode visit(SqlIdentifier id) {
            if (id.isSimple() && SqlValidatorImpl.this.getConformance().isSortByAlias()) {
                String alias2 = id.getSimple();
                SqlValidatorNamespace selectNs = SqlValidatorImpl.this.getNamespace(this.select);
                RelDataType rowType = selectNs.getRowTypeSansSystemColumns();
                RelDataTypeField field = SqlValidatorImpl.this.catalogReader.field(rowType, alias2);
                if (field != null) {
                    return this.nthSelectItem(field.getIndex(), id.getParserPosition());
                }
            }
            return this.getScope().fullyQualify((SqlIdentifier)id).identifier;
        }

        @Override
        protected SqlNode visitScoped(SqlCall call) {
            if (call instanceof SqlSelect) {
                return call;
            }
            return super.visitScoped(call);
        }
    }

    private static class Expander
    extends SqlScopedShuttle {
        private final SqlValidatorImpl validator;

        public Expander(SqlValidatorImpl validator, SqlValidatorScope scope) {
            super(scope);
            this.validator = validator;
        }

        @Override
        public SqlNode visit(SqlIdentifier id) {
            SqlCall call = SqlUtil.makeCall(this.validator.getOperatorTable(), id);
            if (call != null) {
                return call.accept(this);
            }
            SqlIdentifier fqId = this.getScope().fullyQualify((SqlIdentifier)id).identifier;
            this.validator.setOriginal(fqId, id);
            return fqId;
        }

        @Override
        protected SqlNode visitScoped(SqlCall call) {
            switch (call.getKind()) {
                case SCALAR_QUERY: 
                case CURRENT_VALUE: 
                case NEXT_VALUE: {
                    return call;
                }
            }
            SqlShuttle.CallCopyingArgHandler argHandler = new SqlShuttle.CallCopyingArgHandler(call, false);
            call.getOperator().acceptCall(this, call, true, argHandler);
            SqlNode result = (SqlNode)argHandler.result();
            this.validator.setOriginal(result, call);
            return result;
        }
    }

    private class DeriveTypeVisitor
    implements SqlVisitor<RelDataType> {
        private final SqlValidatorScope scope;

        public DeriveTypeVisitor(SqlValidatorScope scope) {
            this.scope = scope;
        }

        @Override
        public RelDataType visit(SqlLiteral literal) {
            return literal.createSqlType(SqlValidatorImpl.this.typeFactory);
        }

        @Override
        public RelDataType visit(SqlCall call) {
            SqlOperator operator = call.getOperator();
            return operator.deriveType(SqlValidatorImpl.this, this.scope, call);
        }

        @Override
        public RelDataType visit(SqlNodeList nodeList) {
            throw Util.needToImplement(nodeList);
        }

        @Override
        public RelDataType visit(SqlIdentifier id) {
            int i;
            SqlCall call = SqlUtil.makeCall(SqlValidatorImpl.this.opTab, id);
            if (call != null) {
                return call.getOperator().validateOperands(SqlValidatorImpl.this, this.scope, call);
            }
            RelDataType type = null;
            if (!(this.scope instanceof EmptyScope)) {
                id = this.scope.fullyQualify((SqlIdentifier)id).identifier;
            }
            for (i = id.names.size() - 1; i > 0; --i) {
                SqlValidatorNamespace resolvedNs = this.scope.resolve(id.names.subList(0, i), null, null);
                if (resolvedNs == null) continue;
                type = resolvedNs.getRowType();
                break;
            }
            if (type == null || id.names.size() == 1) {
                RelDataType colType = this.scope.resolveColumn((String)id.names.get(0), id);
                if (colType != null) {
                    type = colType;
                }
                ++i;
            }
            if (type == null) {
                SqlIdentifier last = id.getComponent(i - 1, i);
                throw SqlValidatorImpl.this.newValidationError(last, Static.RESOURCE.unknownIdentifier(last.toString()));
            }
            while (i < id.names.size()) {
                RelDataTypeField field;
                String name = (String)id.names.get(i);
                if (name.equals("")) {
                    name = "*";
                    field = null;
                } else {
                    field = SqlValidatorImpl.this.catalogReader.field(type, name);
                }
                if (field == null) {
                    throw SqlValidatorImpl.this.newValidationError(id.getComponent(i), Static.RESOURCE.unknownField(name));
                }
                type = field.getType();
                ++i;
            }
            type = SqlTypeUtil.addCharsetAndCollation(type, SqlValidatorImpl.this.getTypeFactory());
            return type;
        }

        @Override
        public RelDataType visit(SqlDataTypeSpec dataType2) {
            SqlValidatorImpl.this.validateDataType(dataType2);
            return dataType2.deriveType(SqlValidatorImpl.this);
        }

        @Override
        public RelDataType visit(SqlDynamicParam param) {
            return SqlValidatorImpl.this.unknownType;
        }

        @Override
        public RelDataType visit(SqlIntervalQualifier intervalQualifier) {
            return SqlValidatorImpl.this.typeFactory.createSqlIntervalType(intervalQualifier);
        }
    }

    private static class MergeNamespace
    extends DmlNamespace {
        private final SqlMerge node;

        public MergeNamespace(SqlValidatorImpl validator, SqlMerge node, SqlNode enclosingNode, SqlValidatorScope parentScope) {
            super(validator, node.getTargetTable(), enclosingNode, parentScope);
            this.node = Preconditions.checkNotNull(node);
        }

        @Override
        public SqlMerge getNode() {
            return this.node;
        }
    }

    private static class DeleteNamespace
    extends DmlNamespace {
        private final SqlDelete node;

        public DeleteNamespace(SqlValidatorImpl validator, SqlDelete node, SqlNode enclosingNode, SqlValidatorScope parentScope) {
            super(validator, node.getTargetTable(), enclosingNode, parentScope);
            this.node = Preconditions.checkNotNull(node);
        }

        @Override
        public SqlDelete getNode() {
            return this.node;
        }
    }

    private static class UpdateNamespace
    extends DmlNamespace {
        private final SqlUpdate node;

        public UpdateNamespace(SqlValidatorImpl validator, SqlUpdate node, SqlNode enclosingNode, SqlValidatorScope parentScope) {
            super(validator, node.getTargetTable(), enclosingNode, parentScope);
            this.node = Preconditions.checkNotNull(node);
        }

        @Override
        public SqlUpdate getNode() {
            return this.node;
        }
    }

    private static class InsertNamespace
    extends DmlNamespace {
        private final SqlInsert node;

        public InsertNamespace(SqlValidatorImpl validator, SqlInsert node, SqlNode enclosingNode, SqlValidatorScope parentScope) {
            super(validator, node.getTargetTable(), enclosingNode, parentScope);
            this.node = Preconditions.checkNotNull(node);
        }

        @Override
        public SqlInsert getNode() {
            return this.node;
        }
    }

    public static class DmlNamespace
    extends IdentifierNamespace {
        protected DmlNamespace(SqlValidatorImpl validator, SqlNode id, SqlNode enclosingNode, SqlValidatorScope parentScope) {
            super(validator, id, enclosingNode, parentScope);
        }
    }

    public static enum Status {
        UNVALIDATED,
        IN_PROGRESS,
        VALID;

    }
}

