/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.table;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql2rel.RelDecorrelator;
import org.apache.calcite.tools.Program;
import org.apache.calcite.tools.Programs;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.io.DiscardingOutputFormat;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.table.FlinkPlannerImpl;
import org.apache.flink.api.table.Row;
import org.apache.flink.api.table.Table;
import org.apache.flink.api.table.TableConfig;
import org.apache.flink.api.table.TableEnvironment;
import org.apache.flink.api.table.TableException;
import org.apache.flink.api.table.ValidationException;
import org.apache.flink.api.table.explain.PlanJsonParser;
import org.apache.flink.api.table.expressions.Expression;
import org.apache.flink.api.table.plan.logical.CatalogNode;
import org.apache.flink.api.table.plan.logical.LogicalRelNode;
import org.apache.flink.api.table.plan.nodes.dataset.DataSetConvention$;
import org.apache.flink.api.table.plan.nodes.dataset.DataSetRel;
import org.apache.flink.api.table.plan.rules.FlinkRuleSets$;
import org.apache.flink.api.table.plan.schema.DataSetTable;
import org.apache.flink.api.table.plan.schema.TableSourceTable;
import org.apache.flink.api.table.sinks.BatchTableSink;
import org.apache.flink.api.table.sinks.TableSink;
import org.apache.flink.api.table.sources.BatchTableSource;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\u0005eg!B\u0001\u0003\u0003\u0003i!!\u0006\"bi\u000eDG+\u00192mK\u0016sg/\u001b:p]6,g\u000e\u001e\u0006\u0003\u0007\u0011\tQ\u0001^1cY\u0016T!!\u0002\u0004\u0002\u0007\u0005\u0004\u0018N\u0003\u0002\b\u0011\u0005)a\r\\5oW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\b\u0011\u0005=\u0001R\"\u0001\u0002\n\u0005E\u0011!\u0001\u0005+bE2,WI\u001c<je>tW.\u001a8u\u0011%\u0019\u0002A!b\u0001\n\u00031A#A\u0004fq\u0016\u001cWI\u001c<\u0016\u0003U\u0001\"AF\r\u000e\u0003]Q!\u0001\u0007\u0003\u0002\t)\fg/Y\u0005\u00035]\u0011A#\u0012=fGV$\u0018n\u001c8F]ZL'o\u001c8nK:$\b\u0002\u0003\u000f\u0001\u0005\u0003\u0005\u000b\u0011B\u000b\u0002\u0011\u0015DXmY#om\u0002B\u0011B\b\u0001\u0003\u0002\u0003\u0006Ia\b\u0012\u0002\r\r|gNZ5h!\ty\u0001%\u0003\u0002\"\u0005\tYA+\u00192mK\u000e{gNZ5h\u0013\tq\u0002\u0003C\u0003%\u0001\u0011\u0005Q%\u0001\u0004=S:LGO\u0010\u000b\u0004M\u001dB\u0003CA\b\u0001\u0011\u0015\u00192\u00051\u0001\u0016\u0011\u0015q2\u00051\u0001 \u0011\u001dQ\u0003A1A\u0005\n-\n\u0001B\\1nK\u000esGO]\u000b\u0002YA\u0011Q&N\u0007\u0002])\u0011q\u0006M\u0001\u0007CR|W.[2\u000b\u0005E\u0012\u0014AC2p]\u000e,(O]3oi*\u00111\u0007N\u0001\u0005kRLGNC\u0001\u0019\u0013\t1dFA\u0007Bi>l\u0017nY%oi\u0016<WM\u001d\u0005\u0007q\u0001\u0001\u000b\u0011\u0002\u0017\u0002\u00139\fW.Z\"oiJ\u0004\u0003b\u0002\u001e\u0001\u0005\u0004%IaO\u0001\u0014S:$XM\u001d8bY:\u000bW.\u001a)biR,'O\\\u000b\u0002yA\u0011QhQ\u0007\u0002})\u0011q\bQ\u0001\t[\u0006$8\r[5oO*\u00111'\u0011\u0006\u0002\u0005\u0006)1oY1mC&\u0011AI\u0010\u0002\u0006%\u0016<W\r\u001f\u0005\u0007\r\u0002\u0001\u000b\u0011\u0002\u001f\u0002)%tG/\u001a:oC2t\u0015-\\3QCR$XM\u001d8!\u0011\u0015A\u0005\u0001\"\u0015J\u0003M\u0019\u0007.Z2l-\u0006d\u0017\u000e\u001a+bE2,g*Y7f)\tQe\n\u0005\u0002L\u00196\t\u0011)\u0003\u0002N\u0003\n!QK\\5u\u0011\u0015yu\t1\u0001Q\u0003\u0011q\u0017-\\3\u0011\u0005E#fBA&S\u0013\t\u0019\u0016)\u0001\u0004Qe\u0016$WMZ\u0005\u0003+Z\u0013aa\u0015;sS:<'BA*B\u0011\u0015A\u0006\u0001\"\u0005Z\u0003U\u0019'/Z1uKVs\u0017.];f)\u0006\u0014G.\u001a(b[\u0016$\u0012\u0001\u0015\u0005\u00067\u0002!\t\u0001X\u0001\u0005g\u000e\fg\u000e\u0006\u0002^AB\u0011qBX\u0005\u0003?\n\u0011Q\u0001V1cY\u0016DQ!\u0019.A\u0002A\u000b\u0011\u0002^1cY\u0016t\u0015-\\3)\u0007i\u001b\u0017\u000eE\u0002LI\u001aL!!Z!\u0003\rQD'o\\<t!\tyq-\u0003\u0002i\u0005\t\u0019b+\u00197jI\u0006$\u0018n\u001c8Fq\u000e,\u0007\u000f^5p]F*a\u0004\u00156\u0002\bE*1e[8\u007faV\u0011A.\\\u000b\u0002!\u0012)a\u000e\u0004b\u0001g\n\tA+\u0003\u0002qc\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIER!A]!\u0002\rQD'o\\<t#\t!x\u000f\u0005\u0002Lk&\u0011a/\u0011\u0002\b\u001d>$\b.\u001b8h!\tA8P\u0004\u0002Ls&\u0011!0Q\u0001\ba\u0006\u001c7.Y4f\u0013\taXPA\u0005UQJ|w/\u00192mK*\u0011!0Q\u0019\bG}\f\t!a\u0001s\u001d\rY\u0015\u0011A\u0005\u0003e\u0006\u000bTAI&B\u0003\u000b\u0011Qa]2bY\u0006\f$A\n4\t\u000f\u0005-\u0001\u0001\"\u0001\u0002\u000e\u0005\u0019\"/Z4jgR,'\u000fV1cY\u0016\u001cv.\u001e:dKR)!*a\u0004\u0002\u0012!1q*!\u0003A\u0002AC\u0001\"a\u0005\u0002\n\u0001\u0007\u0011QC\u0001\fi\u0006\u0014G.Z*pkJ\u001cW\r\r\u0003\u0002\u0018\u0005\u001d\u0002CBA\r\u0003?\t\u0019#\u0004\u0002\u0002\u001c)\u0019\u0011Q\u0004\u0002\u0002\u000fM|WO]2fg&!\u0011\u0011EA\u000e\u0005A\u0011\u0015\r^2i)\u0006\u0014G.Z*pkJ\u001cW\r\u0005\u0003\u0002&\u0005\u001dB\u0002\u0001\u0003\r\u0003S\t\t\"!A\u0001\u0002\u000b\u0005\u00111\u0006\u0002\u0004?\u0012\n\u0014c\u0001;\u0002.A\u00191*a\f\n\u0007\u0005E\u0012IA\u0002B]fDq!!\u000e\u0001\t\u0003\n9$A\u0002tc2$2!XA\u001d\u0011\u001d\tY$a\rA\u0002A\u000bQ!];fefD\u0001\"a\u0010\u0001\t\u00032\u0011\u0011I\u0001\foJLG/\u001a+p'&t7.\u0006\u0003\u0002D\u0005eC#\u0002&\u0002F\u0005\u001d\u0003BB\u0002\u0002>\u0001\u0007Q\f\u0003\u0005\u0002J\u0005u\u0002\u0019AA&\u0003\u0011\u0019\u0018N\\6\u0011\r\u00055\u00131KA,\u001b\t\tyEC\u0002\u0002R\t\tQa]5oWNLA!!\u0016\u0002P\tIA+\u00192mKNKgn\u001b\t\u0005\u0003K\tI\u0006B\u0004o\u0003{\u0011\r!a\u000b\t\u0011\u0005u\u0003\u0001\"\u0001\u0007\u0003?\nq!\u001a=qY\u0006Lg\u000eF\u0003Q\u0003C\n\u0019\u0007\u0003\u0004\u0004\u00037\u0002\r!\u0018\u0005\t\u0003K\nY\u00061\u0001\u0002h\u0005AQ\r\u001f;f]\u0012,G\rE\u0002L\u0003SJ1!a\u001bB\u0005\u001d\u0011un\u001c7fC:Dq!!\u0018\u0001\t\u0003\ty\u0007F\u0002Q\u0003cBaaAA7\u0001\u0004i\u0006bBA;\u0001\u0011E\u0011qO\u0001\u0018e\u0016<\u0017n\u001d;fe\u0012\u000bG/Y*fi&sG/\u001a:oC2,B!!\u001f\u0002\nR)!*a\u001f\u0002~!1q*a\u001dA\u0002AC\u0001\"a \u0002t\u0001\u0007\u0011\u0011Q\u0001\bI\u0006$\u0018mU3u!\u00151\u00121QAD\u0013\r\t)i\u0006\u0002\b\t\u0006$\u0018mU3u!\u0011\t)#!#\u0005\u000f9\f\u0019H1\u0001\u0002,!9\u0011Q\u000f\u0001\u0005\u0012\u00055U\u0003BAH\u00033#rASAI\u0003'\u000bY\n\u0003\u0004P\u0003\u0017\u0003\r\u0001\u0015\u0005\t\u0003\u007f\nY\t1\u0001\u0002\u0016B)a#a!\u0002\u0018B!\u0011QEAM\t\u001dq\u00171\u0012b\u0001\u0003WA\u0001\"!(\u0002\f\u0002\u0007\u0011qT\u0001\u0007M&,G\u000eZ:\u0011\u000b-\u000b\t+!*\n\u0007\u0005\r\u0016IA\u0003BeJ\f\u0017\u0010\u0005\u0003\u0002(\u00065VBAAU\u0015\r\tYKA\u0001\fKb\u0004(/Z:tS>t7/\u0003\u0003\u00020\u0006%&AC#yaJ,7o]5p]\"9\u00111\u0017\u0001\u0005\u0012\u0005U\u0016!\u0003;sC:\u001cH.\u0019;f+\u0011\t9,a0\u0015\t\u0005e\u0016q\u001b\u000b\u0005\u0003w\u000b\u0019\rE\u0003\u0017\u0003\u0007\u000bi\f\u0005\u0003\u0002&\u0005}F\u0001CAa\u0003c\u0013\r!a\u000b\u0003\u0003\u0005C\u0001\"!2\u00022\u0002\u000f\u0011qY\u0001\u0004iB,\u0007CBAe\u0003'\fi,\u0004\u0002\u0002L*!\u0011QZAh\u0003!!\u0018\u0010]3j]\u001a|'bAAi\t\u000511m\\7n_:LA!!6\u0002L\nyA+\u001f9f\u0013:4wN]7bi&|g\u000e\u0003\u0004\u0004\u0003c\u0003\r!\u0018")
public abstract class BatchTableEnvironment
extends TableEnvironment {
    private final ExecutionEnvironment execEnv;
    private final AtomicInteger nameCntr;
    private final Regex internalNamePattern;

    public ExecutionEnvironment execEnv() {
        return this.execEnv;
    }

    private AtomicInteger nameCntr() {
        return this.nameCntr;
    }

    private Regex internalNamePattern() {
        return this.internalNamePattern;
    }

    @Override
    public void checkValidTableName(String name) {
        Option m = this.internalNamePattern().findFirstIn((CharSequence)name);
        Option option = m;
        if (option instanceof Some) {
            throw new ValidationException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Illegal Table name. "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Please choose a name that does not contain the pattern ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.internalNamePattern()}))).toString());
        }
        None$ none$ = None$.MODULE$;
        Option option2 = option;
        if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        throw new MatchError((Object)option);
    }

    public String createUniqueTableName() {
        return new StringBuilder().append((Object)"_DataSetTable_").append((Object)BoxesRunTime.boxToInteger((int)this.nameCntr().getAndIncrement())).toString();
    }

    public Table scan(String tableName) throws ValidationException {
        if (this.isRegistered(tableName)) {
            return new Table(this, new CatalogNode(tableName, this.getRowType(tableName)));
        }
        throw new ValidationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Table \\'", "\\' was not found in the registry."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})));
    }

    public void registerTableSource(String name, BatchTableSource<?> tableSource) {
        this.checkValidTableName(name);
        this.registerTableInternal(name, new TableSourceTable(tableSource));
    }

    @Override
    public Table sql(String query) {
        FlinkPlannerImpl planner = new FlinkPlannerImpl(this.getFrameworkConfig(), this.getPlanner(), this.getTypeFactory());
        SqlNode parsed = planner.parse(query);
        SqlNode validated = planner.validate(parsed);
        RelRoot relational = planner.rel(validated);
        return new Table(this, new LogicalRelNode(relational.rel));
    }

    @Override
    public <T> void writeToSink(Table table, TableSink<T> sink) {
        TableSink<T> tableSink = sink;
        if (tableSink instanceof BatchTableSink) {
            BatchTableSink batchTableSink = (BatchTableSink)tableSink;
            TypeInformation<T> outputType = sink.getOutputType();
            DataSet<T> result = this.translate(table, outputType);
            batchTableSink.emitDataSet(result);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        throw new TableException("BatchTableSink required to emit batch Table");
    }

    public String explain(Table table, boolean extended) {
        String ast = RelOptUtil.toString(table.getRelNode());
        DataSet dataSet = this.translate(table, TypeExtractor.createTypeInfo(Row.class));
        dataSet.output((OutputFormat)new DiscardingOutputFormat());
        ExecutionEnvironment env = dataSet.getExecutionEnvironment();
        String jasonSqlPlan = env.getExecutionPlan();
        String sqlPlan = PlanJsonParser.getSqlExecutionPlan(jasonSqlPlan, Predef$.MODULE$.boolean2Boolean(extended));
        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"== Abstract Syntax Tree =="})).s((Seq)Nil$.MODULE$)).append((Object)System.lineSeparator()).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ast}))).append((Object)System.lineSeparator()).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"== Physical Execution Plan =="})).s((Seq)Nil$.MODULE$)).append((Object)System.lineSeparator()).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sqlPlan}))).toString();
    }

    public String explain(Table table) {
        return this.explain(table, false);
    }

    public <T> void registerDataSetInternal(String name, DataSet<T> dataSet) {
        Tuple2<String[], int[]> tuple2 = this.getFieldInfo(dataSet.getType());
        if (tuple2 != null) {
            Tuple2 tuple22;
            String[] fieldNames = (String[])tuple2._1();
            int[] fieldIndexes = (int[])tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)fieldNames, (Object)fieldIndexes);
            String[] fieldNames2 = (String[])tuple23._1();
            int[] fieldIndexes2 = (int[])tuple23._2();
            DataSetTable<T> dataSetTable = new DataSetTable<T>(dataSet, fieldIndexes2, fieldNames2);
            this.registerTableInternal(name, dataSetTable);
            return;
        }
        throw new MatchError(tuple2);
    }

    public <T> void registerDataSetInternal(String name, DataSet<T> dataSet, Expression[] fields) {
        Tuple2<String[], int[]> tuple2 = this.getFieldInfo(dataSet.getType(), fields);
        if (tuple2 != null) {
            Tuple2 tuple22;
            String[] fieldNames = (String[])tuple2._1();
            int[] fieldIndexes = (int[])tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)fieldNames, (Object)fieldIndexes);
            String[] fieldNames2 = (String[])tuple23._1();
            int[] fieldIndexes2 = (int[])tuple23._2();
            DataSetTable<T> dataSetTable = new DataSetTable<T>(dataSet, fieldIndexes2, fieldNames2);
            this.registerTableInternal(name, dataSetTable);
            return;
        }
        throw new MatchError(tuple2);
    }

    /*
     * WARNING - void declaration
     */
    public <A> DataSet<A> translate(Table table, TypeInformation<A> tpe) {
        void var3_3;
        RelNode relNode;
        RelNode relNode2 = table.getRelNode();
        RelNode decorPlan = RelDecorrelator.decorrelateQuery(relNode2);
        Program optProgram = Programs.ofRules(FlinkRuleSets$.MODULE$.DATASET_OPT_RULES());
        RelTraitSet flinkOutputProps = relNode2.getTraitSet().replace(DataSetConvention$.MODULE$.INSTANCE()).simplify();
        try {
            RelNode dataSetPlan;
            relNode = dataSetPlan = optProgram.run(this.getPlanner(), decorPlan, flinkOutputProps);
        }
        catch (AssertionError assertionError) {
            throw ((Throwable)((Object)assertionError)).getCause();
        }
        catch (TableException tableException) {
            throw new TableException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot generate a valid execution plan for the given query: \\n\\n"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{RelOptUtil.toString((RelNode)var3_3)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableException.msg()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Please check the documentation for the set of currently supported SQL features."})).s((Seq)Nil$.MODULE$)).toString());
        }
        catch (RelOptPlanner.CannotPlanException cannotPlanException) {
            throw new TableException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot generate a valid execution plan for the given query: \\n\\n"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{RelOptUtil.toString((RelNode)var3_3)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"This exception indicates that the query uses an unsupported SQL feature.\\n"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Please check the documentation for the set of currently supported SQL features."})).s((Seq)Nil$.MODULE$)).toString());
        }
        if (relNode instanceof DataSetRel) {
            DataSetRel dataSetRel = (DataSetRel)relNode;
            DataSet<Object> dataSet = dataSetRel.translateToPlan(this, (Option<TypeInformation<Object>>)new Some(tpe));
            return dataSet;
        }
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public BatchTableEnvironment(ExecutionEnvironment execEnv, TableConfig config) {
        this.execEnv = execEnv;
        super(config);
        this.nameCntr = new AtomicInteger(0);
        this.internalNamePattern = new StringOps(Predef$.MODULE$.augmentString("^_DataSetTable_[0-9]+$")).r();
    }
}

