/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.table;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql2rel.RelDecorrelator;
import org.apache.calcite.tools.Program;
import org.apache.calcite.tools.Programs;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.table.FlinkPlannerImpl;
import org.apache.flink.api.table.Table;
import org.apache.flink.api.table.TableConfig;
import org.apache.flink.api.table.TableEnvironment;
import org.apache.flink.api.table.TableException;
import org.apache.flink.api.table.ValidationException;
import org.apache.flink.api.table.expressions.Expression;
import org.apache.flink.api.table.plan.logical.CatalogNode;
import org.apache.flink.api.table.plan.logical.LogicalRelNode;
import org.apache.flink.api.table.plan.nodes.datastream.DataStreamConvention$;
import org.apache.flink.api.table.plan.nodes.datastream.DataStreamRel;
import org.apache.flink.api.table.plan.rules.FlinkRuleSets$;
import org.apache.flink.api.table.plan.schema.DataStreamTable;
import org.apache.flink.api.table.plan.schema.StreamableTableSourceTable;
import org.apache.flink.api.table.plan.schema.TransStreamTable;
import org.apache.flink.api.table.sinks.StreamTableSink;
import org.apache.flink.api.table.sinks.TableSink;
import org.apache.flink.api.table.sources.StreamTableSource;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\u0005mg!B\u0001\u0003\u0003\u0003i!AF*ue\u0016\fW\u000eV1cY\u0016,eN^5s_:lWM\u001c;\u000b\u0005\r!\u0011!\u0002;bE2,'BA\u0003\u0007\u0003\r\t\u0007/\u001b\u0006\u0003\u000f!\tQA\u001a7j].T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sO\u000e\u00011C\u0001\u0001\u000f!\ty\u0001#D\u0001\u0003\u0013\t\t\"A\u0001\tUC\ndW-\u00128wSJ|g.\\3oi\"I1\u0003\u0001BC\u0002\u0013\u0005a\u0001F\u0001\bKb,7-\u00128w+\u0005)\u0002C\u0001\f\u001d\u001b\u00059\"B\u0001\r\u001a\u0003-)gN^5s_:lWM\u001c;\u000b\u0005\u0015Q\"BA\u000e\u0007\u0003%\u0019HO]3b[&tw-\u0003\u0002\u001e/\tQ2\u000b\u001e:fC6,\u00050Z2vi&|g.\u00128wSJ|g.\\3oi\"Aq\u0004\u0001B\u0001B\u0003%Q#\u0001\u0005fq\u0016\u001cWI\u001c<!\u0011%\t\u0003A!A!\u0002\u0013\u0011S%\u0001\u0004d_:4\u0017n\u001a\t\u0003\u001f\rJ!\u0001\n\u0002\u0003\u0017Q\u000b'\r\\3D_:4\u0017nZ\u0005\u0003CAAQa\n\u0001\u0005\u0002!\na\u0001P5oSRtDcA\u0015+WA\u0011q\u0002\u0001\u0005\u0006'\u0019\u0002\r!\u0006\u0005\u0006C\u0019\u0002\rA\t\u0005\b[\u0001\u0011\r\u0011\"\u0003/\u0003!q\u0017-\\3D]R\u0014X#A\u0018\u0011\u0005AJT\"A\u0019\u000b\u0005I\u001a\u0014AB1u_6L7M\u0003\u00025k\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005Y:\u0014\u0001B;uS2T\u0011\u0001O\u0001\u0005U\u00064\u0018-\u0003\u0002;c\ti\u0011\t^8nS\u000eLe\u000e^3hKJDa\u0001\u0010\u0001!\u0002\u0013y\u0013!\u00038b[\u0016\u001ce\u000e\u001e:!\u0011\u001dq\u0004A1A\u0005\n}\n1#\u001b8uKJt\u0017\r\u001c(b[\u0016\u0004\u0016\r\u001e;fe:,\u0012\u0001\u0011\t\u0003\u0003\u001ek\u0011A\u0011\u0006\u0003\u0007\u0012\u000b\u0001\"\\1uG\"Lgn\u001a\u0006\u0003m\u0015S\u0011AR\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0011\n\u0013QAU3hKbDaA\u0013\u0001!\u0002\u0013\u0001\u0015\u0001F5oi\u0016\u0014h.\u00197OC6,\u0007+\u0019;uKJt\u0007\u0005C\u0003M\u0001\u0011ES*A\ndQ\u0016\u001c7NV1mS\u0012$\u0016M\u00197f\u001d\u0006lW\r\u0006\u0002O%B\u0011q\nU\u0007\u0002\u000b&\u0011\u0011+\u0012\u0002\u0005+:LG\u000fC\u0003T\u0017\u0002\u0007A+\u0001\u0003oC6,\u0007CA+Y\u001d\tye+\u0003\u0002X\u000b\u00061\u0001K]3eK\u001aL!!\u0017.\u0003\rM#(/\u001b8h\u0015\t9V\tC\u0003]\u0001\u0011EQ,A\u000bde\u0016\fG/Z+oSF,X\rV1cY\u0016t\u0015-\\3\u0015\u0003QCQa\u0018\u0001\u0005\u0002\u0001\fa!\u001b8hKN$HCA1e!\ty!-\u0003\u0002d\u0005\t)A+\u00192mK\")QM\u0018a\u0001)\u0006IA/\u00192mK:\u000bW.\u001a\u0015\u0004=\u001el\u0007cA(iU&\u0011\u0011.\u0012\u0002\u0007i\"\u0014xn^:\u0011\u0005=Y\u0017B\u00017\u0003\u0005M1\u0016\r\\5eCRLwN\\#yG\u0016\u0004H/[8oc\u0015qBK\\A\bc\u0019\u0019sn]A\u0003iV\u0011\u0001/]\u000b\u0002)\u0012)!\u000f\u0004b\u0001o\n\tA+\u0003\u0002uk\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIER!A^#\u0002\rQD'o\\<t#\tA8\u0010\u0005\u0002Ps&\u0011!0\u0012\u0002\b\u001d>$\b.\u001b8h!\taxP\u0004\u0002P{&\u0011a0R\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\t!a\u0001\u0003\u0013QC'o\\<bE2,'B\u0001@Fc!\u0019\u0013qAA\u0005\u0003\u00171hbA(\u0002\n%\u0011a/R\u0019\u0006E=+\u0015Q\u0002\u0002\u0006g\u000e\fG.Y\u0019\u0003M)Dq!a\u0005\u0001\t\u0003\t)\"A\nsK\u001eL7\u000f^3s)\u0006\u0014G.Z*pkJ\u001cW\rF\u0003O\u0003/\tI\u0002\u0003\u0004T\u0003#\u0001\r\u0001\u0016\u0005\t\u00037\t\t\u00021\u0001\u0002\u001e\u0005YA/\u00192mKN{WO]2fa\u0011\ty\"a\f\u0011\r\u0005\u0005\u0012qEA\u0016\u001b\t\t\u0019CC\u0002\u0002&\t\tqa]8ve\u000e,7/\u0003\u0003\u0002*\u0005\r\"!E*ue\u0016\fW\u000eV1cY\u0016\u001cv.\u001e:dKB!\u0011QFA\u0018\u0019\u0001!A\"!\r\u0002\u001a\u0005\u0005\t\u0011!B\u0001\u0003g\u00111a\u0018\u00132#\rA\u0018Q\u0007\t\u0004\u001f\u0006]\u0012bAA\u001d\u000b\n\u0019\u0011I\\=\t\u000f\u0005u\u0002\u0001\"\u0011\u0002@\u0005\u00191/\u001d7\u0015\u0007\u0005\f\t\u0005C\u0004\u0002D\u0005m\u0002\u0019\u0001+\u0002\u000bE,XM]=\t\u0011\u0005\u001d\u0003\u0001\"\u0011\u0007\u0003\u0013\n1b\u001e:ji\u0016$vnU5oWV!\u00111JA1)\u0015q\u0015QJA(\u0011\u0019\u0019\u0011Q\ta\u0001C\"A\u0011\u0011KA#\u0001\u0004\t\u0019&\u0001\u0003tS:\\\u0007CBA+\u00037\ny&\u0004\u0002\u0002X)\u0019\u0011\u0011\f\u0002\u0002\u000bMLgn[:\n\t\u0005u\u0013q\u000b\u0002\n)\u0006\u0014G.Z*j].\u0004B!!\f\u0002b\u00119!/!\u0012C\u0002\u0005M\u0002bBA3\u0001\u0011E\u0011qM\u0001\u001be\u0016<\u0017n\u001d;fe\u0012\u000bG/Y*ue\u0016\fW.\u00138uKJt\u0017\r\\\u000b\u0005\u0003S\ny\bF\u0004O\u0003W\ni'!!\t\rM\u000b\u0019\u00071\u0001U\u0011!\ty'a\u0019A\u0002\u0005E\u0014A\u00033bi\u0006\u001cFO]3b[B1\u00111OA=\u0003{j!!!\u001e\u000b\u0007\u0005]\u0014$\u0001\u0006eCR\f7\u000f\u001e:fC6LA!a\u001f\u0002v\tQA)\u0019;b'R\u0014X-Y7\u0011\t\u00055\u0012q\u0010\u0003\be\u0006\r$\u0019AA\u001a\u0011!\t\u0019)a\u0019A\u0002\u0005\u0015\u0015aB<sCB\u0004XM\u001d\t\u0004\u001f\u0006\u001d\u0015bAAE\u000b\n9!i\\8mK\u0006t\u0007bBA3\u0001\u0011E\u0011QR\u000b\u0005\u0003\u001f\u000bI\nF\u0005O\u0003#\u000b\u0019*a'\u00022\"11+a#A\u0002QC\u0001\"a\u001c\u0002\f\u0002\u0007\u0011Q\u0013\t\u0007\u0003g\nI(a&\u0011\t\u00055\u0012\u0011\u0014\u0003\be\u0006-%\u0019AA\u001a\u0011!\ti*a#A\u0002\u0005}\u0015A\u00024jK2$7\u000fE\u0003P\u0003C\u000b)+C\u0002\u0002$\u0016\u0013Q!\u0011:sCf\u0004B!a*\u0002.6\u0011\u0011\u0011\u0016\u0006\u0004\u0003W\u0013\u0011aC3yaJ,7o]5p]NLA!a,\u0002*\nQQ\t\u001f9sKN\u001c\u0018n\u001c8\t\u0011\u0005\r\u00151\u0012a\u0001\u0003\u000bCq!!.\u0001\t#\t9,A\u0005ue\u0006t7\u000f\\1uKV!\u0011\u0011XAa)\u0011\tY,!7\u0015\t\u0005u\u0016Q\u0019\t\u0007\u0003g\nI(a0\u0011\t\u00055\u0012\u0011\u0019\u0003\t\u0003\u0007\f\u0019L1\u0001\u00024\t\t\u0011\t\u0003\u0005\u0002H\u0006M\u00069AAe\u0003\r!\b/\u001a\t\u0007\u0003\u0017\f).a0\u000e\u0005\u00055'\u0002BAh\u0003#\f\u0001\u0002^=qK&tgm\u001c\u0006\u0004\u0003'$\u0011AB2p[6|g.\u0003\u0003\u0002X\u00065'a\u0004+za\u0016LeNZ8s[\u0006$\u0018n\u001c8\t\r\r\t\u0019\f1\u0001b\u0001")
public abstract class StreamTableEnvironment
extends TableEnvironment {
    private final StreamExecutionEnvironment execEnv;
    private final AtomicInteger nameCntr;
    private final Regex internalNamePattern;

    public StreamExecutionEnvironment execEnv() {
        return this.execEnv;
    }

    private AtomicInteger nameCntr() {
        return this.nameCntr;
    }

    private Regex internalNamePattern() {
        return this.internalNamePattern;
    }

    @Override
    public void checkValidTableName(String name) {
        Option m = this.internalNamePattern().findFirstIn((CharSequence)name);
        Option option = m;
        if (option instanceof Some) {
            throw new TableException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Illegal Table name. "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Please choose a name that does not contain the pattern ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.internalNamePattern()}))).toString());
        }
        None$ none$ = None$.MODULE$;
        Option option2 = option;
        if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        throw new MatchError((Object)option);
    }

    public String createUniqueTableName() {
        return new StringBuilder().append((Object)"_DataStreamTable_").append((Object)BoxesRunTime.boxToInteger((int)this.nameCntr().getAndIncrement())).toString();
    }

    public Table ingest(String tableName) throws ValidationException {
        if (this.isRegistered(tableName)) {
            return new Table(this, new CatalogNode(tableName, this.getRowType(tableName)));
        }
        throw new ValidationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Table \\'", "\\' was not found in the registry."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})));
    }

    public void registerTableSource(String name, StreamTableSource<?> tableSource) {
        this.checkValidTableName(name);
        this.registerTableInternal(name, new StreamableTableSourceTable(tableSource));
    }

    @Override
    public Table sql(String query) {
        FlinkPlannerImpl planner = new FlinkPlannerImpl(this.getFrameworkConfig(), this.getPlanner(), this.getTypeFactory());
        SqlNode parsed = planner.parse(query);
        SqlNode validated = planner.validate(parsed);
        RelRoot relational = planner.rel(validated);
        return new Table(this, new LogicalRelNode(relational.rel));
    }

    @Override
    public <T> void writeToSink(Table table, TableSink<T> sink) {
        TableSink<T> tableSink = sink;
        if (tableSink instanceof StreamTableSink) {
            StreamTableSink streamTableSink = (StreamTableSink)tableSink;
            TypeInformation<T> outputType = sink.getOutputType();
            DataStream<T> result = this.translate(table, outputType);
            streamTableSink.emitDataStream(result);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        throw new TableException("StreamTableSink required to emit streaming Table");
    }

    public <T> void registerDataStreamInternal(String name, DataStream<T> dataStream, boolean wrapper) {
        Tuple2<String[], int[]> tuple2 = this.getFieldInfo(dataStream.getType());
        if (tuple2 != null) {
            Tuple2 tuple22;
            String[] fieldNames = (String[])tuple2._1();
            int[] fieldIndexes = (int[])tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)fieldNames, (Object)fieldIndexes);
            String[] fieldNames2 = (String[])tuple23._1();
            int[] fieldIndexes2 = (int[])tuple23._2();
            DataStreamTable<T> dataStreamTable = new DataStreamTable<T>(dataStream, fieldIndexes2, fieldNames2);
            if (wrapper) {
                this.registerTableInternal(name, dataStreamTable);
                Table t = this.ingest(name);
                this.replaceRegisteredTable(name, new TransStreamTable(t.getRelNode(), true));
            } else {
                this.registerTableInternal(name, dataStreamTable);
            }
            return;
        }
        throw new MatchError(tuple2);
    }

    public <T> void registerDataStreamInternal(String name, DataStream<T> dataStream, Expression[] fields, boolean wrapper) {
        Tuple2<String[], int[]> tuple2 = this.getFieldInfo(dataStream.getType(), (Expression[])Predef$.MODULE$.refArrayOps((Object[])fields).toArray(ClassTag$.MODULE$.apply(Expression.class)));
        if (tuple2 != null) {
            Tuple2 tuple22;
            String[] fieldNames = (String[])tuple2._1();
            int[] fieldIndexes = (int[])tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)fieldNames, (Object)fieldIndexes);
            String[] fieldNames2 = (String[])tuple23._1();
            int[] fieldIndexes2 = (int[])tuple23._2();
            DataStreamTable<T> dataStreamTable = new DataStreamTable<T>(dataStream, (int[])Predef$.MODULE$.intArrayOps(fieldIndexes2).toArray(ClassTag$.MODULE$.Int()), (String[])Predef$.MODULE$.refArrayOps((Object[])fieldNames2).toArray(ClassTag$.MODULE$.apply(String.class)));
            if (wrapper) {
                this.registerTableInternal(name, dataStreamTable);
                Table t = this.ingest(name);
                this.replaceRegisteredTable(name, new TransStreamTable(t.getRelNode(), true));
            } else {
                this.registerTableInternal(name, dataStreamTable);
            }
            return;
        }
        throw new MatchError(tuple2);
    }

    /*
     * WARNING - void declaration
     */
    public <A> DataStream<A> translate(Table table, TypeInformation<A> tpe) {
        RelNode relNode;
        RelNode relNode2 = table.getRelNode();
        RelNode decorPlan = RelDecorrelator.decorrelateQuery(relNode2);
        Program optProgram = Programs.ofRules(FlinkRuleSets$.MODULE$.DATASTREAM_OPT_RULES());
        RelTraitSet flinkOutputProps = relNode2.getTraitSet().replace(DataStreamConvention$.MODULE$.INSTANCE()).simplify();
        try {
            RelNode dataStreamPlan;
            relNode = dataStreamPlan = optProgram.run(this.getPlanner(), decorPlan, flinkOutputProps);
        }
        catch (RelOptPlanner.CannotPlanException cannotPlanException) {
            void var3_3;
            throw new TableException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot generate a valid execution plan for the given query: \\n\\n"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{RelOptUtil.toString((RelNode)var3_3)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"This exception indicates that the query uses an unsupported SQL feature.\\n"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Please check the documentation for the set of currently supported SQL features."})).s((Seq)Nil$.MODULE$)).toString());
        }
        if (relNode instanceof DataStreamRel) {
            DataStreamRel dataStreamRel = (DataStreamRel)relNode;
            DataStream<Object> dataStream = dataStreamRel.translateToPlan(this, (Option<TypeInformation<Object>>)new Some(tpe));
            return dataStream;
        }
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public StreamTableEnvironment(StreamExecutionEnvironment execEnv, TableConfig config) {
        this.execEnv = execEnv;
        super(config);
        this.nameCntr = new AtomicInteger(0);
        this.internalNamePattern = new StringOps(Predef$.MODULE$.augmentString("^_DataStreamTable_[0-9]+$")).r();
    }
}

