/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.table;

import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.operators.join.JoinType;
import org.apache.flink.api.table.FlinkRelBuilder;
import org.apache.flink.api.table.FlinkTypeFactory$;
import org.apache.flink.api.table.GroupedTable;
import org.apache.flink.api.table.StreamTableEnvironment;
import org.apache.flink.api.table.TableEnvironment;
import org.apache.flink.api.table.ValidationException;
import org.apache.flink.api.table.expressions.Asc;
import org.apache.flink.api.table.expressions.Expression;
import org.apache.flink.api.table.expressions.ExpressionParser$;
import org.apache.flink.api.table.expressions.NamedExpression;
import org.apache.flink.api.table.expressions.Ordering;
import org.apache.flink.api.table.expressions.UnresolvedAlias;
import org.apache.flink.api.table.plan.RexNodeTranslator$;
import org.apache.flink.api.table.plan.logical.Aggregate;
import org.apache.flink.api.table.plan.logical.AliasNode;
import org.apache.flink.api.table.plan.logical.Distinct;
import org.apache.flink.api.table.plan.logical.Filter;
import org.apache.flink.api.table.plan.logical.Intersect;
import org.apache.flink.api.table.plan.logical.Join;
import org.apache.flink.api.table.plan.logical.LogicalNode;
import org.apache.flink.api.table.plan.logical.Minus;
import org.apache.flink.api.table.plan.logical.Project;
import org.apache.flink.api.table.plan.logical.Sort;
import org.apache.flink.api.table.plan.logical.Union;
import org.apache.flink.api.table.sinks.TableSink;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005-h\u0001B\u0001\u0003\u00015\u0011Q\u0001V1cY\u0016T!a\u0001\u0003\u0002\u000bQ\f'\r\\3\u000b\u0005\u00151\u0011aA1qS*\u0011q\u0001C\u0001\u0006M2Lgn\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001q\u0001CA\b\u0013\u001b\u0005\u0001\"\"A\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0001\"AB!osJ+g\rC\u0005\u0016\u0001\t\u0015\r\u0011\"\u0001\u0007-\u0005AA/\u00192mK\u0016sg/F\u0001\u0018!\tA\u0012$D\u0001\u0003\u0013\tQ\"A\u0001\tUC\ndW-\u00128wSJ|g.\\3oi\"AA\u0004\u0001B\u0001B\u0003%q#A\u0005uC\ndW-\u00128wA!Ia\u0004\u0001BC\u0002\u0013\u0005aaH\u0001\fY><\u0017nY1m!2\fg.F\u0001!!\t\tc%D\u0001#\u0015\t\u0019C%A\u0004m_\u001eL7-\u00197\u000b\u0005\u0015\u0012\u0011\u0001\u00029mC:L!a\n\u0012\u0003\u00171{w-[2bY:{G-\u001a\u0005\tS\u0001\u0011\t\u0011)A\u0005A\u0005aAn\\4jG\u0006d\u0007\u000b\\1oA!)1\u0006\u0001C\u0001Y\u00051A(\u001b8jiz\"2!\f\u00180!\tA\u0002\u0001C\u0003\u0016U\u0001\u0007q\u0003C\u0003\u001fU\u0001\u0007\u0001\u0005C\u00032\u0001\u0011\u0005!'\u0001\u0006sK2\u0014U/\u001b7eKJ,\u0012a\r\t\u00031QJ!!\u000e\u0002\u0003\u001f\u0019c\u0017N\\6SK2\u0014U/\u001b7eKJDQa\u000e\u0001\u0005\u0002a\n!bZ3u%\u0016dgj\u001c3f+\u0005I\u0004C\u0001\u001e@\u001b\u0005Y$B\u0001\u001f>\u0003\r\u0011X\r\u001c\u0006\u0003}!\tqaY1mG&$X-\u0003\u0002Aw\t9!+\u001a7O_\u0012,\u0007\"\u0002\"\u0001\t\u0003\u0019\u0015AB:fY\u0016\u001cG\u000f\u0006\u0002.\t\")Q)\u0011a\u0001\r\u00061a-[3mIN\u00042aD$J\u0013\tA\u0005C\u0001\u0006=e\u0016\u0004X-\u0019;fIz\u0002\"AS'\u000e\u0003-S!\u0001\u0014\u0002\u0002\u0017\u0015D\bO]3tg&|gn]\u0005\u0003\u001d.\u0013!\"\u0012=qe\u0016\u001c8/[8o\u0011\u0015\u0011\u0005\u0001\"\u0001Q)\ti\u0013\u000bC\u0003F\u001f\u0002\u0007!\u000b\u0005\u0002T-:\u0011q\u0002V\u0005\u0003+B\ta\u0001\u0015:fI\u00164\u0017BA,Y\u0005\u0019\u0019FO]5oO*\u0011Q\u000b\u0005\u0005\u00065\u0002!\taW\u0001\u0003CN$\"!\f/\t\u000b\u0015K\u0006\u0019\u0001$\t\u000bi\u0003A\u0011\u00010\u0015\u00055z\u0006\"B#^\u0001\u0004\u0011\u0006\"B1\u0001\t\u0003\u0011\u0017A\u00024jYR,'\u000f\u0006\u0002.G\")A\r\u0019a\u0001\u0013\u0006I\u0001O]3eS\u000e\fG/\u001a\u0005\u0006C\u0002!\tA\u001a\u000b\u0003[\u001dDQ\u0001Z3A\u0002ICQ!\u001b\u0001\u0005\u0002)\fQa\u001e5fe\u0016$\"!L6\t\u000b\u0011D\u0007\u0019A%\t\u000b%\u0004A\u0011A7\u0015\u00055r\u0007\"\u00023m\u0001\u0004\u0011\u0006\"\u00029\u0001\t\u0003\t\u0018aB4s_V\u0004()\u001f\u000b\u0003eV\u0004\"\u0001G:\n\u0005Q\u0014!\u0001D$s_V\u0004X\r\u001a+bE2,\u0007\"B#p\u0001\u00041\u0005\"\u00029\u0001\t\u00039HC\u0001:y\u0011\u0015)e\u000f1\u0001S\u0011\u0015Q\b\u0001\"\u0001|\u0003!!\u0017n\u001d;j]\u000e$H#A\u0017\t\u000bu\u0004A\u0011\u0001@\u0002\t)|\u0017N\u001c\u000b\u0003[}Da!!\u0001}\u0001\u0004i\u0013!\u0002:jO\"$\bBB?\u0001\t\u0003\t)\u0001F\u0003.\u0003\u000f\tI\u0001C\u0004\u0002\u0002\u0005\r\u0001\u0019A\u0017\t\u000f\u0005-\u00111\u0001a\u0001%\u0006i!n\\5o!J,G-[2bi\u0016Da! \u0001\u0005\u0002\u0005=A#B\u0017\u0002\u0012\u0005M\u0001bBA\u0001\u0003\u001b\u0001\r!\f\u0005\b\u0003\u0017\ti\u00011\u0001J\u0011\u001d\t9\u0002\u0001C\u0001\u00033\tQ\u0002\\3gi>+H/\u001a:K_&tG#B\u0017\u0002\u001c\u0005u\u0001bBA\u0001\u0003+\u0001\r!\f\u0005\b\u0003\u0017\t)\u00021\u0001S\u0011\u001d\t9\u0002\u0001C\u0001\u0003C!R!LA\u0012\u0003KAq!!\u0001\u0002 \u0001\u0007Q\u0006C\u0004\u0002\f\u0005}\u0001\u0019A%\t\u000f\u0005%\u0002\u0001\"\u0001\u0002,\u0005q!/[4ii>+H/\u001a:K_&tG#B\u0017\u0002.\u0005=\u0002bBA\u0001\u0003O\u0001\r!\f\u0005\b\u0003\u0017\t9\u00031\u0001S\u0011\u001d\tI\u0003\u0001C\u0001\u0003g!R!LA\u001b\u0003oAq!!\u0001\u00022\u0001\u0007Q\u0006C\u0004\u0002\f\u0005E\u0002\u0019A%\t\u000f\u0005m\u0002\u0001\"\u0001\u0002>\u0005ia-\u001e7m\u001fV$XM\u001d&pS:$R!LA \u0003\u0003Bq!!\u0001\u0002:\u0001\u0007Q\u0006C\u0004\u0002\f\u0005e\u0002\u0019\u0001*\t\u000f\u0005m\u0002\u0001\"\u0001\u0002FQ)Q&a\u0012\u0002J!9\u0011\u0011AA\"\u0001\u0004i\u0003bBA\u0006\u0003\u0007\u0002\r!\u0013\u0005\u0007{\u0002!I!!\u0014\u0015\u000f5\ny%!\u0015\u0002T!9\u0011\u0011AA&\u0001\u0004i\u0003bBA\u0006\u0003\u0017\u0002\rA\u0015\u0005\t\u0003+\nY\u00051\u0001\u0002X\u0005A!n\\5o)f\u0004X\r\u0005\u0003\u0002Z\u0005\u0015TBAA.\u0015\ri\u0018Q\f\u0006\u0005\u0003?\n\t'A\u0005pa\u0016\u0014\u0018\r^8sg*\u0019\u00111\r\u0003\u0002\t)\fg/Y\u0005\u0005\u0003O\nYF\u0001\u0005K_&tG+\u001f9f\u0011\u0019i\b\u0001\"\u0003\u0002lQ9Q&!\u001c\u0002p\u0005]\u0004bBA\u0001\u0003S\u0002\r!\f\u0005\t\u0003\u0017\tI\u00071\u0001\u0002rA!q\"a\u001dJ\u0013\r\t)\b\u0005\u0002\u0007\u001fB$\u0018n\u001c8\t\u0011\u0005U\u0013\u0011\u000ea\u0001\u0003/Bq!a\u001f\u0001\t\u0003\ti(A\u0003nS:,8\u000fF\u0002.\u0003\u007fBq!!\u0001\u0002z\u0001\u0007Q\u0006C\u0004\u0002\u0004\u0002!\t!!\"\u0002\u00115Lg.^:BY2$2!LAD\u0011\u001d\t\t!!!A\u00025Bq!a#\u0001\t\u0003\ti)A\u0003v]&|g\u000eF\u0002.\u0003\u001fCq!!\u0001\u0002\n\u0002\u0007Q\u0006C\u0004\u0002\u0014\u0002!\t!!&\u0002\u0011Ut\u0017n\u001c8BY2$2!LAL\u0011\u001d\t\t!!%A\u00025Bq!a'\u0001\t\u0003\ti*A\u0005j]R,'o]3diR\u0019Q&a(\t\u000f\u0005\u0005\u0011\u0011\u0014a\u0001[!9\u00111\u0015\u0001\u0005\u0002\u0005\u0015\u0016\u0001D5oi\u0016\u00148/Z2u\u00032dGcA\u0017\u0002(\"9\u0011\u0011AAQ\u0001\u0004i\u0003bBAV\u0001\u0011\u0005\u0011QV\u0001\b_J$WM\u001d\"z)\ri\u0013q\u0016\u0005\u0007\u000b\u0006%\u0006\u0019\u0001$\t\u000f\u0005-\u0006\u0001\"\u0001\u00024R\u0019Q&!.\t\r\u0015\u000b\t\f1\u0001S\u0011\u001d\tI\f\u0001C\u0001\u0003w\u000b1b\u001e:ji\u0016$vnU5oWV!\u0011QXAm)\u0011\ty,!2\u0011\u0007=\t\t-C\u0002\u0002DB\u0011A!\u00168ji\"A\u0011qYA\\\u0001\u0004\tI-\u0001\u0003tS:\\\u0007CBAf\u0003#\f).\u0004\u0002\u0002N*\u0019\u0011q\u001a\u0002\u0002\u000bMLgn[:\n\t\u0005M\u0017Q\u001a\u0002\n)\u0006\u0014G.Z*j].\u0004B!a6\u0002Z2\u0001A\u0001CAn\u0003o\u0013\r!!8\u0003\u0003Q\u000bB!a8\u0002fB\u0019q\"!9\n\u0007\u0005\r\bCA\u0004O_RD\u0017N\\4\u0011\u0007=\t9/C\u0002\u0002jB\u00111!\u00118z\u0001")
public class Table {
    private final TableEnvironment tableEnv;
    private final LogicalNode logicalPlan;

    public TableEnvironment tableEnv() {
        return this.tableEnv;
    }

    public LogicalNode logicalPlan() {
        return this.logicalPlan;
    }

    public FlinkRelBuilder relBuilder() {
        return this.tableEnv().getRelBuilder();
    }

    public RelNode getRelNode() {
        return this.logicalPlan().toRelNode(this.relBuilder());
    }

    public Table select(Seq<Expression> fields) {
        Seq projectionOnAggregates = (Seq)fields.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Table $outer;

            public final Tuple2<Expression, List<NamedExpression>> apply(Expression x$1) {
                return RexNodeTranslator$.MODULE$.extractAggregations(x$1, this.$outer.tableEnv());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq aggregations = (Seq)projectionOnAggregates.flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final List<NamedExpression> apply(Tuple2<Expression, List<NamedExpression>> x$2) {
                return (List)x$2._2();
            }
        }, Seq$.MODULE$.canBuildFrom());
        return aggregations.nonEmpty() ? new Table(this.tableEnv(), new Project((Seq<NamedExpression>)((Seq)projectionOnAggregates.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final UnresolvedAlias apply(Tuple2<Expression, List<NamedExpression>> e) {
                return new UnresolvedAlias((Expression)e._1());
            }
        }, Seq$.MODULE$.canBuildFrom())), new Aggregate((Seq<Expression>)Nil$.MODULE$, (Seq<NamedExpression>)aggregations, this.logicalPlan()).validate(this.tableEnv())).validate(this.tableEnv())) : new Table(this.tableEnv(), new Project((Seq<NamedExpression>)((Seq)projectionOnAggregates.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final UnresolvedAlias apply(Tuple2<Expression, List<NamedExpression>> e) {
                return new UnresolvedAlias((Expression)e._1());
            }
        }, Seq$.MODULE$.canBuildFrom())), this.logicalPlan()).validate(this.tableEnv()));
    }

    public Table select(String fields) {
        List<Expression> fieldExprs = ExpressionParser$.MODULE$.parseExpressionList(fields);
        return this.select((Seq<Expression>)fieldExprs);
    }

    public Table as(Seq<Expression> fields) {
        return new Table(this.tableEnv(), new AliasNode(fields, this.logicalPlan()).validate(this.tableEnv()));
    }

    public Table as(String fields) {
        List<Expression> fieldExprs = ExpressionParser$.MODULE$.parseExpressionList(fields);
        return this.as((Seq<Expression>)fieldExprs);
    }

    public Table filter(Expression predicate) {
        return new Table(this.tableEnv(), new Filter(predicate, this.logicalPlan()).validate(this.tableEnv()));
    }

    public Table filter(String predicate) {
        Expression predicateExpr = ExpressionParser$.MODULE$.parseExpression(predicate);
        return this.filter(predicateExpr);
    }

    public Table where(Expression predicate) {
        return this.filter(predicate);
    }

    public Table where(String predicate) {
        return this.filter(predicate);
    }

    public GroupedTable groupBy(Seq<Expression> fields) {
        if (this.tableEnv() instanceof StreamTableEnvironment) {
            throw new ValidationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Group by on stream tables is currently not supported."})).s((Seq)Nil$.MODULE$));
        }
        return new GroupedTable(this, fields);
    }

    public GroupedTable groupBy(String fields) {
        List<Expression> fieldsExpr = ExpressionParser$.MODULE$.parseExpressionList(fields);
        return this.groupBy((Seq<Expression>)fieldsExpr);
    }

    public Table distinct() {
        return new Table(this.tableEnv(), new Distinct(this.logicalPlan()).validate(this.tableEnv()));
    }

    public Table join(Table right) {
        return this.join(right, (Option<Expression>)None$.MODULE$, JoinType.INNER);
    }

    public Table join(Table right, String joinPredicate) {
        return this.join(right, joinPredicate, JoinType.INNER);
    }

    public Table join(Table right, Expression joinPredicate) {
        return this.join(right, (Option<Expression>)new Some((Object)joinPredicate), JoinType.INNER);
    }

    public Table leftOuterJoin(Table right, String joinPredicate) {
        return this.join(right, joinPredicate, JoinType.LEFT_OUTER);
    }

    public Table leftOuterJoin(Table right, Expression joinPredicate) {
        return this.join(right, (Option<Expression>)new Some((Object)joinPredicate), JoinType.LEFT_OUTER);
    }

    public Table rightOuterJoin(Table right, String joinPredicate) {
        return this.join(right, joinPredicate, JoinType.RIGHT_OUTER);
    }

    public Table rightOuterJoin(Table right, Expression joinPredicate) {
        return this.join(right, (Option<Expression>)new Some((Object)joinPredicate), JoinType.RIGHT_OUTER);
    }

    public Table fullOuterJoin(Table right, String joinPredicate) {
        return this.join(right, joinPredicate, JoinType.FULL_OUTER);
    }

    public Table fullOuterJoin(Table right, Expression joinPredicate) {
        return this.join(right, (Option<Expression>)new Some((Object)joinPredicate), JoinType.FULL_OUTER);
    }

    private Table join(Table right, String joinPredicate, JoinType joinType) {
        Expression joinPredicateExpr = ExpressionParser$.MODULE$.parseExpression(joinPredicate);
        return this.join(right, (Option<Expression>)new Some((Object)joinPredicateExpr), joinType);
    }

    private Table join(Table right, Option<Expression> joinPredicate, JoinType joinType) {
        TableEnvironment tableEnvironment = right.tableEnv();
        TableEnvironment tableEnvironment2 = this.tableEnv();
        if (!(tableEnvironment != null ? !tableEnvironment.equals(tableEnvironment2) : tableEnvironment2 != null)) {
            return new Table(this.tableEnv(), new Join(this.logicalPlan(), right.logicalPlan(), joinType, joinPredicate).validate(this.tableEnv()));
        }
        throw new ValidationException("Only tables from the same TableEnvironment can be joined.");
    }

    public Table minus(Table right) {
        TableEnvironment tableEnvironment = right.tableEnv();
        TableEnvironment tableEnvironment2 = this.tableEnv();
        if (!(tableEnvironment != null ? !tableEnvironment.equals(tableEnvironment2) : tableEnvironment2 != null)) {
            return new Table(this.tableEnv(), new Minus(this.logicalPlan(), right.logicalPlan(), false).validate(this.tableEnv()));
        }
        throw new ValidationException("Only tables from the same TableEnvironment can be subtracted.");
    }

    public Table minusAll(Table right) {
        TableEnvironment tableEnvironment = right.tableEnv();
        TableEnvironment tableEnvironment2 = this.tableEnv();
        if (!(tableEnvironment != null ? !tableEnvironment.equals(tableEnvironment2) : tableEnvironment2 != null)) {
            return new Table(this.tableEnv(), new Minus(this.logicalPlan(), right.logicalPlan(), true).validate(this.tableEnv()));
        }
        throw new ValidationException("Only tables from the same TableEnvironment can be subtracted.");
    }

    public Table union(Table right) {
        TableEnvironment tableEnvironment = right.tableEnv();
        TableEnvironment tableEnvironment2 = this.tableEnv();
        if (!(tableEnvironment != null ? !tableEnvironment.equals(tableEnvironment2) : tableEnvironment2 != null)) {
            return new Table(this.tableEnv(), new Union(this.logicalPlan(), right.logicalPlan(), false).validate(this.tableEnv()));
        }
        throw new ValidationException("Only tables from the same TableEnvironment can be unioned.");
    }

    public Table unionAll(Table right) {
        TableEnvironment tableEnvironment = right.tableEnv();
        TableEnvironment tableEnvironment2 = this.tableEnv();
        if (!(tableEnvironment != null ? !tableEnvironment.equals(tableEnvironment2) : tableEnvironment2 != null)) {
            return new Table(this.tableEnv(), new Union(this.logicalPlan(), right.logicalPlan(), true).validate(this.tableEnv()));
        }
        throw new ValidationException("Only tables from the same TableEnvironment can be unioned.");
    }

    public Table intersect(Table right) {
        TableEnvironment tableEnvironment = right.tableEnv();
        TableEnvironment tableEnvironment2 = this.tableEnv();
        if (!(tableEnvironment != null ? !tableEnvironment.equals(tableEnvironment2) : tableEnvironment2 != null)) {
            return new Table(this.tableEnv(), new Intersect(this.logicalPlan(), right.logicalPlan(), false).validate(this.tableEnv()));
        }
        throw new ValidationException("Only tables from the same TableEnvironment can be intersected.");
    }

    public Table intersectAll(Table right) {
        TableEnvironment tableEnvironment = right.tableEnv();
        TableEnvironment tableEnvironment2 = this.tableEnv();
        if (!(tableEnvironment != null ? !tableEnvironment.equals(tableEnvironment2) : tableEnvironment2 != null)) {
            return new Table(this.tableEnv(), new Intersect(this.logicalPlan(), right.logicalPlan(), true).validate(this.tableEnv()));
        }
        throw new ValidationException("Only tables from the same TableEnvironment can be intersected.");
    }

    public Table orderBy(Seq<Expression> fields) {
        Seq order = (Seq)fields.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Ordering apply(Expression x0$1) {
                Ordering ordering;
                Expression expression = x0$1;
                Expression expression2 = expression;
                Ordering ordering2 = expression2 instanceof Ordering ? (ordering = (Ordering)expression2) : new Asc(expression);
                Ordering ordering3 = ordering2;
                return ordering3;
            }
        }, Seq$.MODULE$.canBuildFrom());
        return new Table(this.tableEnv(), new Sort((Seq<Ordering>)order, this.logicalPlan()).validate(this.tableEnv()));
    }

    public Table orderBy(String fields) {
        List<Expression> parsedFields = ExpressionParser$.MODULE$.parseExpressionList(fields);
        return this.orderBy((Seq<Expression>)parsedFields);
    }

    public <T> void writeToSink(TableSink<T> sink) {
        RelDataType rowType = this.getRelNode().getRowType();
        String[] fieldNames = (String[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(rowType.getFieldNames()).asScala()).toArray(ClassTag$.MODULE$.apply(String.class));
        TypeInformation[] fieldTypes = (TypeInformation[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(rowType.getFieldList()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final TypeInformation<?> apply(RelDataTypeField field) {
                return FlinkTypeFactory$.MODULE$.toTypeInfo(field.getType());
            }
        }, Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(TypeInformation.class));
        TableSink<T> configuredSink = sink.configure(fieldNames, fieldTypes);
        this.tableEnv().writeToSink(this, configuredSink);
    }

    public Table(TableEnvironment tableEnv, LogicalNode logicalPlan) {
        this.tableEnv = tableEnv;
        this.logicalPlan = logicalPlan;
    }
}

