/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.table.runtime.aggregate;

import org.apache.flink.api.table.Row;
import org.apache.flink.api.table.runtime.aggregate.IntegralAvgAggregate;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001Y2A!\u0001\u0002\u0001#\t\u0001\")\u001f;f\u0003Z<\u0017iZ4sK\u001e\fG/\u001a\u0006\u0003\u0007\u0011\t\u0011\"Y4he\u0016<\u0017\r^3\u000b\u0005\u00151\u0011a\u0002:v]RLW.\u001a\u0006\u0003\u000f!\tQ\u0001^1cY\u0016T!!\u0003\u0006\u0002\u0007\u0005\u0004\u0018N\u0003\u0002\f\u0019\u0005)a\r\\5oW*\u0011QBD\u0001\u0007CB\f7\r[3\u000b\u0003=\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\n\u0011\u0007M!b#D\u0001\u0003\u0013\t)\"A\u0001\u000bJ]R,wM]1m\u0003Z<\u0017iZ4sK\u001e\fG/\u001a\t\u0003/ii\u0011\u0001\u0007\u0006\u00023\u0005)1oY1mC&\u00111\u0004\u0007\u0002\u0005\u0005f$X\rC\u0003\u001e\u0001\u0011\u0005a$\u0001\u0004=S:LGO\u0010\u000b\u0002?A\u00111\u0003\u0001\u0005\u0006C\u0001!\tEI\u0001\nI>\u0004&/\u001a9be\u0016$2a\t\u0014,!\t9B%\u0003\u0002&1\t!QK\\5u\u0011\u00159\u0003\u00051\u0001)\u0003\u00151\u0018\r\\;f!\t9\u0012&\u0003\u0002+1\t\u0019\u0011I\\=\t\u000b1\u0002\u0003\u0019A\u0017\u0002\u000fA\f'\u000f^5bYB\u0011afL\u0007\u0002\r%\u0011\u0001G\u0002\u0002\u0004%><\b\"\u0002\u001a\u0001\t\u0003\u001a\u0014A\u00033p\u000bZ\fG.^1uKR\u0011\u0001\u0006\u000e\u0005\u0006kE\u0002\r!L\u0001\u0007EV4g-\u001a:")
public class ByteAvgAggregate
extends IntegralAvgAggregate<Object> {
    @Override
    public void doPrepare(Object value, Row partial) {
        byte input = BoxesRunTime.unboxToByte((Object)value);
        partial.setField(this.partialSumIndex(), BoxesRunTime.boxToLong((long)input));
        partial.setField(this.partialCountIndex(), BoxesRunTime.boxToLong((long)1L));
    }

    @Override
    public Object doEvaluate(Row buffer) {
        long bufferSum = BoxesRunTime.unboxToLong((Object)buffer.productElement(this.partialSumIndex()));
        long bufferCount = BoxesRunTime.unboxToLong((Object)buffer.productElement(this.partialCountIndex()));
        return bufferCount == 0L ? null : BoxesRunTime.boxToByte((byte)((byte)(bufferSum / bufferCount)));
    }
}

