/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.table.runtime.aggregate;

import java.math.BigDecimal;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.table.Row;
import org.apache.flink.api.table.runtime.aggregate.AvgAggregate;
import org.apache.flink.shaded.calcite.com.google.common.math.LongMath;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001y3A!\u0001\u0002\u0001#\t\u0019B)Z2j[\u0006d\u0017I^4BO\u001e\u0014XmZ1uK*\u00111\u0001B\u0001\nC\u001e<'/Z4bi\u0016T!!\u0002\u0004\u0002\u000fI,h\u000e^5nK*\u0011q\u0001C\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003\u0013)\t1!\u00199j\u0015\tYA\"A\u0003gY&t7N\u0003\u0002\u000e\u001d\u00051\u0011\r]1dQ\u0016T\u0011aD\u0001\u0004_J<7\u0001A\n\u0003\u0001I\u00012a\u0005\u000b\u0017\u001b\u0005\u0011\u0011BA\u000b\u0003\u00051\teoZ!hOJ,w-\u0019;f!\t9B$D\u0001\u0019\u0015\tI\"$\u0001\u0003nCRD'\"A\u000e\u0002\t)\fg/Y\u0005\u0003;a\u0011!BQ5h\t\u0016\u001c\u0017.\\1m\u0011\u0015y\u0002\u0001\"\u0001!\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0005\u0005\u0002\u0014\u0001!)1\u0005\u0001C!I\u0005!\u0012N\u001c;fe6,G-[1uK\u0012\u000bG/\u0019+za\u0016,\u0012!\n\t\u0004M%ZS\"A\u0014\u000b\u0003!\nQa]2bY\u0006L!AK\u0014\u0003\u000b\u0005\u0013(/Y=1\u000512\u0004cA\u00173i5\taF\u0003\u00020a\u0005AA/\u001f9fS:4wN\u0003\u00022\u0011\u000511m\\7n_:L!a\r\u0018\u0003\u001fQK\b/Z%oM>\u0014X.\u0019;j_:\u0004\"!\u000e\u001c\r\u0001\u0011Iq\u0007AA\u0001\u0002\u0003\u0015\ta\u000f\u0002\u0004?\u0012\n\u0014BA\u0012:\u0013\tQ$AA\u0005BO\u001e\u0014XmZ1uKF\u0011Ah\u0010\t\u0003MuJ!AP\u0014\u0003\u000f9{G\u000f[5oOB\u0011a\u0005Q\u0005\u0003\u0003\u001e\u00121!\u00118z\u0011\u0015\u0019\u0005\u0001\"\u0011E\u0003!Ig.\u001b;jCR,GCA#I!\t1c)\u0003\u0002HO\t!QK\\5u\u0011\u0015I%\t1\u0001K\u0003\u001d\u0001\u0018M\u001d;jC2\u0004\"a\u0013'\u000e\u0003\u0019I!!\u0014\u0004\u0003\u0007I{w\u000fC\u0003P\u0001\u0011\u0005\u0003+A\u0004qe\u0016\u0004\u0018M]3\u0015\u0007\u0015\u000b6\u000bC\u0003S\u001d\u0002\u0007q(A\u0003wC2,X\rC\u0003J\u001d\u0002\u0007!\nC\u0003V\u0001\u0011\u0005c+A\u0003nKJ<W\rF\u0002F/bCQ!\u0013+A\u0002)CQ!\u0017+A\u0002)\u000baAY;gM\u0016\u0014\b\"B.\u0001\t\u0003b\u0016\u0001C3wC2,\u0018\r^3\u0015\u0005Yi\u0006\"B-[\u0001\u0004Q\u0005")
public class DecimalAvgAggregate
extends AvgAggregate<BigDecimal> {
    @Override
    public TypeInformation<?>[] intermediateDataType() {
        return (TypeInformation[])((Object[])new TypeInformation[]{BasicTypeInfo.BIG_DEC_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO});
    }

    @Override
    public void initiate(Row partial) {
        partial.setField(this.partialSumIndex(), BigDecimal.ZERO);
        partial.setField(this.partialCountIndex(), BoxesRunTime.boxToLong((long)0L));
    }

    @Override
    public void prepare(Object value, Row partial) {
        if (value == null) {
            this.initiate(partial);
        } else {
            BigDecimal input = (BigDecimal)value;
            partial.setField(this.partialSumIndex(), input);
            partial.setField(this.partialCountIndex(), BoxesRunTime.boxToLong((long)1L));
        }
    }

    @Override
    public void merge(Row partial, Row buffer) {
        BigDecimal partialSum = (BigDecimal)partial.productElement(this.partialSumIndex());
        long partialCount = BoxesRunTime.unboxToLong((Object)partial.productElement(this.partialCountIndex()));
        BigDecimal bufferSum = (BigDecimal)buffer.productElement(this.partialSumIndex());
        long bufferCount = BoxesRunTime.unboxToLong((Object)buffer.productElement(this.partialCountIndex()));
        buffer.setField(this.partialSumIndex(), partialSum.add(bufferSum));
        buffer.setField(this.partialCountIndex(), BoxesRunTime.boxToLong((long)LongMath.checkedAdd(partialCount, bufferCount)));
    }

    @Override
    public BigDecimal evaluate(Row buffer) {
        BigDecimal bigDecimal;
        long bufferCount = BoxesRunTime.unboxToLong((Object)buffer.productElement(this.partialCountIndex()));
        if (bufferCount != 0L) {
            BigDecimal bufferSum = (BigDecimal)buffer.productElement(this.partialSumIndex());
            bigDecimal = bufferSum.divide(BigDecimal.valueOf(bufferCount));
        } else {
            bigDecimal = null;
        }
        return bigDecimal;
    }
}

