/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.table.runtime.aggregate;

import org.apache.flink.api.table.Row;
import org.apache.flink.api.table.runtime.aggregate.FloatingAvgAggregate;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001Y2A!\u0001\u0002\u0001#\t\u0011Bi\\;cY\u0016\feoZ!hOJ,w-\u0019;f\u0015\t\u0019A!A\u0005bO\u001e\u0014XmZ1uK*\u0011QAB\u0001\beVtG/[7f\u0015\t9\u0001\"A\u0003uC\ndWM\u0003\u0002\n\u0015\u0005\u0019\u0011\r]5\u000b\u0005-a\u0011!\u00024mS:\\'BA\u0007\u000f\u0003\u0019\t\u0007/Y2iK*\tq\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001%A\u00191\u0003\u0006\f\u000e\u0003\tI!!\u0006\u0002\u0003)\u0019cw.\u0019;j]\u001e\feoZ!hOJ,w-\u0019;f!\t9\"$D\u0001\u0019\u0015\u0005I\u0012!B:dC2\f\u0017BA\u000e\u0019\u0005\u0019!u.\u001e2mK\")Q\u0004\u0001C\u0001=\u00051A(\u001b8jiz\"\u0012a\b\t\u0003'\u0001AQ!\t\u0001\u0005B\t\n\u0011\u0002Z8Qe\u0016\u0004\u0018M]3\u0015\u0007\r23\u0006\u0005\u0002\u0018I%\u0011Q\u0005\u0007\u0002\u0005+:LG\u000fC\u0003(A\u0001\u0007\u0001&A\u0003wC2,X\r\u0005\u0002\u0018S%\u0011!\u0006\u0007\u0002\u0004\u0003:L\b\"\u0002\u0017!\u0001\u0004i\u0013a\u00029beRL\u0017\r\u001c\t\u0003]=j\u0011AB\u0005\u0003a\u0019\u00111AU8x\u0011\u0015\u0011\u0004\u0001\"\u00114\u0003)!w.\u0012<bYV\fG/\u001a\u000b\u0003QQBQ!N\u0019A\u00025\naAY;gM\u0016\u0014\b")
public class DoubleAvgAggregate
extends FloatingAvgAggregate<Object> {
    @Override
    public void doPrepare(Object value, Row partial) {
        double input = BoxesRunTime.unboxToDouble((Object)value);
        partial.setField(this.partialSumIndex(), BoxesRunTime.boxToDouble((double)input));
        partial.setField(this.partialCountIndex(), BoxesRunTime.boxToLong((long)1L));
    }

    @Override
    public Object doEvaluate(Row buffer) {
        double bufferSum = BoxesRunTime.unboxToDouble((Object)buffer.productElement(this.partialSumIndex()));
        long bufferCount = BoxesRunTime.unboxToLong((Object)buffer.productElement(this.partialCountIndex()));
        return bufferCount == 0L ? null : BoxesRunTime.boxToDouble((double)(bufferSum / (double)bufferCount));
    }

    public DoubleAvgAggregate() {
        super(Numeric.DoubleIsFractional$.MODULE$);
    }
}

