/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.table.runtime.aggregate;

import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.table.Row;
import org.apache.flink.api.table.runtime.aggregate.AvgAggregate;
import org.apache.flink.shaded.calcite.com.google.common.math.LongMath;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\r4Q!\u0001\u0002\u0002\u0002E\u0011A#\u00138uK\u001e\u0014\u0018\r\\!wO\u0006;wM]3hCR,'BA\u0002\u0005\u0003%\twm\u001a:fO\u0006$XM\u0003\u0002\u0006\r\u00059!/\u001e8uS6,'BA\u0004\t\u0003\u0015!\u0018M\u00197f\u0015\tI!\"A\u0002ba&T!a\u0003\u0007\u0002\u000b\u0019d\u0017N\\6\u000b\u00055q\u0011AB1qC\u000eDWMC\u0001\u0010\u0003\ry'oZ\u0002\u0001+\t\u0011\u0012d\u0005\u0002\u0001'A\u0019A#F\f\u000e\u0003\tI!A\u0006\u0002\u0003\u0019\u00053x-Q4he\u0016<\u0017\r^3\u0011\u0005aIB\u0002\u0001\u0003\u00065\u0001\u0011\ra\u0007\u0002\u0002)F\u0011AD\t\t\u0003;\u0001j\u0011A\b\u0006\u0002?\u0005)1oY1mC&\u0011\u0011E\b\u0002\b\u001d>$\b.\u001b8h!\ti2%\u0003\u0002%=\t\u0019\u0011I\\=\t\u000b\u0019\u0002A\u0011A\u0014\u0002\rqJg.\u001b;?)\u0005A\u0003c\u0001\u000b\u0001/!)!\u0006\u0001C!W\u0005A\u0011N\\5uS\u0006$X\r\u0006\u0002-_A\u0011Q$L\u0005\u0003]y\u0011A!\u00168ji\")\u0001'\u000ba\u0001c\u00059\u0001/\u0019:uS\u0006d\u0007C\u0001\u001a4\u001b\u00051\u0011B\u0001\u001b\u0007\u0005\r\u0011vn\u001e\u0005\u0006m\u0001!\teN\u0001\baJ,\u0007/\u0019:f)\ra\u0003H\u000f\u0005\u0006sU\u0002\rAI\u0001\u0006m\u0006dW/\u001a\u0005\u0006aU\u0002\r!\r\u0005\u0006y\u0001!\t%P\u0001\u0006[\u0016\u0014x-\u001a\u000b\u0004Yyz\u0004\"\u0002\u0019<\u0001\u0004\t\u0004\"\u0002!<\u0001\u0004\t\u0014A\u00022vM\u001a,'\u000fC\u0003C\u0001\u0011\u00053)\u0001\u0005fm\u0006dW/\u0019;f)\t9B\tC\u0003A\u0003\u0002\u0007\u0011\u0007C\u0003G\u0001\u0011\u0005s)\u0001\u000bj]R,'/\\3eS\u0006$X\rR1uCRK\b/Z\u000b\u0002\u0011B\u0019Q$S&\n\u0005)s\"!B!se\u0006L\bG\u0001'V!\ri%\u000bV\u0007\u0002\u001d*\u0011q\nU\u0001\tif\u0004X-\u001b8g_*\u0011\u0011\u000bC\u0001\u0007G>lWn\u001c8\n\u0005Ms%a\u0004+za\u0016LeNZ8s[\u0006$\u0018n\u001c8\u0011\u0005a)F!\u0003,\u0001\u0003\u0003\u0005\tQ!\u0001\u001c\u0005\ryF%M\u0005\u0003\rbK!!\u0017\u0002\u0003\u0013\u0005;wM]3hCR,\u0007\"B.\u0001\r\u0003a\u0016!\u00033p!J,\u0007/\u0019:f)\raSL\u0018\u0005\u0006si\u0003\rA\t\u0005\u0006ai\u0003\r!\r\u0005\u0006A\u00021\t!Y\u0001\u000bI>,e/\u00197vCR,GC\u0001\u0012c\u0011\u0015\u0001u\f1\u00012\u0001")
public abstract class IntegralAvgAggregate<T>
extends AvgAggregate<T> {
    @Override
    public void initiate(Row partial) {
        partial.setField(this.partialSumIndex(), BoxesRunTime.boxToLong((long)0L));
        partial.setField(this.partialCountIndex(), BoxesRunTime.boxToLong((long)0L));
    }

    @Override
    public void prepare(Object value, Row partial) {
        if (value == null) {
            partial.setField(this.partialSumIndex(), BoxesRunTime.boxToLong((long)0L));
            partial.setField(this.partialCountIndex(), BoxesRunTime.boxToLong((long)0L));
        } else {
            this.doPrepare(value, partial);
        }
    }

    @Override
    public void merge(Row partial, Row buffer) {
        long partialSum = BoxesRunTime.unboxToLong((Object)partial.productElement(this.partialSumIndex()));
        long partialCount = BoxesRunTime.unboxToLong((Object)partial.productElement(this.partialCountIndex()));
        long bufferSum = BoxesRunTime.unboxToLong((Object)buffer.productElement(this.partialSumIndex()));
        long bufferCount = BoxesRunTime.unboxToLong((Object)buffer.productElement(this.partialCountIndex()));
        buffer.setField(this.partialSumIndex(), BoxesRunTime.boxToLong((long)LongMath.checkedAdd(partialSum, bufferSum)));
        buffer.setField(this.partialCountIndex(), BoxesRunTime.boxToLong((long)LongMath.checkedAdd(partialCount, bufferCount)));
    }

    @Override
    public T evaluate(Row buffer) {
        return (T)this.doEvaluate(buffer);
    }

    @Override
    public TypeInformation<?>[] intermediateDataType() {
        return (TypeInformation[])((Object[])new TypeInformation[]{BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO});
    }

    public abstract void doPrepare(Object var1, Row var2);

    public abstract Object doEvaluate(Row var1);
}

