/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.table.runtime.aggregate;

import java.math.BigInteger;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.table.Row;
import org.apache.flink.api.table.runtime.aggregate.IntegralAvgAggregate;
import org.apache.flink.shaded.calcite.com.google.common.math.LongMath;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001y3A!\u0001\u0002\u0001#\t\u0001Bj\u001c8h\u0003Z<\u0017iZ4sK\u001e\fG/\u001a\u0006\u0003\u0007\u0011\t\u0011\"Y4he\u0016<\u0017\r^3\u000b\u0005\u00151\u0011a\u0002:v]RLW.\u001a\u0006\u0003\u000f!\tQ\u0001^1cY\u0016T!!\u0003\u0006\u0002\u0007\u0005\u0004\u0018N\u0003\u0002\f\u0019\u0005)a\r\\5oW*\u0011QBD\u0001\u0007CB\f7\r[3\u000b\u0003=\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\n\u0011\u0007M!b#D\u0001\u0003\u0013\t)\"A\u0001\u000bJ]R,wM]1m\u0003Z<\u0017iZ4sK\u001e\fG/\u001a\t\u0003/ii\u0011\u0001\u0007\u0006\u00023\u0005)1oY1mC&\u00111\u0004\u0007\u0002\u0005\u0019>tw\rC\u0003\u001e\u0001\u0011\u0005a$\u0001\u0004=S:LGO\u0010\u000b\u0002?A\u00111\u0003\u0001\u0005\u0006C\u0001!\tEI\u0001\u0015S:$XM]7fI&\fG/\u001a#bi\u0006$\u0016\u0010]3\u0016\u0003\r\u00022a\u0006\u0013'\u0013\t)\u0003DA\u0003BeJ\f\u0017\u0010\r\u0002(cA\u0019\u0001&L\u0018\u000e\u0003%R!AK\u0016\u0002\u0011QL\b/Z5oM>T!\u0001\f\u0005\u0002\r\r|W.\\8o\u0013\tq\u0013FA\bUsB,\u0017J\u001c4pe6\fG/[8o!\t\u0001\u0014\u0007\u0004\u0001\u0005\u0013I\u0002\u0011\u0011!A\u0001\u0006\u00031$aA0%c%\u0011\u0011\u0005N\u0005\u0003k\t\u0011\u0011\"Q4he\u0016<\u0017\r^3\u0012\u0005]R\u0004CA\f9\u0013\tI\u0004DA\u0004O_RD\u0017N\\4\u0011\u0005]Y\u0014B\u0001\u001f\u0019\u0005\r\te.\u001f\u0005\u0006}\u0001!\teP\u0001\tS:LG/[1uKR\u0011\u0001i\u0011\t\u0003/\u0005K!A\u0011\r\u0003\tUs\u0017\u000e\u001e\u0005\u0006\tv\u0002\r!R\u0001\ba\u0006\u0014H/[1m!\t1u)D\u0001\u0007\u0013\tAeAA\u0002S_^DQA\u0013\u0001\u0005B-\u000bq\u0001\u001d:fa\u0006\u0014X\rF\u0002A\u0019:CQ!T%A\u0002i\nQA^1mk\u0016DQ\u0001R%A\u0002\u0015CQ\u0001\u0015\u0001\u0005BE\u000b\u0011\u0002Z8Qe\u0016\u0004\u0018M]3\u0015\u0007\u0001\u00136\u000bC\u0003N\u001f\u0002\u0007!\bC\u0003E\u001f\u0002\u0007Q\tC\u0003V\u0001\u0011\u0005c+A\u0003nKJ<W\rF\u0002A/bCQ\u0001\u0012+A\u0002\u0015CQ!\u0017+A\u0002\u0015\u000baAY;gM\u0016\u0014\b\"B.\u0001\t\u0003b\u0016A\u00033p\u000bZ\fG.^1uKR\u0011!(\u0018\u0005\u00063j\u0003\r!\u0012")
public class LongAvgAggregate
extends IntegralAvgAggregate<Object> {
    @Override
    public TypeInformation<?>[] intermediateDataType() {
        return (TypeInformation[])((Object[])new TypeInformation[]{BasicTypeInfo.BIG_INT_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO});
    }

    @Override
    public void initiate(Row partial) {
        partial.setField(this.partialSumIndex(), BigInteger.ZERO);
        partial.setField(this.partialCountIndex(), BoxesRunTime.boxToLong((long)0L));
    }

    @Override
    public void prepare(Object value, Row partial) {
        if (value == null) {
            partial.setField(this.partialSumIndex(), BigInteger.ZERO);
            partial.setField(this.partialCountIndex(), BoxesRunTime.boxToLong((long)0L));
        } else {
            this.doPrepare(value, partial);
        }
    }

    @Override
    public void doPrepare(Object value, Row partial) {
        long input = BoxesRunTime.unboxToLong((Object)value);
        partial.setField(this.partialSumIndex(), BigInteger.valueOf(input));
        partial.setField(this.partialCountIndex(), BoxesRunTime.boxToLong((long)1L));
    }

    @Override
    public void merge(Row partial, Row buffer) {
        BigInteger partialSum = (BigInteger)partial.productElement(this.partialSumIndex());
        long partialCount = BoxesRunTime.unboxToLong((Object)partial.productElement(this.partialCountIndex()));
        BigInteger bufferSum = (BigInteger)buffer.productElement(this.partialSumIndex());
        long bufferCount = BoxesRunTime.unboxToLong((Object)buffer.productElement(this.partialCountIndex()));
        buffer.setField(this.partialSumIndex(), partialSum.add(bufferSum));
        buffer.setField(this.partialCountIndex(), BoxesRunTime.boxToLong((long)LongMath.checkedAdd(partialCount, bufferCount)));
    }

    @Override
    public Object doEvaluate(Row buffer) {
        BigInteger bufferSum = (BigInteger)buffer.productElement(this.partialSumIndex());
        long bufferCount = BoxesRunTime.unboxToLong((Object)buffer.productElement(this.partialCountIndex()));
        return bufferCount == 0L ? null : BoxesRunTime.boxToLong((long)bufferSum.divide(BigInteger.valueOf(bufferCount)).longValue());
    }
}

