/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.table.runtime.aggregate;

import org.apache.flink.api.table.Row;
import org.apache.flink.api.table.runtime.aggregate.IntegralAvgAggregate;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001Y2A!\u0001\u0002\u0001#\t\t2\u000b[8si\u00063x-Q4he\u0016<\u0017\r^3\u000b\u0005\r!\u0011!C1hOJ,w-\u0019;f\u0015\t)a!A\u0004sk:$\u0018.\\3\u000b\u0005\u001dA\u0011!\u0002;bE2,'BA\u0005\u000b\u0003\r\t\u0007/\u001b\u0006\u0003\u00171\tQA\u001a7j].T!!\u0004\b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0011aA8sO\u000e\u00011C\u0001\u0001\u0013!\r\u0019BCF\u0007\u0002\u0005%\u0011QC\u0001\u0002\u0015\u0013:$Xm\u001a:bY\u00063x-Q4he\u0016<\u0017\r^3\u0011\u0005]QR\"\u0001\r\u000b\u0003e\tQa]2bY\u0006L!a\u0007\r\u0003\u000bMCwN\u001d;\t\u000bu\u0001A\u0011\u0001\u0010\u0002\rqJg.\u001b;?)\u0005y\u0002CA\n\u0001\u0011\u0015\t\u0003\u0001\"\u0011#\u0003%!w\u000e\u0015:fa\u0006\u0014X\rF\u0002$M-\u0002\"a\u0006\u0013\n\u0005\u0015B\"\u0001B+oSRDQa\n\u0011A\u0002!\nQA^1mk\u0016\u0004\"aF\u0015\n\u0005)B\"aA!os\")A\u0006\ta\u0001[\u00059\u0001/\u0019:uS\u0006d\u0007C\u0001\u00180\u001b\u00051\u0011B\u0001\u0019\u0007\u0005\r\u0011vn\u001e\u0005\u0006e\u0001!\teM\u0001\u000bI>,e/\u00197vCR,GC\u0001\u00155\u0011\u0015)\u0014\u00071\u0001.\u0003\u0019\u0011WO\u001a4fe\u0002")
public class ShortAvgAggregate
extends IntegralAvgAggregate<Object> {
    @Override
    public void doPrepare(Object value, Row partial) {
        short input = BoxesRunTime.unboxToShort((Object)value);
        partial.setField(this.partialSumIndex(), BoxesRunTime.boxToLong((long)input));
        partial.setField(this.partialCountIndex(), BoxesRunTime.boxToLong((long)1L));
    }

    @Override
    public Object doEvaluate(Row buffer) {
        long bufferSum = BoxesRunTime.unboxToLong((Object)buffer.productElement(this.partialSumIndex()));
        long bufferCount = BoxesRunTime.unboxToLong((Object)buffer.productElement(this.partialCountIndex()));
        return bufferCount == 0L ? null : BoxesRunTime.boxToShort((short)((short)(bufferSum / bufferCount)));
    }
}

