/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.table.typeutils;

import org.apache.flink.api.table.Row;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

public final class NullMaskUtils$ {
    public static final NullMaskUtils$ MODULE$;

    static {
        new NullMaskUtils$();
    }

    public void writeNullMask(int len, Row value, DataOutputView target) {
        int b = 0;
        int bytePos = 0;
        int numPos = 0;
        for (int fieldPos = 0; fieldPos < len; fieldPos += numPos) {
            b = 0;
            numPos = Math.min(8, len - fieldPos);
            for (bytePos = 0; bytePos < numPos; ++bytePos) {
                b <<= 1;
                if (value.productElement(fieldPos + bytePos) != null) continue;
                b |= 1;
            }
            target.writeByte(b <<= 8 - bytePos);
        }
    }

    public void readIntoNullMask(int len, DataInputView source, boolean[] nullMask) {
        int b = 0;
        int bytePos = 0;
        int numPos = 0;
        for (int fieldPos = 0; fieldPos < len; fieldPos += numPos) {
            b = source.readUnsignedByte();
            numPos = Math.min(8, len - fieldPos);
            for (bytePos = 0; bytePos < numPos; ++bytePos) {
                nullMask[fieldPos + bytePos] = (b & 0x80) > 0;
                b <<= 1;
            }
        }
    }

    public void readIntoAndCopyNullMask(int len, DataInputView source, DataOutputView target, boolean[] nullMask) {
        int b = 0;
        int bytePos = 0;
        int numPos = 0;
        for (int fieldPos = 0; fieldPos < len; fieldPos += numPos) {
            b = source.readUnsignedByte();
            target.writeByte(b);
            numPos = Math.min(8, len - fieldPos);
            for (bytePos = 0; bytePos < numPos; ++bytePos) {
                nullMask[fieldPos + bytePos] = (b & 0x80) > 0;
                b <<= 1;
            }
        }
    }

    private NullMaskUtils$() {
        MODULE$ = this;
    }
}

