/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.table.typeutils;

import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.NumericTypeInfo;
import org.apache.flink.api.common.typeinfo.SqlTimeTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.table.validate.ExprValidationResult;
import org.apache.flink.api.table.validate.ValidationFailure;
import org.apache.flink.api.table.validate.ValidationSuccess$;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;

public final class TypeCheckUtils$ {
    public static final TypeCheckUtils$ MODULE$;

    static {
        new TypeCheckUtils$();
    }

    public boolean isAdvanced(TypeInformation<?> dataType2) {
        TypeInformation<?> typeInformation = dataType2;
        boolean bl = typeInformation instanceof BasicTypeInfo ? false : !(typeInformation instanceof SqlTimeTypeInfo);
        return bl;
    }

    public boolean isSimple(TypeInformation<?> dataType2) {
        return !this.isAdvanced(dataType2);
    }

    public boolean isNumeric(TypeInformation<?> dataType2) {
        boolean bl;
        TypeInformation<?> typeInformation = dataType2;
        if (typeInformation instanceof NumericTypeInfo) {
            bl = true;
        } else {
            BasicTypeInfo basicTypeInfo = BasicTypeInfo.BIG_DEC_TYPE_INFO;
            TypeInformation<?> typeInformation2 = typeInformation;
            bl = !(basicTypeInfo != null ? !basicTypeInfo.equals(typeInformation2) : typeInformation2 != null);
        }
        return bl;
    }

    public boolean isTemporal(TypeInformation<?> dataType2) {
        return dataType2 instanceof SqlTimeTypeInfo;
    }

    public boolean isString(TypeInformation<?> dataType2) {
        TypeInformation<?> typeInformation = dataType2;
        BasicTypeInfo basicTypeInfo = BasicTypeInfo.STRING_TYPE_INFO;
        return !(typeInformation != null ? !typeInformation.equals((Object)basicTypeInfo) : basicTypeInfo != null);
    }

    public boolean isBoolean(TypeInformation<?> dataType2) {
        TypeInformation<?> typeInformation = dataType2;
        BasicTypeInfo basicTypeInfo = BasicTypeInfo.BOOLEAN_TYPE_INFO;
        return !(typeInformation != null ? !typeInformation.equals((Object)basicTypeInfo) : basicTypeInfo != null);
    }

    public boolean isDecimal(TypeInformation<?> dataType2) {
        TypeInformation<?> typeInformation = dataType2;
        BasicTypeInfo basicTypeInfo = BasicTypeInfo.BIG_DEC_TYPE_INFO;
        return !(typeInformation != null ? !typeInformation.equals((Object)basicTypeInfo) : basicTypeInfo != null);
    }

    public boolean isComparable(TypeInformation<?> dataType2) {
        return Comparable.class.isAssignableFrom(dataType2.getTypeClass());
    }

    public ExprValidationResult assertNumericExpr(TypeInformation<?> dataType2, String caller) {
        ExprValidationResult exprValidationResult;
        TypeInformation<?> typeInformation = dataType2;
        if (typeInformation instanceof NumericTypeInfo) {
            exprValidationResult = ValidationSuccess$.MODULE$;
        } else {
            BasicTypeInfo basicTypeInfo = BasicTypeInfo.BIG_DEC_TYPE_INFO;
            TypeInformation<?> typeInformation2 = typeInformation;
            exprValidationResult = !(basicTypeInfo != null ? !basicTypeInfo.equals(typeInformation2) : typeInformation2 != null) ? ValidationSuccess$.MODULE$ : new ValidationFailure(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " requires numeric types, get ", " here"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{caller, dataType2})));
        }
        return exprValidationResult;
    }

    public ExprValidationResult assertOrderableExpr(TypeInformation<?> dataType2, String caller) {
        return dataType2.isSortKeyType() ? ValidationSuccess$.MODULE$ : new ValidationFailure(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " requires orderable types, get ", " here"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{caller, dataType2})));
    }

    private TypeCheckUtils$() {
        MODULE$ = this;
    }
}

