/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.examples.java;

import org.apache.flink.api.java.CollectionEnvironment;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.table.BatchTableEnvironment;
import org.apache.flink.api.table.Table;
import org.apache.flink.api.table.TableEnvironment;

public class JavaTableExample {
    public static void main(String[] args) throws Exception {
        CollectionEnvironment env = ExecutionEnvironment.createCollectionsEnvironment();
        BatchTableEnvironment tableEnv = TableEnvironment.getTableEnvironment((ExecutionEnvironment)env);
        DataSource input = env.fromElements((Object[])new WC[]{new WC("Hello", 1L), new WC("Ciao", 1L), new WC("Hello", 1L)});
        Table table = tableEnv.fromDataSet(input);
        Table filtered = table.groupBy("word").select("word.count as count, word").filter("count = 2");
        DataSet<WC> result = tableEnv.toDataSet(filtered, WC.class);
        result.print();
    }

    public static class WC {
        public String word;
        public long count;

        public WC() {
        }

        public WC(String word, long count) {
            this.word = word;
            this.count = count;
        }

        public String toString() {
            return "WC " + this.word + " " + this.count;
        }
    }
}

