/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.shaded.calcite.com.fasterxml.jackson.databind.deser.std;

import java.io.IOException;
import java.util.Collection;
import org.apache.flink.shaded.calcite.com.fasterxml.jackson.core.JsonParser;
import org.apache.flink.shaded.calcite.com.fasterxml.jackson.core.JsonToken;
import org.apache.flink.shaded.calcite.com.fasterxml.jackson.databind.BeanProperty;
import org.apache.flink.shaded.calcite.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.flink.shaded.calcite.com.fasterxml.jackson.databind.DeserializationFeature;
import org.apache.flink.shaded.calcite.com.fasterxml.jackson.databind.JavaType;
import org.apache.flink.shaded.calcite.com.fasterxml.jackson.databind.JsonDeserializer;
import org.apache.flink.shaded.calcite.com.fasterxml.jackson.databind.JsonMappingException;
import org.apache.flink.shaded.calcite.com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import org.apache.flink.shaded.calcite.com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import org.apache.flink.shaded.calcite.com.fasterxml.jackson.databind.deser.ValueInstantiator;
import org.apache.flink.shaded.calcite.com.fasterxml.jackson.databind.deser.std.ContainerDeserializerBase;
import org.apache.flink.shaded.calcite.com.fasterxml.jackson.databind.introspect.AnnotatedWithParams;
import org.apache.flink.shaded.calcite.com.fasterxml.jackson.databind.jsontype.TypeDeserializer;

@JacksonStdImpl
public final class StringCollectionDeserializer
extends ContainerDeserializerBase<Collection<String>>
implements ContextualDeserializer {
    private static final long serialVersionUID = 1L;
    protected final JavaType _collectionType;
    protected final JsonDeserializer<String> _valueDeserializer;
    protected final ValueInstantiator _valueInstantiator;
    protected final JsonDeserializer<Object> _delegateDeserializer;

    public StringCollectionDeserializer(JavaType collectionType, JsonDeserializer<?> valueDeser, ValueInstantiator valueInstantiator) {
        this(collectionType, valueInstantiator, null, valueDeser);
    }

    protected StringCollectionDeserializer(JavaType collectionType, ValueInstantiator valueInstantiator, JsonDeserializer<?> delegateDeser, JsonDeserializer<?> valueDeser) {
        super(collectionType);
        this._collectionType = collectionType;
        this._valueDeserializer = valueDeser;
        this._valueInstantiator = valueInstantiator;
        this._delegateDeserializer = delegateDeser;
    }

    protected StringCollectionDeserializer withResolved(JsonDeserializer<?> delegateDeser, JsonDeserializer<?> valueDeser) {
        if (this._valueDeserializer == valueDeser && this._delegateDeserializer == delegateDeser) {
            return this;
        }
        return new StringCollectionDeserializer(this._collectionType, this._valueInstantiator, delegateDeser, valueDeser);
    }

    @Override
    public boolean isCachable() {
        return this._valueDeserializer == null && this._delegateDeserializer == null;
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        AnnotatedWithParams delegateCreator;
        JsonDeserializer<Object> delegate = null;
        if (this._valueInstantiator != null && (delegateCreator = this._valueInstantiator.getDelegateCreator()) != null) {
            JavaType delegateType = this._valueInstantiator.getDelegateType(ctxt.getConfig());
            delegate = this.findDeserializer(ctxt, delegateType, property);
        }
        JsonDeserializer<Object> valueDeser = this._valueDeserializer;
        JavaType valueType = this._collectionType.getContentType();
        if (valueDeser == null) {
            if ((valueDeser = this.findConvertingContentDeserializer(ctxt, property, valueDeser)) == null) {
                valueDeser = ctxt.findContextualValueDeserializer(valueType, property);
            }
        } else {
            valueDeser = ctxt.handleSecondaryContextualization(valueDeser, property, valueType);
        }
        if (this.isDefaultDeserializer(valueDeser)) {
            valueDeser = null;
        }
        return this.withResolved(delegate, valueDeser);
    }

    @Override
    public JavaType getContentType() {
        return this._collectionType.getContentType();
    }

    @Override
    public JsonDeserializer<Object> getContentDeserializer() {
        JsonDeserializer<Object> deser = this._valueDeserializer;
        return deser;
    }

    @Override
    public Collection<String> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        if (this._delegateDeserializer != null) {
            return (Collection)this._valueInstantiator.createUsingDelegate(ctxt, this._delegateDeserializer.deserialize(jp, ctxt));
        }
        Collection result = (Collection)this._valueInstantiator.createUsingDefault(ctxt);
        return this.deserialize(jp, ctxt, result);
    }

    @Override
    public Collection<String> deserialize(JsonParser jp, DeserializationContext ctxt, Collection<String> result) throws IOException {
        if (!jp.isExpectedStartArrayToken()) {
            return this.handleNonArray(jp, ctxt, result);
        }
        if (this._valueDeserializer != null) {
            return this.deserializeUsingCustom(jp, ctxt, result, this._valueDeserializer);
        }
        try {
            while (true) {
                String value;
                if ((value = jp.nextTextValue()) != null) {
                    result.add(value);
                    continue;
                }
                JsonToken t = jp.getCurrentToken();
                if (t != JsonToken.END_ARRAY) {
                    if (t != JsonToken.VALUE_NULL) {
                        value = this._parseString(jp, ctxt);
                    }
                    result.add(value);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            throw JsonMappingException.wrapWithPath((Throwable)e, result, result.size());
        }
        return result;
    }

    private Collection<String> deserializeUsingCustom(JsonParser jp, DeserializationContext ctxt, Collection<String> result, JsonDeserializer<String> deser) throws IOException {
        while (true) {
            String value;
            if (jp.nextTextValue() == null) {
                JsonToken t = jp.getCurrentToken();
                if (t == JsonToken.END_ARRAY) break;
                value = t == JsonToken.VALUE_NULL ? deser.getNullValue(ctxt) : deser.deserialize(jp, ctxt);
            } else {
                value = deser.deserialize(jp, ctxt);
            }
            result.add(value);
        }
        return result;
    }

    @Override
    public Object deserializeWithType(JsonParser jp, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
        return typeDeserializer.deserializeTypedFromArray(jp, ctxt);
    }

    private final Collection<String> handleNonArray(JsonParser jp, DeserializationContext ctxt, Collection<String> result) throws IOException {
        if (!ctxt.isEnabled(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY)) {
            throw ctxt.mappingException(this._collectionType.getRawClass());
        }
        JsonDeserializer<String> valueDes = this._valueDeserializer;
        JsonToken t = jp.getCurrentToken();
        String value = t == JsonToken.VALUE_NULL ? (valueDes == null ? null : valueDes.getNullValue(ctxt)) : (valueDes == null ? this._parseString(jp, ctxt) : valueDes.deserialize(jp, ctxt));
        result.add(value);
        return result;
    }
}

