/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.enumerable;

import org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.calcite.adapter.enumerable.EnumerableTableScan;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.ConverterRule;
import org.apache.calcite.rel.logical.LogicalTableScan;
import org.apache.calcite.schema.Table;

public class EnumerableTableScanRule
extends ConverterRule {
    public EnumerableTableScanRule() {
        super(LogicalTableScan.class, Convention.NONE, EnumerableConvention.INSTANCE, "EnumerableTableScanRule");
    }

    @Override
    public RelNode convert(RelNode rel) {
        LogicalTableScan scan = (LogicalTableScan)rel;
        RelOptTable relOptTable = scan.getTable();
        Table table = relOptTable.unwrap(Table.class);
        if (!EnumerableTableScan.canHandle(table)) {
            return null;
        }
        Expression expression2 = relOptTable.getExpression(Object.class);
        if (expression2 == null) {
            return null;
        }
        return EnumerableTableScan.create(scan.getCluster(), relOptTable);
    }
}

