/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.linq4j.tree;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.linq4j.tree.AbstractNode;
import org.apache.calcite.linq4j.tree.Blocks;
import org.apache.calcite.linq4j.tree.ExpressionType;
import org.apache.calcite.linq4j.tree.ExpressionWriter;
import org.apache.calcite.linq4j.tree.Node;

public class ConditionalExpression
extends AbstractNode {
    private final List<Node> expressionList;

    public ConditionalExpression(List<Node> expressionList2, Type type) {
        super(ExpressionType.Conditional, type);
        assert (expressionList2 != null) : "expressionList should not be null";
        this.expressionList = expressionList2;
    }

    @Override
    void accept(ExpressionWriter writer, int lprec, int rprec) {
        for (int i = 0; i < this.expressionList.size(); i += 2) {
            writer.append(i > 0 ? " else if (" : "if (").append(this.expressionList.get(i)).append(") ").append(Blocks.toBlock(this.expressionList.get(i + 1)));
        }
        if (this.expressionList.size() % 2 == 1) {
            writer.append(" else ").append(Blocks.toBlock(this.expressionList.get(this.expressionList.size() - 1)));
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConditionalExpression that = (ConditionalExpression)o;
        return this.expressionList.equals(that.expressionList);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.nodeType, this.type, this.expressionList});
    }
}

