/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.core;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.BiRel;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.JoinInfo;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.metadata.RelMdUtil;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexChecker;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.util.Litmus;
import org.apache.calcite.util.Util;
import org.apache.flink.shaded.calcite.com.google.common.base.Preconditions;
import org.apache.flink.shaded.calcite.com.google.common.collect.ImmutableList;
import org.apache.flink.shaded.calcite.com.google.common.collect.ImmutableSet;

public abstract class Join
extends BiRel {
    protected final RexNode condition;
    protected final ImmutableSet<CorrelationId> variablesSet;
    protected final JoinRelType joinType;

    protected Join(RelOptCluster cluster, RelTraitSet traitSet, RelNode left, RelNode right, RexNode condition, Set<CorrelationId> variablesSet, JoinRelType joinType) {
        super(cluster, traitSet, left, right);
        this.condition = Preconditions.checkNotNull(condition);
        this.variablesSet = ImmutableSet.copyOf(variablesSet);
        this.joinType = Preconditions.checkNotNull(joinType);
    }

    @Deprecated
    protected Join(RelOptCluster cluster, RelTraitSet traitSet, RelNode left, RelNode right, RexNode condition, JoinRelType joinType, Set<String> variablesStopped) {
        this(cluster, traitSet, left, right, condition, CorrelationId.setOf(variablesStopped), joinType);
    }

    @Override
    public List<RexNode> getChildExps() {
        return ImmutableList.of(this.condition);
    }

    @Override
    public RelNode accept(RexShuttle shuttle) {
        RexNode condition = shuttle.apply(this.condition);
        if (this.condition == condition) {
            return this;
        }
        return this.copy(this.traitSet, condition, this.left, this.right, this.joinType, this.isSemiJoinDone());
    }

    public RexNode getCondition() {
        return this.condition;
    }

    public JoinRelType getJoinType() {
        return this.joinType;
    }

    public boolean isValid_(Litmus litmus) {
        if (!super.isValid(litmus)) {
            return false;
        }
        if (this.getRowType().getFieldCount() != this.getSystemFieldList().size() + this.left.getRowType().getFieldCount() + this.right.getRowType().getFieldCount()) {
            return litmus.fail("field count mismatch", new Object[0]);
        }
        if (this.condition != null) {
            if (this.condition.getType().getSqlTypeName() != SqlTypeName.BOOLEAN) {
                return litmus.fail("condition must be boolean: {}", this.condition.getType());
            }
            RexChecker checker = new RexChecker(this.getCluster().getTypeFactory().builder().addAll(this.getSystemFieldList()).addAll(this.getLeft().getRowType().getFieldList()).addAll(this.getRight().getRowType().getFieldList()).build(), litmus);
            this.condition.accept(checker);
            if (checker.getFailureCount() > 0) {
                return litmus.fail(checker.getFailureCount() + " failures in condition " + this.condition, new Object[0]);
            }
        }
        return litmus.succeed();
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        double rowCount = mq.getRowCount(this);
        return planner.getCostFactory().makeCost(rowCount, 0.0, 0.0);
    }

    @Deprecated
    public static double estimateJoinedRows(Join joinRel, RexNode condition) {
        RelMetadataQuery mq = RelMetadataQuery.instance();
        return Util.first(RelMdUtil.getJoinRowCount(mq, joinRel, condition), 1.0);
    }

    @Override
    public double estimateRowCount(RelMetadataQuery mq) {
        return Util.first(RelMdUtil.getJoinRowCount(mq, this, this.condition), 1.0);
    }

    @Override
    public Set<CorrelationId> getVariablesSet() {
        return this.variablesSet;
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("condition", this.condition).item("joinType", this.joinType.name().toLowerCase()).itemIf("systemFields", this.getSystemFieldList(), !this.getSystemFieldList().isEmpty());
    }

    @Override
    protected RelDataType deriveRowType() {
        return SqlValidatorUtil.deriveJoinRowType(this.left.getRowType(), this.right.getRowType(), this.joinType, this.getCluster().getTypeFactory(), null, this.getSystemFieldList());
    }

    public boolean isSemiJoinDone() {
        return false;
    }

    public List<RelDataTypeField> getSystemFieldList() {
        return Collections.emptyList();
    }

    @Deprecated
    public static RelDataType deriveJoinRowType(RelDataType leftType, RelDataType rightType, JoinRelType joinType, RelDataTypeFactory typeFactory, List<String> fieldNameList, List<RelDataTypeField> systemFieldList) {
        return SqlValidatorUtil.deriveJoinRowType(leftType, rightType, joinType, typeFactory, fieldNameList, systemFieldList);
    }

    @Deprecated
    public static RelDataType createJoinType(RelDataTypeFactory typeFactory, RelDataType leftType, RelDataType rightType, List<String> fieldNameList, List<RelDataTypeField> systemFieldList) {
        return SqlValidatorUtil.createJoinType(typeFactory, leftType, rightType, fieldNameList, systemFieldList);
    }

    @Override
    public final Join copy(RelTraitSet traitSet, List<RelNode> inputs) {
        assert (inputs.size() == 2);
        return this.copy(traitSet, this.getCondition(), inputs.get(0), inputs.get(1), this.joinType, this.isSemiJoinDone());
    }

    public abstract Join copy(RelTraitSet var1, RexNode var2, RelNode var3, RelNode var4, JoinRelType var5, boolean var6);

    public JoinInfo analyzeCondition() {
        return JoinInfo.of(this.left, this.right, this.condition);
    }
}

