/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import java.util.List;
import org.apache.calcite.sql.SqlAbstractStringLiteral;
import org.apache.calcite.sql.SqlCollation;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.NlsString;
import org.apache.flink.shaded.calcite.com.google.common.base.Function;
import org.apache.flink.shaded.calcite.com.google.common.collect.Lists;

public class SqlCharStringLiteral
extends SqlAbstractStringLiteral {
    private static final Function<SqlLiteral, NlsString> F = new Function<SqlLiteral, NlsString>(){

        @Override
        public NlsString apply(SqlLiteral literal) {
            return ((SqlCharStringLiteral)literal).getNlsString();
        }
    };

    protected SqlCharStringLiteral(NlsString val, SqlParserPos pos) {
        super(val, SqlTypeName.CHAR, pos);
    }

    public NlsString getNlsString() {
        return (NlsString)this.value;
    }

    public SqlCollation getCollation() {
        return this.getNlsString().getCollation();
    }

    @Override
    public SqlNode clone(SqlParserPos pos) {
        return new SqlCharStringLiteral((NlsString)this.value, pos);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        assert (this.value instanceof NlsString);
        writer.literal(this.value.toString());
    }

    @Override
    protected SqlAbstractStringLiteral concat1(List<SqlLiteral> literals) {
        return new SqlCharStringLiteral(NlsString.concat(Lists.transform(literals, F)), literals.get(0).getParserPosition());
    }
}

