/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.validate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.StructKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.validate.DelegatingScope;
import org.apache.calcite.sql.validate.SqlMoniker;
import org.apache.calcite.sql.validate.SqlMonikerImpl;
import org.apache.calcite.sql.validate.SqlMonikerType;
import org.apache.calcite.sql.validate.SqlValidatorNamespace;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.sql.validate.SqlValidatorTable;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Static;
import org.apache.calcite.util.Util;
import org.apache.flink.shaded.calcite.com.google.common.collect.ImmutableList;

public abstract class ListScope
extends DelegatingScope {
    protected final List<Pair<String, SqlValidatorNamespace>> children = new ArrayList<Pair<String, SqlValidatorNamespace>>();

    public ListScope(SqlValidatorScope parent) {
        super(parent);
    }

    @Override
    public void addChild(SqlValidatorNamespace ns, String alias2) {
        assert (alias2 != null);
        this.children.add(Pair.of(alias2, ns));
    }

    public List<SqlValidatorNamespace> getChildren() {
        return Pair.right(this.children);
    }

    private int findChild(List<String> names) {
        for (Ord<Pair<String, SqlValidatorNamespace>> child : Ord.zip(this.children)) {
            SqlValidatorTable table2;
            SqlValidatorTable table;
            String lastName = Util.last(names);
            if (((Pair)child.e).left != null) {
                if (!this.validator.catalogReader.matches((String)((Pair)child.e).left, lastName)) continue;
                if (names.size() == 1) {
                    return child.i;
                }
            }
            if ((table = ((SqlValidatorNamespace)((Pair)child.e).right).getTable()) == null || (table2 = this.validator.catalogReader.getTable(names)) == null || !table.getQualifiedName().equals(table2.getQualifiedName())) continue;
            return child.i;
        }
        return -1;
    }

    @Override
    public void findAllColumnNames(List<SqlMoniker> result) {
        for (Pair<String, SqlValidatorNamespace> pair : this.children) {
            this.addColumnNames((SqlValidatorNamespace)pair.right, result);
        }
        this.parent.findAllColumnNames(result);
    }

    @Override
    public void findAliases(Collection<SqlMoniker> result) {
        for (Pair<String, SqlValidatorNamespace> pair : this.children) {
            result.add(new SqlMonikerImpl((String)pair.left, SqlMonikerType.TABLE));
        }
        this.parent.findAliases(result);
    }

    @Override
    public Pair<String, SqlValidatorNamespace> findQualifyingTableName(String columnName, SqlNode ctx) {
        Map<String, SqlValidatorNamespace> map2 = this.findQualifyingTables(columnName);
        switch (map2.size()) {
            case 0: {
                return this.parent.findQualifyingTableName(columnName, ctx);
            }
            case 1: {
                return Pair.of(map2.entrySet().iterator().next());
            }
        }
        throw this.validator.newValidationError(ctx, Static.RESOURCE.columnAmbiguous(columnName));
    }

    @Override
    public Map<String, SqlValidatorNamespace> findQualifyingTables(String columnName) {
        HashMap<String, SqlValidatorNamespace> map2 = new HashMap<String, SqlValidatorNamespace>();
        for (Pair<String, SqlValidatorNamespace> child : this.children) {
            SqlValidatorScope.ResolvedImpl resolved = new SqlValidatorScope.ResolvedImpl();
            this.resolve(ImmutableList.of(child.left, columnName), true, resolved);
            if (resolved.count() <= 0) continue;
            map2.put(child.getKey(), child.getValue());
        }
        return map2;
    }

    @Override
    protected boolean hasLiberalChild() {
        for (Pair<String, SqlValidatorNamespace> child : this.children) {
            RelDataType rowType = ((SqlValidatorNamespace)child.right).getRowType();
            switch (rowType.getStructKind()) {
                case PEEK_FIELDS: 
                case PEEK_FIELDS_DEFAULT: {
                    return true;
                }
            }
            for (RelDataTypeField field : rowType.getFieldList()) {
                switch (field.getType().getStructKind()) {
                    case PEEK_FIELDS: 
                    case PEEK_FIELDS_DEFAULT: {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    @Override
    public void resolve(List<String> names, boolean deep, SqlValidatorScope.Resolved resolved) {
        int i = this.findChild(names);
        if (i >= 0) {
            SqlValidatorScope.Step path = resolved.emptyPath().add(null, i, StructKind.FULLY_QUALIFIED);
            resolved.found((SqlValidatorNamespace)this.children.get((int)i).right, this, path);
            return;
        }
        if (deep) {
            for (Ord<Pair<String, SqlValidatorNamespace>> child : Ord.zip(this.children)) {
                List<String> names2 = this.validator.catalogReader.matches((String)((Pair)child.e).left, names.get(0)) ? names.subList(1, names.size()) : names;
                this.resolveInNamespace((SqlValidatorNamespace)((Pair)child.e).right, names2, resolved.emptyPath(), resolved);
            }
            if (resolved.count() > 0) {
                return;
            }
        }
        super.resolve(names, deep, resolved);
    }

    @Override
    public RelDataType resolveColumn(String columnName, SqlNode ctx) {
        int found = 0;
        RelDataType type = null;
        for (Pair<String, SqlValidatorNamespace> pair : this.children) {
            SqlValidatorNamespace childNs = (SqlValidatorNamespace)pair.right;
            RelDataType childRowType = childNs.getRowType();
            RelDataTypeField field = this.validator.catalogReader.field(childRowType, columnName);
            if (field == null) continue;
            ++found;
            type = field.getType();
        }
        switch (found) {
            case 0: {
                return null;
            }
            case 1: {
                return type;
            }
        }
        throw this.validator.newValidationError(ctx, Static.RESOURCE.columnAmbiguous(columnName));
    }
}

