/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.shaded.calcite.org.eigenbase.util.property;

import java.util.Properties;
import org.apache.flink.shaded.calcite.org.eigenbase.util.property.Property;

public class DoubleProperty
extends Property {
    private final double minValue;
    private final double maxValue;

    public DoubleProperty(Properties properties, String path, double defaultValue) {
        this(properties, path, defaultValue, -1.7976931348623157E308, Double.MAX_VALUE);
    }

    public DoubleProperty(Properties properties, String path) {
        this(properties, path, -1.7976931348623157E308, Double.MAX_VALUE);
    }

    public DoubleProperty(Properties properties, String path, double defaultValue, double minValue, double maxValue) {
        super(properties, path, Double.toString(defaultValue));
        if (minValue > maxValue) {
            double temp = minValue;
            minValue = maxValue;
            maxValue = temp;
        }
        if (defaultValue < minValue || defaultValue > maxValue) {
            throw new IllegalArgumentException("invalid default value " + defaultValue);
        }
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    public DoubleProperty(Properties properties, String path, double minValue, double maxValue) {
        super(properties, path, null);
        if (minValue > maxValue) {
            double temp = minValue;
            minValue = maxValue;
            maxValue = temp;
        }
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    public double get() {
        String value = this.getInternal(null, false);
        if (value == null) {
            return this.noValue();
        }
        double v = Double.parseDouble(value);
        return this.limit(v);
    }

    public double get(double defaultValue) {
        String value = this.getInternal(Double.toString(defaultValue), false);
        if (value == null) {
            return this.limit(defaultValue);
        }
        double v = Double.parseDouble(value);
        return this.limit(v);
    }

    public double set(double value) {
        String prevValue = this.setString(Double.toString(this.limit(value)));
        if (prevValue == null && (prevValue = this.getDefaultValue()) == null) {
            return this.noValue();
        }
        double v = Double.parseDouble(prevValue);
        return this.limit(v);
    }

    private double limit(double value) {
        return Math.min(Math.max(value, this.minValue), this.maxValue);
    }

    private double noValue() {
        if (this.minValue <= 0.0 && this.maxValue >= 0.0) {
            return 0.0;
        }
        return this.minValue;
    }
}

