/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql2rel.RelDecorrelator;
import org.apache.calcite.tools.Program;
import org.apache.calcite.tools.Programs;
import org.apache.calcite.tools.RuleSet;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.io.DiscardingOutputFormat;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableEnvironment$;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.calcite.FlinkPlannerImpl;
import org.apache.flink.table.explain.PlanJsonParser;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.plan.logical.CatalogNode;
import org.apache.flink.table.plan.logical.LogicalRelNode;
import org.apache.flink.table.plan.nodes.dataset.DataSetConvention$;
import org.apache.flink.table.plan.nodes.dataset.DataSetRel;
import org.apache.flink.table.plan.rules.FlinkRuleSets$;
import org.apache.flink.table.plan.schema.DataSetTable;
import org.apache.flink.table.plan.schema.TableSourceTable;
import org.apache.flink.table.sinks.BatchTableSink;
import org.apache.flink.table.sinks.TableSink;
import org.apache.flink.table.sources.BatchTableSource;
import org.apache.flink.types.Row;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\tua!B\u0001\u0003\u0003\u0003i!!\u0006\"bi\u000eDG+\u00192mK\u0016sg/\u001b:p]6,g\u000e\u001e\u0006\u0003\u0007\u0011\t1!\u00199j\u0015\t)a!A\u0003uC\ndWM\u0003\u0002\b\u0011\u0005)a\r\\5oW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\b\u0011\u0005=\u0001R\"\u0001\u0002\n\u0005E\u0011!\u0001\u0005+bE2,WI\u001c<je>tW.\u001a8u\u0011%\u0019\u0002A!b\u0001\n\u00031A#A\u0004fq\u0016\u001cWI\u001c<\u0016\u0003U\u0001\"A\u0006\u000e\u000e\u0003]Q!\u0001G\r\u0002\t)\fg/\u0019\u0006\u0003\u0007\u0019I!aG\f\u0003)\u0015CXmY;uS>tWI\u001c<je>tW.\u001a8u\u0011!i\u0002A!A!\u0002\u0013)\u0012\u0001C3yK\u000e,eN\u001e\u0011\t\u0013}\u0001!\u0011!Q\u0001\n\u0001\u001a\u0013AB2p]\u001aLw\r\u0005\u0002\u0010C%\u0011!E\u0001\u0002\f)\u0006\u0014G.Z\"p]\u001aLw-\u0003\u0002 !!)Q\u0005\u0001C\u0001M\u00051A(\u001b8jiz\"2a\n\u0015*!\ty\u0001\u0001C\u0003\u0014I\u0001\u0007Q\u0003C\u0003 I\u0001\u0007\u0001\u0005C\u0004,\u0001\t\u0007I\u0011\u0002\u0017\u0002\u00119\fW.Z\"oiJ,\u0012!\f\t\u0003]Yj\u0011a\f\u0006\u0003aE\na!\u0019;p[&\u001c'B\u0001\u001a4\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003iU\nA!\u001e;jY*\t\u0001$\u0003\u00028_\ti\u0011\t^8nS\u000eLe\u000e^3hKJDa!\u000f\u0001!\u0002\u0013i\u0013!\u00038b[\u0016\u001ce\u000e\u001e:!\u0011\u001dY\u0004A1A\u0005\nq\n1#\u001b8uKJt\u0017\r\u001c(b[\u0016\u0004\u0016\r\u001e;fe:,\u0012!\u0010\t\u0003}\u0011k\u0011a\u0010\u0006\u0003\u0001\u0006\u000b\u0001\"\\1uG\"Lgn\u001a\u0006\u0003i\tS\u0011aQ\u0001\u0006g\u000e\fG.Y\u0005\u0003\u000b~\u0012QAU3hKbDaa\u0012\u0001!\u0002\u0013i\u0014\u0001F5oi\u0016\u0014h.\u00197OC6,\u0007+\u0019;uKJt\u0007\u0005C\u0003J\u0001\u0011E#*A\ndQ\u0016\u001c7NV1mS\u0012$\u0016M\u00197f\u001d\u0006lW\r\u0006\u0002L\u001fB\u0011A*T\u0007\u0002\u0005&\u0011aJ\u0011\u0002\u0005+:LG\u000fC\u0003Q\u0011\u0002\u0007\u0011+\u0001\u0003oC6,\u0007C\u0001*V\u001d\ta5+\u0003\u0002U\u0005\u00061\u0001K]3eK\u001aL!AV,\u0003\rM#(/\u001b8h\u0015\t!&\tC\u0003Z\u0001\u0011E!,A\u000bde\u0016\fG/Z+oSF,X\rV1cY\u0016t\u0015-\\3\u0015\u0003ECQ\u0001\u0018\u0001\u0005\u0002u\u000bAa]2b]R\u0011a,\u0019\t\u0003\u001f}K!\u0001\u0019\u0002\u0003\u000bQ\u000b'\r\\3\t\u000b\t\\\u0006\u0019A)\u0002\u0013Q\f'\r\\3OC6,\u0007fA.eUB\u0019A*Z4\n\u0005\u0019\u0014%A\u0002;ie><8\u000f\u0005\u0002\u0010Q&\u0011\u0011N\u0001\u0002\u0014-\u0006d\u0017\u000eZ1uS>tW\t_2faRLwN\\\u0019\u0006=E[\u0017\u0011B\u0019\u0006G1\u0004x0]\u000b\u0003[:,\u0012!\u0015\u0003\u0006_2\u0011\r\u0001\u001e\u0002\u0002)&\u0011\u0011O]\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u0019\u000b\u0005M\u0014\u0015A\u0002;ie><8/\u0005\u0002vqB\u0011AJ^\u0005\u0003o\n\u0013qAT8uQ&tw\r\u0005\u0002zy:\u0011AJ_\u0005\u0003w\n\u000bq\u0001]1dW\u0006<W-\u0003\u0002~}\nIA\u000b\u001b:po\u0006\u0014G.\u001a\u0006\u0003w\n\u000b\u0004bIA\u0001\u0003\u0007\t)a\u001d\b\u0004\u0019\u0006\r\u0011BA:Cc\u0015\u0011CJQA\u0004\u0005\u0015\u00198-\u00197bc\t1s\rC\u0004\u0002\u000e\u0001!\t!a\u0004\u0002'I,w-[:uKJ$\u0016M\u00197f'>,(oY3\u0015\u000b-\u000b\t\"a\u0005\t\rA\u000bY\u00011\u0001R\u0011!\t)\"a\u0003A\u0002\u0005]\u0011a\u0003;bE2,7k\\;sG\u0016\u0004D!!\u0007\u0002*A1\u00111DA\u0011\u0003Ki!!!\b\u000b\u0007\u0005}A!A\u0004t_V\u00148-Z:\n\t\u0005\r\u0012Q\u0004\u0002\u0011\u0005\u0006$8\r\u001b+bE2,7k\\;sG\u0016\u0004B!a\n\u0002*1\u0001A\u0001DA\u0016\u0003'\t\t\u0011!A\u0003\u0002\u00055\"aA0%cE\u0019Q/a\f\u0011\u00071\u000b\t$C\u0002\u00024\t\u00131!\u00118z\u0011\u001d\t9\u0004\u0001C!\u0003s\t1a]9m)\rq\u00161\b\u0005\b\u0003{\t)\u00041\u0001R\u0003\u0015\tX/\u001a:z\u0011!\t\t\u0005\u0001C!\r\u0005\r\u0013aC<sSR,Gk\\*j].,B!!\u0012\u0002\\Q)1*a\u0012\u0002J!1Q!a\u0010A\u0002yC\u0001\"a\u0013\u0002@\u0001\u0007\u0011QJ\u0001\u0005g&t7\u000e\u0005\u0004\u0002P\u0005U\u0013\u0011L\u0007\u0003\u0003#R1!a\u0015\u0005\u0003\u0015\u0019\u0018N\\6t\u0013\u0011\t9&!\u0015\u0003\u0013Q\u000b'\r\\3TS:\\\u0007\u0003BA\u0014\u00037\"qa\\A \u0005\u0004\ti\u0003\u0003\u0005\u0002`\u0001!\tABA1\u0003\u001d)\u0007\u0010\u001d7bS:$R!UA2\u0003KBa!BA/\u0001\u0004q\u0006\u0002CA4\u0003;\u0002\r!!\u001b\u0002\u0011\u0015DH/\u001a8eK\u0012\u00042\u0001TA6\u0013\r\tiG\u0011\u0002\b\u0005>|G.Z1o\u0011\u001d\ty\u0006\u0001C\u0001\u0003c\"2!UA:\u0011\u0019)\u0011q\u000ea\u0001=\"9\u0011q\u000f\u0001\u0005\u0012\u0005e\u0014a\u0006:fO&\u001cH/\u001a:ECR\f7+\u001a;J]R,'O\\1m+\u0011\tY(a#\u0015\u000b-\u000bi(a \t\rA\u000b)\b1\u0001R\u0011!\t\t)!\u001eA\u0002\u0005\r\u0015a\u00023bi\u0006\u001cV\r\u001e\t\u0006-\u0005\u0015\u0015\u0011R\u0005\u0004\u0003\u000f;\"a\u0002#bi\u0006\u001cV\r\u001e\t\u0005\u0003O\tY\tB\u0004p\u0003k\u0012\r!!\f\t\u000f\u0005]\u0004\u0001\"\u0005\u0002\u0010V!\u0011\u0011SAN)\u001dY\u00151SAK\u0003;Ca\u0001UAG\u0001\u0004\t\u0006\u0002CAA\u0003\u001b\u0003\r!a&\u0011\u000bY\t))!'\u0011\t\u0005\u001d\u00121\u0014\u0003\b_\u00065%\u0019AA\u0017\u0011!\ty*!$A\u0002\u0005\u0005\u0016A\u00024jK2$7\u000fE\u0003M\u0003G\u000b9+C\u0002\u0002&\n\u0013Q!\u0011:sCf\u0004B!!+\u000206\u0011\u00111\u0016\u0006\u0004\u0003[#\u0011aC3yaJ,7o]5p]NLA!!-\u0002,\nQQ\t\u001f9sKN\u001c\u0018n\u001c8\t\u000f\u0005U\u0006\u0001\"\u0005\u00028\u0006\tr-\u001a;Ck&dG/\u00138Sk2,7+\u001a;\u0016\u0005\u0005e\u0006\u0003BA^\u0003\u000bl!!!0\u000b\t\u0005}\u0016\u0011Y\u0001\u0006i>|Gn\u001d\u0006\u0004\u0003\u0007D\u0011aB2bY\u000eLG/Z\u0005\u0005\u0003\u000f\fiLA\u0004Sk2,7+\u001a;\t\u0011\u0005-\u0007\u0001\"\u0001\u0007\u0003\u001b\f\u0001b\u001c9uS6L'0\u001a\u000b\u0005\u0003\u001f\fY\u000e\u0005\u0003\u0002R\u0006]WBAAj\u0015\u0011\t).!1\u0002\u0007I,G.\u0003\u0003\u0002Z\u0006M'a\u0002*fY:{G-\u001a\u0005\t\u0003;\fI\r1\u0001\u0002P\u00069!/\u001a7O_\u0012,\u0007bBAq\u0001\u0011E\u00111]\u0001\niJ\fgn\u001d7bi\u0016,B!!:\u0002nR!\u0011q\u001dB\u0003)\u0011\tI/!=\u0011\u000bY\t))a;\u0011\t\u0005\u001d\u0012Q\u001e\u0003\t\u0003_\fyN1\u0001\u0002.\t\t\u0011\t\u0003\u0005\u0002t\u0006}\u00079AA{\u0003\r!\b/\u001a\t\u0007\u0003o\u0014\t!a;\u000e\u0005\u0005e(\u0002BA~\u0003{\f\u0001\u0002^=qK&tgm\u001c\u0006\u0004\u0003\u007fL\u0012AB2p[6|g.\u0003\u0003\u0003\u0004\u0005e(a\u0004+za\u0016LeNZ8s[\u0006$\u0018n\u001c8\t\r\u0015\ty\u000e1\u0001_\u0011\u001d\t\t\u000f\u0001C\t\u0005\u0013)BAa\u0003\u0003\u0014Q!!Q\u0002B\r)\u0011\u0011yA!\u0006\u0011\u000bY\t)I!\u0005\u0011\t\u0005\u001d\"1\u0003\u0003\t\u0003_\u00149A1\u0001\u0002.!A\u00111\u001fB\u0004\u0001\b\u00119\u0002\u0005\u0004\u0002x\n\u0005!\u0011\u0003\u0005\t\u00057\u00119\u00011\u0001\u0002P\u0006YAn\\4jG\u0006d\u0007\u000b\\1o\u0001")
public abstract class BatchTableEnvironment
extends TableEnvironment {
    private final ExecutionEnvironment execEnv;
    private final AtomicInteger nameCntr;
    private final Regex internalNamePattern;

    public ExecutionEnvironment execEnv() {
        return this.execEnv;
    }

    private AtomicInteger nameCntr() {
        return this.nameCntr;
    }

    private Regex internalNamePattern() {
        return this.internalNamePattern;
    }

    @Override
    public void checkValidTableName(String name) {
        Option m = this.internalNamePattern().findFirstIn((CharSequence)name);
        Option option = m;
        if (option instanceof Some) {
            throw new TableException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Illegal Table name. "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Please choose a name that does not contain the pattern ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.internalNamePattern()}))).toString());
        }
        None$ none$ = None$.MODULE$;
        Option option2 = option;
        if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        throw new MatchError((Object)option);
    }

    public String createUniqueTableName() {
        return new StringBuilder().append((Object)"_DataSetTable_").append((Object)BoxesRunTime.boxToInteger((int)this.nameCntr().getAndIncrement())).toString();
    }

    public Table scan(String tableName) throws ValidationException {
        if (this.isRegistered(tableName)) {
            return new Table(this, new CatalogNode(tableName, this.getRowType(tableName)));
        }
        throw new TableException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Table \\'", "\\' was not found in the registry."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})));
    }

    public void registerTableSource(String name, BatchTableSource<?> tableSource) {
        this.checkValidTableName(name);
        this.registerTableInternal(name, new TableSourceTable(tableSource));
    }

    @Override
    public Table sql(String query) {
        FlinkPlannerImpl planner = new FlinkPlannerImpl(this.getFrameworkConfig(), this.getPlanner(), this.getTypeFactory());
        SqlNode parsed = planner.parse(query);
        SqlNode validated = planner.validate(parsed);
        RelRoot relational = planner.rel(validated);
        return new Table(this, new LogicalRelNode(relational.rel));
    }

    @Override
    public <T> void writeToSink(Table table, TableSink<T> sink) {
        TableSink<T> tableSink = sink;
        if (tableSink instanceof BatchTableSink) {
            BatchTableSink batchTableSink = (BatchTableSink)tableSink;
            TypeInformation<T> outputType = sink.getOutputType();
            DataSet<T> result = this.translate(table, outputType);
            batchTableSink.emitDataSet(result);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        throw new TableException("BatchTableSink required to emit batch Table");
    }

    public String explain(Table table, boolean extended) {
        RelNode ast = table.getRelNode();
        RelNode optimizedPlan = this.optimize(ast);
        DataSet dataSet = this.translate(optimizedPlan, TypeExtractor.createTypeInfo(Row.class));
        dataSet.output((OutputFormat)new DiscardingOutputFormat());
        ExecutionEnvironment env = dataSet.getExecutionEnvironment();
        String jasonSqlPlan = env.getExecutionPlan();
        String sqlPlan = PlanJsonParser.getSqlExecutionPlan(jasonSqlPlan, Predef$.MODULE$.boolean2Boolean(extended));
        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"== Abstract Syntax Tree =="})).s((Seq)Nil$.MODULE$)).append((Object)System.lineSeparator()).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{RelOptUtil.toString(ast)}))).append((Object)System.lineSeparator()).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"== Optimized Logical Plan =="})).s((Seq)Nil$.MODULE$)).append((Object)System.lineSeparator()).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{RelOptUtil.toString(optimizedPlan)}))).append((Object)System.lineSeparator()).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"== Physical Execution Plan =="})).s((Seq)Nil$.MODULE$)).append((Object)System.lineSeparator()).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sqlPlan}))).toString();
    }

    public String explain(Table table) {
        return this.explain(table, false);
    }

    public <T> void registerDataSetInternal(String name, DataSet<T> dataSet) {
        Tuple2<String[], int[]> tuple2 = this.getFieldInfo(dataSet.getType());
        if (tuple2 != null) {
            Tuple2 tuple22;
            String[] fieldNames = (String[])tuple2._1();
            int[] fieldIndexes = (int[])tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)fieldNames, (Object)fieldIndexes);
            String[] fieldNames2 = (String[])tuple23._1();
            int[] fieldIndexes2 = (int[])tuple23._2();
            DataSetTable<T> dataSetTable = new DataSetTable<T>(dataSet, fieldIndexes2, fieldNames2);
            this.registerTableInternal(name, dataSetTable);
            return;
        }
        throw new MatchError(tuple2);
    }

    public <T> void registerDataSetInternal(String name, DataSet<T> dataSet, Expression[] fields) {
        Tuple2<String[], int[]> tuple2 = this.getFieldInfo(dataSet.getType(), fields);
        if (tuple2 != null) {
            Tuple2 tuple22;
            String[] fieldNames = (String[])tuple2._1();
            int[] fieldIndexes = (int[])tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)fieldNames, (Object)fieldIndexes);
            String[] fieldNames2 = (String[])tuple23._1();
            int[] fieldIndexes2 = (int[])tuple23._2();
            DataSetTable<T> dataSetTable = new DataSetTable<T>(dataSet, fieldIndexes2, fieldNames2);
            this.registerTableInternal(name, dataSetTable);
            return;
        }
        throw new MatchError(tuple2);
    }

    @Override
    public RuleSet getBuiltInRuleSet() {
        return FlinkRuleSets$.MODULE$.DATASET_OPT_RULES();
    }

    public RelNode optimize(RelNode relNode) {
        RelNode decorPlan = RelDecorrelator.decorrelateQuery(relNode);
        Program optProgram = Programs.ofRules(this.getRuleSet());
        RelTraitSet flinkOutputProps = relNode.getTraitSet().replace(DataSetConvention$.MODULE$.INSTANCE()).simplify();
        try {
            RelNode dataSetPlan = optProgram.run(this.getPlanner(), decorPlan, flinkOutputProps);
            return dataSetPlan;
        }
        catch (AssertionError assertionError) {
            throw ((Throwable)((Object)assertionError)).getCause();
        }
        catch (TableException tableException) {
            throw new TableException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot generate a valid execution plan for the given query: \\n\\n"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{RelOptUtil.toString(relNode)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableException.msg()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Please check the documentation for the set of currently supported SQL features."})).s((Seq)Nil$.MODULE$)).toString());
        }
        catch (RelOptPlanner.CannotPlanException cannotPlanException) {
            throw new TableException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot generate a valid execution plan for the given query: \\n\\n"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{RelOptUtil.toString(relNode)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"This exception indicates that the query uses an unsupported SQL feature.\\n"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Please check the documentation for the set of currently supported SQL features."})).s((Seq)Nil$.MODULE$)).toString());
        }
    }

    public <A> DataSet<A> translate(Table table, TypeInformation<A> tpe) {
        RelNode dataSetPlan = this.optimize(table.getRelNode());
        return this.translate(dataSetPlan, tpe);
    }

    public <A> DataSet<A> translate(RelNode logicalPlan, TypeInformation<A> tpe) {
        TableEnvironment$.MODULE$.validateType(tpe);
        RelNode relNode = logicalPlan;
        if (relNode instanceof DataSetRel) {
            DataSetRel dataSetRel = (DataSetRel)relNode;
            DataSet<Object> dataSet = dataSetRel.translateToPlan(this, (Option<TypeInformation<Object>>)new Some(tpe));
            return dataSet;
        }
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public BatchTableEnvironment(ExecutionEnvironment execEnv, TableConfig config) {
        this.execEnv = execEnv;
        super(config);
        this.nameCntr = new AtomicInteger(0);
        this.internalNamePattern = new StringOps(Predef$.MODULE$.augmentString("^_DataSetTable_[0-9]+$")).r();
    }
}

