/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api;

import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.operators.join.JoinType;
import org.apache.flink.table.api.BatchTableEnvironment;
import org.apache.flink.table.api.GroupedTable;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.ValidationException$;
import org.apache.flink.table.api.Window;
import org.apache.flink.table.api.WindowedTable;
import org.apache.flink.table.calcite.FlinkRelBuilder;
import org.apache.flink.table.calcite.FlinkTypeFactory$;
import org.apache.flink.table.expressions.Alias;
import org.apache.flink.table.expressions.Alias$;
import org.apache.flink.table.expressions.Asc;
import org.apache.flink.table.expressions.Call;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ExpressionParser$;
import org.apache.flink.table.expressions.NamedExpression;
import org.apache.flink.table.expressions.Ordering;
import org.apache.flink.table.expressions.TableFunctionCall;
import org.apache.flink.table.expressions.UnresolvedAlias$;
import org.apache.flink.table.plan.ProjectionTranslator$;
import org.apache.flink.table.plan.logical.Aggregate;
import org.apache.flink.table.plan.logical.AliasNode;
import org.apache.flink.table.plan.logical.Distinct;
import org.apache.flink.table.plan.logical.Filter;
import org.apache.flink.table.plan.logical.Intersect;
import org.apache.flink.table.plan.logical.Join;
import org.apache.flink.table.plan.logical.Limit;
import org.apache.flink.table.plan.logical.Limit$;
import org.apache.flink.table.plan.logical.LogicalNode;
import org.apache.flink.table.plan.logical.Minus;
import org.apache.flink.table.plan.logical.Project;
import org.apache.flink.table.plan.logical.Sort;
import org.apache.flink.table.plan.logical.Union;
import org.apache.flink.table.sinks.TableSink;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\t5c\u0001B\u0001\u0003\u00015\u0011Q\u0001V1cY\u0016T!a\u0001\u0003\u0002\u0007\u0005\u0004\u0018N\u0003\u0002\u0006\r\u0005)A/\u00192mK*\u0011q\u0001C\u0001\u0006M2Lgn\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001q\u0001CA\b\u0013\u001b\u0005\u0001\"\"A\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0001\"AB!osJ+g\rC\u0005\u0016\u0001\t\u0015\r\u0011\"\u0001\u0007-\u0005AA/\u00192mK\u0016sg/F\u0001\u0018!\tA\u0012$D\u0001\u0003\u0013\tQ\"A\u0001\tUC\ndW-\u00128wSJ|g.\\3oi\"AA\u0004\u0001B\u0001B\u0003%q#A\u0005uC\ndW-\u00128wA!Ia\u0004\u0001BC\u0002\u0013\u0005aaH\u0001\fY><\u0017nY1m!2\fg.F\u0001!!\t\tc%D\u0001#\u0015\t\u0019C%A\u0004m_\u001eL7-\u00197\u000b\u0005\u0015\"\u0011\u0001\u00029mC:L!a\n\u0012\u0003\u00171{w-[2bY:{G-\u001a\u0005\tS\u0001\u0011\t\u0011)A\u0005A\u0005aAn\\4jG\u0006d\u0007\u000b\\1oA!)1\u0006\u0001C\u0001Y\u00051A(\u001b8jiz\"2!\f\u00180!\tA\u0002\u0001C\u0003\u0016U\u0001\u0007q\u0003C\u0003\u001fU\u0001\u0007\u0001\u0005C\u00032\u0001\u0011\u0005!'\u0001\u0006sK2\u0014U/\u001b7eKJ,\u0012a\r\t\u0003i]j\u0011!\u000e\u0006\u0003m\u0011\tqaY1mG&$X-\u0003\u00029k\tya\t\\5oWJ+GNQ;jY\u0012,'\u000fC\u0003;\u0001\u0011\u00051(\u0001\u0006hKR\u0014V\r\u001c(pI\u0016,\u0012\u0001\u0010\t\u0003{\u0005k\u0011A\u0010\u0006\u0003\u007f\u0001\u000b1A]3m\u0015\t1\u0004\"\u0003\u0002C}\t9!+\u001a7O_\u0012,\u0007\"\u0002#\u0001\t\u0003)\u0015AB:fY\u0016\u001cG\u000f\u0006\u0002.\r\")qi\u0011a\u0001\u0011\u00061a-[3mIN\u00042aD%L\u0013\tQ\u0005C\u0001\u0006=e\u0016\u0004X-\u0019;fIz\u0002\"\u0001T(\u000e\u00035S!A\u0014\u0003\u0002\u0017\u0015D\bO]3tg&|gn]\u0005\u0003!6\u0013!\"\u0012=qe\u0016\u001c8/[8o\u0011\u0015!\u0005\u0001\"\u0001S)\ti3\u000bC\u0003H#\u0002\u0007A\u000b\u0005\u0002V1:\u0011qBV\u0005\u0003/B\ta\u0001\u0015:fI\u00164\u0017BA-[\u0005\u0019\u0019FO]5oO*\u0011q\u000b\u0005\u0005\u00069\u0002!\t!X\u0001\u0003CN$\"!\f0\t\u000b\u001d[\u0006\u0019\u0001%\t\u000bq\u0003A\u0011\u00011\u0015\u00055\n\u0007\"B$`\u0001\u0004!\u0006\"B2\u0001\t\u0003!\u0017A\u00024jYR,'\u000f\u0006\u0002.K\")aM\u0019a\u0001\u0017\u0006I\u0001O]3eS\u000e\fG/\u001a\u0005\u0006G\u0002!\t\u0001\u001b\u000b\u0003[%DQAZ4A\u0002QCQa\u001b\u0001\u0005\u00021\fQa\u001e5fe\u0016$\"!L7\t\u000b\u0019T\u0007\u0019A&\t\u000b-\u0004A\u0011A8\u0015\u00055\u0002\b\"\u00024o\u0001\u0004!\u0006\"\u0002:\u0001\t\u0003\u0019\u0018aB4s_V\u0004()\u001f\u000b\u0003i^\u0004\"\u0001G;\n\u0005Y\u0014!\u0001D$s_V\u0004X\r\u001a+bE2,\u0007\"B$r\u0001\u0004A\u0005\"\u0002:\u0001\t\u0003IHC\u0001;{\u0011\u00159\u0005\u00101\u0001U\u0011\u0015a\b\u0001\"\u0001~\u0003!!\u0017n\u001d;j]\u000e$H#A\u0017\t\r}\u0004A\u0011AA\u0001\u0003\u0011Qw.\u001b8\u0015\u00075\n\u0019\u0001\u0003\u0004\u0002\u0006y\u0004\r!L\u0001\u0006e&<\u0007\u000e\u001e\u0005\u0007\u007f\u0002!\t!!\u0003\u0015\u000b5\nY!!\u0004\t\u000f\u0005\u0015\u0011q\u0001a\u0001[!9\u0011qBA\u0004\u0001\u0004!\u0016!\u00046pS:\u0004&/\u001a3jG\u0006$X\r\u0003\u0004\u0000\u0001\u0011\u0005\u00111\u0003\u000b\u0006[\u0005U\u0011q\u0003\u0005\b\u0003\u000b\t\t\u00021\u0001.\u0011\u001d\ty!!\u0005A\u0002-Cq!a\u0007\u0001\t\u0003\ti\"A\u0007mK\u001a$x*\u001e;fe*{\u0017N\u001c\u000b\u0006[\u0005}\u0011\u0011\u0005\u0005\b\u0003\u000b\tI\u00021\u0001.\u0011\u001d\ty!!\u0007A\u0002QCq!a\u0007\u0001\t\u0003\t)\u0003F\u0003.\u0003O\tI\u0003C\u0004\u0002\u0006\u0005\r\u0002\u0019A\u0017\t\u000f\u0005=\u00111\u0005a\u0001\u0017\"9\u0011Q\u0006\u0001\u0005\u0002\u0005=\u0012A\u0004:jO\"$x*\u001e;fe*{\u0017N\u001c\u000b\u0006[\u0005E\u00121\u0007\u0005\b\u0003\u000b\tY\u00031\u0001.\u0011\u001d\ty!a\u000bA\u0002QCq!!\f\u0001\t\u0003\t9\u0004F\u0003.\u0003s\tY\u0004C\u0004\u0002\u0006\u0005U\u0002\u0019A\u0017\t\u000f\u0005=\u0011Q\u0007a\u0001\u0017\"9\u0011q\b\u0001\u0005\u0002\u0005\u0005\u0013!\u00044vY2|U\u000f^3s\u0015>Lg\u000eF\u0003.\u0003\u0007\n)\u0005C\u0004\u0002\u0006\u0005u\u0002\u0019A\u0017\t\u000f\u0005=\u0011Q\ba\u0001)\"9\u0011q\b\u0001\u0005\u0002\u0005%C#B\u0017\u0002L\u00055\u0003bBA\u0003\u0003\u000f\u0002\r!\f\u0005\b\u0003\u001f\t9\u00051\u0001L\u0011\u0019y\b\u0001\"\u0003\u0002RQ9Q&a\u0015\u0002V\u0005]\u0003bBA\u0003\u0003\u001f\u0002\r!\f\u0005\b\u0003\u001f\ty\u00051\u0001U\u0011!\tI&a\u0014A\u0002\u0005m\u0013\u0001\u00036pS:$\u0016\u0010]3\u0011\t\u0005u\u00131N\u0007\u0003\u0003?R1a`A1\u0015\u0011\t\u0019'!\u001a\u0002\u0013=\u0004XM]1u_J\u001c(\u0002BA4\u0003S\nAA[1wC*\u00111AB\u0005\u0005\u0003[\nyF\u0001\u0005K_&tG+\u001f9f\u0011\u0019y\b\u0001\"\u0003\u0002rQ9Q&a\u001d\u0002v\u0005u\u0004bBA\u0003\u0003_\u0002\r!\f\u0005\t\u0003\u001f\ty\u00071\u0001\u0002xA!q\"!\u001fL\u0013\r\tY\b\u0005\u0002\u0007\u001fB$\u0018n\u001c8\t\u0011\u0005e\u0013q\u000ea\u0001\u00037Bq!!!\u0001\t\u0003\t\u0019)A\u0003nS:,8\u000fF\u0002.\u0003\u000bCq!!\u0002\u0002\u0000\u0001\u0007Q\u0006C\u0004\u0002\n\u0002!\t!a#\u0002\u00115Lg.^:BY2$2!LAG\u0011\u001d\t)!a\"A\u00025Bq!!%\u0001\t\u0003\t\u0019*A\u0003v]&|g\u000eF\u0002.\u0003+Cq!!\u0002\u0002\u0010\u0002\u0007Q\u0006C\u0004\u0002\u001a\u0002!\t!a'\u0002\u0011Ut\u0017n\u001c8BY2$2!LAO\u0011\u001d\t)!a&A\u00025Bq!!)\u0001\t\u0003\t\u0019+A\u0005j]R,'o]3diR\u0019Q&!*\t\u000f\u0005\u0015\u0011q\u0014a\u0001[!9\u0011\u0011\u0016\u0001\u0005\u0002\u0005-\u0016\u0001D5oi\u0016\u00148/Z2u\u00032dGcA\u0017\u0002.\"9\u0011QAAT\u0001\u0004i\u0003bBAY\u0001\u0011\u0005\u00111W\u0001\b_J$WM\u001d\"z)\ri\u0013Q\u0017\u0005\u0007\u000f\u0006=\u0006\u0019\u0001%\t\u000f\u0005E\u0006\u0001\"\u0001\u0002:R\u0019Q&a/\t\r\u001d\u000b9\f1\u0001U\u0011\u001d\ty\f\u0001C\u0001\u0003\u0003\fQ\u0001\\5nSR$2!LAb\u0011!\t)-!0A\u0002\u0005\u001d\u0017AB8gMN,G\u000fE\u0002\u0010\u0003\u0013L1!a3\u0011\u0005\rIe\u000e\u001e\u0005\b\u0003\u007f\u0003A\u0011AAh)\u0015i\u0013\u0011[Aj\u0011!\t)-!4A\u0002\u0005\u001d\u0007\u0002CAk\u0003\u001b\u0004\r!a2\u0002\u000b\u0019,Go\u00195\t\r}\u0004A\u0011AAm)\ri\u00131\u001c\u0005\b\u0003;\f9\u000e1\u0001L\u0003\u0011)H\r\u001e4\t\r}\u0004A\u0011AAq)\ri\u00131\u001d\u0005\b\u0003;\fy\u000e1\u0001U\u0011\u001d\tY\u0002\u0001C\u0001\u0003O$2!LAu\u0011\u001d\ti.!:A\u0002-Cq!a\u0007\u0001\t\u0003\ti\u000fF\u0002.\u0003_Dq!!8\u0002l\u0002\u0007A\u000bC\u0004\u0002t\u0002!I!!>\u0002!)|\u0017N\\+ei\u001aLe\u000e^3s]\u0006dG#B\u0017\u0002x\u0006m\bbBA}\u0003c\u0004\r\u0001V\u0001\u000bk\u0012$hm\u0015;sS:<\u0007\u0002CA-\u0003c\u0004\r!a\u0017\t\u000f\u0005M\b\u0001\"\u0003\u0002\u0000R)QF!\u0001\u0003\u0004!9\u0011Q\\A\u007f\u0001\u0004Y\u0005\u0002CA-\u0003{\u0004\r!a\u0017\t\u000f\t\u001d\u0001\u0001\"\u0001\u0003\n\u0005YqO]5uKR{7+\u001b8l+\u0011\u0011YAa\n\u0015\t\t5!1\u0003\t\u0004\u001f\t=\u0011b\u0001B\t!\t!QK\\5u\u0011!\u0011)B!\u0002A\u0002\t]\u0011\u0001B:j].\u0004bA!\u0007\u0003 \t\rRB\u0001B\u000e\u0015\r\u0011i\u0002B\u0001\u0006g&t7n]\u0005\u0005\u0005C\u0011YBA\u0005UC\ndWmU5oWB!!Q\u0005B\u0014\u0019\u0001!\u0001B!\u000b\u0003\u0006\t\u0007!1\u0006\u0002\u0002)F!!Q\u0006B\u001a!\ry!qF\u0005\u0004\u0005c\u0001\"a\u0002(pi\"Lgn\u001a\t\u0004\u001f\tU\u0012b\u0001B\u001c!\t\u0019\u0011I\\=\t\u000f\tm\u0002\u0001\"\u0001\u0003>\u00051q/\u001b8e_^$BAa\u0010\u0003FA\u0019\u0001D!\u0011\n\u0007\t\r#AA\u0007XS:$wn^3e)\u0006\u0014G.\u001a\u0005\t\u0005w\u0011I\u00041\u0001\u0003HA\u0019\u0001D!\u0013\n\u0007\t-#A\u0001\u0004XS:$wn\u001e")
public class Table {
    private final TableEnvironment tableEnv;
    private final LogicalNode logicalPlan;

    public TableEnvironment tableEnv() {
        return this.tableEnv;
    }

    public LogicalNode logicalPlan() {
        return this.logicalPlan;
    }

    public FlinkRelBuilder relBuilder() {
        return this.tableEnv().getRelBuilder();
    }

    public RelNode getRelNode() {
        return this.logicalPlan().toRelNode(this.relBuilder());
    }

    public Table select(Seq<Expression> fields) {
        Seq<Expression> expandedFields = ProjectionTranslator$.MODULE$.expandProjectList(fields, this.logicalPlan(), this.tableEnv());
        Tuple2<Map<Expression, String>, Map<Expression, String>> tuple2 = ProjectionTranslator$.MODULE$.extractAggregationsAndProperties(expandedFields, this.tableEnv());
        if (tuple2 != null) {
            Table table;
            Tuple2 tuple22;
            Map aggNames = (Map)tuple2._1();
            Map propNames = (Map)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)aggNames, (Object)propNames);
            Map aggNames2 = (Map)tuple23._1();
            Map propNames2 = (Map)tuple23._2();
            if (propNames2.nonEmpty()) {
                throw ValidationException$.MODULE$.apply("Window properties can only be used on windowed tables.");
            }
            if (aggNames2.nonEmpty()) {
                Seq<NamedExpression> projectsOnAgg = ProjectionTranslator$.MODULE$.replaceAggregationsAndProperties(expandedFields, this.tableEnv(), (Map<Expression, String>)aggNames2, (Map<Expression, String>)propNames2);
                Seq<NamedExpression> projectFields = ProjectionTranslator$.MODULE$.extractFieldReferences(expandedFields);
                table = new Table(this.tableEnv(), new Project(projectsOnAgg, new Aggregate((Seq<Expression>)Nil$.MODULE$, (Seq<NamedExpression>)((TraversableOnce)aggNames2.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Alias apply(Tuple2<Expression, String> a) {
                        return new Alias((Expression)a._1(), (String)a._2(), Alias$.MODULE$.apply$default$3());
                    }
                }, Iterable$.MODULE$.canBuildFrom())).toSeq(), new Project(projectFields, this.logicalPlan()).validate(this.tableEnv())).validate(this.tableEnv())).validate(this.tableEnv()));
            } else {
                table = new Table(this.tableEnv(), new Project((Seq<NamedExpression>)((Seq)expandedFields.map((Function1)UnresolvedAlias$.MODULE$, Seq$.MODULE$.canBuildFrom())), this.logicalPlan()).validate(this.tableEnv()));
            }
            return table;
        }
        throw new MatchError(tuple2);
    }

    public Table select(String fields) {
        List<Expression> fieldExprs = ExpressionParser$.MODULE$.parseExpressionList(fields);
        return this.select((Seq<Expression>)fieldExprs);
    }

    public Table as(Seq<Expression> fields) {
        return new Table(this.tableEnv(), new AliasNode(fields, this.logicalPlan()).validate(this.tableEnv()));
    }

    public Table as(String fields) {
        List<Expression> fieldExprs = ExpressionParser$.MODULE$.parseExpressionList(fields);
        return this.as((Seq<Expression>)fieldExprs);
    }

    public Table filter(Expression predicate) {
        return new Table(this.tableEnv(), new Filter(predicate, this.logicalPlan()).validate(this.tableEnv()));
    }

    public Table filter(String predicate) {
        Expression predicateExpr = ExpressionParser$.MODULE$.parseExpression(predicate);
        return this.filter(predicateExpr);
    }

    public Table where(Expression predicate) {
        return this.filter(predicate);
    }

    public Table where(String predicate) {
        return this.filter(predicate);
    }

    public GroupedTable groupBy(Seq<Expression> fields) {
        return new GroupedTable(this, fields);
    }

    public GroupedTable groupBy(String fields) {
        List<Expression> fieldsExpr = ExpressionParser$.MODULE$.parseExpressionList(fields);
        return this.groupBy((Seq<Expression>)fieldsExpr);
    }

    public Table distinct() {
        return new Table(this.tableEnv(), new Distinct(this.logicalPlan()).validate(this.tableEnv()));
    }

    public Table join(Table right) {
        return this.join(right, (Option<Expression>)None$.MODULE$, JoinType.INNER);
    }

    public Table join(Table right, String joinPredicate) {
        return this.join(right, joinPredicate, JoinType.INNER);
    }

    public Table join(Table right, Expression joinPredicate) {
        return this.join(right, (Option<Expression>)new Some((Object)joinPredicate), JoinType.INNER);
    }

    public Table leftOuterJoin(Table right, String joinPredicate) {
        return this.join(right, joinPredicate, JoinType.LEFT_OUTER);
    }

    public Table leftOuterJoin(Table right, Expression joinPredicate) {
        return this.join(right, (Option<Expression>)new Some((Object)joinPredicate), JoinType.LEFT_OUTER);
    }

    public Table rightOuterJoin(Table right, String joinPredicate) {
        return this.join(right, joinPredicate, JoinType.RIGHT_OUTER);
    }

    public Table rightOuterJoin(Table right, Expression joinPredicate) {
        return this.join(right, (Option<Expression>)new Some((Object)joinPredicate), JoinType.RIGHT_OUTER);
    }

    public Table fullOuterJoin(Table right, String joinPredicate) {
        return this.join(right, joinPredicate, JoinType.FULL_OUTER);
    }

    public Table fullOuterJoin(Table right, Expression joinPredicate) {
        return this.join(right, (Option<Expression>)new Some((Object)joinPredicate), JoinType.FULL_OUTER);
    }

    private Table join(Table right, String joinPredicate, JoinType joinType) {
        Expression joinPredicateExpr = ExpressionParser$.MODULE$.parseExpression(joinPredicate);
        return this.join(right, (Option<Expression>)new Some((Object)joinPredicateExpr), joinType);
    }

    private Table join(Table right, Option<Expression> joinPredicate, JoinType joinType) {
        TableEnvironment tableEnvironment = right.tableEnv();
        TableEnvironment tableEnvironment2 = this.tableEnv();
        if (!(tableEnvironment != null ? !tableEnvironment.equals(tableEnvironment2) : tableEnvironment2 != null)) {
            return new Table(this.tableEnv(), new Join(this.logicalPlan(), right.logicalPlan(), joinType, joinPredicate, false).validate(this.tableEnv()));
        }
        throw new ValidationException("Only tables from the same TableEnvironment can be joined.");
    }

    public Table minus(Table right) {
        TableEnvironment tableEnvironment = right.tableEnv();
        TableEnvironment tableEnvironment2 = this.tableEnv();
        if (!(tableEnvironment != null ? !tableEnvironment.equals(tableEnvironment2) : tableEnvironment2 != null)) {
            return new Table(this.tableEnv(), new Minus(this.logicalPlan(), right.logicalPlan(), false).validate(this.tableEnv()));
        }
        throw new ValidationException("Only tables from the same TableEnvironment can be subtracted.");
    }

    public Table minusAll(Table right) {
        TableEnvironment tableEnvironment = right.tableEnv();
        TableEnvironment tableEnvironment2 = this.tableEnv();
        if (!(tableEnvironment != null ? !tableEnvironment.equals(tableEnvironment2) : tableEnvironment2 != null)) {
            return new Table(this.tableEnv(), new Minus(this.logicalPlan(), right.logicalPlan(), true).validate(this.tableEnv()));
        }
        throw new ValidationException("Only tables from the same TableEnvironment can be subtracted.");
    }

    public Table union(Table right) {
        TableEnvironment tableEnvironment = right.tableEnv();
        TableEnvironment tableEnvironment2 = this.tableEnv();
        if (!(tableEnvironment != null ? !tableEnvironment.equals(tableEnvironment2) : tableEnvironment2 != null)) {
            return new Table(this.tableEnv(), new Union(this.logicalPlan(), right.logicalPlan(), false).validate(this.tableEnv()));
        }
        throw new ValidationException("Only tables from the same TableEnvironment can be unioned.");
    }

    public Table unionAll(Table right) {
        TableEnvironment tableEnvironment = right.tableEnv();
        TableEnvironment tableEnvironment2 = this.tableEnv();
        if (!(tableEnvironment != null ? !tableEnvironment.equals(tableEnvironment2) : tableEnvironment2 != null)) {
            return new Table(this.tableEnv(), new Union(this.logicalPlan(), right.logicalPlan(), true).validate(this.tableEnv()));
        }
        throw new ValidationException("Only tables from the same TableEnvironment can be unioned.");
    }

    public Table intersect(Table right) {
        TableEnvironment tableEnvironment = right.tableEnv();
        TableEnvironment tableEnvironment2 = this.tableEnv();
        if (!(tableEnvironment != null ? !tableEnvironment.equals(tableEnvironment2) : tableEnvironment2 != null)) {
            return new Table(this.tableEnv(), new Intersect(this.logicalPlan(), right.logicalPlan(), false).validate(this.tableEnv()));
        }
        throw new ValidationException("Only tables from the same TableEnvironment can be intersected.");
    }

    public Table intersectAll(Table right) {
        TableEnvironment tableEnvironment = right.tableEnv();
        TableEnvironment tableEnvironment2 = this.tableEnv();
        if (!(tableEnvironment != null ? !tableEnvironment.equals(tableEnvironment2) : tableEnvironment2 != null)) {
            return new Table(this.tableEnv(), new Intersect(this.logicalPlan(), right.logicalPlan(), true).validate(this.tableEnv()));
        }
        throw new ValidationException("Only tables from the same TableEnvironment can be intersected.");
    }

    public Table orderBy(Seq<Expression> fields) {
        Seq order = (Seq)fields.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Ordering apply(Expression x0$1) {
                Ordering ordering;
                Expression expression2 = x0$1;
                Ordering ordering2 = expression2 instanceof Ordering ? (ordering = (Ordering)expression2) : new Asc(expression2);
                return ordering2;
            }
        }, Seq$.MODULE$.canBuildFrom());
        return new Table(this.tableEnv(), new Sort((Seq<Ordering>)order, this.logicalPlan()).validate(this.tableEnv()));
    }

    public Table orderBy(String fields) {
        List<Expression> parsedFields = ExpressionParser$.MODULE$.parseExpressionList(fields);
        return this.orderBy((Seq<Expression>)parsedFields);
    }

    public Table limit(int offset) {
        int x$5 = offset;
        LogicalNode x$6 = this.logicalPlan();
        int x$7 = Limit$.MODULE$.apply$default$2();
        return new Table(this.tableEnv(), new Limit(x$5, x$7, x$6).validate(this.tableEnv()));
    }

    public Table limit(int offset, int fetch) {
        return new Table(this.tableEnv(), new Limit(offset, fetch, this.logicalPlan()).validate(this.tableEnv()));
    }

    public Table join(Expression udtf) {
        return this.joinUdtfInternal(udtf, JoinType.INNER);
    }

    public Table join(String udtf) {
        return this.joinUdtfInternal(udtf, JoinType.INNER);
    }

    public Table leftOuterJoin(Expression udtf) {
        return this.joinUdtfInternal(udtf, JoinType.LEFT_OUTER);
    }

    public Table leftOuterJoin(String udtf) {
        return this.joinUdtfInternal(udtf, JoinType.LEFT_OUTER);
    }

    private Table joinUdtfInternal(String udtfString, JoinType joinType) {
        Expression udtf = ExpressionParser$.MODULE$.parseExpression(udtfString);
        return this.joinUdtfInternal(udtf, joinType);
    }

    private Table joinUdtfInternal(Expression udtf, JoinType joinType) {
        ObjectRef alias2 = new ObjectRef((Object)None$.MODULE$);
        LogicalNode call = this.unwrap$1(udtf, alias2).as((Option<Seq<String>>)((Option)alias2.elem)).toLogicalTableFunctionCall(this.logicalPlan()).validate(this.tableEnv());
        return new Table(this.tableEnv(), new Join(this.logicalPlan(), call, joinType, (Option<Expression>)None$.MODULE$, true).validate(this.tableEnv()));
    }

    public <T> void writeToSink(TableSink<T> sink) {
        RelDataType rowType = this.getRelNode().getRowType();
        String[] fieldNames = (String[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(rowType.getFieldNames()).asScala()).toArray(ClassTag$.MODULE$.apply(String.class));
        TypeInformation[] fieldTypes = (TypeInformation[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(rowType.getFieldList()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final TypeInformation<?> apply(RelDataTypeField field) {
                return FlinkTypeFactory$.MODULE$.toTypeInfo(field.getType());
            }
        }, Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(TypeInformation.class));
        TableSink<T> configuredSink = sink.configure(fieldNames, fieldTypes);
        this.tableEnv().writeToSink(this, configuredSink);
    }

    public WindowedTable window(Window window) {
        if (this.tableEnv() instanceof BatchTableEnvironment) {
            throw new ValidationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Windows on batch tables are currently not supported."})).s((Seq)Nil$.MODULE$));
        }
        if (window.alias().isEmpty()) {
            throw new ValidationException("An alias must be specified for the window.");
        }
        return new WindowedTable(this, window);
    }

    private final TableFunctionCall unwrap$1(Expression expr, ObjectRef alias$1) {
        Expression expression2;
        while (true) {
            Expression function;
            if ((expression2 = expr) instanceof Alias) {
                Alias alias2 = (Alias)expression2;
                Expression child = alias2.child();
                String name = alias2.name();
                Seq<String> extraNames = alias2.extraNames();
                alias$1.elem = new Some(((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{name}))).$plus$plus(extraNames, Seq$.MODULE$.canBuildFrom()));
                expr = child;
                continue;
            }
            if (!(expression2 instanceof Call)) break;
            Call call = (Call)expression2;
            String name = call.functionName();
            Seq<Expression> args = call.args();
            expr = function = this.tableEnv().getFunctionCatalog().lookupFunction(name, args);
        }
        if (expression2 instanceof TableFunctionCall) {
            TableFunctionCall tableFunctionCall;
            TableFunctionCall tableFunctionCall2 = tableFunctionCall = (TableFunctionCall)expression2;
            return tableFunctionCall2;
        }
        throw new TableException("Cross/Outer Apply operators only accept expressions that define table functions.");
    }

    public Table(TableEnvironment tableEnv, LogicalNode logicalPlan) {
        this.tableEnv = tableEnv;
        this.logicalPlan = logicalPlan;
    }
}

