/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.functions.utils;

import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlOperandTypeInference;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.calcite.FlinkTypeFactory;
import org.apache.flink.table.calcite.FlinkTypeFactory$;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.functions.utils.ScalarSqlFunction$;
import org.apache.flink.table.functions.utils.UserDefinedFunctionUtils$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;

public final class ScalarSqlFunction$ {
    public static final ScalarSqlFunction$ MODULE$;

    static {
        new ScalarSqlFunction$();
    }

    public SqlReturnTypeInference createReturnTypeInference(String name, ScalarFunction scalarFunction, FlinkTypeFactory typeFactory) {
        return new SqlReturnTypeInference(name, scalarFunction, typeFactory){
            private final String name$1;
            private final ScalarFunction scalarFunction$1;
            private final FlinkTypeFactory typeFactory$1;

            public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
                Buffer parameters = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(opBinding.collectOperandTypes()).asScala()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final TypeInformation<?> apply(RelDataType operandType) {
                        SqlTypeName sqlTypeName = operandType.getSqlTypeName();
                        SqlTypeName sqlTypeName2 = SqlTypeName.NULL;
                        return !(sqlTypeName != null ? !((Object)((Object)sqlTypeName)).equals((Object)((Object)sqlTypeName2)) : sqlTypeName2 != null) ? null : FlinkTypeFactory$.MODULE$.toTypeInfo(operandType);
                    }
                }, Buffer$.MODULE$.canBuildFrom());
                Option<Class<?>[]> foundSignature = UserDefinedFunctionUtils$.MODULE$.getSignature(this.scalarFunction$1, (Seq<TypeInformation<?>>)parameters);
                if (foundSignature.isEmpty()) {
                    throw new ValidationException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Given parameters of function '", "' do not match any signature. \\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name$1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Actual: ", " \\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{UserDefinedFunctionUtils$.MODULE$.signatureToString((Seq<TypeInformation<?>>)parameters)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{UserDefinedFunctionUtils$.MODULE$.signaturesToString(this.scalarFunction$1)}))).toString());
                }
                TypeInformation<?> resultType = UserDefinedFunctionUtils$.MODULE$.getResultType(this.scalarFunction$1, (Class[])foundSignature.get());
                return this.typeFactory$1.createTypeFromTypeInfo(resultType);
            }
            {
                this.name$1 = name$1;
                this.scalarFunction$1 = scalarFunction$1;
                this.typeFactory$1 = typeFactory$1;
            }
        };
    }

    public SqlOperandTypeInference createOperandTypeInference(ScalarFunction scalarFunction, FlinkTypeFactory typeFactory) {
        return new SqlOperandTypeInference(scalarFunction, typeFactory){
            private final ScalarFunction scalarFunction$2;
            public final FlinkTypeFactory typeFactory$2;

            public void inferOperandTypes(SqlCallBinding callBinding, RelDataType returnType, RelDataType[] operandTypes) {
                Seq<TypeInformation<?>> operandTypeInfo = ScalarSqlFunction$.MODULE$.getOperandTypeInfo(callBinding);
                Class[] foundSignature = (Class[])UserDefinedFunctionUtils$.MODULE$.getSignature(this.scalarFunction$2, operandTypeInfo).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Nothing$ apply() {
                        throw new ValidationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Operand types of could not be inferred."})).s((Seq)Nil$.MODULE$));
                    }
                });
                RelDataType[] inferredTypes = (RelDataType[])Predef$.MODULE$.refArrayOps((Object[])this.scalarFunction$2.getParameterTypes(foundSignature)).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.2 $outer;

                    public final RelDataType apply(TypeInformation<?> typeInfo) {
                        return this.$outer.typeFactory$2.createTypeFromTypeInfo(typeInfo);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(RelDataType.class)));
                Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])inferredTypes).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(this, operandTypes){
                    public static final long serialVersionUID = 0L;
                    private final RelDataType[] operandTypes$1;

                    public final void apply(Tuple2<RelDataType, Object> x0$1) {
                        Tuple2<RelDataType, Object> tuple2 = x0$1;
                        if (tuple2 != null) {
                            RelDataType inferredType = (RelDataType)tuple2._1();
                            int i = tuple2._2$mcI$sp();
                            this.operandTypes$1[i] = inferredType;
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.operandTypes$1 = operandTypes$1;
                    }
                });
            }
            {
                this.scalarFunction$2 = scalarFunction$2;
                this.typeFactory$2 = typeFactory$2;
            }
        };
    }

    public SqlOperandTypeChecker createOperandTypeChecker(String name, ScalarFunction scalarFunction) {
        Class[][] signatures = UserDefinedFunctionUtils$.MODULE$.getSignatures(scalarFunction);
        return new SqlOperandTypeChecker(name, scalarFunction, signatures){
            private final String name$2;
            private final ScalarFunction scalarFunction$3;
            private final Class[][] signatures$1;

            public String getAllowedSignatures(SqlOperator op, String opName) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "[", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{opName, UserDefinedFunctionUtils$.MODULE$.signaturesToString(this.scalarFunction$3)}));
            }

            public SqlOperandCountRange getOperandCountRange() {
                int[] signatureLengths = (int[])Predef$.MODULE$.refArrayOps((Object[])this.signatures$1).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(Class<?>[] x$1) {
                        return x$1.length;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
                return SqlOperandCountRanges.between(BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.intArrayOps(signatureLengths).min((Ordering)Ordering.Int$.MODULE$)), BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.intArrayOps(signatureLengths).max((Ordering)Ordering.Int$.MODULE$)));
            }

            public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
                boolean bl;
                Seq<TypeInformation<?>> operandTypeInfo = ScalarSqlFunction$.MODULE$.getOperandTypeInfo(callBinding);
                Option<Class<?>[]> foundSignature = UserDefinedFunctionUtils$.MODULE$.getSignature(this.scalarFunction$3, operandTypeInfo);
                if (foundSignature.isEmpty()) {
                    if (throwOnFailure) {
                        throw new ValidationException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Given parameters of function '", "' do not match any signature. \\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name$2}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Actual: ", " \\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{UserDefinedFunctionUtils$.MODULE$.signatureToString(operandTypeInfo)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{UserDefinedFunctionUtils$.MODULE$.signaturesToString(this.scalarFunction$3)}))).toString());
                    }
                    bl = false;
                } else {
                    bl = true;
                }
                return bl;
            }

            public boolean isOptional(int i) {
                return false;
            }

            public SqlOperandTypeChecker.Consistency getConsistency() {
                return SqlOperandTypeChecker.Consistency.NONE;
            }
            {
                this.name$2 = name$2;
                this.scalarFunction$3 = scalarFunction$3;
                this.signatures$1 = signatures$1;
            }
        };
    }

    public Seq<TypeInformation<?>> getOperandTypeInfo(SqlCallBinding callBinding) {
        IndexedSeq operandTypes = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), callBinding.getOperandCount()).map((Function1)new Serializable(callBinding){
            public static final long serialVersionUID = 0L;
            private final SqlCallBinding callBinding$1;

            public final RelDataType apply(int i) {
                return this.callBinding$1.getOperandType(i);
            }
            {
                this.callBinding$1 = callBinding$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        return (Seq)operandTypes.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final TypeInformation<?> apply(RelDataType operandType) {
                SqlTypeName sqlTypeName = operandType.getSqlTypeName();
                SqlTypeName sqlTypeName2 = SqlTypeName.NULL;
                return !(sqlTypeName != null ? !((Object)((Object)sqlTypeName)).equals((Object)((Object)sqlTypeName2)) : sqlTypeName2 != null) ? null : FlinkTypeFactory$.MODULE$.toTypeInfo(operandType);
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
    }

    private ScalarSqlFunction$() {
        MODULE$ = this;
    }
}

