/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.functions.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.apache.calcite.sql.SqlFunction;
import org.apache.flink.api.common.functions.InvalidTypesException;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.shaded.calcite.com.google.common.primitives.Primitives;
import org.apache.flink.table.api.TableEnvironment$;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.ValidationException$;
import org.apache.flink.table.calcite.FlinkTypeFactory;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.functions.utils.ScalarSqlFunction;
import org.apache.flink.table.functions.utils.TableSqlFunction;
import org.apache.flink.table.functions.utils.TableSqlFunction$;
import org.apache.flink.table.functions.utils.UserDefinedFunctionUtils$;
import org.apache.flink.table.plan.schema.FlinkTableFunctionImpl;
import org.apache.flink.util.InstantiationUtil;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

public final class UserDefinedFunctionUtils$ {
    public static final UserDefinedFunctionUtils$ MODULE$;

    static {
        new UserDefinedFunctionUtils$();
    }

    public <T extends UserDefinedFunction> T instantiate(Class<T> clazz) {
        Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
        constructor.setAccessible(true);
        return (T)((UserDefinedFunction)constructor.newInstance(new Object[0]));
    }

    public void checkForInstantiation(Class<?> clazz) {
        if (InstantiationUtil.isPublic(clazz)) {
            if (InstantiationUtil.isProperClass(clazz)) {
                if (InstantiationUtil.isNonStaticInnerClass(clazz)) {
                    throw ValidationException$.MODULE$.apply("The class is an inner class, but not statically accessible.");
                }
                Predef$.MODULE$.refArrayOps((Object[])clazz.getDeclaredConstructors()).find((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Constructor<?> x$1) {
                        return Predef$.MODULE$.refArrayOps((Object[])x$1.getParameterTypes()).isEmpty();
                    }
                }).getOrElse((Function0)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Nothing$ apply() {
                        throw ValidationException$.MODULE$.apply("Function class needs a default constructor.");
                    }
                });
                return;
            }
            throw ValidationException$.MODULE$.apply("Function class is no proper class, it is either abstract, an interface, or a primitive type.");
        }
        throw ValidationException$.MODULE$.apply("Function class is not public.");
    }

    public void checkNotSingleton(Class<?> clazz) {
        if (Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])clazz.getFields()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Field x$2) {
                return x$2.getName();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).contains((Object)"MODULE$")) {
            throw new ValidationException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TableFunction implemented by class ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{clazz.getCanonicalName()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"is a Scala object, it is forbidden since concurrent risks."})).s((Seq)Nil$.MODULE$)).toString());
        }
    }

    public Option<Class<?>[]> getSignature(UserDefinedFunction function, Seq<TypeInformation<?>> signature) {
        Class[] actualSignature = this.typeInfoToClass(signature);
        Class<?>[][] signatures = this.getSignatures(function);
        return Predef$.MODULE$.refArrayOps((Object[])signatures).find((Function1)new Serializable(actualSignature){
            public static final long serialVersionUID = 0L;
            public final Class[] actualSignature$1;

            public final boolean apply(Class<?>[] curSig) {
                return this.actualSignature$1.length == curSig.length && Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])curSig).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.getSignature.1 $outer;

                    public final boolean apply(Tuple2<Class<?>, Object> x0$1) {
                        Tuple2<Class<?>, Object> tuple2 = x0$1;
                        if (tuple2 != null) {
                            Class clazz = (Class)tuple2._1();
                            int i = tuple2._2$mcI$sp();
                            boolean bl = UserDefinedFunctionUtils$.MODULE$.org$apache$flink$table$functions$utils$UserDefinedFunctionUtils$$parameterTypeEquals(this.$outer.actualSignature$1[i], clazz);
                            return bl;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.actualSignature$1 = actualSignature$1;
            }
        });
    }

    public Option<Method> getEvalMethod(UserDefinedFunction function, Seq<TypeInformation<?>> signature) {
        Class[] actualSignature = this.typeInfoToClass(signature);
        Method[] evalMethods = this.checkAndExtractEvalMethods(function);
        return Predef$.MODULE$.refArrayOps((Object[])evalMethods).find((Function1)new Serializable(actualSignature){
            public static final long serialVersionUID = 0L;
            public final Class[] actualSignature$2;

            public final boolean apply(Method cur) {
                Class<?>[] signatures = cur.getParameterTypes();
                return this.actualSignature$2.length == signatures.length && Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])signatures).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.getEvalMethod.1 $outer;

                    public final boolean apply(Tuple2<Class<?>, Object> x0$2) {
                        Tuple2<Class<?>, Object> tuple2 = x0$2;
                        if (tuple2 != null) {
                            Class clazz = (Class)tuple2._1();
                            int i = tuple2._2$mcI$sp();
                            boolean bl = UserDefinedFunctionUtils$.MODULE$.org$apache$flink$table$functions$utils$UserDefinedFunctionUtils$$parameterTypeEquals(this.$outer.actualSignature$2[i], clazz);
                            return bl;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.actualSignature$2 = actualSignature$2;
            }
        });
    }

    public Method[] checkAndExtractEvalMethods(UserDefinedFunction function) {
        Method[] methods = (Method[])Predef$.MODULE$.refArrayOps((Object[])function.getClass().getDeclaredMethods()).filter((Function1)new Serializable(function){
            public static final long serialVersionUID = 0L;
            private final UserDefinedFunction function$1;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean apply(Method m) {
                int modifiers = m.getModifiers();
                String string = m.getName();
                String string2 = "eval";
                if (string == null) {
                    if (string2 != null) {
                        return false;
                    }
                } else if (!string.equals(string2)) return false;
                if (!Modifier.isPublic(modifiers)) return false;
                if (Modifier.isAbstract(modifiers)) return false;
                if (!(this.function$1 instanceof TableFunction)) return true;
                if (Modifier.isStatic(modifiers)) return false;
                return true;
            }
            {
                this.function$1 = function$1;
            }
        });
        if (Predef$.MODULE$.refArrayOps((Object[])methods).isEmpty()) {
            throw new ValidationException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Function class '", "' does not implement at least "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{function.getClass().getCanonicalName()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"one method named 'eval' which is public, not abstract and "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(in case of table functions) not static."})).s((Seq)Nil$.MODULE$)).toString());
        }
        return methods;
    }

    public Class<?>[][] getSignatures(UserDefinedFunction function) {
        return (Class[][])Predef$.MODULE$.refArrayOps((Object[])this.checkAndExtractEvalMethods(function)).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Class<?>[] apply(Method x$3) {
                return x$3.getParameterTypes();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Class.class))));
    }

    public SqlFunction createScalarSqlFunction(String name, ScalarFunction function, FlinkTypeFactory typeFactory) {
        return new ScalarSqlFunction(name, function, typeFactory);
    }

    public Seq<SqlFunction> createTableSqlFunctions(String name, TableFunction<?> tableFunction, TypeInformation<?> resultType, FlinkTypeFactory typeFactory) {
        Tuple3<String[], int[], TypeInformation<?>[]> tuple3 = this.getFieldInfo(resultType);
        if (tuple3 != null) {
            Tuple2 tuple2;
            String[] fieldNames = (String[])tuple3._1();
            int[] fieldIndexes = (int[])tuple3._2();
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)fieldNames, (Object)fieldIndexes);
            String[] fieldNames2 = (String[])tuple22._1();
            int[] fieldIndexes2 = (int[])tuple22._2();
            Method[] evalMethods = this.checkAndExtractEvalMethods(tableFunction);
            return (Seq)Predef$.MODULE$.refArrayOps((Object[])evalMethods).map((Function1)new Serializable(name, tableFunction, resultType, typeFactory, fieldNames2, fieldIndexes2){
                public static final long serialVersionUID = 0L;
                private final String name$1;
                private final TableFunction tableFunction$1;
                private final TypeInformation resultType$1;
                private final FlinkTypeFactory typeFactory$1;
                private final String[] fieldNames$1;
                private final int[] fieldIndexes$1;

                public final TableSqlFunction apply(Method method) {
                    FlinkTableFunctionImpl<T> function = new FlinkTableFunctionImpl<T>(this.resultType$1, this.fieldIndexes$1, this.fieldNames$1, method);
                    return TableSqlFunction$.MODULE$.apply(this.name$1, this.tableFunction$1, this.resultType$1, this.typeFactory$1, function);
                }
                {
                    this.name$1 = name$1;
                    this.tableFunction$1 = tableFunction$1;
                    this.resultType$1 = resultType$1;
                    this.typeFactory$1 = typeFactory$1;
                    this.fieldNames$1 = fieldNames$1;
                    this.fieldIndexes$1 = fieldIndexes$1;
                }
            }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
        }
        throw new MatchError(tuple3);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TypeInformation<?> getResultType(ScalarFunction function, Class<?>[] signature) {
        TypeInformation typeInformation;
        Method evalMethod = (Method)Predef$.MODULE$.refArrayOps((Object[])this.checkAndExtractEvalMethods(function)).find((Function1)new Serializable(signature){
            public static final long serialVersionUID = 0L;
            private final Class[] signature$2;

            public final boolean apply(Method m) {
                return Predef$.MODULE$.refArrayOps((Object[])this.signature$2).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])m.getParameterTypes()));
            }
            {
                this.signature$2 = signature$2;
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new ValidationException("Given signature is invalid.");
            }
        });
        TypeInformation userDefinedTypeInfo = function.getResultType(signature);
        if (userDefinedTypeInfo != null) {
            typeInformation = userDefinedTypeInfo;
            return typeInformation;
        }
        try {
            typeInformation = TypeExtractor.getForClass(evalMethod.getReturnType());
            return typeInformation;
        }
        catch (InvalidTypesException invalidTypesException) {
            throw new ValidationException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Return type of scalar function '", "' cannot be "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{function.getClass().getCanonicalName()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"automatically determined. Please provide type information manually."})).s((Seq)Nil$.MODULE$)).toString());
        }
    }

    public Class<?> getResultTypeClass(ScalarFunction function, Class<?>[] signature) {
        Method evalMethod = (Method)Predef$.MODULE$.refArrayOps((Object[])this.checkAndExtractEvalMethods(function)).find((Function1)new Serializable(signature){
            public static final long serialVersionUID = 0L;
            private final Class[] signature$1;

            public final boolean apply(Method m) {
                return Predef$.MODULE$.refArrayOps((Object[])this.signature$1).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])m.getParameterTypes()));
            }
            {
                this.signature$1 = signature$1;
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new IllegalArgumentException("Given signature is invalid.");
            }
        });
        return evalMethod.getReturnType();
    }

    public Tuple3<String[], int[], TypeInformation<?>[]> getFieldInfo(TypeInformation<?> inputType) {
        return new Tuple3((Object)TableEnvironment$.MODULE$.getFieldNames(inputType), (Object)TableEnvironment$.MODULE$.getFieldIndices(inputType), TableEnvironment$.MODULE$.getFieldTypes(inputType));
    }

    public String signatureToString(Class<?>[] signature) {
        return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])signature).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Class<?> clazz) {
                return clazz == null ? "null" : clazz.getCanonicalName();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString("(", ", ", ")");
    }

    public String signatureToString(Seq<TypeInformation<?>> signature) {
        return this.signatureToString(this.typeInfoToClass(signature));
    }

    public String signaturesToString(UserDefinedFunction function) {
        return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.getSignatures(function)).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Class<?>[] signature) {
                return UserDefinedFunctionUtils$.MODULE$.signatureToString(signature);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString(", ");
    }

    private Class<?>[] typeInfoToClass(Seq<TypeInformation<?>> typeInfos) {
        return (Class[])((TraversableOnce)typeInfos.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Class<?> apply(TypeInformation<?> typeInfo) {
                return typeInfo == null ? null : typeInfo.getTypeClass();
            }
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Class.class));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean org$apache$flink$table$functions$utils$UserDefinedFunctionUtils$$parameterTypeEquals(Class<?> candidate, Class<?> expected) {
        if (candidate == null) return true;
        Class<?> clazz = candidate;
        Class<?> clazz2 = expected;
        if (clazz == null) {
            if (clazz2 == null) return true;
        } else if (clazz.equals(clazz2)) return true;
        if (expected.isPrimitive()) {
            Class<?> clazz3 = Primitives.wrap(expected);
            Class<?> clazz4 = candidate;
            if (clazz3 == null) {
                if (clazz4 == null) return true;
            } else if (clazz3.equals(clazz4)) return true;
        }
        Class<?> clazz5 = candidate;
        Class<Date> clazz6 = Date.class;
        if (!(clazz5 != null ? !clazz5.equals(clazz6) : clazz6 != null)) {
            Class<?> clazz7 = expected;
            Class<Integer> clazz8 = Integer.TYPE;
            if (clazz7 == null) {
                if (clazz8 == null) return true;
            } else if (clazz7.equals(clazz8)) return true;
        }
        Class<?> clazz9 = candidate;
        Class<Time> clazz10 = Time.class;
        if (!(clazz9 != null ? !clazz9.equals(clazz10) : clazz10 != null)) {
            Class<?> clazz11 = expected;
            Class<Integer> clazz12 = Integer.TYPE;
            if (clazz11 == null) {
                if (clazz12 == null) return true;
            } else if (clazz11.equals(clazz12)) return true;
        }
        Class<?> clazz13 = candidate;
        Class<Timestamp> clazz14 = Timestamp.class;
        if (clazz13 == null) {
            if (clazz14 != null) {
                return false;
            }
        } else if (!clazz13.equals(clazz14)) return false;
        Class<?> clazz15 = expected;
        Class<Long> clazz16 = Long.TYPE;
        if (clazz15 == null) {
            if (clazz16 == null) return true;
            return false;
        } else {
            if (!clazz15.equals(clazz16)) return false;
            return true;
        }
    }

    private UserDefinedFunctionUtils$() {
        MODULE$ = this;
    }
}

