/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan.nodes.dataset;

import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.operators.Order;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.operators.MapPartitionOperator;
import org.apache.flink.api.java.operators.SingleInputUdfOperator;
import org.apache.flink.table.api.BatchTableEnvironment;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableException$;
import org.apache.flink.table.plan.nodes.FlinkRel$class;
import org.apache.flink.table.plan.nodes.dataset.DataSetRel;
import org.apache.flink.table.plan.nodes.dataset.DataSetRel$class;
import org.apache.flink.table.plan.nodes.dataset.DataSetSort$;
import org.apache.flink.table.runtime.CountPartitionFunction;
import org.apache.flink.table.runtime.LimitFilterFunction;
import org.apache.flink.table.typeutils.TypeConverter$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichDouble;

@ScalaSignature(bytes="\u0006\u0001\t\ra\u0001B\u0001\u0003\u0001E\u00111\u0002R1uCN+GoU8si*\u00111\u0001B\u0001\bI\u0006$\u0018m]3u\u0015\t)a!A\u0003o_\u0012,7O\u0003\u0002\b\u0011\u0005!\u0001\u000f\\1o\u0015\tI!\"A\u0003uC\ndWM\u0003\u0002\f\u0019\u0005)a\r\\5oW*\u0011QBD\u0001\u0007CB\f7\r[3\u000b\u0003=\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\n\u001b!\t\u0019\u0002$D\u0001\u0015\u0015\t)b#A\u0002sK2T!a\u0006\u0007\u0002\u000f\r\fGnY5uK&\u0011\u0011\u0004\u0006\u0002\n'&tw\r\\3SK2\u0004\"a\u0007\u000f\u000e\u0003\tI!!\b\u0002\u0003\u0015\u0011\u000bG/Y*fiJ+G\u000e\u0003\u0005 \u0001\t\u0005\t\u0015!\u0003!\u0003\u001d\u0019G.^:uKJ\u0004\"!I\u0012\u000e\u0003\tR!a\u0002\f\n\u0005\u0011\u0012#!\u0004*fY>\u0003Ho\u00117vgR,'\u000f\u0003\u0005'\u0001\t\u0005\t\u0015!\u0003(\u0003!!(/Y5u'\u0016$\bCA\u0011)\u0013\tI#EA\u0006SK2$&/Y5u'\u0016$\b\u0002C\u0016\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0017\u0002\u0007%t\u0007\u000f\u0005\u0002\u0014[%\u0011a\u0006\u0006\u0002\b%\u0016dgj\u001c3f\u0011!\u0001\u0004A!A!\u0002\u0013\t\u0014AC2pY2\fG/[8ogB\u00111CM\u0005\u0003gQ\u0011ABU3m\u0007>dG.\u0019;j_:D\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IAN\u0001\u000fe><(+\u001a7ECR\fG+\u001f9f!\t9$(D\u00019\u0015\tID#\u0001\u0003usB,\u0017BA\u001e9\u0005-\u0011V\r\u001c#bi\u0006$\u0016\u0010]3\t\u0011u\u0002!\u0011!Q\u0001\ny\naa\u001c4gg\u0016$\bCA C\u001b\u0005\u0001%BA!\u0017\u0003\r\u0011X\r_\u0005\u0003\u0007\u0002\u0013qAU3y\u001d>$W\r\u0003\u0005F\u0001\t\u0005\t\u0015!\u0003?\u0003\u00151W\r^2i\u0011\u00159\u0005\u0001\"\u0001I\u0003\u0019a\u0014N\\5u}QA\u0011JS&M\u001b:{\u0005\u000b\u0005\u0002\u001c\u0001!)qD\u0012a\u0001A!)aE\u0012a\u0001O!)1F\u0012a\u0001Y!)\u0001G\u0012a\u0001c!)QG\u0012a\u0001m!)QH\u0012a\u0001}!)QI\u0012a\u0001}!9!\u000b\u0001b\u0001\n\u0013\u0019\u0016A\u00037j[&$8\u000b^1siV\tA\u000b\u0005\u0002V16\taKC\u0001X\u0003\u0015\u00198-\u00197b\u0013\tIfK\u0001\u0003M_:<\u0007BB.\u0001A\u0003%A+A\u0006mS6LGo\u0015;beR\u0004\u0003bB/\u0001\u0005\u0004%IaU\u0001\tY&l\u0017\u000e^#oI\"1q\f\u0001Q\u0001\nQ\u000b\u0011\u0002\\5nSR,e\u000e\u001a\u0011\t\u000b\u0005\u0004A\u0011\t2\u0002\u001b\u0011,'/\u001b<f%><H+\u001f9f)\u00051\u0004\"\u00023\u0001\t\u0003*\u0017\u0001B2paf$2\u0001\f4h\u0011\u001513\r1\u0001(\u0011\u0015A7\r1\u0001j\u0003\u0019Ig\u000e];ugB\u0019!n\u001c\u0017\u000e\u0003-T!\u0001\\7\u0002\tU$\u0018\u000e\u001c\u0006\u0002]\u0006!!.\u0019<b\u0013\t\u00018N\u0001\u0003MSN$\b\"\u0002:\u0001\t\u0003\u001a\u0018\u0001E3ti&l\u0017\r^3S_^\u001cu.\u001e8u)\t!x\u000f\u0005\u0002Vk&\u0011aO\u0016\u0002\u0007\t>,(\r\\3\t\u000ba\f\b\u0019A=\u0002\u00115,G/\u00193bi\u0006\u0004\"A\u001f?\u000e\u0003mT!\u0001\u001f\u000b\n\u0005u\\(\u0001\u0005*fY6+G/\u00193bi\u0006\fV/\u001a:z\u0011\u0019y\b\u0001\"\u0011\u0002\u0002\u0005yAO]1og2\fG/\u001a+p!2\fg\u000e\u0006\u0004\u0002\u0004\u0005]\u0011Q\u0005\t\u0007\u0003\u000b\ti!!\u0005\u000e\u0005\u0005\u001d!b\u00018\u0002\n)\u0019\u00111\u0002\u0006\u0002\u0007\u0005\u0004\u0018.\u0003\u0003\u0002\u0010\u0005\u001d!a\u0002#bi\u0006\u001cV\r\u001e\t\u0004+\u0006M\u0011bAA\u000b-\n\u0019\u0011I\\=\t\u000f\u0005ea\u00101\u0001\u0002\u001c\u0005AA/\u00192mK\u0016sg\u000f\u0005\u0003\u0002\u001e\u0005\u0005RBAA\u0010\u0015\r\tY\u0001C\u0005\u0005\u0003G\tyBA\u000bCCR\u001c\u0007\u000eV1cY\u0016,eN^5s_:lWM\u001c;\t\u0013\u0005\u001db\u0010%AA\u0002\u0005%\u0012\u0001D3ya\u0016\u001cG/\u001a3UsB,\u0007#B+\u0002,\u0005=\u0012bAA\u0017-\n1q\n\u001d;j_:\u0004b!!\r\u0002<\u0005EQBAA\u001a\u0015\u0011\t)$a\u000e\u0002\u0011QL\b/Z5oM>TA!!\u000f\u0002\n\u000511m\\7n_:LA!!\u0010\u00024\tyA+\u001f9f\u0013:4wN]7bi&|g\u000eC\u0004\u0002B\u0001!I!a\u0011\u0002!\u0011L'/Z2uS>tGk\\(sI\u0016\u0014H\u0003BA#\u0003#\u0002B!a\u0012\u0002N5\u0011\u0011\u0011\n\u0006\u0005\u0003\u0017\n9$A\u0005pa\u0016\u0014\u0018\r^8sg&!\u0011qJA%\u0005\u0015y%\u000fZ3s\u0011!\t\u0019&a\u0010A\u0002\u0005U\u0013!\u00033je\u0016\u001cG/[8o!\u0011\t9&a\u001d\u000f\t\u0005e\u0013q\u000e\b\u0005\u00037\niG\u0004\u0003\u0002^\u0005-d\u0002BA0\u0003SrA!!\u0019\u0002h5\u0011\u00111\r\u0006\u0004\u0003K\u0002\u0012A\u0002\u001fs_>$h(C\u0001\u0010\u0013\tia\"\u0003\u0002\u0018\u0019%\u0011QCF\u0005\u0004\u0003c\"\u0012!\u0005*fY\u001aKW\r\u001c3D_2d\u0017\r^5p]&!\u0011QOA<\u0005%!\u0015N]3di&|gNC\u0002\u0002rQA\u0011\"a\u001f\u0001\u0005\u0004%I!! \u0002\u001f\u0019LW\r\u001c3D_2d\u0017\r^5p]N,\"!a \u0011\r\u0005\u0005\u00151RAH\u001b\t\t\u0019I\u0003\u0003\u0002\u0006\u0006\u001d\u0015aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0003\u00133\u0016AC2pY2,7\r^5p]&!\u0011QRAB\u0005\u0019\u0011UO\u001a4feB9Q+!%\u0002\u0016\u0006\u0015\u0013bAAJ-\n1A+\u001e9mKJ\u00022!VAL\u0013\r\tIJ\u0016\u0002\u0004\u0013:$\b\u0002CAO\u0001\u0001\u0006I!a \u0002!\u0019LW\r\u001c3D_2d\u0017\r^5p]N\u0004\u0003\"CAQ\u0001\t\u0007I\u0011BAR\u0003I\u0019xN\u001d;GS\u0016dGm\u001d+p'R\u0014\u0018N\\4\u0016\u0005\u0005\u0015\u0006\u0003BAT\u0003[s1!VAU\u0013\r\tYKV\u0001\u0007!J,G-\u001a4\n\t\u0005=\u0016\u0011\u0017\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005-f\u000b\u0003\u0005\u00026\u0002\u0001\u000b\u0011BAS\u0003M\u0019xN\u001d;GS\u0016dGm\u001d+p'R\u0014\u0018N\\4!\u0011%\tI\f\u0001b\u0001\n\u0013\t\u0019+\u0001\bpM\u001a\u001cX\r\u001e+p'R\u0014\u0018N\\4\t\u0011\u0005u\u0006\u0001)A\u0005\u0003K\u000bqb\u001c4gg\u0016$Hk\\*ue&tw\r\t\u0005\n\u0003\u0003\u0004!\u0019!C\u0005\u0003\u0007\fQBZ3uG\"$vn\u0015;sS:<WCAAc!\u0011\t9-!4\u000e\u0005\u0005%'bAAf[\u0006!A.\u00198h\u0013\u0011\ty+!3\t\u0011\u0005E\u0007\u0001)A\u0005\u0003\u000b\faBZ3uG\"$vn\u0015;sS:<\u0007\u0005C\u0004\u0002V\u0002!\t%a6\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!*\t\u000f\u0005m\u0007\u0001\"\u0011\u0002^\u0006aQ\r\u001f9mC&tG+\u001a:ngR!\u0011q\\As!\r\u0019\u0012\u0011]\u0005\u0004\u0003G$\"!\u0003*fY^\u0013\u0018\u000e^3s\u0011!\t9/!7A\u0002\u0005}\u0017A\u00019x\u0011%\tY\u000fAI\u0001\n\u0003\ni/A\rue\u0006t7\u000f\\1uKR{\u0007\u000b\\1oI\u0011,g-Y;mi\u0012\u0012TCAAxU\u0011\tI#!=,\u0005\u0005M\b\u0003BA{\u0003\u007fl!!a>\u000b\t\u0005e\u00181`\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!@W\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005\u0003\t9PA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class DataSetSort
extends SingleRel
implements DataSetRel {
    private final RelOptCluster cluster;
    private final RelNode inp;
    private final RelCollation collations;
    private final RelDataType rowRelDataType;
    private final RexNode offset;
    private final RexNode fetch;
    private final long limitStart;
    private final long limitEnd;
    private final Buffer<Tuple2<Object, Order>> fieldCollations;
    private final String sortFieldsToString;
    private final String offsetToString;
    private final String fetchToString;

    @Override
    public String getExpressionString(RexNode expr, List<String> inFields, Option<List<RexNode>> localExprsTable) {
        return FlinkRel$class.getExpressionString(this, expr, inFields, localExprsTable);
    }

    @Override
    public MapFunction<Object, Object> getConversionMapper(TableConfig config, boolean nullableInput, TypeInformation<Object> inputType, TypeInformation<Object> expectedType, String conversionOperatorName, Seq<String> fieldNames, Option<int[]> inputPojoFieldMapping) {
        return FlinkRel$class.getConversionMapper(this, config, nullableInput, inputType, expectedType, conversionOperatorName, fieldNames, inputPojoFieldMapping);
    }

    @Override
    public double estimateRowSize(RelDataType rowType) {
        return FlinkRel$class.estimateRowSize(this, rowType);
    }

    @Override
    public double estimateDataTypeSize(RelDataType t) {
        return FlinkRel$class.estimateDataTypeSize(this, t);
    }

    @Override
    public Option<int[]> getConversionMapper$default$7() {
        return FlinkRel$class.getConversionMapper$default$7(this);
    }

    private long limitStart() {
        return this.limitStart;
    }

    private long limitEnd() {
        return this.limitEnd;
    }

    @Override
    public RelDataType deriveRowType() {
        return this.rowRelDataType;
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, java.util.List<RelNode> inputs) {
        return new DataSetSort(this.cluster, traitSet, inputs.get(0), this.collations, this.getRowType(), this.offset, this.fetch);
    }

    @Override
    public double estimateRowCount(RelMetadataQuery metadata) {
        double d;
        Double inputRowCnt = metadata.getRowCount(this.getInput());
        if (inputRowCnt == null) {
            d = Predef$.MODULE$.Double2double(inputRowCnt);
        } else {
            double rowCount = BoxesRunTime.unboxToDouble((Object)new RichDouble(Predef$.MODULE$.doubleWrapper(Predef$.MODULE$.Double2double(inputRowCnt) - (double)this.limitStart())).max((Object)BoxesRunTime.boxToDouble((double)1.0)));
            if (this.fetch == null) {
                d = rowCount;
            } else {
                int limit = RexLiteral.intValue(this.fetch);
                d = BoxesRunTime.unboxToDouble((Object)new RichDouble(Predef$.MODULE$.doubleWrapper(rowCount)).min((Object)BoxesRunTime.boxToDouble((double)limit)));
            }
        }
        return d;
    }

    @Override
    public DataSet<Object> translateToPlan(BatchTableEnvironment tableEnv, Option<TypeInformation<Object>> expectedType) {
        DataSet dataSet;
        DataSet dataSet2;
        if (this.fieldCollations().isEmpty()) {
            throw TableException$.MODULE$.apply("Limiting the result without sorting is not allowed as it could lead to arbitrary results.");
        }
        TableConfig config = tableEnv.getConfig();
        DataSetRel qual$1 = (DataSetRel)this.inp;
        BatchTableEnvironment x$3 = tableEnv;
        Option<TypeInformation<Object>> x$4 = qual$1.translateToPlan$default$2();
        DataSet<Object> inputDs = qual$1.translateToPlan(x$3, x$4);
        int currentParallelism = inputDs.getExecutionEnvironment().getParallelism();
        ObjectRef partitionedDs = currentParallelism == 1 ? new ObjectRef(inputDs) : new ObjectRef((Object)inputDs.partitionByRange((int[])((TraversableOnce)this.fieldCollations().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Tuple2<Object, Order> x$1) {
                return x$1._1$mcI$sp();
            }
        }, Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Int())).withOrders((Order[])((TraversableOnce)this.fieldCollations().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Order apply(Tuple2<Object, Order> x$2) {
                return (Order)x$2._2();
            }
        }, Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Order.class))));
        this.fieldCollations().foreach((Function1)new Serializable(this, partitionedDs){
            public static final long serialVersionUID = 0L;
            private final ObjectRef partitionedDs$1;

            public final void apply(Tuple2<Object, Order> fieldCollation) {
                this.partitionedDs$1.elem = ((DataSet)this.partitionedDs$1.elem).sortPartition(fieldCollation._1$mcI$sp(), (Order)fieldCollation._2());
            }
            {
                this.partitionedDs$1 = partitionedDs$1;
            }
        });
        if (this.offset == null && this.fetch == null) {
            dataSet2 = (DataSet)partitionedDs.elem;
        } else {
            CountPartitionFunction countFunction = new CountPartitionFunction();
            String partitionCountName = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"prepare offset/fetch"})).s((Seq)Nil$.MODULE$);
            MapPartitionOperator partitionCount = (MapPartitionOperator)((DataSet)partitionedDs.elem).mapPartition(countFunction).name(partitionCountName);
            String broadcastName = "countPartition";
            LimitFilterFunction limitFunction = new LimitFilterFunction(this.limitStart(), this.limitEnd(), broadcastName);
            String limitName = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"offset: ", ", fetch: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.offsetToString(), this.fetchToString()}));
            dataSet2 = ((SingleInputUdfOperator)((DataSet)partitionedDs.elem).filter(limitFunction).name(limitName)).withBroadcastSet((DataSet)partitionCount, broadcastName);
        }
        DataSet limitedDs = dataSet2;
        TypeInformation inputType = ((DataSet)partitionedDs.elem).getType();
        Option<TypeInformation<Object>> option = expectedType;
        None$ none$ = None$.MODULE$;
        Option<TypeInformation<Object>> option2 = option;
        if (!(none$ != null ? !none$.equals(option2) : option2 != null) && config.getEfficientTypeUsage()) {
            dataSet = limitedDs;
        } else {
            DataSet dataSet3;
            TypeInformation<Object> determinedType;
            TypeInformation<Object> typeInformation = determinedType = TypeConverter$.MODULE$.determineReturnType(this.getRowType(), expectedType, config.getNullCheck(), config.getEfficientTypeUsage());
            TypeInformation typeInformation2 = inputType;
            if (!(typeInformation != null ? !typeInformation.equals((Object)typeInformation2) : typeInformation2 != null)) {
                dataSet3 = limitedDs;
            } else {
                MapFunction<Object, Object> mapFunc = this.getConversionMapper(config, false, (TypeInformation<Object>)((DataSet)partitionedDs.elem).getType(), determinedType, "DataSetSortConversion", (Seq<String>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(this.getRowType().getFieldNames()).asScala()), this.getConversionMapper$default$7());
                String opName = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"convert: (", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.getRowType().getFieldNames()).asScala()).toList().mkString(", ")}));
                dataSet3 = limitedDs.map(mapFunc).name(opName);
            }
            dataSet = dataSet3;
        }
        return dataSet;
    }

    @Override
    public Option<TypeInformation<Object>> translateToPlan$default$2() {
        return None$.MODULE$;
    }

    public Order org$apache$flink$table$plan$nodes$dataset$DataSetSort$$directionToOrder(RelFieldCollation.Direction direction) {
        block9: {
            Order order;
            block8: {
                boolean bl;
                RelFieldCollation.Direction direction2;
                block7: {
                    boolean bl2;
                    direction2 = direction;
                    RelFieldCollation.Direction direction3 = RelFieldCollation.Direction.ASCENDING;
                    RelFieldCollation.Direction direction4 = direction2;
                    if (!(direction3 != null ? !((Object)((Object)direction3)).equals((Object)direction4) : direction4 != null)) {
                        bl2 = true;
                    } else {
                        RelFieldCollation.Direction direction5 = RelFieldCollation.Direction.STRICTLY_ASCENDING;
                        RelFieldCollation.Direction direction6 = direction2;
                        bl2 = !(direction5 != null ? !((Object)((Object)direction5)).equals((Object)direction6) : direction6 != null);
                    }
                    if (!bl2) break block7;
                    order = Order.ASCENDING;
                    break block8;
                }
                RelFieldCollation.Direction direction7 = RelFieldCollation.Direction.DESCENDING;
                RelFieldCollation.Direction direction8 = direction2;
                if (!(direction7 != null ? !((Object)((Object)direction7)).equals((Object)direction8) : direction8 != null)) {
                    bl = true;
                } else {
                    RelFieldCollation.Direction direction9 = RelFieldCollation.Direction.STRICTLY_DESCENDING;
                    RelFieldCollation.Direction direction10 = direction2;
                    bl = !(direction9 != null ? !((Object)((Object)direction9)).equals((Object)direction10) : direction10 != null);
                }
                if (!bl) break block9;
                order = Order.DESCENDING;
            }
            return order;
        }
        throw new IllegalArgumentException("Unsupported direction.");
    }

    private Buffer<Tuple2<Object, Order>> fieldCollations() {
        return this.fieldCollations;
    }

    private String sortFieldsToString() {
        return this.sortFieldsToString;
    }

    private String offsetToString() {
        return this.offsetToString;
    }

    private String fetchToString() {
        return this.fetchToString;
    }

    @Override
    public String toString() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sort(by: (", "), offset: ", ", fetch: ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.sortFieldsToString(), this.offsetToString(), this.fetchToString()}));
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("orderBy", this.sortFieldsToString()).item("offset", this.offsetToString()).item("fetch", this.fetchToString());
    }

    public DataSetSort(RelOptCluster cluster, RelTraitSet traitSet, RelNode inp, RelCollation collations, RelDataType rowRelDataType, RexNode offset, RexNode fetch) {
        this.cluster = cluster;
        this.inp = inp;
        this.collations = collations;
        this.rowRelDataType = rowRelDataType;
        this.offset = offset;
        this.fetch = fetch;
        super(cluster, traitSet, inp);
        FlinkRel$class.$init$(this);
        DataSetRel$class.$init$(this);
        this.limitStart = offset == null ? 0L : (long)RexLiteral.intValue(offset);
        this.limitEnd = fetch == null ? Long.MAX_VALUE : (long)RexLiteral.intValue(fetch) + this.limitStart();
        this.fieldCollations = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(collations.getFieldCollations()).asScala()).map((Function1)new $anonfun$3(this), Buffer$.MODULE$.canBuildFrom());
        this.sortFieldsToString = ((TraversableOnce)this.fieldCollations().map((Function1)new $anonfun$4(this), Buffer$.MODULE$.canBuildFrom())).mkString(", ");
        this.offsetToString = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{offset}));
        this.fetchToString = this.limitEnd() == Long.MAX_VALUE ? "unlimited" : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.limitEnd())}));
    }
}

