/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.aggregate;

import org.apache.flink.table.runtime.aggregate.FloatingAvgAggregate;
import org.apache.flink.types.Row;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001Y2A!\u0001\u0002\u0001\u001f\t\u0011Bi\\;cY\u0016\feoZ!hOJ,w-\u0019;f\u0015\t\u0019A!A\u0005bO\u001e\u0014XmZ1uK*\u0011QAB\u0001\beVtG/[7f\u0015\t9\u0001\"A\u0003uC\ndWM\u0003\u0002\n\u0015\u0005)a\r\\5oW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\t\u0011\u0007E\u0011B#D\u0001\u0003\u0013\t\u0019\"A\u0001\u000bGY>\fG/\u001b8h\u0003Z<\u0017iZ4sK\u001e\fG/\u001a\t\u0003+ai\u0011A\u0006\u0006\u0002/\u0005)1oY1mC&\u0011\u0011D\u0006\u0002\u0007\t>,(\r\\3\t\u000bm\u0001A\u0011\u0001\u000f\u0002\rqJg.\u001b;?)\u0005i\u0002CA\t\u0001\u0011\u0015y\u0002\u0001\"\u0011!\u0003%!w\u000e\u0015:fa\u0006\u0014X\rF\u0002\"I%\u0002\"!\u0006\u0012\n\u0005\r2\"\u0001B+oSRDQ!\n\u0010A\u0002\u0019\nQA^1mk\u0016\u0004\"!F\u0014\n\u0005!2\"aA!os\")!F\ba\u0001W\u00059\u0001/\u0019:uS\u0006d\u0007C\u0001\u00170\u001b\u0005i#B\u0001\u0018\t\u0003\u0015!\u0018\u0010]3t\u0013\t\u0001TFA\u0002S_^DQA\r\u0001\u0005BM\n!\u0002Z8Fm\u0006dW/\u0019;f)\t1C\u0007C\u00036c\u0001\u00071&\u0001\u0004ck\u001a4WM\u001d")
public class DoubleAvgAggregate
extends FloatingAvgAggregate<Object> {
    @Override
    public void doPrepare(Object value, Row partial) {
        double input = BoxesRunTime.unboxToDouble((Object)value);
        partial.setField(this.partialSumIndex(), (Object)BoxesRunTime.boxToDouble((double)input));
        partial.setField(this.partialCountIndex(), (Object)BoxesRunTime.boxToLong((long)1L));
    }

    @Override
    public Object doEvaluate(Row buffer) {
        double bufferSum = BoxesRunTime.unboxToDouble((Object)buffer.getField(this.partialSumIndex()));
        long bufferCount = BoxesRunTime.unboxToLong((Object)buffer.getField(this.partialCountIndex()));
        return bufferCount == 0L ? null : BoxesRunTime.boxToDouble((double)(bufferSum / (double)bufferCount));
    }

    public DoubleAvgAggregate() {
        super(Numeric.DoubleIsFractional$.MODULE$);
    }
}

