/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica.com.google.protobuf;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.avatica.com.google.protobuf.MapEntry;
import org.apache.calcite.avatica.com.google.protobuf.MapFieldLite;
import org.apache.calcite.avatica.com.google.protobuf.Message;
import org.apache.calcite.avatica.com.google.protobuf.MutabilityOracle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapField<K, V>
implements MutabilityOracle {
    private volatile boolean isMutable;
    private volatile StorageMode mode;
    private MapFieldLite.MutatabilityAwareMap<K, V> mapData;
    private List<Message> listData;
    private final Converter<K, V> converter;

    private MapField(Converter<K, V> converter, StorageMode mode, Map<K, V> mapData) {
        this.converter = converter;
        this.isMutable = true;
        this.mode = mode;
        this.mapData = new MapFieldLite.MutatabilityAwareMap<K, V>(this, mapData);
        this.listData = null;
    }

    private MapField(MapEntry<K, V> defaultEntry, StorageMode mode, Map<K, V> mapData) {
        this(new ImmutableMessageConverter<K, V>(defaultEntry), mode, mapData);
    }

    public static <K, V> MapField<K, V> emptyMapField(MapEntry<K, V> defaultEntry) {
        return new MapField<K, V>(defaultEntry, StorageMode.MAP, Collections.emptyMap());
    }

    public static <K, V> MapField<K, V> newMapField(MapEntry<K, V> defaultEntry) {
        return new MapField<K, V>(defaultEntry, StorageMode.MAP, new LinkedHashMap());
    }

    private Message convertKeyAndValueToMessage(K key, V value) {
        return this.converter.convertKeyAndValueToMessage(key, value);
    }

    private void convertMessageToKeyAndValue(Message message, Map<K, V> map2) {
        this.converter.convertMessageToKeyAndValue(message, map2);
    }

    private List<Message> convertMapToList(MapFieldLite.MutatabilityAwareMap<K, V> mapData) {
        ArrayList<Message> listData = new ArrayList<Message>();
        for (Map.Entry<K, V> entry : mapData.entrySet()) {
            listData.add(this.convertKeyAndValueToMessage(entry.getKey(), entry.getValue()));
        }
        return listData;
    }

    private MapFieldLite.MutatabilityAwareMap<K, V> convertListToMap(List<Message> listData) {
        LinkedHashMap mapData = new LinkedHashMap();
        for (Message item : listData) {
            this.convertMessageToKeyAndValue(item, mapData);
        }
        return new MapFieldLite.MutatabilityAwareMap(this, mapData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<K, V> getMap() {
        if (this.mode == StorageMode.LIST) {
            MapField mapField = this;
            synchronized (mapField) {
                if (this.mode == StorageMode.LIST) {
                    this.mapData = this.convertListToMap(this.listData);
                    this.mode = StorageMode.BOTH;
                }
            }
        }
        return Collections.unmodifiableMap(this.mapData);
    }

    public Map<K, V> getMutableMap() {
        if (this.mode != StorageMode.MAP) {
            if (this.mode == StorageMode.LIST) {
                this.mapData = this.convertListToMap(this.listData);
            }
            this.listData = null;
            this.mode = StorageMode.MAP;
        }
        return this.mapData;
    }

    public void mergeFrom(MapField<K, V> other) {
        this.getMutableMap().putAll(MapFieldLite.copy(other.getMap()));
    }

    public void clear() {
        this.mapData = new MapFieldLite.MutatabilityAwareMap(this, new LinkedHashMap());
        this.mode = StorageMode.MAP;
    }

    public boolean equals(Object object) {
        if (!(object instanceof MapField)) {
            return false;
        }
        MapField other = (MapField)object;
        return MapFieldLite.equals(this.getMap(), other.getMap());
    }

    public int hashCode() {
        return MapFieldLite.calculateHashCodeForMap(this.getMap());
    }

    public MapField<K, V> copy() {
        return new MapField<K, V>(this.converter, StorageMode.MAP, MapFieldLite.copy(this.getMap()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Message> getList() {
        if (this.mode == StorageMode.MAP) {
            MapField mapField = this;
            synchronized (mapField) {
                if (this.mode == StorageMode.MAP) {
                    this.listData = this.convertMapToList(this.mapData);
                    this.mode = StorageMode.BOTH;
                }
            }
        }
        return Collections.unmodifiableList(this.listData);
    }

    List<Message> getMutableList() {
        if (this.mode != StorageMode.LIST) {
            if (this.mode == StorageMode.MAP) {
                this.listData = this.convertMapToList(this.mapData);
            }
            this.mapData = null;
            this.mode = StorageMode.LIST;
        }
        return this.listData;
    }

    Message getMapEntryMessageDefaultInstance() {
        return this.converter.getMessageDefaultInstance();
    }

    public void makeImmutable() {
        this.isMutable = false;
    }

    public boolean isMutable() {
        return this.isMutable;
    }

    @Override
    public void ensureMutable() {
        if (!this.isMutable()) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ImmutableMessageConverter<K, V>
    implements Converter<K, V> {
        private final MapEntry<K, V> defaultEntry;

        public ImmutableMessageConverter(MapEntry<K, V> defaultEntry) {
            this.defaultEntry = defaultEntry;
        }

        @Override
        public Message convertKeyAndValueToMessage(K key, V value) {
            return ((MapEntry.Builder)this.defaultEntry.newBuilderForType()).setKey(key).setValue(value).buildPartial();
        }

        @Override
        public void convertMessageToKeyAndValue(Message message, Map<K, V> map2) {
            MapEntry entry = (MapEntry)message;
            map2.put(entry.getKey(), entry.getValue());
        }

        @Override
        public Message getMessageDefaultInstance() {
            return this.defaultEntry;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface Converter<K, V> {
        public Message convertKeyAndValueToMessage(K var1, V var2);

        public void convertMessageToKeyAndValue(Message var1, Map<K, V> var2);

        public Message getMessageDefaultInstance();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum StorageMode {
        MAP,
        LIST,
        BOTH;

    }
}

