/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.jdbc;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.avatica.AvaticaParameter;
import org.apache.calcite.avatica.ColumnMetaData;
import org.apache.calcite.avatica.Meta;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.EnumerableDefaults;
import org.apache.calcite.linq4j.Queryable;
import org.apache.calcite.linq4j.function.Function0;
import org.apache.calcite.linq4j.tree.ClassDeclaration;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.prepare.CalcitePrepareImpl;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.runtime.ArrayBindable;
import org.apache.calcite.runtime.Bindable;
import org.apache.calcite.schema.Table;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.flink.shaded.calcite.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.flink.shaded.calcite.com.google.common.collect.ImmutableList;

public interface CalcitePrepare {
    public static final Function0<CalcitePrepare> DEFAULT_FACTORY = new Function0<CalcitePrepare>(){

        @Override
        public CalcitePrepare apply() {
            return new CalcitePrepareImpl();
        }
    };
    public static final ThreadLocal<Deque<Context>> THREAD_CONTEXT_STACK = new ThreadLocal<Deque<Context>>(){

        @Override
        protected Deque<Context> initialValue() {
            return new ArrayDeque<Context>();
        }
    };

    public ParseResult parse(Context var1, String var2);

    public ConvertResult convert(Context var1, String var2);

    public void executeDdl(Context var1, SqlNode var2);

    public AnalyzeViewResult analyzeView(Context var1, String var2, boolean var3);

    public <T> CalciteSignature<T> prepareSql(Context var1, Query<T> var2, Type var3, long var4);

    public <T> CalciteSignature<T> prepareQueryable(Context var1, Queryable<T> var2);

    public static class Query<T> {
        public final String sql;
        public final Queryable<T> queryable;
        public final RelNode rel;

        private Query(String sql, Queryable<T> queryable, RelNode rel) {
            this.sql = sql;
            this.queryable = queryable;
            this.rel = rel;
            assert ((sql == null ? 0 : 1) + (queryable == null ? 0 : 1) + (rel == null ? 0 : 1) == 1);
        }

        public static <T> Query<T> of(String sql) {
            return new Query<T>(sql, null, null);
        }

        public static <T> Query<T> of(Queryable<T> queryable) {
            return new Query<T>(null, queryable, null);
        }

        public static <T> Query<T> of(RelNode rel) {
            return new Query<T>(null, null, rel);
        }
    }

    public static class CalciteSignature<T>
    extends Meta.Signature {
        @JsonIgnore
        public final RelDataType rowType;
        @JsonIgnore
        private final List<RelCollation> collationList;
        private final long maxRowCount;
        private final Bindable<T> bindable;

        public CalciteSignature(String sql, List<AvaticaParameter> parameterList, Map<String, Object> internalParameters, RelDataType rowType, List<ColumnMetaData> columns, Meta.CursorFactory cursorFactory, List<RelCollation> collationList, long maxRowCount, Bindable<T> bindable) {
            super(columns, sql, parameterList, internalParameters, cursorFactory, null);
            this.rowType = rowType;
            this.collationList = collationList;
            this.maxRowCount = maxRowCount;
            this.bindable = bindable;
        }

        public CalciteSignature(String sql, List<AvaticaParameter> parameterList, Map<String, Object> internalParameters, RelDataType rowType, List<ColumnMetaData> columns, Meta.CursorFactory cursorFactory, List<RelCollation> collationList, long maxRowCount, Bindable<T> bindable, Meta.StatementType statementType) {
            super(columns, sql, parameterList, internalParameters, cursorFactory, statementType);
            this.rowType = rowType;
            this.collationList = collationList;
            this.maxRowCount = maxRowCount;
            this.bindable = bindable;
        }

        public Enumerable<T> enumerable(DataContext dataContext) {
            Enumerable<T> enumerable = this.bindable.bind(dataContext);
            if (this.maxRowCount >= 0L) {
                enumerable = EnumerableDefaults.take(enumerable, this.maxRowCount);
            }
            return enumerable;
        }

        public List<RelCollation> getCollationList() {
            return this.collationList;
        }
    }

    public static class AnalyzeViewResult
    extends ConvertResult {
        public final Table table;
        public final ImmutableList<String> tablePath;
        public final RexNode constraint;
        public final ImmutableIntList columnMapping;

        public AnalyzeViewResult(CalcitePrepareImpl prepare, SqlValidator validator, String sql, SqlNode sqlNode, RelDataType rowType, RelRoot root, Table table, ImmutableList<String> tablePath, RexNode constraint, ImmutableIntList columnMapping) {
            super(prepare, validator, sql, sqlNode, rowType, root);
            this.table = table;
            this.tablePath = tablePath;
            this.constraint = constraint;
            this.columnMapping = columnMapping;
        }
    }

    public static class ConvertResult
    extends ParseResult {
        public final RelRoot root;

        public ConvertResult(CalcitePrepareImpl prepare, SqlValidator validator, String sql, SqlNode sqlNode, RelDataType rowType, RelRoot root) {
            super(prepare, validator, sql, sqlNode, rowType);
            this.root = root;
        }
    }

    public static class ParseResult {
        public final CalcitePrepareImpl prepare;
        public final String sql;
        public final SqlNode sqlNode;
        public final RelDataType rowType;
        public final RelDataTypeFactory typeFactory;

        public ParseResult(CalcitePrepareImpl prepare, SqlValidator validator, String sql, SqlNode sqlNode, RelDataType rowType) {
            this.prepare = prepare;
            this.sql = sql;
            this.sqlNode = sqlNode;
            this.rowType = rowType;
            this.typeFactory = validator.getTypeFactory();
        }

        public SqlKind kind() {
            return this.sqlNode.getKind();
        }
    }

    public static class Dummy {
        private static SparkHandler sparkHandler;

        private Dummy() {
        }

        public static synchronized SparkHandler getSparkHandler(boolean enable) {
            if (sparkHandler == null) {
                sparkHandler = enable ? Dummy.createHandler() : new TrivialSparkHandler();
            }
            return sparkHandler;
        }

        private static SparkHandler createHandler() {
            try {
                Class<?> clazz = Class.forName("org.apache.calcite.adapter.spark.SparkHandlerImpl");
                Method method = clazz.getMethod("instance", new Class[0]);
                return (SparkHandler)method.invoke(null, new Object[0]);
            }
            catch (ClassNotFoundException e) {
                return new TrivialSparkHandler();
            }
            catch (ClassCastException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }

        public static void push(Context context) {
            THREAD_CONTEXT_STACK.get().push(context);
        }

        public static Context peek() {
            return THREAD_CONTEXT_STACK.get().peek();
        }

        public static void pop(Context context) {
            Context x = THREAD_CONTEXT_STACK.get().pop();
            assert (x == context);
        }

        private static class TrivialSparkHandler
        implements SparkHandler {
            private TrivialSparkHandler() {
            }

            @Override
            public RelNode flattenTypes(RelOptPlanner planner, RelNode rootRel, boolean restructure) {
                return rootRel;
            }

            @Override
            public void registerRules(SparkHandler.RuleSetBuilder builder) {
            }

            @Override
            public boolean enabled() {
                return false;
            }

            @Override
            public ArrayBindable compile(ClassDeclaration expr, String s) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Object sparkContext() {
                throw new UnsupportedOperationException();
            }
        }
    }

    public static interface SparkHandler {
        public RelNode flattenTypes(RelOptPlanner var1, RelNode var2, boolean var3);

        public void registerRules(RuleSetBuilder var1);

        public boolean enabled();

        public ArrayBindable compile(ClassDeclaration var1, String var2);

        public Object sparkContext();

        public static interface RuleSetBuilder {
            public void addRule(RelOptRule var1);

            public void removeRule(RelOptRule var1);
        }
    }

    public static interface Context {
        public JavaTypeFactory getTypeFactory();

        public CalciteSchema getRootSchema();

        public List<String> getDefaultSchemaPath();

        public CalciteConnectionConfig config();

        public SparkHandler spark();

        public DataContext getDataContext();
    }
}

