/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.linq4j.tree;

import java.util.List;
import java.util.Objects;
import org.apache.calcite.linq4j.tree.Blocks;
import org.apache.calcite.linq4j.tree.CatchBlock;
import org.apache.calcite.linq4j.tree.ExpressionType;
import org.apache.calcite.linq4j.tree.ExpressionWriter;
import org.apache.calcite.linq4j.tree.Statement;
import org.apache.calcite.linq4j.tree.Visitor;
import org.apache.flink.shaded.calcite.com.google.common.base.Preconditions;

public class TryStatement
extends Statement {
    public final Statement body;
    public final List<CatchBlock> catchBlocks;
    public final Statement fynally;

    public TryStatement(Statement body, List<CatchBlock> catchBlocks, Statement fynally) {
        super(ExpressionType.Try, body.getType());
        this.body = Preconditions.checkNotNull(body);
        this.catchBlocks = Preconditions.checkNotNull(catchBlocks);
        this.fynally = fynally;
    }

    @Override
    public Statement accept(Visitor visitor) {
        return visitor.visit(this);
    }

    @Override
    void accept0(ExpressionWriter writer) {
        writer.append("try ").append(Blocks.toBlock(this.body));
        for (CatchBlock catchBlock : this.catchBlocks) {
            writer.backUp();
            writer.append(" catch (").append(catchBlock.parameter.declString()).append(") ").append(Blocks.toBlock(catchBlock.body));
        }
        if (this.fynally != null) {
            writer.backUp();
            writer.append(" finally ").append(Blocks.toBlock(this.fynally));
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TryStatement that = (TryStatement)o;
        if (!this.body.equals(that.body)) {
            return false;
        }
        if (!this.catchBlocks.equals(that.catchBlocks)) {
            return false;
        }
        return !(this.fynally != null ? !this.fynally.equals(that.fynally) : that.fynally != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.nodeType, this.type, this.body, this.catchBlocks, this.fynally});
    }
}

