/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import java.util.Collections;
import java.util.List;
import org.apache.calcite.plan.MaterializedViewSubstitutionVisitor;
import org.apache.calcite.plan.RelOptMaterialization;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.hep.HepPlanner;
import org.apache.calcite.plan.hep.HepProgram;
import org.apache.calcite.plan.hep.HepProgramBuilder;
import org.apache.calcite.plan.volcano.VolcanoPlanner;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.rules.FilterProjectTransposeRule;
import org.apache.calcite.rel.rules.ProjectMergeRule;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.flink.shaded.calcite.com.google.common.collect.ImmutableList;

public class MaterializedViewFilterScanRule
extends RelOptRule {
    public static final MaterializedViewFilterScanRule INSTANCE = new MaterializedViewFilterScanRule(RelFactories.LOGICAL_BUILDER);
    private final HepProgram program = new HepProgramBuilder().addRuleInstance(FilterProjectTransposeRule.INSTANCE).addRuleInstance(ProjectMergeRule.INSTANCE).build();

    protected MaterializedViewFilterScanRule(RelBuilderFactory relBuilderFactory) {
        super(MaterializedViewFilterScanRule.operand(Filter.class, MaterializedViewFilterScanRule.operand(TableScan.class, null, MaterializedViewFilterScanRule.none()), new RelOptRuleOperand[0]), relBuilderFactory, "MaterializedViewFilterScanRule");
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Filter filter = (Filter)call.rel(0);
        TableScan scan = (TableScan)call.rel(1);
        this.apply(call, filter, scan);
    }

    protected void apply(RelOptRuleCall call, Filter filter, TableScan scan) {
        ImmutableList<RelOptMaterialization> materializations;
        RelOptPlanner planner = call.getPlanner();
        ImmutableList<RelOptMaterialization> immutableList = materializations = planner instanceof VolcanoPlanner ? ((VolcanoPlanner)planner).getMaterializations() : ImmutableList.of();
        if (!materializations.isEmpty()) {
            RelNode root = filter.copy(filter.getTraitSet(), Collections.singletonList(scan));
            List<RelOptMaterialization> applicableMaterializations = VolcanoPlanner.getApplicableMaterializations(root, materializations);
            for (RelOptMaterialization materialization : applicableMaterializations) {
                if (!RelOptUtil.areRowTypesEqual(scan.getRowType(), materialization.queryRel.getRowType(), false)) continue;
                RelNode target = materialization.queryRel;
                HepPlanner hepPlanner = new HepPlanner(this.program, planner.getContext());
                hepPlanner.setRoot(target);
                target = hepPlanner.findBestExp();
                List<RelNode> subs = new MaterializedViewSubstitutionVisitor(target, root).go(materialization.tableRel);
                for (RelNode s : subs) {
                    call.transformTo(s);
                }
            }
        }
    }
}

