/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.validate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.calcite.linq4j.Linq4j;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.validate.AggChecker;
import org.apache.calcite.sql.validate.AggregatingScope;
import org.apache.calcite.sql.validate.DelegatingScope;
import org.apache.calcite.sql.validate.SelectScope;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Litmus;
import org.apache.flink.shaded.calcite.com.google.common.base.Supplier;
import org.apache.flink.shaded.calcite.com.google.common.base.Suppliers;
import org.apache.flink.shaded.calcite.com.google.common.collect.ImmutableList;
import org.apache.flink.shaded.calcite.com.google.common.collect.ImmutableMap;
import org.apache.flink.shaded.calcite.com.google.common.collect.Sets;

public class AggregatingSelectScope
extends DelegatingScope
implements AggregatingScope {
    private final SqlSelect select;
    private final boolean distinct;
    private List<SqlNode> temporaryGroupExprList;
    public final Supplier<Resolved> resolved = Suppliers.memoize(new Supplier<Resolved>(){

        @Override
        public Resolved get() {
            assert (AggregatingSelectScope.this.temporaryGroupExprList == null);
            AggregatingSelectScope.this.temporaryGroupExprList = new ArrayList();
            try {
                Resolved resolved = AggregatingSelectScope.this.resolve();
                return resolved;
            }
            finally {
                AggregatingSelectScope.this.temporaryGroupExprList = null;
            }
        }
    });

    AggregatingSelectScope(SqlValidatorScope selectScope, SqlSelect select2, boolean distinct) {
        super(selectScope);
        this.select = select2;
        this.distinct = distinct;
    }

    private Resolved resolve() {
        HashMap<Integer, Integer> groupExprProjection = new HashMap<Integer, Integer>();
        ImmutableList.Builder<ImmutableList<ImmutableBitSet>> builder = ImmutableList.builder();
        if (this.select.getGroup() != null) {
            SqlNodeList groupList = this.select.getGroup();
            for (SqlNode sqlNode : groupList) {
                SqlValidatorUtil.analyzeGroupItem(this, this.temporaryGroupExprList, groupExprProjection, builder, sqlNode);
            }
        }
        TreeSet<ImmutableBitSet> flatGroupSets = Sets.newTreeSet(ImmutableBitSet.COMPARATOR);
        for (List list : Linq4j.product(builder.build())) {
            flatGroupSets.add(ImmutableBitSet.union(list));
        }
        if (flatGroupSets.isEmpty()) {
            flatGroupSets.add(ImmutableBitSet.of());
        }
        return new Resolved(this.temporaryGroupExprList, flatGroupSets, groupExprProjection);
    }

    private ImmutableList<SqlNode> getGroupExprs() {
        if (this.distinct) {
            assert (this.select.isDistinct());
            ImmutableList.Builder groupExprs = ImmutableList.builder();
            SelectScope selectScope = (SelectScope)this.parent;
            for (SqlNode selectItem : selectScope.getExpandedSelectList()) {
                groupExprs.add(SqlUtil.stripAs(selectItem));
            }
            return groupExprs.build();
        }
        if (this.select.getGroup() != null) {
            if (this.temporaryGroupExprList != null) {
                return ImmutableList.copyOf(this.temporaryGroupExprList);
            }
            return this.resolved.get().groupExprList;
        }
        return ImmutableList.of();
    }

    @Override
    public SqlNode getNode() {
        return this.select;
    }

    private static boolean allContain(List<ImmutableBitSet> bitSets, int bit) {
        for (ImmutableBitSet bitSet : bitSets) {
            if (bitSet.get(bit)) continue;
            return false;
        }
        return true;
    }

    @Override
    public RelDataType nullifyType(SqlNode node, RelDataType type) {
        Resolved r = this.resolved.get();
        for (Ord<SqlNode> groupExpr : Ord.zip(r.groupExprList)) {
            if (!((SqlNode)groupExpr.e).equalsDeep(node, Litmus.IGNORE) || !r.isNullable(groupExpr.i)) continue;
            return this.validator.getTypeFactory().createTypeWithNullability(type, true);
        }
        return type;
    }

    @Override
    public SqlValidatorScope getOperandScope(SqlCall call) {
        if (call.getOperator().isAggregator()) {
            return this.parent;
        }
        boolean matches = this.checkAggregateExpr(call, false);
        if (matches) {
            return this.parent;
        }
        return super.getOperandScope(call);
    }

    @Override
    public boolean checkAggregateExpr(SqlNode expr, boolean deep) {
        if (deep) {
            expr = this.validator.expand(expr, this);
        }
        ImmutableList<SqlNode> groupExprs = this.getGroupExprs();
        AggChecker aggChecker = new AggChecker(this.validator, this, groupExprs, this.distinct);
        if (deep) {
            expr.accept(aggChecker);
        }
        return aggChecker.isGroupExpr(expr);
    }

    @Override
    public void validateExpr(SqlNode expr) {
        this.checkAggregateExpr(expr, true);
    }

    public class Resolved {
        public final ImmutableList<SqlNode> groupExprList;
        public final ImmutableBitSet groupSet;
        public final ImmutableList<ImmutableBitSet> groupSets;
        public final boolean indicator;
        public final Map<Integer, Integer> groupExprProjection;

        Resolved(List<SqlNode> groupExprList, Iterable<ImmutableBitSet> groupSets, Map<Integer, Integer> groupExprProjection) {
            this.groupExprList = ImmutableList.copyOf(groupExprList);
            this.groupSet = ImmutableBitSet.range(groupExprList.size());
            this.groupSets = ImmutableList.copyOf(groupSets);
            this.indicator = !this.groupSets.equals(ImmutableList.of(this.groupSet));
            this.groupExprProjection = ImmutableMap.copyOf(groupExprProjection);
        }

        public boolean isNullable(int i) {
            return i < this.groupExprList.size() && !AggregatingSelectScope.allContain(this.groupSets, i);
        }

        public boolean isGroupingExpr(SqlNode operand) {
            return this.lookupGroupingExpr(operand) >= 0;
        }

        public int lookupGroupingExpr(SqlNode operand) {
            for (Ord<SqlNode> groupExpr : Ord.zip(this.groupExprList)) {
                if (!operand.equalsDeep((SqlNode)groupExpr.e, Litmus.IGNORE)) continue;
                return groupExpr.i;
            }
            return -1;
        }
    }
}

