/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.expressions;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.api.ValidationException$;
import org.apache.flink.table.expressions.ArrayConstructor;
import org.apache.flink.table.expressions.Cast;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.Literal;
import org.apache.flink.table.expressions.Literal$;
import org.apache.flink.table.expressions.Mul;
import org.apache.flink.table.typeutils.RowIntervalTypeInfo$;
import org.apache.flink.table.typeutils.TimeIntervalTypeInfo$;
import scala.Array$;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class ExpressionUtils$ {
    public static final ExpressionUtils$ MODULE$;

    static {
        new ExpressionUtils$();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public Expression toMonthInterval(Expression expr, int multiplier) {
        void var9_11;
        Expression expression2 = expr;
        if (expression2 instanceof Literal) {
            Literal literal = (Literal)expression2;
            Object value = literal.value();
            TypeInformation<?> typeInformation = literal.resultType();
            if (value instanceof Integer) {
                int n = BoxesRunTime.unboxToInt((Object)value);
                BasicTypeInfo basicTypeInfo = BasicTypeInfo.INT_TYPE_INFO;
                TypeInformation<?> typeInformation2 = typeInformation;
                if (!(basicTypeInfo != null ? !basicTypeInfo.equals(typeInformation2) : typeInformation2 != null)) {
                    Literal literal2 = new Literal(BoxesRunTime.boxToInteger((int)(n * multiplier)), TimeIntervalTypeInfo$.MODULE$.INTERVAL_MONTHS());
                    return var9_11;
                }
            }
        }
        Cast cast = new Cast(new Mul(expr, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)multiplier))), TimeIntervalTypeInfo$.MODULE$.INTERVAL_MONTHS());
        return var9_11;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public Expression toMilliInterval(Expression expr, long multiplier) {
        void var11_13;
        boolean bl = false;
        Literal literal = null;
        Expression expression2 = expr;
        if (expression2 instanceof Literal) {
            bl = true;
            literal = (Literal)expression2;
            Object value = literal.value();
            TypeInformation<?> typeInformation = literal.resultType();
            if (value instanceof Integer) {
                int n = BoxesRunTime.unboxToInt((Object)value);
                BasicTypeInfo basicTypeInfo = BasicTypeInfo.INT_TYPE_INFO;
                TypeInformation<?> typeInformation2 = typeInformation;
                if (!(basicTypeInfo != null ? !basicTypeInfo.equals(typeInformation2) : typeInformation2 != null)) {
                    Literal literal2 = new Literal(BoxesRunTime.boxToLong((long)((long)n * multiplier)), TimeIntervalTypeInfo$.MODULE$.INTERVAL_MILLIS());
                    return var11_13;
                }
            }
        }
        if (bl) {
            Object value = literal.value();
            TypeInformation<?> typeInformation = literal.resultType();
            if (value instanceof Long) {
                long l = BoxesRunTime.unboxToLong((Object)value);
                BasicTypeInfo basicTypeInfo = BasicTypeInfo.LONG_TYPE_INFO;
                TypeInformation<?> typeInformation3 = typeInformation;
                if (!(basicTypeInfo != null ? !basicTypeInfo.equals(typeInformation3) : typeInformation3 != null)) {
                    Literal literal3 = new Literal(BoxesRunTime.boxToLong((long)(l * multiplier)), TimeIntervalTypeInfo$.MODULE$.INTERVAL_MILLIS());
                    return var11_13;
                }
            }
        }
        Cast cast = new Cast(new Mul(expr, Literal$.MODULE$.apply(BoxesRunTime.boxToLong((long)multiplier))), TimeIntervalTypeInfo$.MODULE$.INTERVAL_MILLIS());
        return var11_13;
    }

    public Expression toRowInterval(Expression expr) {
        block4: {
            Literal literal;
            block3: {
                Literal literal2;
                boolean bl;
                block2: {
                    bl = false;
                    literal2 = null;
                    Expression expression2 = expr;
                    if (!(expression2 instanceof Literal)) break block2;
                    bl = true;
                    literal2 = (Literal)expression2;
                    Object value = literal2.value();
                    TypeInformation<?> typeInformation = literal2.resultType();
                    if (!(value instanceof Integer)) break block2;
                    int n = BoxesRunTime.unboxToInt((Object)value);
                    BasicTypeInfo basicTypeInfo = BasicTypeInfo.INT_TYPE_INFO;
                    TypeInformation<?> typeInformation2 = typeInformation;
                    if (basicTypeInfo != null ? !basicTypeInfo.equals(typeInformation2) : typeInformation2 != null) break block2;
                    literal = new Literal(BoxesRunTime.boxToLong((long)n), RowIntervalTypeInfo$.MODULE$.INTERVAL_ROWS());
                    break block3;
                }
                if (!bl) break block4;
                Object value = literal2.value();
                TypeInformation<?> typeInformation = literal2.resultType();
                if (!(value instanceof Long)) break block4;
                long l = BoxesRunTime.unboxToLong((Object)value);
                BasicTypeInfo basicTypeInfo = BasicTypeInfo.LONG_TYPE_INFO;
                TypeInformation<?> typeInformation3 = typeInformation;
                if (basicTypeInfo != null ? !basicTypeInfo.equals(typeInformation3) : typeInformation3 != null) break block4;
                literal = new Literal(BoxesRunTime.boxToLong((long)l), RowIntervalTypeInfo$.MODULE$.INTERVAL_ROWS());
            }
            return literal;
        }
        throw new IllegalArgumentException("Invalid value for row interval literal.");
    }

    public Expression convertArray(Object array2) {
        block23: {
            Expression expression2;
            block3: {
                block22: {
                    Object object;
                    block21: {
                        block20: {
                            block19: {
                                block18: {
                                    block17: {
                                        block16: {
                                            block15: {
                                                block14: {
                                                    block13: {
                                                        block12: {
                                                            block11: {
                                                                block10: {
                                                                    block9: {
                                                                        block8: {
                                                                            block7: {
                                                                                block6: {
                                                                                    block5: {
                                                                                        block4: {
                                                                                            block2: {
                                                                                                object = array2;
                                                                                                if (!(object instanceof boolean[])) break block2;
                                                                                                expression2 = this.createArray$1(array2);
                                                                                                break block3;
                                                                                            }
                                                                                            if (!(object instanceof byte[])) break block4;
                                                                                            expression2 = this.createArray$1(array2);
                                                                                            break block3;
                                                                                        }
                                                                                        if (!(object instanceof short[])) break block5;
                                                                                        expression2 = this.createArray$1(array2);
                                                                                        break block3;
                                                                                    }
                                                                                    if (!(object instanceof int[])) break block6;
                                                                                    expression2 = this.createArray$1(array2);
                                                                                    break block3;
                                                                                }
                                                                                if (!(object instanceof long[])) break block7;
                                                                                expression2 = this.createArray$1(array2);
                                                                                break block3;
                                                                            }
                                                                            if (!(object instanceof float[])) break block8;
                                                                            expression2 = this.createArray$1(array2);
                                                                            break block3;
                                                                        }
                                                                        if (!(object instanceof double[])) break block9;
                                                                        expression2 = this.createArray$1(array2);
                                                                        break block3;
                                                                    }
                                                                    if (!(object instanceof Boolean[])) break block10;
                                                                    expression2 = this.createArray$1(array2);
                                                                    break block3;
                                                                }
                                                                if (!(object instanceof Byte[])) break block11;
                                                                expression2 = this.createArray$1(array2);
                                                                break block3;
                                                            }
                                                            if (!(object instanceof Short[])) break block12;
                                                            expression2 = this.createArray$1(array2);
                                                            break block3;
                                                        }
                                                        if (!(object instanceof Integer[])) break block13;
                                                        expression2 = this.createArray$1(array2);
                                                        break block3;
                                                    }
                                                    if (!(object instanceof Long[])) break block14;
                                                    expression2 = this.createArray$1(array2);
                                                    break block3;
                                                }
                                                if (!(object instanceof Float[])) break block15;
                                                expression2 = this.createArray$1(array2);
                                                break block3;
                                            }
                                            if (!(object instanceof Double[])) break block16;
                                            expression2 = this.createArray$1(array2);
                                            break block3;
                                        }
                                        if (!(object instanceof String[])) break block17;
                                        expression2 = this.createArray$1(array2);
                                        break block3;
                                    }
                                    if (!(object instanceof BigDecimal[])) break block18;
                                    expression2 = this.createArray$1(array2);
                                    break block3;
                                }
                                if (!(object instanceof Date[])) break block19;
                                expression2 = this.createArray$1(array2);
                                break block3;
                            }
                            if (!(object instanceof Time[])) break block20;
                            expression2 = this.createArray$1(array2);
                            break block3;
                        }
                        if (!(object instanceof Timestamp[])) break block21;
                        expression2 = this.createArray$1(array2);
                        break block3;
                    }
                    if (!(object instanceof scala.math.BigDecimal[])) break block22;
                    scala.math.BigDecimal[] bigDecimalArray = (scala.math.BigDecimal[])object;
                    expression2 = new ArrayConstructor((Seq<Expression>)((Seq)Predef$.MODULE$.refArrayOps((Object[])bigDecimalArray).map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final Literal apply(scala.math.BigDecimal bd) {
                            return Literal$.MODULE$.apply(bd.bigDecimal());
                        }
                    }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()))));
                    break block3;
                }
                if (ScalaRunTime$.MODULE$.array_length(array2) <= 0 || !ScalaRunTime$.MODULE$.isArray(Predef$.MODULE$.genericArrayOps(array2).head(), 1)) break block23;
                expression2 = new ArrayConstructor((Seq<Expression>)((Seq)Predef$.MODULE$.genericArrayOps(array2).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Expression apply(Object na) {
                        return ExpressionUtils$.MODULE$.convertArray(na);
                    }
                }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()))));
            }
            return expression2;
        }
        throw ValidationException$.MODULE$.apply("Unsupported array type.");
    }

    public BigDecimal getFactor(TimeUnit unit) {
        block8: {
            BigDecimal bigDecimal;
            block3: {
                TimeUnit timeUnit;
                block7: {
                    block6: {
                        block5: {
                            block4: {
                                block2: {
                                    timeUnit = unit;
                                    TimeUnit timeUnit2 = TimeUnit.DAY;
                                    TimeUnit timeUnit3 = timeUnit;
                                    if (timeUnit2 != null ? !((Object)((Object)timeUnit2)).equals((Object)timeUnit3) : timeUnit3 != null) break block2;
                                    bigDecimal = BigDecimal.ONE;
                                    break block3;
                                }
                                TimeUnit timeUnit4 = TimeUnit.HOUR;
                                TimeUnit timeUnit5 = timeUnit;
                                if (timeUnit4 != null ? !((Object)((Object)timeUnit4)).equals((Object)timeUnit5) : timeUnit5 != null) break block4;
                                bigDecimal = TimeUnit.DAY.multiplier;
                                break block3;
                            }
                            TimeUnit timeUnit6 = TimeUnit.MINUTE;
                            TimeUnit timeUnit7 = timeUnit;
                            if (timeUnit6 != null ? !((Object)((Object)timeUnit6)).equals((Object)timeUnit7) : timeUnit7 != null) break block5;
                            bigDecimal = TimeUnit.HOUR.multiplier;
                            break block3;
                        }
                        TimeUnit timeUnit8 = TimeUnit.SECOND;
                        TimeUnit timeUnit9 = timeUnit;
                        if (timeUnit8 != null ? !((Object)((Object)timeUnit8)).equals((Object)timeUnit9) : timeUnit9 != null) break block6;
                        bigDecimal = TimeUnit.MINUTE.multiplier;
                        break block3;
                    }
                    TimeUnit timeUnit10 = TimeUnit.YEAR;
                    TimeUnit timeUnit11 = timeUnit;
                    if (timeUnit10 != null ? !((Object)((Object)timeUnit10)).equals((Object)timeUnit11) : timeUnit11 != null) break block7;
                    bigDecimal = BigDecimal.ONE;
                    break block3;
                }
                TimeUnit timeUnit12 = TimeUnit.MONTH;
                TimeUnit timeUnit13 = timeUnit;
                if (timeUnit12 != null ? !((Object)((Object)timeUnit12)).equals((Object)timeUnit13) : timeUnit13 != null) break block8;
                bigDecimal = TimeUnit.YEAR.multiplier;
            }
            return bigDecimal;
        }
        throw new IllegalArgumentException("Invalid start unit.");
    }

    public RexNode mod(RexBuilder rexBuilder, RelDataType resType, RexNode res, BigDecimal value) {
        if (BoxesRunTime.equalsNumNum((Number)value, (Number)BigDecimal.ONE)) {
            return res;
        }
        return rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.MOD, res, rexBuilder.makeExactLiteral(value, resType));
    }

    public RexNode divide(RexBuilder rexBuilder, RexNode res, BigDecimal value) {
        if (BoxesRunTime.equalsNumNum((Number)value, (Number)BigDecimal.ONE)) {
            return res;
        }
        if (value.compareTo(BigDecimal.ONE) < 0 && value.signum() == 1) {
            try {
                BigDecimal reciprocal = BigDecimal.ONE.divide(value, 7);
                return rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.MULTIPLY, res, rexBuilder.makeExactLiteral(reciprocal));
            }
            catch (ArithmeticException arithmeticException) {
                // empty catch block
            }
        }
        return rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.DIVIDE_INTEGER, res, rexBuilder.makeExactLiteral(value));
    }

    private final Expression createArray$1(Object array$1) {
        return new ArrayConstructor((Seq<Expression>)((Seq)Predef$.MODULE$.genericArrayOps(array$1).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Literal apply(Object x$1) {
                return Literal$.MODULE$.apply(x$1);
            }
        }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()))));
    }

    private ExpressionUtils$() {
        MODULE$ = this;
    }
}

