/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan.rules.dataSet;

import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.plan.volcano.RelSubset;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.ConverterRule;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.logical.LogicalAggregate;
import org.apache.calcite.rel.logical.LogicalCalc;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.flink.table.plan.nodes.dataset.DataSetConvention$;
import org.apache.flink.table.plan.nodes.dataset.DataSetSingleRowJoin;
import org.apache.flink.table.plan.rules.dataSet.DataSetSingleRowJoinRule$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001i3A!\u0001\u0002\u0001#\tAB)\u0019;b'\u0016$8+\u001b8hY\u0016\u0014vn\u001e&pS:\u0014V\u000f\\3\u000b\u0005\r!\u0011a\u00023bi\u0006\u001cV\r\u001e\u0006\u0003\u000b\u0019\tQA];mKNT!a\u0002\u0005\u0002\tAd\u0017M\u001c\u0006\u0003\u0013)\tQ\u0001^1cY\u0016T!a\u0003\u0007\u0002\u000b\u0019d\u0017N\\6\u000b\u00055q\u0011AB1qC\u000eDWMC\u0001\u0010\u0003\ry'oZ\u0002\u0001'\t\u0001!\u0003\u0005\u0002\u001455\tAC\u0003\u0002\u0016-\u000591m\u001c8wKJ$(BA\f\u0019\u0003\r\u0011X\r\u001c\u0006\u000331\tqaY1mG&$X-\u0003\u0002\u001c)\ti1i\u001c8wKJ$XM\u001d*vY\u0016DQ!\b\u0001\u0005\u0002y\ta\u0001P5oSRtD#A\u0010\u0011\u0005\u0001\u0002Q\"\u0001\u0002\t\u000b\t\u0002A\u0011I\u0012\u0002\u000f5\fGo\u00195fgR\u0011AE\u000b\t\u0003K!j\u0011A\n\u0006\u0002O\u0005)1oY1mC&\u0011\u0011F\n\u0002\b\u0005>|G.Z1o\u0011\u0015Y\u0013\u00051\u0001-\u0003\u0011\u0019\u0017\r\u001c7\u0011\u00055zS\"\u0001\u0018\u000b\u0005\u001dA\u0012B\u0001\u0019/\u00059\u0011V\r\\(qiJ+H.Z\"bY2DQA\r\u0001\u0005\nM\n1\"[:J]:,'OS8j]R\u0011A\u0005\u000e\u0005\u0006kE\u0002\rAN\u0001\u0005U>Lg\u000e\u0005\u00028u5\t\u0001H\u0003\u0002:-\u00059An\\4jG\u0006d\u0017BA\u001e9\u0005-aunZ5dC2Tu.\u001b8\t\u000bu\u0002A\u0011\u0002 \u0002\u0017%\u001c8+\u001b8hY\u0016\u0014vn\u001e\u000b\u0003I}BQ\u0001\u0011\u001fA\u0002\u0005\u000bAA\\8eKB\u0011!iQ\u0007\u0002-%\u0011AI\u0006\u0002\b%\u0016dgj\u001c3f\u0011\u0015)\u0002\u0001\"\u0011G)\t\tu\tC\u0003\u0018\u000b\u0002\u0007\u0011iB\u0003J\u0005!\u0005!*\u0001\rECR\f7+\u001a;TS:<G.\u001a*po*{\u0017N\u001c*vY\u0016\u0004\"\u0001I&\u0007\u000b\u0005\u0011\u0001\u0012\u0001'\u0014\u0005-k\u0005CA\u0013O\u0013\tyeE\u0001\u0004B]f\u0014VM\u001a\u0005\u0006;-#\t!\u0015\u000b\u0002\u0015\"91k\u0013b\u0001\n\u0003!\u0016\u0001C%O'R\u000bejQ#\u0016\u0003U\u0003\"!\f,\n\u0005]s#A\u0003*fY>\u0003HOU;mK\"1\u0011l\u0013Q\u0001\nU\u000b\u0011\"\u0013(T)\u0006s5)\u0012\u0011")
public class DataSetSingleRowJoinRule
extends ConverterRule {
    public static RelOptRule INSTANCE() {
        return DataSetSingleRowJoinRule$.MODULE$.INSTANCE();
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        LogicalJoin join = (LogicalJoin)call.rel(0);
        return this.isInnerJoin(join) ? this.isSingleRow(join.getRight()) || this.isSingleRow(join.getLeft()) : false;
    }

    private boolean isInnerJoin(LogicalJoin join) {
        JoinRelType joinRelType = join.getJoinType();
        JoinRelType joinRelType2 = JoinRelType.INNER;
        return !(joinRelType != null ? !((Object)((Object)joinRelType)).equals((Object)joinRelType2) : joinRelType2 != null);
    }

    private boolean isSingleRow(RelNode node) {
        boolean bl;
        RelNode relNode;
        while (true) {
            if ((relNode = node) instanceof RelSubset) {
                RelSubset relSubset = (RelSubset)relNode;
                node = relSubset.getOriginal();
                continue;
            }
            if (relNode instanceof LogicalProject) {
                LogicalProject logicalProject = (LogicalProject)relNode;
                node = logicalProject.getInput();
                continue;
            }
            if (relNode instanceof LogicalFilter) {
                LogicalFilter logicalFilter = (LogicalFilter)relNode;
                node = logicalFilter.getInput();
                continue;
            }
            if (!(relNode instanceof LogicalCalc)) break;
            LogicalCalc logicalCalc = (LogicalCalc)relNode;
            node = logicalCalc.getInput();
        }
        if (relNode instanceof LogicalAggregate) {
            LogicalAggregate logicalAggregate = (LogicalAggregate)relNode;
            bl = logicalAggregate.getGroupSet().isEmpty();
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public RelNode convert(RelNode rel) {
        LogicalJoin join = (LogicalJoin)rel;
        RelTraitSet traitSet = rel.getTraitSet().replace(DataSetConvention$.MODULE$.INSTANCE());
        RelNode dataSetLeftNode = RelOptRule.convert(join.getLeft(), DataSetConvention$.MODULE$.INSTANCE());
        RelNode dataSetRightNode = RelOptRule.convert(join.getRight(), DataSetConvention$.MODULE$.INSTANCE());
        boolean leftIsSingle = this.isSingleRow(join.getLeft());
        return new DataSetSingleRowJoin(rel.getCluster(), traitSet, dataSetLeftNode, dataSetRightNode, leftIsSingle, rel.getRowType(), join.getCondition(), join.getRowType(), this.description);
    }

    public DataSetSingleRowJoinRule() {
        super(LogicalJoin.class, Convention.NONE, DataSetConvention$.MODULE$.INSTANCE(), "DataSetSingleRowJoinRule");
    }
}

