/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.aggregate;

import java.math.BigDecimal;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.shaded.calcite.com.google.common.math.LongMath;
import org.apache.flink.table.runtime.aggregate.AvgAggregate;
import org.apache.flink.types.Row;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00014A!\u0001\u0002\u0001\u001f\t\u0019B)Z2j[\u0006d\u0017I^4BO\u001e\u0014XmZ1uK*\u00111\u0001B\u0001\nC\u001e<'/Z4bi\u0016T!!\u0002\u0004\u0002\u000fI,h\u000e^5nK*\u0011q\u0001C\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003\u0013)\tQA\u001a7j].T!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sO\u000e\u00011C\u0001\u0001\u0011!\r\t\"\u0003F\u0007\u0002\u0005%\u00111C\u0001\u0002\r\u0003Z<\u0017iZ4sK\u001e\fG/\u001a\t\u0003+ii\u0011A\u0006\u0006\u0003/a\tA!\\1uQ*\t\u0011$\u0001\u0003kCZ\f\u0017BA\u000e\u0017\u0005)\u0011\u0015n\u001a#fG&l\u0017\r\u001c\u0005\u0006;\u0001!\tAH\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003}\u0001\"!\u0005\u0001\t\u000b\u0005\u0002A\u0011\t\u0012\u0002)%tG/\u001a:nK\u0012L\u0017\r^3ECR\fG+\u001f9f+\u0005\u0019\u0003c\u0001\u0013(S5\tQEC\u0001'\u0003\u0015\u00198-\u00197b\u0013\tASEA\u0003BeJ\f\u0017\u0010\r\u0002+mA\u00191F\r\u001b\u000e\u00031R!!\f\u0018\u0002\u0011QL\b/Z5oM>T!a\f\u0019\u0002\r\r|W.\\8o\u0015\t\t\u0004\"A\u0002ba&L!a\r\u0017\u0003\u001fQK\b/Z%oM>\u0014X.\u0019;j_:\u0004\"!\u000e\u001c\r\u0001\u0011Iq\u0007AA\u0001\u0002\u0003\u0015\ta\u000f\u0002\u0004?\u0012\n\u0014BA\u0011:\u0013\tQ$AA\u0005BO\u001e\u0014XmZ1uKF\u0011Ah\u0010\t\u0003IuJ!AP\u0013\u0003\u000f9{G\u000f[5oOB\u0011A\u0005Q\u0005\u0003\u0003\u0016\u00121!\u00118z\u0011\u0015\u0019\u0005\u0001\"\u0011E\u0003!Ig.\u001b;jCR,GCA#I!\t!c)\u0003\u0002HK\t!QK\\5u\u0011\u0015I%\t1\u0001K\u0003\u001d\u0001\u0018M\u001d;jC2\u0004\"a\u0013(\u000e\u00031S!!\u0014\u0005\u0002\u000bQL\b/Z:\n\u0005=c%a\u0001*po\")\u0011\u000b\u0001C!%\u00069\u0001O]3qCJ,GcA#T+\")A\u000b\u0015a\u0001\u007f\u0005)a/\u00197vK\")\u0011\n\u0015a\u0001\u0015\")q\u000b\u0001C!1\u0006)Q.\u001a:hKR\u0019Q)\u0017.\t\u000b%3\u0006\u0019\u0001&\t\u000bm3\u0006\u0019\u0001&\u0002\r\t,hMZ3s\u0011\u0015i\u0006\u0001\"\u0011_\u0003!)g/\u00197vCR,GC\u0001\u000b`\u0011\u0015YF\f1\u0001K\u0001")
public class DecimalAvgAggregate
extends AvgAggregate<BigDecimal> {
    @Override
    public TypeInformation<?>[] intermediateDataType() {
        return (TypeInformation[])((Object[])new TypeInformation[]{BasicTypeInfo.BIG_DEC_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO});
    }

    @Override
    public void initiate(Row partial) {
        partial.setField(this.partialSumIndex(), (Object)BigDecimal.ZERO);
        partial.setField(this.partialCountIndex(), (Object)BoxesRunTime.boxToLong((long)0L));
    }

    @Override
    public void prepare(Object value, Row partial) {
        if (value == null) {
            this.initiate(partial);
        } else {
            BigDecimal input = (BigDecimal)value;
            partial.setField(this.partialSumIndex(), (Object)input);
            partial.setField(this.partialCountIndex(), (Object)BoxesRunTime.boxToLong((long)1L));
        }
    }

    @Override
    public void merge(Row partial, Row buffer) {
        BigDecimal partialSum = (BigDecimal)partial.getField(this.partialSumIndex());
        long partialCount = BoxesRunTime.unboxToLong((Object)partial.getField(this.partialCountIndex()));
        BigDecimal bufferSum = (BigDecimal)buffer.getField(this.partialSumIndex());
        long bufferCount = BoxesRunTime.unboxToLong((Object)buffer.getField(this.partialCountIndex()));
        buffer.setField(this.partialSumIndex(), (Object)partialSum.add(bufferSum));
        buffer.setField(this.partialCountIndex(), (Object)BoxesRunTime.boxToLong((long)LongMath.checkedAdd(partialCount, bufferCount)));
    }

    @Override
    public BigDecimal evaluate(Row buffer) {
        BigDecimal bigDecimal;
        long bufferCount = BoxesRunTime.unboxToLong((Object)buffer.getField(this.partialCountIndex()));
        if (bufferCount != 0L) {
            BigDecimal bufferSum = (BigDecimal)buffer.getField(this.partialSumIndex());
            bigDecimal = bufferSum.divide(BigDecimal.valueOf(bufferCount));
        } else {
            bigDecimal = null;
        }
        return bigDecimal;
    }
}

