/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.aggregate;

import org.apache.flink.table.runtime.aggregate.FloatingAvgAggregate;
import org.apache.flink.types.Row;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001Y2A!\u0001\u0002\u0001\u001f\t\tb\t\\8bi\u00063x-Q4he\u0016<\u0017\r^3\u000b\u0005\r!\u0011!C1hOJ,w-\u0019;f\u0015\t)a!A\u0004sk:$\u0018.\\3\u000b\u0005\u001dA\u0011!\u0002;bE2,'BA\u0005\u000b\u0003\u00151G.\u001b8l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0005\t\u0004#I!R\"\u0001\u0002\n\u0005M\u0011!\u0001\u0006$m_\u0006$\u0018N\\4Bm\u001e\fum\u001a:fO\u0006$X\r\u0005\u0002\u001615\taCC\u0001\u0018\u0003\u0015\u00198-\u00197b\u0013\tIbCA\u0003GY>\fG\u000fC\u0003\u001c\u0001\u0011\u0005A$\u0001\u0004=S:LGO\u0010\u000b\u0002;A\u0011\u0011\u0003\u0001\u0005\u0006?\u0001!\t\u0005I\u0001\nI>\u0004&/\u001a9be\u0016$2!\t\u0013*!\t)\"%\u0003\u0002$-\t!QK\\5u\u0011\u0015)c\u00041\u0001'\u0003\u00151\u0018\r\\;f!\t)r%\u0003\u0002)-\t\u0019\u0011I\\=\t\u000b)r\u0002\u0019A\u0016\u0002\u000fA\f'\u000f^5bYB\u0011AfL\u0007\u0002[)\u0011a\u0006C\u0001\u0006if\u0004Xm]\u0005\u0003a5\u00121AU8x\u0011\u0015\u0011\u0004\u0001\"\u00114\u0003)!w.\u0012<bYV\fG/\u001a\u000b\u0003MQBQ!N\u0019A\u0002-\naAY;gM\u0016\u0014\b")
public class FloatAvgAggregate
extends FloatingAvgAggregate<Object> {
    @Override
    public void doPrepare(Object value, Row partial) {
        float input = BoxesRunTime.unboxToFloat((Object)value);
        partial.setField(this.partialSumIndex(), (Object)BoxesRunTime.boxToDouble((double)input));
        partial.setField(this.partialCountIndex(), (Object)BoxesRunTime.boxToLong((long)1L));
    }

    @Override
    public Object doEvaluate(Row buffer) {
        double bufferSum = BoxesRunTime.unboxToDouble((Object)buffer.getField(this.partialSumIndex()));
        long bufferCount = BoxesRunTime.unboxToLong((Object)buffer.getField(this.partialCountIndex()));
        return bufferCount == 0L ? null : BoxesRunTime.boxToFloat((float)((float)(bufferSum / (double)bufferCount)));
    }

    public FloatAvgAggregate() {
        super(Numeric.FloatIsFractional$.MODULE$);
    }
}

