/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.aggregate;

import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.shaded.calcite.com.google.common.math.LongMath;
import org.apache.flink.table.runtime.aggregate.AvgAggregate;
import org.apache.flink.types.Row;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00154Q!\u0001\u0002\u0002\u0002=\u0011A#\u00138uK\u001e\u0014\u0018\r\\!wO\u0006;wM]3hCR,'BA\u0002\u0005\u0003%\twm\u001a:fO\u0006$XM\u0003\u0002\u0006\r\u00059!/\u001e8uS6,'BA\u0004\t\u0003\u0015!\u0018M\u00197f\u0015\tI!\"A\u0003gY&t7N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001A\u000b\u0003!]\u0019\"\u0001A\t\u0011\u0007I\u0019R#D\u0001\u0003\u0013\t!\"A\u0001\u0007Bm\u001e\fum\u001a:fO\u0006$X\r\u0005\u0002\u0017/1\u0001A!\u0002\r\u0001\u0005\u0004I\"!\u0001+\u0012\u0005i\u0001\u0003CA\u000e\u001f\u001b\u0005a\"\"A\u000f\u0002\u000bM\u001c\u0017\r\\1\n\u0005}a\"a\u0002(pi\"Lgn\u001a\t\u00037\u0005J!A\t\u000f\u0003\u0007\u0005s\u0017\u0010C\u0003%\u0001\u0011\u0005Q%\u0001\u0004=S:LGO\u0010\u000b\u0002MA\u0019!\u0003A\u000b\t\u000b!\u0002A\u0011I\u0015\u0002\u0011%t\u0017\u000e^5bi\u0016$\"AK\u0017\u0011\u0005mY\u0013B\u0001\u0017\u001d\u0005\u0011)f.\u001b;\t\u000b9:\u0003\u0019A\u0018\u0002\u000fA\f'\u000f^5bYB\u0011\u0001gM\u0007\u0002c)\u0011!\u0007C\u0001\u0006if\u0004Xm]\u0005\u0003iE\u00121AU8x\u0011\u00151\u0004\u0001\"\u00118\u0003\u001d\u0001(/\u001a9be\u0016$2A\u000b\u001d;\u0011\u0015IT\u00071\u0001!\u0003\u00151\u0018\r\\;f\u0011\u0015qS\u00071\u00010\u0011\u0015a\u0004\u0001\"\u0011>\u0003\u0015iWM]4f)\rQch\u0010\u0005\u0006]m\u0002\ra\f\u0005\u0006\u0001n\u0002\raL\u0001\u0007EV4g-\u001a:\t\u000b\t\u0003A\u0011I\"\u0002\u0011\u00154\u0018\r\\;bi\u0016$\"!\u0006#\t\u000b\u0001\u000b\u0005\u0019A\u0018\t\u000b\u0019\u0003A\u0011I$\u0002)%tG/\u001a:nK\u0012L\u0017\r^3ECR\fG+\u001f9f+\u0005A\u0005cA\u000eJ\u0017&\u0011!\n\b\u0002\u0006\u0003J\u0014\u0018-\u001f\u0019\u0003\u0019^\u00032!\u0014+W\u001b\u0005q%BA(Q\u0003!!\u0018\u0010]3j]\u001a|'BA)S\u0003\u0019\u0019w.\\7p]*\u00111\u000bC\u0001\u0004CBL\u0017BA+O\u0005=!\u0016\u0010]3J]\u001a|'/\\1uS>t\u0007C\u0001\fX\t%A\u0006!!A\u0001\u0002\u000b\u0005\u0011DA\u0002`IEJ!A\u0012.\n\u0005m\u0013!!C!hOJ,w-\u0019;f\u0011\u0015i\u0006A\"\u0001_\u0003%!w\u000e\u0015:fa\u0006\u0014X\rF\u0002+?\u0002DQ!\u000f/A\u0002\u0001BQA\f/A\u0002=BQA\u0019\u0001\u0007\u0002\r\f!\u0002Z8Fm\u0006dW/\u0019;f)\t\u0001C\rC\u0003AC\u0002\u0007q\u0006")
public abstract class IntegralAvgAggregate<T>
extends AvgAggregate<T> {
    @Override
    public void initiate(Row partial) {
        partial.setField(this.partialSumIndex(), (Object)BoxesRunTime.boxToLong((long)0L));
        partial.setField(this.partialCountIndex(), (Object)BoxesRunTime.boxToLong((long)0L));
    }

    @Override
    public void prepare(Object value, Row partial) {
        if (value == null) {
            partial.setField(this.partialSumIndex(), (Object)BoxesRunTime.boxToLong((long)0L));
            partial.setField(this.partialCountIndex(), (Object)BoxesRunTime.boxToLong((long)0L));
        } else {
            this.doPrepare(value, partial);
        }
    }

    @Override
    public void merge(Row partial, Row buffer) {
        long partialSum = BoxesRunTime.unboxToLong((Object)partial.getField(this.partialSumIndex()));
        long partialCount = BoxesRunTime.unboxToLong((Object)partial.getField(this.partialCountIndex()));
        long bufferSum = BoxesRunTime.unboxToLong((Object)buffer.getField(this.partialSumIndex()));
        long bufferCount = BoxesRunTime.unboxToLong((Object)buffer.getField(this.partialCountIndex()));
        buffer.setField(this.partialSumIndex(), (Object)BoxesRunTime.boxToLong((long)LongMath.checkedAdd(partialSum, bufferSum)));
        buffer.setField(this.partialCountIndex(), (Object)BoxesRunTime.boxToLong((long)LongMath.checkedAdd(partialCount, bufferCount)));
    }

    @Override
    public T evaluate(Row buffer) {
        return (T)this.doEvaluate(buffer);
    }

    @Override
    public TypeInformation<?>[] intermediateDataType() {
        return (TypeInformation[])((Object[])new TypeInformation[]{BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO});
    }

    public abstract void doPrepare(Object var1, Row var2);

    public abstract Object doEvaluate(Row var1);
}

