/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.aggregate;

import java.math.BigInteger;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.shaded.calcite.com.google.common.math.LongMath;
import org.apache.flink.table.runtime.aggregate.IntegralAvgAggregate;
import org.apache.flink.types.Row;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00014A!\u0001\u0002\u0001\u001f\t\u0001Bj\u001c8h\u0003Z<\u0017iZ4sK\u001e\fG/\u001a\u0006\u0003\u0007\u0011\t\u0011\"Y4he\u0016<\u0017\r^3\u000b\u0005\u00151\u0011a\u0002:v]RLW.\u001a\u0006\u0003\u000f!\tQ\u0001^1cY\u0016T!!\u0003\u0006\u0002\u000b\u0019d\u0017N\\6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\t\u0001\u0001\u0003E\u0002\u0012%Qi\u0011AA\u0005\u0003'\t\u0011A#\u00138uK\u001e\u0014\u0018\r\\!wO\u0006;wM]3hCR,\u0007CA\u000b\u0019\u001b\u00051\"\"A\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005e1\"\u0001\u0002'p]\u001eDQa\u0007\u0001\u0005\u0002q\ta\u0001P5oSRtD#A\u000f\u0011\u0005E\u0001\u0001\"B\u0010\u0001\t\u0003\u0002\u0013\u0001F5oi\u0016\u0014X.\u001a3jCR,G)\u0019;b)f\u0004X-F\u0001\"!\r)\"\u0005J\u0005\u0003GY\u0011Q!\u0011:sCf\u0004$!J\u0019\u0011\u0007\u0019js&D\u0001(\u0015\tA\u0013&\u0001\u0005usB,\u0017N\u001c4p\u0015\tQ3&\u0001\u0004d_6lwN\u001c\u0006\u0003Y!\t1!\u00199j\u0013\tqsEA\bUsB,\u0017J\u001c4pe6\fG/[8o!\t\u0001\u0014\u0007\u0004\u0001\u0005\u0013I\u0002\u0011\u0011!A\u0001\u0006\u00031$aA0%c%\u0011q\u0004N\u0005\u0003k\t\u0011\u0011\"Q4he\u0016<\u0017\r^3\u0012\u0005]R\u0004CA\u000b9\u0013\tIdCA\u0004O_RD\u0017N\\4\u0011\u0005UY\u0014B\u0001\u001f\u0017\u0005\r\te.\u001f\u0005\u0006}\u0001!\teP\u0001\tS:LG/[1uKR\u0011\u0001i\u0011\t\u0003+\u0005K!A\u0011\f\u0003\tUs\u0017\u000e\u001e\u0005\u0006\tv\u0002\r!R\u0001\ba\u0006\u0014H/[1m!\t1\u0015*D\u0001H\u0015\tA\u0005\"A\u0003usB,7/\u0003\u0002K\u000f\n\u0019!k\\<\t\u000b1\u0003A\u0011I'\u0002\u000fA\u0014X\r]1sKR\u0019\u0001I\u0014)\t\u000b=[\u0005\u0019\u0001\u001e\u0002\u000bY\fG.^3\t\u000b\u0011[\u0005\u0019A#\t\u000bI\u0003A\u0011I*\u0002\u0013\u0011|\u0007K]3qCJ,Gc\u0001!U+\")q*\u0015a\u0001u!)A)\u0015a\u0001\u000b\")q\u000b\u0001C!1\u0006)Q.\u001a:hKR\u0019\u0001)\u0017.\t\u000b\u00113\u0006\u0019A#\t\u000bm3\u0006\u0019A#\u0002\r\t,hMZ3s\u0011\u0015i\u0006\u0001\"\u0011_\u0003)!w.\u0012<bYV\fG/\u001a\u000b\u0003u}CQa\u0017/A\u0002\u0015\u0003")
public class LongAvgAggregate
extends IntegralAvgAggregate<Object> {
    @Override
    public TypeInformation<?>[] intermediateDataType() {
        return (TypeInformation[])((Object[])new TypeInformation[]{BasicTypeInfo.BIG_INT_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO});
    }

    @Override
    public void initiate(Row partial) {
        partial.setField(this.partialSumIndex(), (Object)BigInteger.ZERO);
        partial.setField(this.partialCountIndex(), (Object)BoxesRunTime.boxToLong((long)0L));
    }

    @Override
    public void prepare(Object value, Row partial) {
        if (value == null) {
            partial.setField(this.partialSumIndex(), (Object)BigInteger.ZERO);
            partial.setField(this.partialCountIndex(), (Object)BoxesRunTime.boxToLong((long)0L));
        } else {
            this.doPrepare(value, partial);
        }
    }

    @Override
    public void doPrepare(Object value, Row partial) {
        long input = BoxesRunTime.unboxToLong((Object)value);
        partial.setField(this.partialSumIndex(), (Object)BigInteger.valueOf(input));
        partial.setField(this.partialCountIndex(), (Object)BoxesRunTime.boxToLong((long)1L));
    }

    @Override
    public void merge(Row partial, Row buffer) {
        BigInteger partialSum = (BigInteger)partial.getField(this.partialSumIndex());
        long partialCount = BoxesRunTime.unboxToLong((Object)partial.getField(this.partialCountIndex()));
        BigInteger bufferSum = (BigInteger)buffer.getField(this.partialSumIndex());
        long bufferCount = BoxesRunTime.unboxToLong((Object)buffer.getField(this.partialCountIndex()));
        buffer.setField(this.partialSumIndex(), (Object)partialSum.add(bufferSum));
        buffer.setField(this.partialCountIndex(), (Object)BoxesRunTime.boxToLong((long)LongMath.checkedAdd(partialCount, bufferCount)));
    }

    @Override
    public Object doEvaluate(Row buffer) {
        BigInteger bufferSum = (BigInteger)buffer.getField(this.partialSumIndex());
        long bufferCount = BoxesRunTime.unboxToLong((Object)buffer.getField(this.partialCountIndex()));
        return bufferCount == 0L ? null : BoxesRunTime.boxToLong((long)bufferSum.divide(BigInteger.valueOf(bufferCount)).longValue());
    }
}

