/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.aggregate;

import org.apache.calcite.runtime.SqlFunctions;
import org.apache.flink.streaming.api.windowing.windows.TimeWindow;
import org.apache.flink.types.Row;
import org.apache.flink.util.Collector;
import scala.Option;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t4A!\u0001\u0002\u0001\u001f\tYB+[7f/&tGm\\<Qe>\u0004XM\u001d;z\u0007>dG.Z2u_JT!a\u0001\u0003\u0002\u0013\u0005<wM]3hCR,'BA\u0003\u0007\u0003\u001d\u0011XO\u001c;j[\u0016T!a\u0002\u0005\u0002\u000bQ\f'\r\\3\u000b\u0005%Q\u0011!\u00024mS:\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001!a\u0001\"!\u0005\f\u000e\u0003IQ!a\u0005\u000b\u0002\t1\fgn\u001a\u0006\u0002+\u0005!!.\u0019<b\u0013\t9\"C\u0001\u0004PE*,7\r\u001e\t\u00043qqR\"\u0001\u000e\u000b\u0005mA\u0011\u0001B;uS2L!!\b\u000e\u0003\u0013\r{G\u000e\\3di>\u0014\bCA\u0010#\u001b\u0005\u0001#BA\u0011\t\u0003\u0015!\u0018\u0010]3t\u0013\t\u0019\u0003EA\u0002S_^D\u0001\"\n\u0001\u0003\u0002\u0003\u0006IAJ\u0001\u0012o&tGm\\<Ti\u0006\u0014Ho\u00144gg\u0016$\bcA\u0014+Y5\t\u0001FC\u0001*\u0003\u0015\u00198-\u00197b\u0013\tY\u0003F\u0001\u0004PaRLwN\u001c\t\u0003O5J!A\f\u0015\u0003\u0007%sG\u000f\u0003\u00051\u0001\t\u0005\t\u0015!\u0003'\u0003=9\u0018N\u001c3po\u0016sGm\u00144gg\u0016$\b\"\u0002\u001a\u0001\t\u0003\u0019\u0014A\u0002\u001fj]&$h\bF\u00025m]\u0002\"!\u000e\u0001\u000e\u0003\tAQ!J\u0019A\u0002\u0019BQ\u0001M\u0019A\u0002\u0019B\u0011\"\u000f\u0001A\u0002\u0003\u0007I\u0011\u0001\u001e\u0002!]\u0014\u0018\r\u001d9fI\u000e{G\u000e\\3di>\u0014X#\u0001\r\t\u0013q\u0002\u0001\u0019!a\u0001\n\u0003i\u0014\u0001F<sCB\u0004X\rZ\"pY2,7\r^8s?\u0012*\u0017\u000f\u0006\u0002?\u0003B\u0011qeP\u0005\u0003\u0001\"\u0012A!\u00168ji\"9!iOA\u0001\u0002\u0004A\u0012a\u0001=%c!1A\t\u0001Q!\na\t\u0011c\u001e:baB,GmQ8mY\u0016\u001cGo\u001c:!\u0011%1\u0005\u00011AA\u0002\u0013\u0005q)\u0001\u0006uS6,w+\u001b8e_^,\u0012\u0001\u0013\t\u0003\u0013Jk\u0011A\u0013\u0006\u0003\u00172\u000bqa^5oI><8O\u0003\u0002N\u001d\u0006Iq/\u001b8e_^Lgn\u001a\u0006\u0003\u001fB\u000b1!\u00199j\u0015\t\t\u0006\"A\u0005tiJ,\u0017-\\5oO&\u00111K\u0013\u0002\u000b)&lWmV5oI><\b\"C+\u0001\u0001\u0004\u0005\r\u0011\"\u0001W\u00039!\u0018.\\3XS:$wn^0%KF$\"AP,\t\u000f\t#\u0016\u0011!a\u0001\u0011\"1\u0011\f\u0001Q!\n!\u000b1\u0002^5nK^Kg\u000eZ8xA!)1\f\u0001C!9\u000691m\u001c7mK\u000e$HC\u0001 ^\u0011\u0015q&\f1\u0001\u001f\u0003\u0019\u0011XmY8sI\")\u0001\r\u0001C!C\u0006)1\r\\8tKR\ta\b")
public class TimeWindowPropertyCollector
implements Collector<Row> {
    private final Option<Object> windowStartOffset;
    private final Option<Object> windowEndOffset;
    private Collector<Row> wrappedCollector;
    private TimeWindow timeWindow;

    public Collector<Row> wrappedCollector() {
        return this.wrappedCollector;
    }

    public void wrappedCollector_$eq(Collector<Row> x$1) {
        this.wrappedCollector = x$1;
    }

    public TimeWindow timeWindow() {
        return this.timeWindow;
    }

    public void timeWindow_$eq(TimeWindow x$1) {
        this.timeWindow = x$1;
    }

    public void collect(Row record) {
        int lastFieldPos = record.getArity() - 1;
        if (this.windowStartOffset.isDefined()) {
            record.setField(lastFieldPos + BoxesRunTime.unboxToInt((Object)this.windowStartOffset.get()), (Object)SqlFunctions.internalToTimestamp(this.timeWindow().getStart()));
        }
        if (this.windowEndOffset.isDefined()) {
            record.setField(lastFieldPos + BoxesRunTime.unboxToInt((Object)this.windowEndOffset.get()), (Object)SqlFunctions.internalToTimestamp(this.timeWindow().getEnd()));
        }
        this.wrappedCollector().collect((Object)record);
    }

    public void close() {
        this.wrappedCollector().close();
    }

    public TimeWindowPropertyCollector(Option<Object> windowStartOffset, Option<Object> windowEndOffset) {
        this.windowStartOffset = windowStartOffset;
        this.windowEndOffset = windowEndOffset;
    }
}

