/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.interpreter;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.DataContext;
import org.apache.calcite.interpreter.Context;
import org.apache.calcite.interpreter.Interpreter;
import org.apache.calcite.interpreter.Node;
import org.apache.calcite.interpreter.Row;
import org.apache.calcite.interpreter.Scalar;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Queryable;
import org.apache.calcite.linq4j.function.Function1;
import org.apache.calcite.linq4j.function.Predicate1;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.runtime.Enumerables;
import org.apache.calcite.schema.FilterableTable;
import org.apache.calcite.schema.ProjectableFilterableTable;
import org.apache.calcite.schema.QueryableTable;
import org.apache.calcite.schema.ScannableTable;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Schemas;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.calcite.util.Static;
import org.apache.calcite.util.Util;
import org.apache.calcite.util.mapping.Mapping;
import org.apache.calcite.util.mapping.Mappings;
import org.apache.flink.shaded.calcite.com.google.common.collect.ImmutableCollection;
import org.apache.flink.shaded.calcite.com.google.common.collect.ImmutableList;
import org.apache.flink.shaded.calcite.com.google.common.collect.Iterables;
import org.apache.flink.shaded.calcite.com.google.common.collect.Lists;

public class TableScanNode
implements Node {
    private TableScanNode(Interpreter interpreter, TableScan rel, Enumerable<Row> enumerable) {
        interpreter.enumerable(rel, enumerable);
    }

    @Override
    public void run() throws InterruptedException {
    }

    static TableScanNode create(Interpreter interpreter, TableScan rel, ImmutableList<RexNode> filters, ImmutableIntList projects) {
        RelOptTable relOptTable = rel.getTable();
        ProjectableFilterableTable pfTable = relOptTable.unwrap(ProjectableFilterableTable.class);
        if (pfTable != null) {
            return TableScanNode.createProjectableFilterable(interpreter, rel, filters, projects, pfTable);
        }
        FilterableTable filterableTable = relOptTable.unwrap(FilterableTable.class);
        if (filterableTable != null) {
            return TableScanNode.createFilterable(interpreter, rel, filters, projects, filterableTable);
        }
        ScannableTable scannableTable = relOptTable.unwrap(ScannableTable.class);
        if (scannableTable != null) {
            return TableScanNode.createScannable(interpreter, rel, filters, projects, scannableTable);
        }
        Enumerable enumerable = relOptTable.unwrap(Enumerable.class);
        if (enumerable != null) {
            return TableScanNode.createEnumerable(interpreter, rel, enumerable, null, filters, projects);
        }
        QueryableTable queryableTable = relOptTable.unwrap(QueryableTable.class);
        if (queryableTable != null) {
            return TableScanNode.createQueryable(interpreter, rel, filters, projects, queryableTable);
        }
        throw new AssertionError((Object)("cannot convert table " + relOptTable + " to enumerable"));
    }

    private static TableScanNode createScannable(Interpreter interpreter, TableScan rel, ImmutableList<RexNode> filters, ImmutableIntList projects, ScannableTable scannableTable) {
        Enumerable<Row> rowEnumerable = Enumerables.toRow(scannableTable.scan(interpreter.getDataContext()));
        return TableScanNode.createEnumerable(interpreter, rel, rowEnumerable, null, filters, projects);
    }

    private static TableScanNode createQueryable(Interpreter interpreter, TableScan rel, ImmutableList<RexNode> filters, ImmutableIntList projects, QueryableTable queryableTable) {
        Enumerable<Row> rowEnumerable;
        DataContext root = interpreter.getDataContext();
        RelOptTable relOptTable = rel.getTable();
        Type elementType = queryableTable.getElementType();
        SchemaPlus schema = root.getRootSchema();
        for (String name : Util.skipLast(relOptTable.getQualifiedName())) {
            schema = schema.getSubSchema(name);
        }
        if (elementType instanceof Class) {
            Queryable queryable = Schemas.queryable(root, (Class)elementType, relOptTable.getQualifiedName());
            ImmutableList.Builder fieldBuilder = ImmutableList.builder();
            Class type = (Class)elementType;
            for (Field field : type.getFields()) {
                if (!Modifier.isPublic(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) continue;
                fieldBuilder.add(field);
            }
            ImmutableCollection fields = fieldBuilder.build();
            rowEnumerable = queryable.select(new Function1<Object, Row>((List)((Object)fields)){
                final /* synthetic */ List val$fields;
                {
                    this.val$fields = list;
                }

                @Override
                public Row apply(Object o) {
                    Object[] values = new Object[this.val$fields.size()];
                    for (int i = 0; i < this.val$fields.size(); ++i) {
                        Field field = (Field)this.val$fields.get(i);
                        try {
                            values[i] = field.get(o);
                            continue;
                        }
                        catch (IllegalAccessException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    return new Row(values);
                }
            });
        } else {
            rowEnumerable = Schemas.queryable(root, Row.class, relOptTable.getQualifiedName());
        }
        return TableScanNode.createEnumerable(interpreter, rel, rowEnumerable, null, filters, projects);
    }

    private static TableScanNode createFilterable(Interpreter interpreter, TableScan rel, ImmutableList<RexNode> filters, ImmutableIntList projects, FilterableTable filterableTable) {
        DataContext root = interpreter.getDataContext();
        ArrayList<RexNode> mutableFilters = Lists.newArrayList(filters);
        Enumerable<Object[]> enumerable = filterableTable.scan(root, mutableFilters);
        for (RexNode filter : mutableFilters) {
            if (filters.contains(filter)) continue;
            throw Static.RESOURCE.filterableTableInventedFilter(filter.toString()).ex();
        }
        Enumerable<Row> rowEnumerable = Enumerables.toRow(enumerable);
        return TableScanNode.createEnumerable(interpreter, rel, rowEnumerable, null, mutableFilters, projects);
    }

    private static TableScanNode createProjectableFilterable(Interpreter interpreter, TableScan rel, ImmutableList<RexNode> filters, ImmutableIntList projects, ProjectableFilterableTable pfTable) {
        Enumerable<Object[]> enumerable1;
        ArrayList<RexNode> mutableFilters;
        int changeCount;
        DataContext root = interpreter.getDataContext();
        ImmutableIntList originalProjects = projects;
        do {
            mutableFilters = Lists.newArrayList(filters);
            int[] projectInts = projects == null || projects.equals(TableScan.identity(rel.getTable())) ? null : projects.toIntArray();
            enumerable1 = pfTable.scan(root, mutableFilters, projectInts);
            for (RexNode filter : mutableFilters) {
                if (filters.contains(filter)) continue;
                throw Static.RESOURCE.filterableTableInventedFilter(filter.toString()).ex();
            }
            ImmutableBitSet usedFields = RelOptUtil.InputFinder.bits(mutableFilters, null);
            if (projects == null) break;
            changeCount = 0;
            for (int usedField : usedFields) {
                if (projects.contains(usedField)) continue;
                projects = ImmutableIntList.copyOf(Iterables.concat(projects, ImmutableList.of(Integer.valueOf(usedField))));
                ++changeCount;
            }
        } while (changeCount > 0);
        Enumerable<Row> rowEnumerable = Enumerables.toRow(enumerable1);
        ImmutableIntList rejectedProjects = Objects.equals(projects, originalProjects) ? null : ImmutableIntList.identity(originalProjects.size());
        return TableScanNode.createEnumerable(interpreter, rel, rowEnumerable, projects, mutableFilters, rejectedProjects);
    }

    private static TableScanNode createEnumerable(Interpreter interpreter, TableScan rel, Enumerable<Row> enumerable, ImmutableIntList acceptedProjects, List<RexNode> rejectedFilters, final ImmutableIntList rejectedProjects) {
        if (!rejectedFilters.isEmpty()) {
            RelDataType inputRowType;
            RexNode filter2;
            RexNode filter = RexUtil.composeConjunction(rel.getCluster().getRexBuilder(), rejectedFilters, false);
            if (acceptedProjects == null) {
                filter2 = filter;
                inputRowType = rel.getRowType();
            } else {
                Mapping mapping = Mappings.target(acceptedProjects, rel.getTable().getRowType().getFieldCount());
                filter2 = RexUtil.apply((Mappings.TargetMapping)mapping, filter);
                RelDataTypeFactory.FieldInfoBuilder builder = rel.getCluster().getTypeFactory().builder();
                List<RelDataTypeField> fieldList = rel.getTable().getRowType().getFieldList();
                for (int acceptedProject : acceptedProjects) {
                    builder.add(fieldList.get(acceptedProject));
                }
                inputRowType = builder.build();
            }
            final Scalar condition = interpreter.compile(ImmutableList.of(filter2), inputRowType);
            final Context context = interpreter.createContext();
            enumerable = enumerable.where(new Predicate1<Row>(){

                @Override
                public boolean apply(Row row) {
                    context.values = row.getValues();
                    Boolean b = (Boolean)condition.execute(context);
                    return b != null && b != false;
                }
            });
        }
        if (rejectedProjects != null) {
            enumerable = enumerable.select(new Function1<Row, Row>(){
                final Object[] values;
                {
                    this.values = new Object[rejectedProjects.size()];
                }

                @Override
                public Row apply(Row row) {
                    Object[] inValues = row.getValues();
                    for (int i = 0; i < rejectedProjects.size(); ++i) {
                        this.values[i] = inValues[rejectedProjects.get(i)];
                    }
                    return Row.asCopy(this.values);
                }
            });
        }
        return new TableScanNode(interpreter, rel, enumerable);
    }
}

