/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.interpreter;

import java.util.ArrayList;
import org.apache.calcite.interpreter.Context;
import org.apache.calcite.interpreter.Interpreter;
import org.apache.calcite.interpreter.Node;
import org.apache.calcite.interpreter.Row;
import org.apache.calcite.interpreter.Scalar;
import org.apache.calcite.interpreter.Sink;
import org.apache.calcite.rel.core.Values;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.shaded.calcite.com.google.common.collect.ImmutableList;
import org.apache.flink.shaded.calcite.com.google.common.collect.Lists;

public class ValuesNode
implements Node {
    private final Sink sink;
    private final int fieldCount;
    private final ImmutableList<Row> rows;

    public ValuesNode(Interpreter interpreter, Values rel) {
        this.sink = interpreter.sink(rel);
        this.fieldCount = rel.getRowType().getFieldCount();
        this.rows = this.createRows(interpreter, rel.getTuples());
    }

    private ImmutableList<Row> createRows(Interpreter interpreter, ImmutableList<ImmutableList<RexLiteral>> tuples) {
        ArrayList<RexNode> nodes = Lists.newArrayList();
        for (ImmutableList immutableList : tuples) {
            nodes.addAll(immutableList);
        }
        Scalar scalar = interpreter.compile(nodes, null);
        Object[] objectArray = new Object[nodes.size()];
        Context context = interpreter.createContext();
        scalar.execute(context, objectArray);
        ImmutableList.Builder rows = ImmutableList.builder();
        Object[] subValues = new Object[this.fieldCount];
        for (int i = 0; i < objectArray.length; i += this.fieldCount) {
            System.arraycopy(objectArray, i, subValues, 0, this.fieldCount);
            rows.add(Row.asCopy(subValues));
        }
        return rows.build();
    }

    @Override
    public void run() throws InterruptedException {
        for (Row row : this.rows) {
            this.sink.send(row);
        }
        this.sink.end();
    }
}

