/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.plan;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.flink.shaded.calcite.com.google.common.base.Preconditions;
import org.apache.flink.shaded.calcite.com.google.common.collect.Iterables;

public class Strong {
    private static final Map<SqlKind, Policy> MAP = Strong.createPolicyMap();

    public static Strong of(final ImmutableBitSet nullColumns) {
        return new Strong(){

            @Override
            public boolean isNull(RexInputRef ref) {
                return nullColumns.get(ref.getIndex());
            }
        };
    }

    public static boolean isNull(RexNode node, ImmutableBitSet nullColumns) {
        return Strong.of(nullColumns).isNull(node);
    }

    public static boolean isNotTrue(RexNode node, ImmutableBitSet nullColumns) {
        return Strong.of(nullColumns).isNotTrue(node);
    }

    public static Policy policy(SqlKind kind) {
        return Preconditions.checkNotNull(MAP.get((Object)kind), (Object)kind);
    }

    public boolean isNotTrue(RexNode node) {
        switch (node.getKind()) {
            case IS_NOT_NULL: {
                return this.anyNull(((RexCall)node).getOperands());
            }
        }
        return this.isNull(node);
    }

    public boolean isNull(RexNode node) {
        switch (node.getKind()) {
            case LITERAL: {
                return ((RexLiteral)node).getValue() == null;
            }
            case AND: 
            case NOT: 
            case EQUALS: 
            case NOT_EQUALS: 
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL: 
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUAL: 
            case PLUS_PREFIX: 
            case MINUS_PREFIX: 
            case PLUS: 
            case TIMESTAMP_ADD: 
            case MINUS: 
            case TIMESTAMP_DIFF: 
            case TIMES: 
            case DIVIDE: 
            case CAST: 
            case REINTERPRET: 
            case TRIM: 
            case LTRIM: 
            case RTRIM: 
            case CEIL: 
            case FLOOR: 
            case EXTRACT: 
            case GREATEST: 
            case LEAST: {
                return this.anyNull(((RexCall)node).getOperands());
            }
            case OR: {
                return this.allNull(((RexCall)node).getOperands());
            }
            case INPUT_REF: {
                return this.isNull((RexInputRef)node);
            }
        }
        return false;
    }

    public boolean isNull(RexInputRef ref) {
        return false;
    }

    private boolean allNull(List<RexNode> operands) {
        for (RexNode operand : operands) {
            if (this.isNull(operand)) continue;
            return false;
        }
        return true;
    }

    private boolean anyNull(List<RexNode> operands) {
        for (RexNode operand : operands) {
            if (!this.isNull(operand)) continue;
            return true;
        }
        return false;
    }

    private static Map<SqlKind, Policy> createPolicyMap() {
        EnumMap<SqlKind, Policy> map2 = new EnumMap<SqlKind, Policy>(SqlKind.class);
        map2.put(SqlKind.INPUT_REF, Policy.AS_IS);
        map2.put(SqlKind.LOCAL_REF, Policy.AS_IS);
        map2.put(SqlKind.DYNAMIC_PARAM, Policy.AS_IS);
        map2.put(SqlKind.OTHER_FUNCTION, Policy.AS_IS);
        map2.put(SqlKind.CASE, Policy.AS_IS);
        map2.put(SqlKind.DECODE, Policy.AS_IS);
        map2.put(SqlKind.NULLIF, Policy.AS_IS);
        map2.put(SqlKind.COALESCE, Policy.AS_IS);
        map2.put(SqlKind.NVL, Policy.AS_IS);
        map2.put(SqlKind.AND, Policy.AS_IS);
        map2.put(SqlKind.OR, Policy.AS_IS);
        map2.put(SqlKind.LITERAL, Policy.CUSTOM);
        map2.put(SqlKind.EXISTS, Policy.NOT_NULL);
        map2.put(SqlKind.IS_DISTINCT_FROM, Policy.NOT_NULL);
        map2.put(SqlKind.IS_NOT_DISTINCT_FROM, Policy.NOT_NULL);
        map2.put(SqlKind.IS_NULL, Policy.NOT_NULL);
        map2.put(SqlKind.IS_NOT_NULL, Policy.NOT_NULL);
        map2.put(SqlKind.IS_TRUE, Policy.NOT_NULL);
        map2.put(SqlKind.IS_NOT_TRUE, Policy.NOT_NULL);
        map2.put(SqlKind.IS_FALSE, Policy.NOT_NULL);
        map2.put(SqlKind.IS_NOT_FALSE, Policy.NOT_NULL);
        map2.put(SqlKind.IS_DISTINCT_FROM, Policy.NOT_NULL);
        map2.put(SqlKind.IS_NOT_DISTINCT_FROM, Policy.NOT_NULL);
        map2.put(SqlKind.NOT, Policy.ANY);
        map2.put(SqlKind.EQUALS, Policy.ANY);
        map2.put(SqlKind.NOT_EQUALS, Policy.ANY);
        map2.put(SqlKind.LESS_THAN, Policy.ANY);
        map2.put(SqlKind.LESS_THAN_OR_EQUAL, Policy.ANY);
        map2.put(SqlKind.GREATER_THAN, Policy.ANY);
        map2.put(SqlKind.GREATER_THAN_OR_EQUAL, Policy.ANY);
        map2.put(SqlKind.LIKE, Policy.ANY);
        map2.put(SqlKind.SIMILAR, Policy.ANY);
        map2.put(SqlKind.PLUS_PREFIX, Policy.ANY);
        map2.put(SqlKind.MINUS_PREFIX, Policy.ANY);
        map2.put(SqlKind.PLUS, Policy.ANY);
        map2.put(SqlKind.MINUS, Policy.ANY);
        map2.put(SqlKind.TIMES, Policy.ANY);
        map2.put(SqlKind.DIVIDE, Policy.ANY);
        map2.put(SqlKind.CAST, Policy.ANY);
        map2.put(SqlKind.REINTERPRET, Policy.ANY);
        map2.put(SqlKind.TRIM, Policy.ANY);
        map2.put(SqlKind.LTRIM, Policy.ANY);
        map2.put(SqlKind.RTRIM, Policy.ANY);
        map2.put(SqlKind.CEIL, Policy.ANY);
        map2.put(SqlKind.FLOOR, Policy.ANY);
        map2.put(SqlKind.EXTRACT, Policy.ANY);
        map2.put(SqlKind.GREATEST, Policy.ANY);
        map2.put(SqlKind.LEAST, Policy.ANY);
        for (SqlKind k : Iterables.concat(SqlKind.EXPRESSION, SqlKind.AGGREGATE)) {
            if (map2.containsKey((Object)k)) continue;
            map2.put(k, Policy.AS_IS);
        }
        return map2;
    }

    public static enum Policy {
        NOT_NULL,
        CUSTOM,
        ANY,
        AS_IS;

    }
}

