/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.metadata;

import java.util.List;
import org.apache.calcite.adapter.enumerable.EnumerableInterpreter;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.Union;
import org.apache.calcite.rel.metadata.BuiltInMetadata;
import org.apache.calcite.rel.metadata.ChainedRelMetadataProvider;
import org.apache.calcite.rel.metadata.MetadataDef;
import org.apache.calcite.rel.metadata.MetadataHandler;
import org.apache.calcite.rel.metadata.ReflectiveRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.flink.shaded.calcite.com.google.common.collect.ImmutableList;

public class RelMdPercentageOriginalRows
implements MetadataHandler<BuiltInMetadata.PercentageOriginalRows> {
    private static final RelMdPercentageOriginalRows INSTANCE = new RelMdPercentageOriginalRows();
    public static final RelMetadataProvider SOURCE = ChainedRelMetadataProvider.of(ImmutableList.of(ReflectiveRelMetadataProvider.reflectiveSource(BuiltInMethod.PERCENTAGE_ORIGINAL_ROWS.method, INSTANCE), ReflectiveRelMetadataProvider.reflectiveSource(BuiltInMethod.CUMULATIVE_COST.method, INSTANCE), ReflectiveRelMetadataProvider.reflectiveSource(BuiltInMethod.NON_CUMULATIVE_COST.method, INSTANCE)));

    private RelMdPercentageOriginalRows() {
    }

    @Override
    public MetadataDef<BuiltInMetadata.PercentageOriginalRows> getDef() {
        return BuiltInMetadata.PercentageOriginalRows.DEF;
    }

    public Double getPercentageOriginalRows(Aggregate rel, RelMetadataQuery mq) {
        return mq.getPercentageOriginalRows(rel.getInput());
    }

    public Double getPercentageOriginalRows(Union rel, RelMetadataQuery mq) {
        double numerator = 0.0;
        double denominator = 0.0;
        for (RelNode input : rel.getInputs()) {
            double rowCount = mq.getRowCount(input);
            double percentage = mq.getPercentageOriginalRows(input);
            if (percentage == 0.0) continue;
            denominator += rowCount / percentage;
            numerator += rowCount;
        }
        return RelMdPercentageOriginalRows.quotientForPercentage(numerator, denominator);
    }

    public Double getPercentageOriginalRows(Join rel, RelMetadataQuery mq) {
        double left = mq.getPercentageOriginalRows(rel.getLeft());
        double right = mq.getPercentageOriginalRows(rel.getRight());
        return left * right;
    }

    public Double getPercentageOriginalRows(RelNode rel, RelMetadataQuery mq) {
        if (rel.getInputs().size() > 1) {
            return null;
        }
        if (rel.getInputs().size() == 0) {
            return 1.0;
        }
        RelNode child = rel.getInputs().get(0);
        Double childPercentage = mq.getPercentageOriginalRows(child);
        if (childPercentage == null) {
            return null;
        }
        Double relPercentage = RelMdPercentageOriginalRows.quotientForPercentage(mq.getRowCount(rel), mq.getRowCount(child));
        if (relPercentage == null) {
            return null;
        }
        double percent = relPercentage * childPercentage;
        if (percent < 0.0 || percent > 1.0) {
            return null;
        }
        return relPercentage * childPercentage;
    }

    public RelOptCost getCumulativeCost(RelNode rel, RelMetadataQuery mq) {
        RelOptCost cost = mq.getNonCumulativeCost(rel);
        List<RelNode> inputs = rel.getInputs();
        for (RelNode input : inputs) {
            cost = cost.plus(mq.getCumulativeCost(input));
        }
        return cost;
    }

    public RelOptCost getCumulativeCost(EnumerableInterpreter rel, RelMetadataQuery mq) {
        return mq.getNonCumulativeCost(rel);
    }

    public RelOptCost getNonCumulativeCost(RelNode rel, RelMetadataQuery mq) {
        return rel.computeSelfCost(rel.getCluster().getPlanner(), mq);
    }

    private static Double quotientForPercentage(Double numerator, Double denominator) {
        if (numerator == null || denominator == null) {
            return null;
        }
        if (denominator == 0.0) {
            return 1.0;
        }
        return numerator / denominator;
    }
}

