/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.plan.RelOptPredicateList;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.core.Union;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.mapping.Mapping;
import org.apache.calcite.util.mapping.Mappings;
import org.apache.flink.shaded.calcite.com.google.common.collect.ImmutableList;

public class UnionPullUpConstantsRule
extends RelOptRule {
    public static final UnionPullUpConstantsRule INSTANCE = new UnionPullUpConstantsRule(Union.class, RelFactories.LOGICAL_BUILDER);

    protected UnionPullUpConstantsRule(Class<? extends Union> unionClass, RelBuilderFactory relBuilderFactory) {
        super(UnionPullUpConstantsRule.operand(unionClass, UnionPullUpConstantsRule.any()), relBuilderFactory, null);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Union union = (Union)call.rel(0);
        int count = union.getRowType().getFieldCount();
        if (count == 1) {
            return;
        }
        RexBuilder rexBuilder = union.getCluster().getRexBuilder();
        RelMetadataQuery mq = RelMetadataQuery.instance();
        RelOptPredicateList predicates = mq.getPulledUpPredicates(union);
        if (predicates == null) {
            return;
        }
        HashMap constants = new HashMap();
        for (Map.Entry e : predicates.constantMap.entrySet()) {
            if (!(e.getKey() instanceof RexInputRef)) continue;
            constants.put(((RexInputRef)e.getKey()).getIndex(), e.getValue());
        }
        if (constants.isEmpty()) {
            return;
        }
        List<RelDataTypeField> fields = union.getRowType().getFieldList();
        AbstractCollection topChildExprs = new ArrayList<RexNode>();
        ArrayList<String> topChildExprsFields = new ArrayList<String>();
        ArrayList<RexNode> refs = new ArrayList<RexNode>();
        ImmutableBitSet.Builder refsIndexBuilder = ImmutableBitSet.builder();
        for (RelDataTypeField field : fields) {
            RexNode constant = (RexNode)constants.get(field.getIndex());
            if (constant != null) {
                topChildExprs.add(constant);
                topChildExprsFields.add(field.getName());
                continue;
            }
            RexInputRef expr = rexBuilder.makeInputRef(union, field.getIndex());
            topChildExprs.add(expr);
            topChildExprsFields.add(field.getName());
            refs.add(expr);
            refsIndexBuilder.set(field.getIndex());
        }
        ImmutableBitSet refsIndex = refsIndexBuilder.build();
        Mapping mapping = RelOptUtil.permutation(refs, union.getInput(0).getRowType()).inverse();
        topChildExprs = ImmutableList.copyOf(RexUtil.apply((Mappings.TargetMapping)mapping, topChildExprs));
        RelBuilder relBuilder = call.builder();
        for (RelNode input : union.getInputs()) {
            ArrayList<Pair<RexInputRef, String>> newChildExprs = new ArrayList<Pair<RexInputRef, String>>();
            for (int j2 : refsIndex) {
                newChildExprs.add(Pair.of(rexBuilder.makeInputRef(input, j2), input.getRowType().getFieldList().get(j2).getName()));
            }
            if (newChildExprs.isEmpty()) {
                newChildExprs.add(Pair.of(topChildExprs.get(0), topChildExprsFields.get(0)));
            }
            relBuilder.push(input);
            relBuilder.project(Pair.left(newChildExprs), Pair.right(newChildExprs));
        }
        relBuilder.union(union.all, union.getInputs().size());
        relBuilder.project(topChildExprs, topChildExprsFields);
        relBuilder.convert(union.getRowType(), false);
        call.transformTo(relBuilder.build());
    }
}

