/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.runtime;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.sql.Array;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import org.apache.calcite.DataContext;
import org.apache.calcite.avatica.util.ByteString;
import org.apache.calcite.avatica.util.DateTimeUtils;
import org.apache.calcite.avatica.util.Spaces;
import org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.calcite.linq4j.AbstractEnumerable;
import org.apache.calcite.linq4j.CartesianProductEnumerator;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.linq4j.Linq4j;
import org.apache.calcite.linq4j.function.Deterministic;
import org.apache.calcite.linq4j.function.Function1;
import org.apache.calcite.linq4j.function.NonDeterministic;
import org.apache.calcite.linq4j.tree.Primitive;
import org.apache.calcite.runtime.FlatLists;
import org.apache.calcite.runtime.Like;
import org.apache.calcite.util.Bug;
import org.apache.calcite.util.NumberUtil;
import org.apache.commons.lang3.StringUtils;

@Deterministic
public class SqlFunctions {
    private static final DecimalFormat DOUBLE_FORMAT = NumberUtil.decimalFormat("0.0E0");
    private static final TimeZone LOCAL_TZ = TimeZone.getDefault();
    private static final Function1<List<Object>, Enumerable<Object>> LIST_AS_ENUMERABLE = new Function1<List<Object>, Enumerable<Object>>(){

        @Override
        public Enumerable<Object> apply(List<Object> list) {
            return Linq4j.asEnumerable(list);
        }
    };
    private static final Function1<Object[], Enumerable<Object[]>> ARRAY_CARTESIAN_PRODUCT = new Function1<Object[], Enumerable<Object[]>>(){

        @Override
        public Enumerable<Object[]> apply(Object[] lists) {
            ArrayList enumerators = new ArrayList();
            for (Object list : lists) {
                enumerators.add(Linq4j.enumerator((List)list));
            }
            final Enumerator product2 = Linq4j.product(enumerators);
            return new AbstractEnumerable<Object[]>(){

                @Override
                public Enumerator<Object[]> enumerator() {
                    return Linq4j.transform(product2, new Function1<List<Object>, Object[]>(){

                        @Override
                        public Object[] apply(List<Object> list) {
                            return list.toArray();
                        }
                    });
                }
            };
        }
    };
    private static final ThreadLocal<Map<String, AtomicLong>> THREAD_SEQUENCES = new ThreadLocal<Map<String, AtomicLong>>(){

        @Override
        protected Map<String, AtomicLong> initialValue() {
            return new HashMap<String, AtomicLong>();
        }
    };

    private SqlFunctions() {
    }

    public static String substring(String s, int from, int for_) {
        return s.substring(from - 1, Math.min(from - 1 + for_, s.length()));
    }

    public static String substring(String s, int from) {
        return s.substring(from - 1);
    }

    public static ByteString substring(ByteString b, int from, int for_) {
        return b.substring(from - 1, Math.min(from - 1 + for_, b.length()));
    }

    public static ByteString substring(ByteString b, int from) {
        return b.substring(from - 1);
    }

    public static String upper(String s) {
        return s.toUpperCase(Locale.ROOT);
    }

    public static String lower(String s) {
        return s.toLowerCase(Locale.ROOT);
    }

    public static String initcap(String s) {
        int len = s.length();
        boolean start = true;
        StringBuilder newS = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            char curCh;
            char c = curCh = s.charAt(i);
            if (start) {
                if (c > '/' && c < ':') {
                    start = false;
                } else if (c > '@' && c < '[') {
                    start = false;
                } else if (c > '`' && c < '{') {
                    start = false;
                    curCh = (char)(c - 32);
                }
            } else if (c <= '/' || c >= ':') {
                if (c > '@' && c < '[') {
                    curCh = (char)(c + 32);
                } else if (c <= '`' || c >= '{') {
                    start = true;
                }
            }
            newS.append(curCh);
        }
        return newS.toString();
    }

    public static int charLength(String s) {
        return s.length();
    }

    public static String concat(String s0, String s1) {
        return s0 + s1;
    }

    public static ByteString concat(ByteString s0, ByteString s1) {
        return s0.concat(s1);
    }

    public static String rtrim(String s) {
        return SqlFunctions.trim_(s, false, true, ' ');
    }

    public static String ltrim(String s) {
        return SqlFunctions.trim_(s, true, false, ' ');
    }

    public static String trim(boolean leading, boolean trailing, String seek, String s) {
        return SqlFunctions.trim_(s, leading, trailing, seek.charAt(0));
    }

    private static String trim_(String s, boolean left, boolean right, char c) {
        int j2 = s.length();
        if (right) {
            while (true) {
                if (j2 == 0) {
                    return "";
                }
                if (s.charAt(j2 - 1) != c) break;
                --j2;
            }
        }
        int i = 0;
        if (left) {
            while (true) {
                if (i == j2) {
                    return "";
                }
                if (s.charAt(i) != c) break;
                ++i;
            }
        }
        return s.substring(i, j2);
    }

    public static ByteString trim(ByteString s) {
        return SqlFunctions.trim_(s, true, true);
    }

    public static ByteString rtrim(ByteString s) {
        return SqlFunctions.trim_(s, false, true);
    }

    private static ByteString trim_(ByteString s, boolean left, boolean right) {
        int j2 = s.length();
        if (right) {
            while (true) {
                if (j2 == 0) {
                    return ByteString.EMPTY;
                }
                if (s.byteAt(j2 - 1) != 0) break;
                --j2;
            }
        }
        int i = 0;
        if (left) {
            while (true) {
                if (i == j2) {
                    return ByteString.EMPTY;
                }
                if (s.byteAt(i) != 0) break;
                ++i;
            }
        }
        return s.substring(i, j2);
    }

    public static String overlay(String s, String r, int start) {
        if (s == null || r == null) {
            return null;
        }
        return s.substring(0, start - 1) + r + s.substring(start - 1 + r.length());
    }

    public static String overlay(String s, String r, int start, int length) {
        if (s == null || r == null) {
            return null;
        }
        return s.substring(0, start - 1) + r + s.substring(start - 1 + length);
    }

    public static ByteString overlay(ByteString s, ByteString r, int start) {
        if (s == null || r == null) {
            return null;
        }
        return s.substring(0, start - 1).concat(r).concat(s.substring(start - 1 + r.length()));
    }

    public static ByteString overlay(ByteString s, ByteString r, int start, int length) {
        if (s == null || r == null) {
            return null;
        }
        return s.substring(0, start - 1).concat(r).concat(s.substring(start - 1 + length));
    }

    public static boolean like(String s, String pattern) {
        String regex = Like.sqlToRegexLike(pattern, null);
        return Pattern.matches(regex, s);
    }

    public static boolean like(String s, String pattern, String escape) {
        String regex = Like.sqlToRegexLike(pattern, escape);
        return Pattern.matches(regex, s);
    }

    public static boolean similar(String s, String pattern) {
        String regex = Like.sqlToRegexSimilar(pattern, null);
        return Pattern.matches(regex, s);
    }

    public static boolean similar(String s, String pattern, String escape) {
        String regex = Like.sqlToRegexSimilar(pattern, escape);
        return Pattern.matches(regex, s);
    }

    public static boolean eq(BigDecimal b0, BigDecimal b1) {
        return b0.stripTrailingZeros().equals(b1.stripTrailingZeros());
    }

    public static boolean eq(Object b0, Object b1) {
        return b0.equals(b1);
    }

    public static boolean eqAny(Object b0, Object b1) {
        if (b0.getClass().equals(b1.getClass())) {
            if (BigDecimal.class.isInstance(b0)) {
                return SqlFunctions.eq((BigDecimal)b0, (BigDecimal)b1);
            }
            return b0.equals(b1);
        }
        if (SqlFunctions.allAssignable(Number.class, b0, b1)) {
            return SqlFunctions.eq(SqlFunctions.toBigDecimal((Number)b0), SqlFunctions.toBigDecimal((Number)b1));
        }
        return false;
    }

    private static boolean allAssignable(Class clazz, Object o0, Object o1) {
        return clazz.isInstance(o0) && clazz.isInstance(o1);
    }

    public static boolean ne(BigDecimal b0, BigDecimal b1) {
        return b0.compareTo(b1) != 0;
    }

    public static boolean ne(Object b0, Object b1) {
        return !SqlFunctions.eq(b0, b1);
    }

    public static boolean neAny(Object b0, Object b1) {
        return !SqlFunctions.eqAny(b0, b1);
    }

    public static boolean lt(boolean b0, boolean b1) {
        return SqlFunctions.compare(b0, b1) < 0;
    }

    public static boolean lt(String b0, String b1) {
        return b0.compareTo(b1) < 0;
    }

    public static boolean lt(ByteString b0, ByteString b1) {
        return b0.compareTo(b1) < 0;
    }

    public static boolean lt(BigDecimal b0, BigDecimal b1) {
        return b0.compareTo(b1) < 0;
    }

    public static boolean ltAny(Object b0, Object b1) {
        if (b0.getClass().equals(b1.getClass()) && b0 instanceof Comparable) {
            return ((Comparable)b0).compareTo(b1) < 0;
        }
        if (SqlFunctions.allAssignable(Number.class, b0, b1)) {
            return SqlFunctions.lt(SqlFunctions.toBigDecimal((Number)b0), SqlFunctions.toBigDecimal((Number)b1));
        }
        throw SqlFunctions.notComparable("<", b0, b1);
    }

    public static boolean le(boolean b0, boolean b1) {
        return SqlFunctions.compare(b0, b1) <= 0;
    }

    public static boolean le(String b0, String b1) {
        return b0.compareTo(b1) <= 0;
    }

    public static boolean le(ByteString b0, ByteString b1) {
        return b0.compareTo(b1) <= 0;
    }

    public static boolean le(BigDecimal b0, BigDecimal b1) {
        return b0.compareTo(b1) <= 0;
    }

    public static boolean leAny(Object b0, Object b1) {
        if (b0.getClass().equals(b1.getClass()) && b0 instanceof Comparable) {
            return ((Comparable)b0).compareTo(b1) <= 0;
        }
        if (SqlFunctions.allAssignable(Number.class, b0, b1)) {
            return SqlFunctions.le(SqlFunctions.toBigDecimal((Number)b0), SqlFunctions.toBigDecimal((Number)b1));
        }
        throw SqlFunctions.notComparable("<=", b0, b1);
    }

    public static boolean gt(boolean b0, boolean b1) {
        return SqlFunctions.compare(b0, b1) > 0;
    }

    public static boolean gt(String b0, String b1) {
        return b0.compareTo(b1) > 0;
    }

    public static boolean gt(ByteString b0, ByteString b1) {
        return b0.compareTo(b1) > 0;
    }

    public static boolean gt(BigDecimal b0, BigDecimal b1) {
        return b0.compareTo(b1) > 0;
    }

    public static boolean gtAny(Object b0, Object b1) {
        if (b0.getClass().equals(b1.getClass()) && b0 instanceof Comparable) {
            return ((Comparable)b0).compareTo(b1) > 0;
        }
        if (SqlFunctions.allAssignable(Number.class, b0, b1)) {
            return SqlFunctions.gt(SqlFunctions.toBigDecimal((Number)b0), SqlFunctions.toBigDecimal((Number)b1));
        }
        throw SqlFunctions.notComparable(">", b0, b1);
    }

    public static boolean ge(boolean b0, boolean b1) {
        return SqlFunctions.compare(b0, b1) >= 0;
    }

    public static boolean ge(String b0, String b1) {
        return b0.compareTo(b1) >= 0;
    }

    public static boolean ge(ByteString b0, ByteString b1) {
        return b0.compareTo(b1) >= 0;
    }

    public static boolean ge(BigDecimal b0, BigDecimal b1) {
        return b0.compareTo(b1) >= 0;
    }

    public static boolean geAny(Object b0, Object b1) {
        if (b0.getClass().equals(b1.getClass()) && b0 instanceof Comparable) {
            return ((Comparable)b0).compareTo(b1) >= 0;
        }
        if (SqlFunctions.allAssignable(Number.class, b0, b1)) {
            return SqlFunctions.ge(SqlFunctions.toBigDecimal((Number)b0), SqlFunctions.toBigDecimal((Number)b1));
        }
        throw SqlFunctions.notComparable(">=", b0, b1);
    }

    public static int plus(int b0, int b1) {
        return b0 + b1;
    }

    public static Integer plus(Integer b0, int b1) {
        return b0 == null ? null : Integer.valueOf(b0 + b1);
    }

    public static Integer plus(int b0, Integer b1) {
        return b1 == null ? null : Integer.valueOf(b0 + b1);
    }

    public static Integer plus(Integer b0, Integer b1) {
        return b0 == null || b1 == null ? null : Integer.valueOf(b0 + b1);
    }

    public static Long plus(Long b0, Integer b1) {
        return b0 == null || b1 == null ? null : Long.valueOf(b0 + b1.longValue());
    }

    public static Long plus(Integer b0, Long b1) {
        return b0 == null || b1 == null ? null : Long.valueOf(b0.longValue() + b1);
    }

    public static BigDecimal plus(BigDecimal b0, BigDecimal b1) {
        return b0 == null || b1 == null ? null : b0.add(b1);
    }

    public static Object plusAny(Object b0, Object b1) {
        if (b0 == null || b1 == null) {
            return null;
        }
        if (SqlFunctions.allAssignable(Number.class, b0, b1)) {
            return SqlFunctions.plus(SqlFunctions.toBigDecimal((Number)b0), SqlFunctions.toBigDecimal((Number)b1));
        }
        throw SqlFunctions.notArithmetic("+", b0, b1);
    }

    public static int minus(int b0, int b1) {
        return b0 - b1;
    }

    public static Integer minus(Integer b0, int b1) {
        return b0 == null ? null : Integer.valueOf(b0 - b1);
    }

    public static Integer minus(int b0, Integer b1) {
        return b1 == null ? null : Integer.valueOf(b0 - b1);
    }

    public static Integer minus(Integer b0, Integer b1) {
        return b0 == null || b1 == null ? null : Integer.valueOf(b0 - b1);
    }

    public static Long minus(Long b0, Integer b1) {
        return b0 == null || b1 == null ? null : Long.valueOf(b0 - b1.longValue());
    }

    public static Long minus(Integer b0, Long b1) {
        return b0 == null || b1 == null ? null : Long.valueOf(b0.longValue() - b1);
    }

    public static BigDecimal minus(BigDecimal b0, BigDecimal b1) {
        return b0 == null || b1 == null ? null : b0.subtract(b1);
    }

    public static Object minusAny(Object b0, Object b1) {
        if (b0 == null || b1 == null) {
            return null;
        }
        if (SqlFunctions.allAssignable(Number.class, b0, b1)) {
            return SqlFunctions.minus(SqlFunctions.toBigDecimal((Number)b0), SqlFunctions.toBigDecimal((Number)b1));
        }
        throw SqlFunctions.notArithmetic("-", b0, b1);
    }

    public static int divide(int b0, int b1) {
        return b0 / b1;
    }

    public static Integer divide(Integer b0, int b1) {
        return b0 == null ? null : Integer.valueOf(b0 / b1);
    }

    public static Integer divide(int b0, Integer b1) {
        return b1 == null ? null : Integer.valueOf(b0 / b1);
    }

    public static Integer divide(Integer b0, Integer b1) {
        return b0 == null || b1 == null ? null : Integer.valueOf(b0 / b1);
    }

    public static Long divide(Long b0, Integer b1) {
        return b0 == null || b1 == null ? null : Long.valueOf(b0 / b1.longValue());
    }

    public static Long divide(Integer b0, Long b1) {
        return b0 == null || b1 == null ? null : Long.valueOf(b0.longValue() / b1);
    }

    public static BigDecimal divide(BigDecimal b0, BigDecimal b1) {
        return b0 == null || b1 == null ? null : b0.divide(b1, MathContext.DECIMAL64);
    }

    public static Object divideAny(Object b0, Object b1) {
        if (b0 == null || b1 == null) {
            return null;
        }
        if (SqlFunctions.allAssignable(Number.class, b0, b1)) {
            return SqlFunctions.divide(SqlFunctions.toBigDecimal((Number)b0), SqlFunctions.toBigDecimal((Number)b1));
        }
        throw SqlFunctions.notArithmetic("/", b0, b1);
    }

    public static int divide(int b0, BigDecimal b1) {
        return BigDecimal.valueOf(b0).divide(b1, RoundingMode.HALF_DOWN).intValue();
    }

    public static long divide(long b0, BigDecimal b1) {
        return BigDecimal.valueOf(b0).divide(b1, RoundingMode.HALF_DOWN).longValue();
    }

    public static int multiply(int b0, int b1) {
        return b0 * b1;
    }

    public static Integer multiply(Integer b0, int b1) {
        return b0 == null ? null : Integer.valueOf(b0 * b1);
    }

    public static Integer multiply(int b0, Integer b1) {
        return b1 == null ? null : Integer.valueOf(b0 * b1);
    }

    public static Integer multiply(Integer b0, Integer b1) {
        return b0 == null || b1 == null ? null : Integer.valueOf(b0 * b1);
    }

    public static Long multiply(Long b0, Integer b1) {
        return b0 == null || b1 == null ? null : Long.valueOf(b0 * b1.longValue());
    }

    public static Long multiply(Integer b0, Long b1) {
        return b0 == null || b1 == null ? null : Long.valueOf(b0.longValue() * b1);
    }

    public static BigDecimal multiply(BigDecimal b0, BigDecimal b1) {
        return b0 == null || b1 == null ? null : b0.multiply(b1);
    }

    public static Object multiplyAny(Object b0, Object b1) {
        if (b0 == null || b1 == null) {
            return null;
        }
        if (SqlFunctions.allAssignable(Number.class, b0, b1)) {
            return SqlFunctions.multiply(SqlFunctions.toBigDecimal((Number)b0), SqlFunctions.toBigDecimal((Number)b1));
        }
        throw SqlFunctions.notArithmetic("*", b0, b1);
    }

    private static IllegalArgumentException notArithmetic(String op, Object b0, Object b1) {
        return new IllegalArgumentException("Invalid types for arithmetic: " + b0.getClass() + " " + op + " " + b1.getClass());
    }

    private static IllegalArgumentException notComparable(String op, Object b0, Object b1) {
        return new IllegalArgumentException("Invalid types for comparison: " + b0.getClass() + " " + op + " " + b1.getClass());
    }

    public static double exp(double b0) {
        return Math.exp(b0);
    }

    public static double exp(BigDecimal b0) {
        return Math.exp(b0.doubleValue());
    }

    public static double exp(long b0) {
        return Math.exp(b0);
    }

    public static double power(double b0, double b1) {
        return Math.pow(b0, b1);
    }

    public static double power(long b0, long b1) {
        return Math.pow(b0, b1);
    }

    public static double power(BigDecimal b0, BigDecimal b1) {
        return Math.pow(b0.doubleValue(), b1.doubleValue());
    }

    public static double power(long b0, BigDecimal b1) {
        return Math.pow(b0, b1.doubleValue());
    }

    public static double ln(double d) {
        return Math.log(d);
    }

    public static double ln(long b0) {
        return Math.log(b0);
    }

    public static double ln(BigDecimal d) {
        return Math.log(d.doubleValue());
    }

    public static double log10(double b0) {
        return Math.log10(b0);
    }

    public static double log10(long b0) {
        return Math.log10(b0);
    }

    public static double log10(BigDecimal d) {
        return Math.log10(d.doubleValue());
    }

    public static byte mod(byte b0, byte b1) {
        return (byte)(b0 % b1);
    }

    public static short mod(short b0, short b1) {
        return (short)(b0 % b1);
    }

    public static int mod(int b0, int b1) {
        return b0 % b1;
    }

    public static long mod(long b0, long b1) {
        return b0 % b1;
    }

    public static BigDecimal mod(BigDecimal b0, int b1) {
        return SqlFunctions.mod(b0, BigDecimal.valueOf(b1));
    }

    public static int mod(int b0, BigDecimal b1) {
        return SqlFunctions.mod(b0, b1.intValue());
    }

    public static BigDecimal mod(BigDecimal b0, BigDecimal b1) {
        BigDecimal[] bigDecimals = b0.divideAndRemainder(b1);
        return bigDecimals[1];
    }

    public static double floor(double b0) {
        return Math.floor(b0);
    }

    public static float floor(float b0) {
        return (float)Math.floor(b0);
    }

    public static BigDecimal floor(BigDecimal b0) {
        return b0.setScale(0, RoundingMode.FLOOR);
    }

    public static byte floor(byte b0, byte b1) {
        return (byte)SqlFunctions.floor((int)b0, (int)b1);
    }

    public static short floor(short b0, short b1) {
        return (short)SqlFunctions.floor((int)b0, (int)b1);
    }

    public static int floor(int b0, int b1) {
        int r = b0 % b1;
        if (r < 0) {
            r += b1;
        }
        return b0 - r;
    }

    public static long floor(long b0, long b1) {
        long r = b0 % b1;
        if (r < 0L) {
            r += b1;
        }
        return b0 - r;
    }

    public static BigDecimal floor(BigDecimal b0, int b1) {
        return SqlFunctions.floor(b0, BigDecimal.valueOf(b1));
    }

    public static int floor(int b0, BigDecimal b1) {
        return SqlFunctions.floor(b0, b1.intValue());
    }

    public static BigDecimal floor(BigDecimal b0, BigDecimal b1) {
        BigDecimal[] bigDecimals = b0.divideAndRemainder(b1);
        BigDecimal r = bigDecimals[1];
        if (r.signum() < 0) {
            r = r.add(b1);
        }
        return b0.subtract(r);
    }

    public static double ceil(double b0) {
        return Math.ceil(b0);
    }

    public static float ceil(float b0) {
        return (float)Math.ceil(b0);
    }

    public static BigDecimal ceil(BigDecimal b0) {
        return b0.setScale(0, RoundingMode.CEILING);
    }

    public static byte ceil(byte b0, byte b1) {
        return SqlFunctions.floor((byte)(b0 + b1 - 1), b1);
    }

    public static short ceil(short b0, short b1) {
        return SqlFunctions.floor((short)(b0 + b1 - 1), b1);
    }

    public static int ceil(int b0, int b1) {
        int r = b0 % b1;
        if (r > 0) {
            r -= b1;
        }
        return b0 - r;
    }

    public static long ceil(long b0, long b1) {
        return SqlFunctions.floor(b0 + b1 - 1L, b1);
    }

    public static BigDecimal ceil(BigDecimal b0, int b1) {
        return SqlFunctions.ceil(b0, BigDecimal.valueOf(b1));
    }

    public static int ceil(int b0, BigDecimal b1) {
        return SqlFunctions.ceil(b0, b1.intValue());
    }

    public static BigDecimal ceil(BigDecimal b0, BigDecimal b1) {
        BigDecimal[] bigDecimals = b0.divideAndRemainder(b1);
        BigDecimal r = bigDecimals[1];
        if (r.signum() > 0) {
            r = r.subtract(b1);
        }
        return b0.subtract(r);
    }

    public static byte abs(byte b0) {
        return (byte)Math.abs(b0);
    }

    public static short abs(short b0) {
        return (short)Math.abs(b0);
    }

    public static int abs(int b0) {
        return Math.abs(b0);
    }

    public static long abs(long b0) {
        return Math.abs(b0);
    }

    public static float abs(float b0) {
        return Math.abs(b0);
    }

    public static double abs(double b0) {
        return Math.abs(b0);
    }

    public static BigDecimal abs(BigDecimal b0) {
        return b0.abs();
    }

    public static double acos(long b0) {
        return Math.acos(b0);
    }

    public static double acos(BigDecimal b0) {
        return Math.acos(b0.doubleValue());
    }

    public static double acos(double b0) {
        return Math.acos(b0);
    }

    public static double asin(long b0) {
        return Math.asin(b0);
    }

    public static double asin(BigDecimal b0) {
        return Math.asin(b0.doubleValue());
    }

    public static double asin(double b0) {
        return Math.asin(b0);
    }

    public static double atan(long b0) {
        return Math.atan(b0);
    }

    public static double atan(BigDecimal b0) {
        return Math.atan(b0.doubleValue());
    }

    public static double atan(double b0) {
        return Math.atan(b0);
    }

    public static double atan2(long b0, long b1) {
        return Math.atan2(b0, b1);
    }

    public static double atan2(long b0, BigDecimal b1) {
        return Math.atan2(b0, b1.doubleValue());
    }

    public static double atan2(BigDecimal b0, BigDecimal b1) {
        return Math.atan2(b0.doubleValue(), b1.doubleValue());
    }

    public static double atan2(double b0, double b1) {
        return Math.atan2(b0, b1);
    }

    public static double cos(long b0) {
        return Math.cos(b0);
    }

    public static double cos(BigDecimal b0) {
        return Math.cos(b0.doubleValue());
    }

    public static double cos(double b0) {
        return Math.cos(b0);
    }

    public static double cot(long b0) {
        return 1.0 / Math.tan(b0);
    }

    public static double cot(BigDecimal b0) {
        return 1.0 / Math.tan(b0.doubleValue());
    }

    public static double cot(double b0) {
        return 1.0 / Math.tan(b0);
    }

    public static double degrees(long b0) {
        return Math.toDegrees(b0);
    }

    public static double degrees(BigDecimal b0) {
        return Math.toDegrees(b0.doubleValue());
    }

    public static double degrees(double b0) {
        return Math.toDegrees(b0);
    }

    public static double radians(long b0) {
        return Math.toRadians(b0);
    }

    public static double radians(BigDecimal b0) {
        return Math.toRadians(b0.doubleValue());
    }

    public static double radians(double b0) {
        return Math.toRadians(b0);
    }

    public static int sround(int b0, int b1) {
        return SqlFunctions.sround(BigDecimal.valueOf(b0), b1).intValue();
    }

    public static long sround(long b0, int b1) {
        return SqlFunctions.sround(BigDecimal.valueOf(b0), b1).longValue();
    }

    public static BigDecimal sround(BigDecimal b0, int b1) {
        return b0.movePointRight(b1).setScale(0, RoundingMode.HALF_UP).movePointLeft(b1);
    }

    public static double sround(double b0, int b1) {
        return SqlFunctions.sround(BigDecimal.valueOf(b0), b1).doubleValue();
    }

    public static int struncate(int b0, int b1) {
        return SqlFunctions.struncate(BigDecimal.valueOf(b0), b1).intValue();
    }

    public static long struncate(long b0, int b1) {
        return SqlFunctions.struncate(BigDecimal.valueOf(b0), b1).longValue();
    }

    public static BigDecimal struncate(BigDecimal b0, int b1) {
        return b0.movePointRight(b1).setScale(0, RoundingMode.DOWN).movePointLeft(b1);
    }

    public static double struncate(double b0, int b1) {
        return SqlFunctions.struncate(BigDecimal.valueOf(b0), b1).doubleValue();
    }

    public static int sign(int b0) {
        return Integer.signum(b0);
    }

    public static long sign(long b0) {
        return Long.signum(b0);
    }

    public static BigDecimal sign(BigDecimal b0) {
        return BigDecimal.valueOf(b0.signum());
    }

    public static double sign(double b0) {
        return Math.signum(b0);
    }

    public static double sin(long b0) {
        return Math.sin(b0);
    }

    public static double sin(BigDecimal b0) {
        return Math.sin(b0.doubleValue());
    }

    public static double sin(double b0) {
        return Math.sin(b0);
    }

    public static double tan(long b0) {
        return Math.tan(b0);
    }

    public static double tan(BigDecimal b0) {
        return Math.tan(b0.doubleValue());
    }

    public static double tan(double b0) {
        return Math.tan(b0);
    }

    public static <T extends Comparable<T>> T lesser(T b0, T b1) {
        return b0 == null || b0.compareTo(b1) > 0 ? b1 : b0;
    }

    public static <T extends Comparable<T>> T least(T b0, T b1) {
        return b0 == null || b1 != null && b0.compareTo(b1) > 0 ? b1 : b0;
    }

    public static boolean greater(boolean b0, boolean b1) {
        return b0 || b1;
    }

    public static boolean lesser(boolean b0, boolean b1) {
        return b0 && b1;
    }

    public static byte greater(byte b0, byte b1) {
        return b0 > b1 ? b0 : b1;
    }

    public static byte lesser(byte b0, byte b1) {
        return b0 > b1 ? b1 : b0;
    }

    public static char greater(char b0, char b1) {
        return b0 > b1 ? b0 : b1;
    }

    public static char lesser(char b0, char b1) {
        return b0 > b1 ? b1 : b0;
    }

    public static short greater(short b0, short b1) {
        return b0 > b1 ? b0 : b1;
    }

    public static short lesser(short b0, short b1) {
        return b0 > b1 ? b1 : b0;
    }

    public static int greater(int b0, int b1) {
        return b0 > b1 ? b0 : b1;
    }

    public static int lesser(int b0, int b1) {
        return b0 > b1 ? b1 : b0;
    }

    public static long greater(long b0, long b1) {
        return b0 > b1 ? b0 : b1;
    }

    public static long lesser(long b0, long b1) {
        return b0 > b1 ? b1 : b0;
    }

    public static float greater(float b0, float b1) {
        return b0 > b1 ? b0 : b1;
    }

    public static float lesser(float b0, float b1) {
        return b0 > b1 ? b1 : b0;
    }

    public static double greater(double b0, double b1) {
        return b0 > b1 ? b0 : b1;
    }

    public static double lesser(double b0, double b1) {
        return b0 > b1 ? b1 : b0;
    }

    public static <T extends Comparable<T>> T greater(T b0, T b1) {
        return b0 == null || b0.compareTo(b1) < 0 ? b1 : b0;
    }

    public static <T extends Comparable<T>> T greatest(T b0, T b1) {
        return b0 == null || b1 != null && b0.compareTo(b1) < 0 ? b1 : b0;
    }

    public static int compare(boolean x, boolean y) {
        return x == y ? 0 : (x ? 1 : -1);
    }

    public static String toString(float x) {
        if (x == 0.0f) {
            return "0E0";
        }
        BigDecimal bigDecimal = new BigDecimal(x, MathContext.DECIMAL32).stripTrailingZeros();
        String s = bigDecimal.toString();
        return s.replaceAll("0*E", "E").replace("E+", "E");
    }

    public static String toString(double x) {
        if (x == 0.0) {
            return "0E0";
        }
        BigDecimal bigDecimal = new BigDecimal(x, MathContext.DECIMAL64).stripTrailingZeros();
        String s = bigDecimal.toString();
        return s.replaceAll("0*E", "E").replace("E+", "E");
    }

    public static String toString(BigDecimal x) {
        String s = x.toString();
        if (s.startsWith("0")) {
            return s.substring(1);
        }
        if (s.startsWith("-0")) {
            return "-" + s.substring(2);
        }
        return s;
    }

    public static String toString(boolean x) {
        return x ? "TRUE" : "FALSE";
    }

    @NonDeterministic
    private static Object cannotConvert(Object o, Class toType) {
        throw new RuntimeException("Cannot convert " + o + " to " + toType);
    }

    public static boolean toBoolean(String s) {
        if ((s = SqlFunctions.trim_(s, true, true, ' ')).equalsIgnoreCase("TRUE")) {
            return true;
        }
        if (s.equalsIgnoreCase("FALSE")) {
            return false;
        }
        throw new RuntimeException("Invalid character for cast");
    }

    public static boolean toBoolean(Number number) {
        return !number.equals(0);
    }

    public static boolean toBoolean(Object o) {
        return o instanceof Boolean ? (Boolean)o : (o instanceof Number ? SqlFunctions.toBoolean((Number)o) : (o instanceof String ? SqlFunctions.toBoolean((String)o) : (Boolean)SqlFunctions.cannotConvert(o, Boolean.TYPE)));
    }

    public static byte toByte(Object o) {
        return o instanceof Byte ? (Byte)o : (o instanceof Number ? SqlFunctions.toByte((Number)o) : Byte.parseByte(o.toString()));
    }

    public static byte toByte(Number number) {
        return number.byteValue();
    }

    public static char toChar(String s) {
        return s.charAt(0);
    }

    public static Character toCharBoxed(String s) {
        return Character.valueOf(s.charAt(0));
    }

    public static short toShort(String s) {
        return Short.parseShort(s.trim());
    }

    public static short toShort(Number number) {
        return number.shortValue();
    }

    public static short toShort(Object o) {
        return o instanceof Short ? (Short)o : (o instanceof Number ? SqlFunctions.toShort((Number)o) : (o instanceof String ? SqlFunctions.toShort((String)o) : (Short)SqlFunctions.cannotConvert(o, Short.TYPE)));
    }

    public static int toInt(java.util.Date v) {
        return SqlFunctions.toInt(v, LOCAL_TZ);
    }

    public static int toInt(java.util.Date v, TimeZone timeZone) {
        return (int)(SqlFunctions.toLong(v, timeZone) / 86400000L);
    }

    public static Integer toIntOptional(java.util.Date v) {
        return v == null ? null : Integer.valueOf(SqlFunctions.toInt(v));
    }

    public static Integer toIntOptional(java.util.Date v, TimeZone timeZone) {
        return v == null ? null : Integer.valueOf(SqlFunctions.toInt(v, timeZone));
    }

    public static long toLong(java.util.Date v) {
        return SqlFunctions.toLong(v, LOCAL_TZ);
    }

    public static int toInt(Time v) {
        return (int)(SqlFunctions.toLong(v) % 86400000L);
    }

    public static Integer toIntOptional(Time v) {
        return v == null ? null : Integer.valueOf(SqlFunctions.toInt(v));
    }

    public static int toInt(String s) {
        return Integer.parseInt(s.trim());
    }

    public static int toInt(Number number) {
        return number.intValue();
    }

    public static int toInt(Object o) {
        return o instanceof Integer ? (Integer)o : (o instanceof Number ? SqlFunctions.toInt((Number)o) : (o instanceof String ? SqlFunctions.toInt((String)o) : (o instanceof java.util.Date ? SqlFunctions.toInt((java.util.Date)o) : (Integer)SqlFunctions.cannotConvert(o, Integer.TYPE))));
    }

    public static long toLong(Timestamp v) {
        return SqlFunctions.toLong(v, LOCAL_TZ);
    }

    public static long toLong(java.util.Date v, TimeZone timeZone) {
        long time = v.getTime();
        return time + (long)timeZone.getOffset(time);
    }

    public static Long toLongOptional(java.util.Date v) {
        return v == null ? null : Long.valueOf(SqlFunctions.toLong(v, LOCAL_TZ));
    }

    public static Long toLongOptional(Timestamp v, TimeZone timeZone) {
        if (v == null) {
            return null;
        }
        return SqlFunctions.toLong(v, LOCAL_TZ);
    }

    public static long toLong(String s) {
        if (s.startsWith("199") && s.contains(":")) {
            return Timestamp.valueOf(s).getTime();
        }
        return Long.parseLong(s.trim());
    }

    public static long toLong(Number number) {
        return number.longValue();
    }

    public static long toLong(Object o) {
        return o instanceof Long ? (Long)o : (o instanceof Number ? SqlFunctions.toLong((Number)o) : (o instanceof String ? SqlFunctions.toLong((String)o) : (Long)SqlFunctions.cannotConvert(o, Long.TYPE)));
    }

    public static float toFloat(String s) {
        return Float.parseFloat(s.trim());
    }

    public static float toFloat(Number number) {
        return number.floatValue();
    }

    public static float toFloat(Object o) {
        return o instanceof Float ? ((Float)o).floatValue() : (o instanceof Number ? SqlFunctions.toFloat((Number)o) : (o instanceof String ? SqlFunctions.toFloat((String)o) : ((Float)SqlFunctions.cannotConvert(o, Float.TYPE)).floatValue()));
    }

    public static double toDouble(String s) {
        return Double.parseDouble(s.trim());
    }

    public static double toDouble(Number number) {
        return number.doubleValue();
    }

    public static double toDouble(Object o) {
        return o instanceof Double ? (Double)o : (o instanceof Number ? SqlFunctions.toDouble((Number)o) : (o instanceof String ? SqlFunctions.toDouble((String)o) : (Double)SqlFunctions.cannotConvert(o, Double.TYPE)));
    }

    public static BigDecimal toBigDecimal(String s) {
        return new BigDecimal(s.trim());
    }

    public static BigDecimal toBigDecimal(Number number) {
        return number instanceof BigDecimal ? (BigDecimal)number : (number instanceof BigInteger ? new BigDecimal((BigInteger)number) : (number instanceof Long ? new BigDecimal(number.longValue()) : new BigDecimal(number.doubleValue())));
    }

    public static BigDecimal toBigDecimal(Object o) {
        return o instanceof Number ? SqlFunctions.toBigDecimal((Number)o) : SqlFunctions.toBigDecimal(o.toString());
    }

    public static Date internalToDate(int v) {
        long t = (long)v * 86400000L;
        return new Date(t - (long)LOCAL_TZ.getOffset(t));
    }

    public static Date internalToDate(Integer v) {
        return v == null ? null : SqlFunctions.internalToDate((int)v);
    }

    public static Time internalToTime(int v) {
        return new Time(v - LOCAL_TZ.getOffset(v));
    }

    public static Time internalToTime(Integer v) {
        return v == null ? null : SqlFunctions.internalToTime((int)v);
    }

    public static Timestamp internalToTimestamp(long v) {
        return new Timestamp(v - (long)LOCAL_TZ.getOffset(v));
    }

    public static Timestamp internalToTimestamp(Long v) {
        return v == null ? null : SqlFunctions.internalToTimestamp((long)v);
    }

    public static String truncate(String s, int maxLength) {
        if (s == null) {
            return null;
        }
        if (s.length() > maxLength) {
            return s.substring(0, maxLength);
        }
        return s;
    }

    public static String truncateOrPad(String s, int maxLength) {
        if (s == null) {
            return null;
        }
        int length = s.length();
        if (length > maxLength) {
            return s.substring(0, maxLength);
        }
        return length < maxLength ? Spaces.padRight(s, maxLength) : s;
    }

    public static ByteString truncate(ByteString s, int maxLength) {
        if (s == null) {
            return null;
        }
        if (s.length() > maxLength) {
            return s.substring(0, maxLength);
        }
        return s;
    }

    public static ByteString truncateOrPad(ByteString s, int maxLength) {
        if (s == null) {
            return null;
        }
        int length = s.length();
        if (length > maxLength) {
            return s.substring(0, maxLength);
        }
        if (length < maxLength) {
            return s.concat(new ByteString(new byte[maxLength - length]));
        }
        return s;
    }

    public static int position(String seek, String s) {
        return s.indexOf(seek) + 1;
    }

    public static int position(ByteString seek, ByteString s) {
        return s.indexOf(seek) + 1;
    }

    public static int position(String seek, String s, int from) {
        int from0 = from - 1;
        if (from0 > s.length() || from0 < 0) {
            return 0;
        }
        return s.indexOf(seek, from0) + 1;
    }

    public static int position(ByteString seek, ByteString s, int from) {
        int from0 = from - 1;
        if (from0 > s.length() || from0 < 0) {
            return 0;
        }
        Bug.upgrade("in avatica-1.9, use ByteString.substring(ByteString, int)");
        int p = s.substring(from0).indexOf(seek);
        if (p < 0) {
            return 0;
        }
        return p + from;
    }

    public static long round(long v, long x) {
        return SqlFunctions.truncate(v + x / 2L, x);
    }

    public static long truncate(long v, long x) {
        long remainder = v % x;
        if (remainder < 0L) {
            remainder += x;
        }
        return v - remainder;
    }

    public static int round(int v, int x) {
        return SqlFunctions.truncate(v + x / 2, x);
    }

    public static int truncate(int v, int x) {
        int remainder = v % x;
        if (remainder < 0) {
            remainder += x;
        }
        return v - remainder;
    }

    @NonDeterministic
    public static long currentTimestamp(DataContext root) {
        return (Long)DataContext.Variable.CURRENT_TIMESTAMP.get(root);
    }

    @NonDeterministic
    public static int currentTime(DataContext root) {
        int time = (int)(SqlFunctions.currentTimestamp(root) % 86400000L);
        if (time < 0) {
            time = (int)((long)time + 86400000L);
        }
        return time;
    }

    @NonDeterministic
    public static int currentDate(DataContext root) {
        long timestamp = SqlFunctions.currentTimestamp(root);
        int date = (int)(timestamp / 86400000L);
        int time = (int)(timestamp % 86400000L);
        if (time < 0) {
            --date;
        }
        return date;
    }

    @NonDeterministic
    public static long localTimestamp(DataContext root) {
        return (Long)DataContext.Variable.LOCAL_TIMESTAMP.get(root);
    }

    @NonDeterministic
    public static int localTime(DataContext root) {
        return (int)(SqlFunctions.localTimestamp(root) % 86400000L);
    }

    public static String translate3(String s, String search, String replacement) {
        return StringUtils.replaceChars((String)s, (String)search, (String)replacement);
    }

    public static String replace(String s, String search, String replacement) {
        return s.replace(search, replacement);
    }

    public static Object arrayItem(List list, int item) {
        if (item < 1 || item > list.size()) {
            return null;
        }
        return list.get(item - 1);
    }

    public static Object mapItem(Map map2, Object item) {
        return map2.get(item);
    }

    public static Object item(Object object, Object index) {
        if (object instanceof Map) {
            return SqlFunctions.mapItem((Map)object, index);
        }
        if (object instanceof List && index instanceof Number) {
            return SqlFunctions.arrayItem((List)object, ((Number)index).intValue());
        }
        return null;
    }

    public static Object arrayItemOptional(List list, int item) {
        if (list == null) {
            return null;
        }
        return SqlFunctions.arrayItem(list, item);
    }

    public static Object mapItemOptional(Map map2, Object item) {
        if (map2 == null) {
            return null;
        }
        return SqlFunctions.mapItem(map2, item);
    }

    public static Object itemOptional(Object object, Object index) {
        if (object == null) {
            return null;
        }
        return SqlFunctions.item(object, index);
    }

    public static boolean isTrue(Boolean b) {
        return b != null && b != false;
    }

    public static boolean isFalse(Boolean b) {
        return b != null && b == false;
    }

    public static boolean isNotTrue(Boolean b) {
        return b == null || b == false;
    }

    public static boolean isNotFalse(Boolean b) {
        return b == null || b != false;
    }

    public static Boolean not(Boolean b) {
        return b == null ? null : Boolean.valueOf(b == false);
    }

    public static List arrayToList(Array a) {
        if (a == null) {
            return null;
        }
        try {
            return Primitive.asList(a.getArray());
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @NonDeterministic
    public static long sequenceCurrentValue(String key) {
        return SqlFunctions.getAtomicLong(key).get();
    }

    @NonDeterministic
    public static long sequenceNextValue(String key) {
        return SqlFunctions.getAtomicLong(key).incrementAndGet();
    }

    private static AtomicLong getAtomicLong(String key) {
        Map<String, AtomicLong> map2 = THREAD_SEQUENCES.get();
        AtomicLong atomic = map2.get(key);
        if (atomic == null) {
            atomic = new AtomicLong();
            map2.put(key, atomic);
        }
        return atomic;
    }

    public static List slice(List list) {
        return list;
    }

    public static Object element(List list) {
        switch (list.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return list.get(0);
            }
        }
        throw new RuntimeException("more than one value");
    }

    public static Function1<Object, Enumerable<FlatLists.ComparableList<Comparable>>> flatProduct(final int[] fieldCounts, final boolean withOrdinality, final FlatProductInputType[] inputTypes) {
        if (fieldCounts.length == 1) {
            if (!withOrdinality && inputTypes[0] == FlatProductInputType.SCALAR) {
                return LIST_AS_ENUMERABLE;
            }
            return new Function1<Object, Enumerable<FlatLists.ComparableList<Comparable>>>(){

                @Override
                public Enumerable<FlatLists.ComparableList<Comparable>> apply(Object row) {
                    return SqlFunctions.p2(new Object[]{row}, fieldCounts, withOrdinality, inputTypes);
                }
            };
        }
        return new Function1<Object, Enumerable<FlatLists.ComparableList<Comparable>>>(){

            @Override
            public Enumerable<FlatLists.ComparableList<Comparable>> apply(Object lists) {
                return SqlFunctions.p2((Object[])lists, fieldCounts, withOrdinality, inputTypes);
            }
        };
    }

    private static Enumerable<FlatLists.ComparableList<Comparable>> p2(Object[] lists, int[] fieldCounts, boolean withOrdinality, FlatProductInputType[] inputTypes) {
        ArrayList<Enumerator<List<Enumerator<List<Comparable<Object>>>>>> enumerators = new ArrayList<Enumerator<List<Enumerator<List<Comparable<Object>>>>>>();
        int totalFieldCount = 0;
        for (int i = 0; i < lists.length; ++i) {
            int fieldCount = fieldCounts[i];
            FlatProductInputType inputType = inputTypes[i];
            Object inputObject = lists[i];
            switch (inputType) {
                case SCALAR: {
                    List list = (List)inputObject;
                    enumerators.add(Linq4j.transform(Linq4j.enumerator(list), new Function1<Comparable, List<Comparable>>(){

                        @Override
                        public List<Comparable> apply(Comparable a0) {
                            return FlatLists.of(a0);
                        }
                    }));
                    break;
                }
                case LIST: {
                    List listList = (List)inputObject;
                    enumerators.add(Linq4j.enumerator(listList));
                    break;
                }
                case MAP: {
                    Map map2 = (Map)inputObject;
                    Enumerator enumerator = Linq4j.enumerator(map2.entrySet());
                    Enumerator<List<Comparable>> transformed = Linq4j.transform(enumerator, new Function1<Map.Entry<Comparable, Comparable>, List<Comparable>>(){

                        @Override
                        public List<Comparable> apply(Map.Entry<Comparable, Comparable> entry) {
                            return FlatLists.of(entry.getKey(), entry.getValue());
                        }
                    });
                    enumerators.add(transformed);
                    break;
                }
            }
            if (fieldCount < 0) {
                ++totalFieldCount;
                continue;
            }
            totalFieldCount += fieldCount;
        }
        if (withOrdinality) {
            ++totalFieldCount;
        }
        return SqlFunctions.product(enumerators, totalFieldCount, withOrdinality);
    }

    public static Object[] array(Object ... args) {
        return args;
    }

    public static <E extends Comparable> Enumerable<FlatLists.ComparableList<E>> product(final List<Enumerator<List<E>>> enumerators, final int fieldCount, final boolean withOrdinality) {
        return new AbstractEnumerable<FlatLists.ComparableList<E>>(){

            @Override
            public Enumerator<FlatLists.ComparableList<E>> enumerator() {
                return new ProductComparableListEnumerator(enumerators, fieldCount, withOrdinality);
            }
        };
    }

    public static long addMonths(long timestamp, int m) {
        long millis = DateTimeUtils.floorMod(timestamp, 86400000L);
        long x = SqlFunctions.addMonths((int)((timestamp -= millis) / 86400000L), m);
        return x * 86400000L + millis;
    }

    public static int addMonths(int date, int m) {
        int y;
        int last;
        int y0 = (int)DateTimeUtils.unixDateExtract(TimeUnitRange.YEAR, date);
        int m0 = (int)DateTimeUtils.unixDateExtract(TimeUnitRange.MONTH, date);
        int d0 = (int)DateTimeUtils.unixDateExtract(TimeUnitRange.DAY, date);
        if (d0 > (last = SqlFunctions.lastDay(y0 += (y = m / 12), m0 += m - y * 12))) {
            d0 = 1;
            if (++m0 > 12) {
                m0 = 1;
                ++y0;
            }
        }
        return DateTimeUtils.ymdToUnixDate(y0, m0, d0);
    }

    private static int lastDay(int y, int m) {
        switch (m) {
            case 2: {
                return y % 4 == 0 && (y % 100 != 0 || y % 400 == 0) ? 29 : 28;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                return 30;
            }
        }
        return 31;
    }

    public static int subtractMonths(int date0, int date1) {
        if (date0 < date1) {
            return -SqlFunctions.subtractMonths(date1, date0);
        }
        int m = (date0 - date1) / 31;
        int date2;
        while ((date2 = SqlFunctions.addMonths(date1, m)) < date0) {
            int date3 = SqlFunctions.addMonths(date1, m + 1);
            if (date3 > date0) {
                return m;
            }
            ++m;
        }
        return m;
    }

    public static int subtractMonths(long t0, long t1) {
        int x;
        long millis0 = DateTimeUtils.floorMod(t0, 86400000L);
        int d0 = (int)DateTimeUtils.floorDiv(t0 - millis0, 86400000L);
        long millis1 = DateTimeUtils.floorMod(t1, 86400000L);
        int d1 = (int)DateTimeUtils.floorDiv(t1 - millis1, 86400000L);
        long d2 = SqlFunctions.addMonths(d1, x = SqlFunctions.subtractMonths(d0, d1));
        if (d2 == (long)d0 && millis0 < millis1) {
            --x;
        }
        return x;
    }

    public static enum FlatProductInputType {
        SCALAR,
        LIST,
        MAP;

    }

    private static class ProductComparableListEnumerator<E extends Comparable>
    extends CartesianProductEnumerator<List<E>, FlatLists.ComparableList<E>> {
        final E[] flatElements;
        final List<E> list;
        private final boolean withOrdinality;
        private int ordinality;

        ProductComparableListEnumerator(List<Enumerator<List<E>>> enumerators, int fieldCount, boolean withOrdinality) {
            super(enumerators);
            this.withOrdinality = withOrdinality;
            this.flatElements = new Comparable[fieldCount];
            this.list = Arrays.asList(this.flatElements);
        }

        @Override
        public FlatLists.ComparableList<E> current() {
            int i = 0;
            for (Object element : this.elements) {
                List list2 = (List)element;
                Object[] a = list2.toArray();
                System.arraycopy(a, 0, this.flatElements, i, a.length);
                i += a.length;
            }
            if (this.withOrdinality) {
                this.flatElements[i] = ++this.ordinality;
            }
            return FlatLists.ofComparable(this.list);
        }
    }
}

