/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.validate;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.sql.util.SqlBasicVisitor;
import org.apache.calcite.util.Util;
import org.apache.flink.shaded.calcite.com.google.common.collect.Lists;

class AggFinder
extends SqlBasicVisitor<Void> {
    private final SqlOperatorTable opTab;
    private final boolean over;
    private boolean aggregate;
    private boolean group;
    private final AggFinder delegate;

    AggFinder(SqlOperatorTable opTab, boolean over2, boolean aggregate, boolean group, AggFinder delegate) {
        this.opTab = opTab;
        this.over = over2;
        this.aggregate = aggregate;
        this.group = group;
        this.delegate = delegate;
    }

    public SqlCall findAgg(SqlNode node) {
        try {
            node.accept(this);
            return null;
        }
        catch (Util.FoundOne e) {
            Util.swallow(e, null);
            return (SqlCall)e.getNode();
        }
    }

    public SqlCall findAgg(List<SqlNode> nodes) {
        try {
            for (SqlNode node : nodes) {
                node.accept(this);
            }
            return null;
        }
        catch (Util.FoundOne e) {
            Util.swallow(e, null);
            return (SqlCall)e.getNode();
        }
    }

    @Override
    public Void visit(SqlCall call) {
        SqlFunction sqlFunction;
        SqlOperator operator = call.getOperator();
        if (operator.isAggregator() && !operator.requiresOver()) {
            if (this.delegate != null) {
                return operator.acceptCall(this.delegate, call);
            }
            if (this.aggregate) {
                throw new Util.FoundOne(call);
            }
        }
        if (this.group && operator.isGroup()) {
            throw new Util.FoundOne(call);
        }
        if (operator instanceof SqlFunction && (sqlFunction = (SqlFunction)operator).getFunctionType().isUserDefinedNotSpecificFunction()) {
            ArrayList<SqlOperator> list = Lists.newArrayList();
            this.opTab.lookupOperatorOverloads(sqlFunction.getSqlIdentifier(), sqlFunction.getFunctionType(), SqlSyntax.FUNCTION, list);
            for (SqlOperator operator2 : list) {
                if (!operator2.isAggregator() || operator2.requiresOver() || !this.aggregate) continue;
                throw new Util.FoundOne(call);
            }
        }
        if (call.isA(SqlKind.QUERY)) {
            return null;
        }
        if (call.getKind() == SqlKind.OVER) {
            if (this.over) {
                throw new Util.FoundOne(call);
            }
            return null;
        }
        return (Void)super.visit(call);
    }
}

