/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.validate;

import java.util.List;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.schema.ExtensibleTable;
import org.apache.calcite.schema.Table;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.validate.AbstractNamespace;
import org.apache.calcite.sql.validate.SqlMonotonicity;
import org.apache.calcite.sql.validate.SqlValidatorImpl;
import org.apache.calcite.sql.validate.SqlValidatorTable;
import org.apache.flink.shaded.calcite.com.google.common.base.Preconditions;
import org.apache.flink.shaded.calcite.com.google.common.collect.ImmutableList;
import org.apache.flink.shaded.calcite.com.google.common.collect.Iterables;

class TableNamespace
extends AbstractNamespace {
    private final SqlValidatorTable table;
    public final ImmutableList<RelDataTypeField> extendedFields;

    TableNamespace(SqlValidatorImpl validator, SqlValidatorTable table, ImmutableList<RelDataTypeField> fields) {
        super(validator, null);
        this.table = Preconditions.checkNotNull(table);
        this.extendedFields = fields;
    }

    public TableNamespace(SqlValidatorImpl validator, SqlValidatorTable table) {
        this(validator, table, ImmutableList.of());
    }

    @Override
    protected RelDataType validateImpl(RelDataType targetRowType) {
        if (this.extendedFields.isEmpty()) {
            return this.table.getRowType();
        }
        RelDataTypeFactory.FieldInfoBuilder builder = this.validator.getTypeFactory().builder();
        builder.addAll(this.table.getRowType().getFieldList());
        builder.addAll(this.extendedFields);
        return builder.build();
    }

    @Override
    public SqlNode getNode() {
        return null;
    }

    @Override
    public SqlValidatorTable getTable() {
        return this.table;
    }

    @Override
    public SqlMonotonicity getMonotonicity(String columnName) {
        SqlValidatorTable table = this.getTable();
        return table.getMonotonicity(columnName);
    }

    public TableNamespace extend(List<RelDataTypeField> extendedFields) {
        Table schemaTable = this.table.unwrap(Table.class);
        if (schemaTable != null && this.table instanceof RelOptTable && schemaTable instanceof ExtensibleTable) {
            SqlValidatorTable validatorTable = ((RelOptTable)((Object)this.table)).extend(ImmutableList.copyOf(Iterables.concat(this.extendedFields, extendedFields))).unwrap(SqlValidatorTable.class);
            return new TableNamespace(this.validator, validatorTable, ImmutableList.of());
        }
        return new TableNamespace(this.validator, this.table, ImmutableList.copyOf(Iterables.concat(this.extendedFields, extendedFields)));
    }
}

