/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql2rel;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeFamily;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCallBinding;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexRangeRef;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlBinaryOperator;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlIntervalLiteral;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlJdbcFunctionCall;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlNumericLiteral;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.fun.OracleSqlOperatorTable;
import org.apache.calcite.sql.fun.SqlArrayValueConstructor;
import org.apache.calcite.sql.fun.SqlBetweenOperator;
import org.apache.calcite.sql.fun.SqlCase;
import org.apache.calcite.sql.fun.SqlDatetimeSubtractionOperator;
import org.apache.calcite.sql.fun.SqlExtractFunction;
import org.apache.calcite.sql.fun.SqlLiteralChainOperator;
import org.apache.calcite.sql.fun.SqlMapValueConstructor;
import org.apache.calcite.sql.fun.SqlMultisetQueryConstructor;
import org.apache.calcite.sql.fun.SqlMultisetValueConstructor;
import org.apache.calcite.sql.fun.SqlOverlapsOperator;
import org.apache.calcite.sql.fun.SqlRowOperator;
import org.apache.calcite.sql.fun.SqlSequenceValueOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.fun.SqlTrimFunction;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql2rel.ReflectiveConvertletTable;
import org.apache.calcite.sql2rel.SqlRexContext;
import org.apache.calcite.sql2rel.SqlRexConvertlet;
import org.apache.calcite.util.Util;
import org.apache.flink.shaded.calcite.com.google.common.collect.ImmutableList;
import org.apache.flink.shaded.calcite.com.google.common.collect.Lists;
import org.apache.flink.shaded.calcite.com.google.common.collect.Sets;

public class StandardConvertletTable
extends ReflectiveConvertletTable {
    public static final StandardConvertletTable INSTANCE = new StandardConvertletTable();

    private StandardConvertletTable() {
        this.addAlias(SqlStdOperatorTable.CHARACTER_LENGTH, SqlStdOperatorTable.CHAR_LENGTH);
        this.addAlias(SqlStdOperatorTable.IS_UNKNOWN, SqlStdOperatorTable.IS_NULL);
        this.addAlias(SqlStdOperatorTable.IS_NOT_UNKNOWN, SqlStdOperatorTable.IS_NOT_NULL);
        this.registerOp(SqlStdOperatorTable.CAST, new SqlRexConvertlet(){

            @Override
            public RexNode convertCall(SqlRexContext cx, SqlCall call) {
                return StandardConvertletTable.this.convertCast(cx, call);
            }
        });
        this.registerOp(SqlStdOperatorTable.IS_DISTINCT_FROM, new SqlRexConvertlet(){

            @Override
            public RexNode convertCall(SqlRexContext cx, SqlCall call) {
                return StandardConvertletTable.this.convertIsDistinctFrom(cx, call, false);
            }
        });
        this.registerOp(SqlStdOperatorTable.IS_NOT_DISTINCT_FROM, new SqlRexConvertlet(){

            @Override
            public RexNode convertCall(SqlRexContext cx, SqlCall call) {
                return StandardConvertletTable.this.convertIsDistinctFrom(cx, call, true);
            }
        });
        this.registerOp(SqlStdOperatorTable.PLUS, new SqlRexConvertlet(){

            @Override
            public RexNode convertCall(SqlRexContext cx, SqlCall call) {
                return StandardConvertletTable.this.convertPlus(cx, call);
            }
        });
        this.registerOp(SqlStdOperatorTable.MINUS, new SqlRexConvertlet(){

            @Override
            public RexNode convertCall(SqlRexContext cx, SqlCall call) {
                RexCall e = (RexCall)StandardConvertletTable.this.convertCall(cx, call, call.getOperator());
                switch (e.getOperands().get(0).getType().getSqlTypeName()) {
                    case DATE: 
                    case TIME: 
                    case TIMESTAMP: {
                        return StandardConvertletTable.this.convertDatetimeMinus(cx, SqlStdOperatorTable.MINUS_DATE, call);
                    }
                }
                return e;
            }
        });
        this.registerOp(OracleSqlOperatorTable.LTRIM, new TrimConvertlet(SqlTrimFunction.Flag.LEADING));
        this.registerOp(OracleSqlOperatorTable.RTRIM, new TrimConvertlet(SqlTrimFunction.Flag.TRAILING));
        this.registerOp(OracleSqlOperatorTable.GREATEST, new GreatestConvertlet());
        this.registerOp(OracleSqlOperatorTable.LEAST, new GreatestConvertlet());
        this.registerOp(OracleSqlOperatorTable.NVL, new SqlRexConvertlet(){

            @Override
            public RexNode convertCall(SqlRexContext cx, SqlCall call) {
                RexBuilder rexBuilder = cx.getRexBuilder();
                RexNode operand0 = cx.convertExpression(call.getOperandList().get(0));
                RexNode operand1 = cx.convertExpression(call.getOperandList().get(1));
                RelDataType type = cx.getValidator().getValidatedNodeType(call);
                return rexBuilder.makeCall(type, SqlStdOperatorTable.CASE, ImmutableList.of(rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, operand0), rexBuilder.makeCast(type, operand0), rexBuilder.makeCast(type, operand1)));
            }
        });
        this.registerOp(OracleSqlOperatorTable.DECODE, new SqlRexConvertlet(){

            @Override
            public RexNode convertCall(SqlRexContext cx, SqlCall call) {
                RexBuilder rexBuilder = cx.getRexBuilder();
                List operands = StandardConvertletTable.convertExpressionList(cx, call.getOperandList(), SqlOperandTypeChecker.Consistency.NONE);
                RelDataType type = cx.getValidator().getValidatedNodeType(call);
                ArrayList<RexNode> exprs = new ArrayList<RexNode>();
                for (int i = 1; i < operands.size() - 1; i += 2) {
                    exprs.add(RelOptUtil.isDistinctFrom(rexBuilder, (RexNode)operands.get(0), (RexNode)operands.get(i), true));
                    exprs.add((RexNode)operands.get(i + 1));
                }
                if (operands.size() % 2 == 0) {
                    exprs.add((RexNode)Util.last(operands));
                } else {
                    exprs.add(rexBuilder.makeNullLiteral(type));
                }
                return rexBuilder.makeCall(type, SqlStdOperatorTable.CASE, exprs);
            }
        });
        this.registerOp(SqlStdOperatorTable.NOT_LIKE, new SqlRexConvertlet(){

            @Override
            public RexNode convertCall(SqlRexContext cx, SqlCall call) {
                SqlCall expanded = SqlStdOperatorTable.NOT.createCall(SqlParserPos.ZERO, SqlStdOperatorTable.LIKE.createCall(SqlParserPos.ZERO, call.getOperandList()));
                return cx.convertExpression(expanded);
            }
        });
        this.registerOp(SqlStdOperatorTable.NOT_SIMILAR_TO, new SqlRexConvertlet(){

            @Override
            public RexNode convertCall(SqlRexContext cx, SqlCall call) {
                SqlCall expanded = SqlStdOperatorTable.NOT.createCall(SqlParserPos.ZERO, SqlStdOperatorTable.SIMILAR_TO.createCall(SqlParserPos.ZERO, call.getOperandList()));
                return cx.convertExpression(expanded);
            }
        });
        this.registerOp(SqlStdOperatorTable.UNARY_PLUS, new SqlRexConvertlet(){

            @Override
            public RexNode convertCall(SqlRexContext cx, SqlCall call) {
                Object expanded = call.operand(0);
                return cx.convertExpression((SqlNode)expanded);
            }
        });
        this.registerOp(SqlStdOperatorTable.AS, new SqlRexConvertlet(){

            @Override
            public RexNode convertCall(SqlRexContext cx, SqlCall call) {
                Object expanded = call.operand(0);
                return cx.convertExpression((SqlNode)expanded);
            }
        });
        this.registerOp(SqlStdOperatorTable.SQRT, new SqlRexConvertlet(){

            @Override
            public RexNode convertCall(SqlRexContext cx, SqlCall call) {
                SqlCall expanded = SqlStdOperatorTable.POWER.createCall(SqlParserPos.ZERO, new SqlNode[]{call.operand(0), SqlLiteral.createExactNumeric("0.5", SqlParserPos.ZERO)});
                return cx.convertExpression(expanded);
            }
        });
        this.registerOp(SqlStdOperatorTable.AVG, new AvgVarianceConvertlet(SqlKind.AVG));
        this.registerOp(SqlStdOperatorTable.STDDEV_POP, new AvgVarianceConvertlet(SqlKind.STDDEV_POP));
        this.registerOp(SqlStdOperatorTable.STDDEV_SAMP, new AvgVarianceConvertlet(SqlKind.STDDEV_SAMP));
        this.registerOp(SqlStdOperatorTable.VAR_POP, new AvgVarianceConvertlet(SqlKind.VAR_POP));
        this.registerOp(SqlStdOperatorTable.VAR_SAMP, new AvgVarianceConvertlet(SqlKind.VAR_SAMP));
        FloorCeilConvertlet floorCeilConvertlet = new FloorCeilConvertlet();
        this.registerOp(SqlStdOperatorTable.FLOOR, floorCeilConvertlet);
        this.registerOp(SqlStdOperatorTable.CEIL, floorCeilConvertlet);
        this.registerOp(SqlStdOperatorTable.TIMESTAMP_ADD, new TimestampAddConvertlet());
        this.registerOp(SqlStdOperatorTable.TIMESTAMP_DIFF, new TimestampDiffConvertlet());
    }

    public RexNode convertCase(SqlRexContext cx, SqlCase call) {
        SqlNodeList whenList = call.getWhenOperands();
        SqlNodeList thenList = call.getThenOperands();
        assert (whenList.size() == thenList.size());
        ArrayList<RexNode> exprList = new ArrayList<RexNode>();
        for (int i = 0; i < whenList.size(); ++i) {
            exprList.add(cx.convertExpression(whenList.get(i)));
            exprList.add(cx.convertExpression(thenList.get(i)));
        }
        exprList.add(cx.convertExpression(call.getElseOperand()));
        RexBuilder rexBuilder = cx.getRexBuilder();
        RelDataType type = rexBuilder.deriveReturnType(call.getOperator(), exprList);
        for (int i : this.elseArgs(exprList.size())) {
            exprList.set(i, rexBuilder.ensureType(type, (RexNode)exprList.get(i), false));
        }
        return rexBuilder.makeCall(type, SqlStdOperatorTable.CASE, exprList);
    }

    public RexNode convertMultiset(SqlRexContext cx, SqlMultisetValueConstructor op, SqlCall call) {
        RelDataType originalType = cx.getValidator().getValidatedNodeType(call);
        RexRangeRef rr = cx.getSubQueryExpr(call);
        assert (rr != null);
        RelDataType msType = rr.getType().getFieldList().get(0).getType();
        RexNode expr = cx.getRexBuilder().makeInputRef(msType, rr.getOffset());
        assert (msType.getComponentType().isStruct());
        if (!originalType.getComponentType().isStruct()) {
            expr = cx.getRexBuilder().makeCall(originalType, SqlStdOperatorTable.SLICE, ImmutableList.of(expr));
        }
        return expr;
    }

    public RexNode convertArray(SqlRexContext cx, SqlArrayValueConstructor op, SqlCall call) {
        return this.convertCall(cx, call);
    }

    public RexNode convertMap(SqlRexContext cx, SqlMapValueConstructor op, SqlCall call) {
        return this.convertCall(cx, call);
    }

    public RexNode convertMultisetQuery(SqlRexContext cx, SqlMultisetQueryConstructor op, SqlCall call) {
        RelDataType originalType = cx.getValidator().getValidatedNodeType(call);
        RexRangeRef rr = cx.getSubQueryExpr(call);
        assert (rr != null);
        RelDataType msType = rr.getType().getFieldList().get(0).getType();
        RexNode expr = cx.getRexBuilder().makeInputRef(msType, rr.getOffset());
        assert (msType.getComponentType().isStruct());
        if (!originalType.getComponentType().isStruct()) {
            expr = cx.getRexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.SLICE, expr);
        }
        return expr;
    }

    public RexNode convertJdbc(SqlRexContext cx, SqlJdbcFunctionCall op, SqlCall call) {
        SqlCall convertedCall = op.getLookupCall();
        return cx.convertExpression(convertedCall);
    }

    protected RexNode convertCast(SqlRexContext cx, SqlCall call) {
        RelDataTypeFactory typeFactory = cx.getTypeFactory();
        assert (call.getKind() == SqlKind.CAST);
        Object left = call.operand(0);
        Object right = call.operand(1);
        if (right instanceof SqlIntervalQualifier) {
            SqlIntervalQualifier intervalQualifier = (SqlIntervalQualifier)right;
            if (left instanceof SqlIntervalLiteral) {
                RexLiteral sourceInterval = (RexLiteral)cx.convertExpression((SqlNode)left);
                BigDecimal sourceValue = (BigDecimal)sourceInterval.getValue();
                RexLiteral castedInterval = cx.getRexBuilder().makeIntervalLiteral(sourceValue, intervalQualifier);
                return this.castToValidatedType(cx, call, castedInterval);
            }
            if (left instanceof SqlNumericLiteral) {
                RexLiteral sourceInterval = (RexLiteral)cx.convertExpression((SqlNode)left);
                BigDecimal sourceValue = (BigDecimal)sourceInterval.getValue();
                BigDecimal multiplier = intervalQualifier.getUnit().multiplier;
                sourceValue = sourceValue.multiply(multiplier);
                RexLiteral castedInterval = cx.getRexBuilder().makeIntervalLiteral(sourceValue, intervalQualifier);
                return this.castToValidatedType(cx, call, castedInterval);
            }
            return this.castToValidatedType(cx, call, cx.convertExpression((SqlNode)left));
        }
        SqlDataTypeSpec dataType2 = (SqlDataTypeSpec)right;
        if (SqlUtil.isNullLiteral(left, false)) {
            return cx.convertExpression((SqlNode)left);
        }
        RexNode arg = cx.convertExpression((SqlNode)left);
        RelDataType type = dataType2.deriveType(typeFactory);
        if (arg.getType().isNullable()) {
            type = typeFactory.createTypeWithNullability(type, true);
        }
        if (null != dataType2.getCollectionsTypeName()) {
            RelDataType argComponentType = arg.getType().getComponentType();
            RelDataType componentType = type.getComponentType();
            if (argComponentType.isStruct() && !componentType.isStruct()) {
                RelDataType tt = typeFactory.builder().add(argComponentType.getFieldList().get(0).getName(), componentType).build();
                tt = typeFactory.createTypeWithNullability(tt, componentType.isNullable());
                boolean isn = type.isNullable();
                type = typeFactory.createMultisetType(tt, -1L);
                type = typeFactory.createTypeWithNullability(type, isn);
            }
        }
        return cx.getRexBuilder().makeCast(type, arg);
    }

    protected RexNode convertFloorCeil(SqlRexContext cx, SqlCall call) {
        boolean floor;
        boolean bl = floor = call.getKind() == SqlKind.FLOOR;
        if (call.operandCount() == 1 && call.operand(0) instanceof SqlIntervalLiteral) {
            RexNode mult;
            SqlIntervalLiteral literal = (SqlIntervalLiteral)call.operand(0);
            SqlIntervalLiteral.IntervalValue interval = (SqlIntervalLiteral.IntervalValue)literal.getValue();
            BigDecimal val = interval.getIntervalQualifier().getStartUnit().multiplier;
            RexNode rexInterval = cx.convertExpression(literal);
            RexBuilder rexBuilder = cx.getRexBuilder();
            RexLiteral zero = rexBuilder.makeExactLiteral(BigDecimal.valueOf(0L));
            RexNode cond = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, rexInterval, zero);
            RexLiteral pad = rexBuilder.makeExactLiteral(val.subtract(BigDecimal.ONE));
            RexNode cast = rexBuilder.makeReinterpretCast(rexInterval.getType(), pad, rexBuilder.makeLiteral(false));
            SqlBinaryOperator op = floor ? SqlStdOperatorTable.MINUS : SqlStdOperatorTable.PLUS;
            RexNode sum = rexBuilder.makeCall((SqlOperator)op, rexInterval, cast);
            RexNode kase = floor ? rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.CASE, cond, rexInterval, sum) : rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.CASE, cond, sum, rexInterval);
            RexLiteral factor = rexBuilder.makeExactLiteral(val);
            RexNode div = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.DIVIDE_INTEGER, kase, factor);
            RexNode res = mult = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.MULTIPLY, div, factor);
            return res;
        }
        return this.convertFunction(cx, (SqlFunction)call.getOperator(), call);
    }

    public RexNode convertExtract(SqlRexContext cx, SqlExtractFunction op, SqlCall call) {
        RexBuilder rexBuilder = cx.getRexBuilder();
        List<SqlNode> operands = call.getOperandList();
        List<RexNode> exprs = StandardConvertletTable.convertExpressionList(cx, operands, SqlOperandTypeChecker.Consistency.NONE);
        RelDataType resType = cx.getTypeFactory().createSqlType(SqlTypeName.BIGINT);
        resType = cx.getTypeFactory().createTypeWithNullability(resType, exprs.get(1).getType().isNullable());
        RexNode res = rexBuilder.makeReinterpretCast(resType, exprs.get(1), rexBuilder.makeLiteral(false));
        TimeUnit unit = ((SqlIntervalQualifier)operands.get(0)).getStartUnit();
        SqlTypeName sqlTypeName = exprs.get(1).getType().getSqlTypeName();
        block0 : switch (unit) {
            case YEAR: 
            case MONTH: 
            case DAY: {
                switch (sqlTypeName) {
                    case INTERVAL_YEAR: 
                    case INTERVAL_YEAR_MONTH: 
                    case INTERVAL_MONTH: 
                    case INTERVAL_DAY: 
                    case INTERVAL_DAY_HOUR: 
                    case INTERVAL_DAY_MINUTE: 
                    case INTERVAL_DAY_SECOND: 
                    case INTERVAL_HOUR: 
                    case INTERVAL_HOUR_MINUTE: 
                    case INTERVAL_HOUR_SECOND: 
                    case INTERVAL_MINUTE: 
                    case INTERVAL_MINUTE_SECOND: 
                    case INTERVAL_SECOND: {
                        break block0;
                    }
                    case TIMESTAMP: {
                        res = StandardConvertletTable.divide(rexBuilder, res, TimeUnit.DAY.multiplier);
                    }
                    case DATE: {
                        return rexBuilder.makeCall(resType, SqlStdOperatorTable.EXTRACT_DATE, ImmutableList.of(exprs.get(0), res));
                    }
                }
                throw new AssertionError((Object)("unexpected " + (Object)((Object)sqlTypeName)));
            }
            case MILLENNIUM: 
            case CENTURY: 
            case DECADE: {
                switch (sqlTypeName) {
                    case TIMESTAMP: {
                        res = StandardConvertletTable.divide(rexBuilder, res, TimeUnit.DAY.multiplier);
                    }
                    case DATE: {
                        res = rexBuilder.makeCall(resType, SqlStdOperatorTable.EXTRACT_DATE, ImmutableList.of(rexBuilder.makeFlag(TimeUnitRange.YEAR), res));
                        return StandardConvertletTable.divide(rexBuilder, res, unit.multiplier.divide(TimeUnit.YEAR.multiplier));
                    }
                }
                break;
            }
            case QUARTER: {
                switch (sqlTypeName) {
                    case TIMESTAMP: {
                        res = StandardConvertletTable.divide(rexBuilder, res, TimeUnit.DAY.multiplier);
                    }
                    case DATE: {
                        res = rexBuilder.makeCall(resType, SqlStdOperatorTable.EXTRACT_DATE, ImmutableList.of(rexBuilder.makeFlag(TimeUnitRange.MONTH), res));
                        res = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.MINUS, res, rexBuilder.makeExactLiteral(BigDecimal.ONE));
                        res = StandardConvertletTable.divide(rexBuilder, res, unit.multiplier);
                        return rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.PLUS, res, rexBuilder.makeExactLiteral(BigDecimal.ONE));
                    }
                }
                break;
            }
            case EPOCH: {
                switch (sqlTypeName) {
                    case DATE: {
                        res = rexBuilder.makeCall(resType, SqlStdOperatorTable.MULTIPLY, ImmutableList.of(res, rexBuilder.makeExactLiteral(TimeUnit.DAY.multiplier)));
                    }
                    case TIMESTAMP: {
                        return StandardConvertletTable.divide(rexBuilder, res, TimeUnit.SECOND.multiplier);
                    }
                    case INTERVAL_YEAR: 
                    case INTERVAL_YEAR_MONTH: 
                    case INTERVAL_MONTH: 
                    case INTERVAL_DAY: 
                    case INTERVAL_DAY_HOUR: 
                    case INTERVAL_DAY_MINUTE: 
                    case INTERVAL_DAY_SECOND: 
                    case INTERVAL_HOUR: 
                    case INTERVAL_HOUR_MINUTE: 
                    case INTERVAL_HOUR_SECOND: 
                    case INTERVAL_MINUTE: 
                    case INTERVAL_MINUTE_SECOND: 
                    case INTERVAL_SECOND: {
                        return this.convertFunction(cx, (SqlFunction)call.getOperator(), call);
                    }
                }
                break;
            }
            case DOW: 
            case DOY: 
            case WEEK: {
                switch (sqlTypeName) {
                    case INTERVAL_YEAR: 
                    case INTERVAL_YEAR_MONTH: 
                    case INTERVAL_MONTH: 
                    case INTERVAL_DAY: 
                    case INTERVAL_DAY_HOUR: 
                    case INTERVAL_DAY_MINUTE: 
                    case INTERVAL_DAY_SECOND: 
                    case INTERVAL_HOUR: 
                    case INTERVAL_HOUR_MINUTE: 
                    case INTERVAL_HOUR_SECOND: 
                    case INTERVAL_MINUTE: 
                    case INTERVAL_MINUTE_SECOND: 
                    case INTERVAL_SECOND: {
                        throw new IllegalArgumentException("Extract " + (Object)((Object)unit) + " from " + (Object)((Object)sqlTypeName) + " type data is not supported");
                    }
                    case DATE: 
                    case TIMESTAMP: {
                        return this.convertFunction(cx, (SqlFunction)call.getOperator(), call);
                    }
                }
            }
        }
        res = this.mod(rexBuilder, resType, res, StandardConvertletTable.getFactor(unit));
        if (unit == TimeUnit.QUARTER) {
            res = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.MINUS, res, rexBuilder.makeExactLiteral(BigDecimal.ONE));
        }
        res = StandardConvertletTable.divide(rexBuilder, res, unit.multiplier);
        if (unit == TimeUnit.QUARTER) {
            res = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.PLUS, res, rexBuilder.makeExactLiteral(BigDecimal.ONE));
        }
        return res;
    }

    private static BigDecimal getFactor(TimeUnit unit) {
        switch (unit) {
            case DAY: {
                return BigDecimal.ONE;
            }
            case HOUR: {
                return TimeUnit.DAY.multiplier;
            }
            case MINUTE: {
                return TimeUnit.HOUR.multiplier;
            }
            case SECOND: {
                return TimeUnit.MINUTE.multiplier;
            }
            case MONTH: {
                return TimeUnit.YEAR.multiplier;
            }
            case QUARTER: {
                return TimeUnit.YEAR.multiplier;
            }
            case YEAR: 
            case MILLENNIUM: 
            case CENTURY: 
            case DECADE: {
                return BigDecimal.ONE;
            }
        }
        throw Util.unexpected(unit);
    }

    private RexNode mod(RexBuilder rexBuilder, RelDataType resType, RexNode res, BigDecimal val) {
        if (val.equals(BigDecimal.ONE)) {
            return res;
        }
        return rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.MOD, res, rexBuilder.makeExactLiteral(val, resType));
    }

    private static RexNode divide(RexBuilder rexBuilder, RexNode res, BigDecimal val) {
        if (val.equals(BigDecimal.ONE)) {
            return res;
        }
        if (val.compareTo(BigDecimal.ONE) < 0 && val.signum() == 1) {
            try {
                BigDecimal reciprocal = BigDecimal.ONE.divide(val, RoundingMode.UNNECESSARY);
                return rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.MULTIPLY, res, rexBuilder.makeExactLiteral(reciprocal));
            }
            catch (ArithmeticException arithmeticException) {
                // empty catch block
            }
        }
        return rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.DIVIDE_INTEGER, res, rexBuilder.makeExactLiteral(val));
    }

    public RexNode convertDatetimeMinus(SqlRexContext cx, SqlDatetimeSubtractionOperator op, SqlCall call) {
        RexBuilder rexBuilder = cx.getRexBuilder();
        List<SqlNode> operands = call.getOperandList();
        List<RexNode> exprs = StandardConvertletTable.convertExpressionList(cx, operands, SqlOperandTypeChecker.Consistency.NONE);
        RelDataType int8Type = cx.getTypeFactory().createSqlType(SqlTypeName.BIGINT);
        RexNode[] casts = new RexNode[]{rexBuilder.makeCast(cx.getTypeFactory().createTypeWithNullability(int8Type, exprs.get(0).getType().isNullable()), exprs.get(0)), rexBuilder.makeCast(cx.getTypeFactory().createTypeWithNullability(int8Type, exprs.get(1).getType().isNullable()), exprs.get(1))};
        RelDataType resType = cx.getValidator().getValidatedNodeType(call);
        return rexBuilder.makeCall(resType, op, exprs.subList(0, 2));
    }

    public RexNode convertFunction(SqlRexContext cx, SqlFunction fun, SqlCall call) {
        List<SqlNode> operands = call.getOperandList();
        List<RexNode> exprs = StandardConvertletTable.convertExpressionList(cx, operands, SqlOperandTypeChecker.Consistency.NONE);
        if (fun.getFunctionType() == SqlFunctionCategory.USER_DEFINED_CONSTRUCTOR) {
            return StandardConvertletTable.makeConstructorCall(cx, fun, exprs);
        }
        RelDataType returnType = cx.getValidator().getValidatedNodeTypeIfKnown(call);
        if (returnType == null) {
            returnType = cx.getRexBuilder().deriveReturnType(fun, exprs);
        }
        return cx.getRexBuilder().makeCall(returnType, fun, exprs);
    }

    public RexNode convertSequenceValue(SqlRexContext cx, SqlSequenceValueOperator fun, SqlCall call) {
        List<SqlNode> operands = call.getOperandList();
        assert (operands.size() == 1);
        assert (operands.get(0) instanceof SqlIdentifier);
        SqlIdentifier id = (SqlIdentifier)operands.get(0);
        String key = Util.listToString(id.names);
        RelDataType returnType = cx.getValidator().getValidatedNodeType(call);
        return cx.getRexBuilder().makeCall(returnType, fun, ImmutableList.of(cx.getRexBuilder().makeLiteral(key)));
    }

    public RexNode convertAggregateFunction(SqlRexContext cx, SqlAggFunction fun, SqlCall call) {
        List<SqlNode> operands = call.getOperandList();
        List<Object> exprs = call.isCountStar() ? ImmutableList.of() : StandardConvertletTable.convertExpressionList(cx, operands, SqlOperandTypeChecker.Consistency.NONE);
        RelDataType returnType = cx.getValidator().getValidatedNodeTypeIfKnown(call);
        final int groupCount = cx.getGroupCount();
        if (returnType == null) {
            RexCallBinding binding = new RexCallBinding(cx.getTypeFactory(), fun, exprs, ImmutableList.of()){

                @Override
                public int getGroupCount() {
                    return groupCount;
                }
            };
            returnType = fun.inferReturnType(binding);
        }
        return cx.getRexBuilder().makeCall(returnType, fun, exprs);
    }

    private static RexNode makeConstructorCall(SqlRexContext cx, SqlFunction constructor, List<RexNode> exprs) {
        RexBuilder rexBuilder = cx.getRexBuilder();
        RelDataType type = rexBuilder.deriveReturnType(constructor, exprs);
        int n = type.getFieldCount();
        ImmutableList.Builder initializationExprs = ImmutableList.builder();
        for (int i = 0; i < n; ++i) {
            initializationExprs.add(cx.getInitializerExpressionFactory().newAttributeInitializer(type, constructor, i, exprs));
        }
        List<RexNode> defaultCasts = RexUtil.generateCastExpressions(rexBuilder, type, (List<RexNode>)((Object)initializationExprs.build()));
        return rexBuilder.makeNewInvocation(type, defaultCasts);
    }

    public RexNode convertCall(SqlRexContext cx, SqlCall call) {
        return this.convertCall(cx, call, call.getOperator());
    }

    private RexNode convertCall(SqlRexContext cx, SqlCall call, SqlOperator op) {
        List<SqlNode> operands = call.getOperandList();
        RexBuilder rexBuilder = cx.getRexBuilder();
        SqlOperandTypeChecker.Consistency consistency = op.getOperandTypeChecker() == null ? SqlOperandTypeChecker.Consistency.NONE : op.getOperandTypeChecker().getConsistency();
        List<RexNode> exprs = StandardConvertletTable.convertExpressionList(cx, operands, consistency);
        RelDataType type = rexBuilder.deriveReturnType(op, exprs);
        return rexBuilder.makeCall(type, op, RexUtil.flatten(exprs, op));
    }

    private List<Integer> elseArgs(int count) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int i = count % 2;
        do {
            list.add(i);
        } while ((i += 2) < count);
        list.add(i - 1);
        return list;
    }

    private static List<RexNode> convertExpressionList(SqlRexContext cx, List<SqlNode> nodes, SqlOperandTypeChecker.Consistency consistency) {
        RelDataType type;
        ArrayList<RexNode> exprs = Lists.newArrayList();
        for (SqlNode node : nodes) {
            exprs.add(cx.convertExpression(node));
        }
        if (exprs.size() > 1 && (type = StandardConvertletTable.consistentType(cx, consistency, RexUtil.types(exprs))) != null) {
            ArrayList<RexNode> oldExprs = Lists.newArrayList(exprs);
            exprs.clear();
            for (RexNode expr : oldExprs) {
                exprs.add(cx.getRexBuilder().ensureType(type, expr, true));
            }
        }
        return exprs;
    }

    private static RelDataType consistentType(SqlRexContext cx, SqlOperandTypeChecker.Consistency consistency, List<RelDataType> types) {
        switch (consistency) {
            case COMPARE: {
                HashSet<RelDataTypeFamily> families = Sets.newHashSet(RexUtil.families(types));
                if (families.size() < 2) {
                    return null;
                }
                ArrayList<RelDataType> nonCharacterTypes = Lists.newArrayList();
                for (RelDataType type : types) {
                    if (type.getFamily() == SqlTypeFamily.CHARACTER) continue;
                    nonCharacterTypes.add(type);
                }
                if (!nonCharacterTypes.isEmpty()) {
                    RelDataTypeFamily family;
                    int typeCount = types.size();
                    types = nonCharacterTypes;
                    if (nonCharacterTypes.size() < typeCount && (family = ((RelDataType)nonCharacterTypes.get(0)).getFamily()) instanceof SqlTypeFamily) {
                        switch ((SqlTypeFamily)family) {
                            case INTEGER: 
                            case NUMERIC: {
                                nonCharacterTypes.add(cx.getTypeFactory().createSqlType(SqlTypeName.BIGINT));
                            }
                        }
                    }
                }
            }
            case LEAST_RESTRICTIVE: {
                return cx.getTypeFactory().leastRestrictive(types);
            }
        }
        return null;
    }

    private RexNode convertPlus(SqlRexContext cx, SqlCall call) {
        RexNode rex = this.convertCall(cx, call);
        switch (rex.getType().getSqlTypeName()) {
            case DATE: 
            case TIME: 
            case TIMESTAMP: {
                RexBuilder rexBuilder = cx.getRexBuilder();
                List<RexNode> operands = ((RexCall)rex).getOperands();
                if (operands.size() == 2) {
                    SqlTypeName sqlTypeName = operands.get(0).getType().getSqlTypeName();
                    switch (sqlTypeName) {
                        case INTERVAL_YEAR: 
                        case INTERVAL_YEAR_MONTH: 
                        case INTERVAL_MONTH: 
                        case INTERVAL_DAY: 
                        case INTERVAL_DAY_HOUR: 
                        case INTERVAL_DAY_MINUTE: 
                        case INTERVAL_DAY_SECOND: 
                        case INTERVAL_HOUR: 
                        case INTERVAL_HOUR_MINUTE: 
                        case INTERVAL_HOUR_SECOND: 
                        case INTERVAL_MINUTE: 
                        case INTERVAL_MINUTE_SECOND: 
                        case INTERVAL_SECOND: {
                            operands = ImmutableList.of(operands.get(1), operands.get(0));
                        }
                    }
                }
                return rexBuilder.makeCall(rex.getType(), SqlStdOperatorTable.DATETIME_PLUS, operands);
            }
        }
        return rex;
    }

    private RexNode convertIsDistinctFrom(SqlRexContext cx, SqlCall call, boolean neg) {
        RexNode op0 = cx.convertExpression((SqlNode)call.operand(0));
        RexNode op1 = cx.convertExpression((SqlNode)call.operand(1));
        return RelOptUtil.isDistinctFrom(cx.getRexBuilder(), op0, op1, neg);
    }

    public RexNode convertBetween(SqlRexContext cx, SqlBetweenOperator op, SqlCall call) {
        RexNode res;
        List<RexNode> list = StandardConvertletTable.convertExpressionList(cx, call.getOperandList(), op.getOperandTypeChecker().getConsistency());
        RexNode x = list.get(0);
        RexNode y = list.get(1);
        RexNode z = list.get(2);
        RexBuilder rexBuilder = cx.getRexBuilder();
        RexNode ge1 = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, x, y);
        RexNode le1 = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, x, z);
        RexNode and1 = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, ge1, le1);
        SqlBetweenOperator.Flag symmetric = op.flag;
        switch (symmetric) {
            case ASYMMETRIC: {
                res = and1;
                break;
            }
            case SYMMETRIC: {
                RexNode ge2 = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, x, z);
                RexNode le2 = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, x, y);
                RexNode and2 = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, ge2, le2);
                res = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.OR, and1, and2);
                break;
            }
            default: {
                throw Util.unexpected(symmetric);
            }
        }
        SqlBetweenOperator betweenOp = (SqlBetweenOperator)call.getOperator();
        if (betweenOp.isNegated()) {
            res = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, res);
        }
        return res;
    }

    public RexNode convertLiteralChain(SqlRexContext cx, SqlLiteralChainOperator op, SqlCall call) {
        Util.discard(cx);
        SqlLiteral sum = SqlLiteralChainOperator.concatenateOperands(call);
        return cx.convertLiteral(sum);
    }

    public RexNode convertRow(SqlRexContext cx, SqlRowOperator op, SqlCall call) {
        if (cx.getValidator().getValidatedNodeType(call).getSqlTypeName() != SqlTypeName.COLUMN_LIST) {
            return this.convertCall(cx, call);
        }
        RexBuilder rexBuilder = cx.getRexBuilder();
        ArrayList<RexNode> columns = new ArrayList<RexNode>();
        for (SqlNode operand : call.getOperandList()) {
            columns.add(rexBuilder.makeLiteral(((SqlIdentifier)operand).getSimple()));
        }
        RelDataType type = rexBuilder.deriveReturnType(SqlStdOperatorTable.COLUMN_LIST, columns);
        return rexBuilder.makeCall(type, SqlStdOperatorTable.COLUMN_LIST, columns);
    }

    public RexNode convertOverlaps(SqlRexContext cx, SqlOverlapsOperator op, SqlCall call) {
        SqlBinaryOperator op1;
        SqlNode[] operands = ((SqlBasicCall)call).getOperands();
        assert (operands.length == 4);
        if (operands[1] instanceof SqlIntervalLiteral) {
            op1 = SqlStdOperatorTable.PLUS;
            SqlNode[] second = new SqlNode[]{operands[0], operands[1]};
            operands[1] = op1.createCall(call.getParserPosition(), second);
        }
        if (operands[3] instanceof SqlIntervalLiteral) {
            op1 = SqlStdOperatorTable.PLUS;
            SqlNode[] four = new SqlNode[]{operands[2], operands[3]};
            operands[3] = op1.createCall(call.getParserPosition(), four);
        }
        op1 = SqlStdOperatorTable.GREATER_THAN_OR_EQUAL;
        SqlNode[] left = new SqlNode[]{operands[1], operands[2]};
        SqlCall call1 = op1.createCall(call.getParserPosition(), left);
        SqlBinaryOperator op2 = SqlStdOperatorTable.GREATER_THAN_OR_EQUAL;
        SqlNode[] right = new SqlNode[]{operands[3], operands[0]};
        SqlCall call2 = op2.createCall(call.getParserPosition(), right);
        SqlBinaryOperator and = SqlStdOperatorTable.AND;
        SqlNode[] overlaps = new SqlNode[]{call1, call2};
        SqlCall call3 = and.createCall(call.getParserPosition(), overlaps);
        return cx.convertExpression(call3);
    }

    public RexNode castToValidatedType(SqlRexContext cx, SqlCall call, RexNode value) {
        return StandardConvertletTable.castToValidatedType(call, value, cx.getValidator(), cx.getRexBuilder());
    }

    public static RexNode castToValidatedType(SqlNode node, RexNode e, SqlValidator validator, RexBuilder rexBuilder) {
        RelDataType type = validator.getValidatedNodeType(node);
        if (e.getType() == type) {
            return e;
        }
        return rexBuilder.makeCast(type, e);
    }

    private static class TimestampDiffConvertlet
    implements SqlRexConvertlet {
        private TimestampDiffConvertlet() {
        }

        @Override
        public RexNode convertCall(SqlRexContext cx, SqlCall call) {
            RexBuilder rexBuilder = cx.getRexBuilder();
            SqlLiteral unitLiteral = (SqlLiteral)call.operand(0);
            TimeUnit unit = unitLiteral.symbolValue(TimeUnit.class);
            BigDecimal multiplier = BigDecimal.ONE;
            BigDecimal divider = BigDecimal.ONE;
            switch (unit) {
                case WEEK: 
                case MICROSECOND: 
                case MILLISECOND: {
                    multiplier = BigDecimal.valueOf(1000L);
                    divider = unit.multiplier;
                    unit = TimeUnit.SECOND;
                    break;
                }
                case QUARTER: {
                    divider = unit.multiplier;
                    unit = TimeUnit.MONTH;
                }
            }
            SqlIntervalQualifier qualifier = new SqlIntervalQualifier(unit, null, SqlParserPos.ZERO);
            RexNode op2 = cx.convertExpression((SqlNode)call.operand(2));
            RexNode op1 = cx.convertExpression((SqlNode)call.operand(1));
            RelDataType intervalType = cx.getTypeFactory().createTypeWithNullability(cx.getTypeFactory().createSqlIntervalType(qualifier), op1.getType().isNullable() || op2.getType().isNullable());
            RexCall rexCall = (RexCall)rexBuilder.makeCall(intervalType, SqlStdOperatorTable.MINUS_DATE, ImmutableList.of(op2, op1));
            RelDataType intType = cx.getTypeFactory().createTypeWithNullability(cx.getTypeFactory().createSqlType(SqlTypeName.INTEGER), SqlTypeUtil.containsNullable(rexCall.getType()));
            RexNode e = rexBuilder.makeCast(intType, rexCall);
            return rexBuilder.multiplyDivide(e, multiplier, divider);
        }
    }

    private static class TimestampAddConvertlet
    implements SqlRexConvertlet {
        private TimestampAddConvertlet() {
        }

        @Override
        public RexNode convertCall(SqlRexContext cx, SqlCall call) {
            RexBuilder rexBuilder = cx.getRexBuilder();
            SqlLiteral unitLiteral = (SqlLiteral)call.operand(0);
            TimeUnit unit = unitLiteral.symbolValue(TimeUnit.class);
            return rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.DATETIME_PLUS, cx.convertExpression((SqlNode)call.operand(2)), rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.MULTIPLY, rexBuilder.makeIntervalLiteral(unit.multiplier, new SqlIntervalQualifier(unit, null, unitLiteral.getParserPosition())), cx.convertExpression((SqlNode)call.operand(1))));
        }
    }

    private class FloorCeilConvertlet
    implements SqlRexConvertlet {
        private FloorCeilConvertlet() {
        }

        @Override
        public RexNode convertCall(SqlRexContext cx, SqlCall call) {
            return StandardConvertletTable.this.convertFloorCeil(cx, call);
        }
    }

    private static class GreatestConvertlet
    implements SqlRexConvertlet {
        private GreatestConvertlet() {
        }

        @Override
        public RexNode convertCall(SqlRexContext cx, SqlCall call) {
            SqlBinaryOperator op;
            RexBuilder rexBuilder = cx.getRexBuilder();
            RelDataType type = cx.getValidator().getValidatedNodeType(call);
            switch (call.getKind()) {
                case GREATEST: {
                    op = SqlStdOperatorTable.GREATER_THAN;
                    break;
                }
                case LEAST: {
                    op = SqlStdOperatorTable.LESS_THAN;
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            List exprs = StandardConvertletTable.convertExpressionList(cx, call.getOperandList(), SqlOperandTypeChecker.Consistency.NONE);
            ArrayList<RexNode> list = new ArrayList<RexNode>();
            ArrayList<RexNode> orList = new ArrayList<RexNode>();
            for (RexNode expr : exprs) {
                orList.add(rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NULL, expr));
            }
            list.add(RexUtil.composeDisjunction(rexBuilder, orList));
            list.add(rexBuilder.makeNullLiteral(type));
            for (int i = 0; i < exprs.size() - 1; ++i) {
                RexNode expr;
                expr = (RexNode)exprs.get(i);
                ArrayList<RexNode> andList = new ArrayList<RexNode>();
                for (int j2 = i + 1; j2 < exprs.size(); ++j2) {
                    RexNode expr2 = (RexNode)exprs.get(j2);
                    andList.add(rexBuilder.makeCall((SqlOperator)op, expr, expr2));
                }
                list.add(RexUtil.composeConjunction(rexBuilder, andList, false));
                list.add(expr);
            }
            list.add((RexNode)exprs.get(exprs.size() - 1));
            return rexBuilder.makeCall(type, SqlStdOperatorTable.CASE, list);
        }
    }

    private static class TrimConvertlet
    implements SqlRexConvertlet {
        private final SqlTrimFunction.Flag flag;

        public TrimConvertlet(SqlTrimFunction.Flag flag) {
            this.flag = flag;
        }

        @Override
        public RexNode convertCall(SqlRexContext cx, SqlCall call) {
            RexBuilder rexBuilder = cx.getRexBuilder();
            RexNode operand = cx.convertExpression(call.getOperandList().get(0));
            return rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.TRIM, rexBuilder.makeFlag(this.flag), rexBuilder.makeLiteral(" "), operand);
        }
    }

    private static class AvgVarianceConvertlet
    implements SqlRexConvertlet {
        private final SqlKind kind;

        public AvgVarianceConvertlet(SqlKind kind) {
            this.kind = kind;
        }

        @Override
        public RexNode convertCall(SqlRexContext cx, SqlCall call) {
            SqlNode expr;
            assert (call.operandCount() == 1);
            Object arg = call.operand(0);
            switch (this.kind) {
                case AVG: {
                    expr = this.expandAvg((SqlNode)arg);
                    break;
                }
                case STDDEV_POP: {
                    expr = this.expandVariance((SqlNode)arg, true, true);
                    break;
                }
                case STDDEV_SAMP: {
                    expr = this.expandVariance((SqlNode)arg, false, true);
                    break;
                }
                case VAR_POP: {
                    expr = this.expandVariance((SqlNode)arg, true, false);
                    break;
                }
                case VAR_SAMP: {
                    expr = this.expandVariance((SqlNode)arg, false, false);
                    break;
                }
                default: {
                    throw Util.unexpected(this.kind);
                }
            }
            RelDataType type = cx.getValidator().getValidatedNodeType(call);
            RexNode rex = cx.convertExpression(expr);
            return cx.getRexBuilder().ensureType(type, rex, true);
        }

        private SqlNode expandAvg(SqlNode arg) {
            SqlParserPos pos = SqlParserPos.ZERO;
            SqlCall sum = SqlStdOperatorTable.SUM.createCall(pos, arg);
            SqlCall count = SqlStdOperatorTable.COUNT.createCall(pos, arg);
            return SqlStdOperatorTable.DIVIDE.createCall(pos, sum, count);
        }

        private SqlNode expandVariance(SqlNode arg, boolean biased, boolean sqrt) {
            SqlCall div;
            SqlCall denominator;
            SqlParserPos pos = SqlParserPos.ZERO;
            SqlCall argSquared = SqlStdOperatorTable.MULTIPLY.createCall(pos, arg, arg);
            SqlCall sumArgSquared = SqlStdOperatorTable.SUM.createCall(pos, argSquared);
            SqlCall sum = SqlStdOperatorTable.SUM.createCall(pos, arg);
            SqlCall sumSquared = SqlStdOperatorTable.MULTIPLY.createCall(pos, sum, sum);
            SqlCall count = SqlStdOperatorTable.COUNT.createCall(pos, arg);
            SqlCall avgSumSquared = SqlStdOperatorTable.DIVIDE.createCall(pos, sumSquared, count);
            SqlCall diff = SqlStdOperatorTable.MINUS.createCall(pos, sumArgSquared, avgSumSquared);
            if (biased) {
                denominator = count;
            } else {
                SqlNumericLiteral one = SqlLiteral.createExactNumeric("1", pos);
                denominator = SqlStdOperatorTable.MINUS.createCall(pos, count, one);
            }
            SqlCall result = div = SqlStdOperatorTable.DIVIDE.createCall(pos, diff, denominator);
            if (sqrt) {
                SqlNumericLiteral half = SqlLiteral.createExactNumeric("0.5", pos);
                result = SqlStdOperatorTable.POWER.createCall(pos, div, half);
            }
            return result;
        }
    }
}

