/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.functions.aggfunctions;

import java.math.BigInteger;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.functions.aggfunctions.BigIntegralAvgAccumulator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u000194Q!\u0001\u0002\u0002\u0002=\u0011\u0011DQ5h\u0013:$Xm\u001a:bY\u00063x-Q4h\rVt7\r^5p]*\u00111\u0001B\u0001\rC\u001e<g-\u001e8di&|gn\u001d\u0006\u0003\u000b\u0019\t\u0011BZ;oGRLwN\\:\u000b\u0005\u001dA\u0011!\u0002;bE2,'BA\u0005\u000b\u0003\u00151G.\u001b8l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001U\u0011\u0001cF\n\u0003\u0001E\u0001BAE\n\u0016G5\tA!\u0003\u0002\u0015\t\t\t\u0012iZ4sK\u001e\fG/\u001a$v]\u000e$\u0018n\u001c8\u0011\u0005Y9B\u0002\u0001\u0003\u00061\u0001\u0011\r!\u0007\u0002\u0002)F\u0011!\u0004\t\t\u00037yi\u0011\u0001\b\u0006\u0002;\u0005)1oY1mC&\u0011q\u0004\b\u0002\b\u001d>$\b.\u001b8h!\tY\u0012%\u0003\u0002#9\t\u0019\u0011I\\=\u0011\u0005\u0011*S\"\u0001\u0002\n\u0005\u0019\u0012!!\u0007\"jO&sG/Z4sC2\feoZ!dGVlW\u000f\\1u_JDQ\u0001\u000b\u0001\u0005\u0002%\na\u0001P5oSRtD#\u0001\u0016\u0011\u0007\u0011\u0002Q\u0003C\u0003-\u0001\u0011\u0005S&A\tde\u0016\fG/Z!dGVlW\u000f\\1u_J$\u0012a\t\u0005\u0006_\u0001!\t\u0001M\u0001\u000bC\u000e\u001cW/\\;mCR,GcA\u00195mA\u00111DM\u0005\u0003gq\u0011A!\u00168ji\")QG\fa\u0001G\u0005\u0019\u0011mY2\t\u000b]r\u0003\u0019\u0001\u0011\u0002\u000bY\fG.^3\t\u000be\u0002A\u0011\u0001\u001e\u0002\u000fI,GO]1diR\u0019\u0011g\u000f\u001f\t\u000bUB\u0004\u0019A\u0012\t\u000b]B\u0004\u0019\u0001\u0011\t\u000by\u0002A\u0011I \u0002\u0011\u001d,GOV1mk\u0016$\"!\u0006!\t\u000bUj\u0004\u0019A\u0012\t\u000b\t\u0003A\u0011A\"\u0002\u000b5,'oZ3\u0015\u0007E\"U\tC\u00036\u0003\u0002\u00071\u0005C\u0003G\u0003\u0002\u0007q)A\u0002jiN\u00042\u0001S'$\u001b\u0005I%B\u0001&L\u0003\u0011a\u0017M\\4\u000b\u00031\u000bAA[1wC&\u0011a*\u0013\u0002\t\u0013R,'/\u00192mK\")\u0001\u000b\u0001C\u0001#\u0006\u0001\"/Z:fi\u0006\u001b7-^7vY\u0006$xN\u001d\u000b\u0003cICQ!N(A\u0002\rBQ\u0001\u0016\u0001\u0005\u0002U\u000b!cZ3u\u0003\u000e\u001cW/\\;mCR|'\u000fV=qKV\ta\u000b\r\u0002XEB\u0019\u0001lX1\u000e\u0003eS!AW.\u0002\u0011QL\b/Z5oM>T!\u0001X/\u0002\r\r|W.\\8o\u0015\tq\u0006\"A\u0002ba&L!\u0001Y-\u0003\u001fQK\b/Z%oM>\u0014X.\u0019;j_:\u0004\"A\u00062\u0005\u0013\r\u001c\u0016\u0011!A\u0001\u0006\u0003I\"aA0%e!)Q\r\u0001D\u0001M\u0006\t\"/Z:vYR$\u0016\u0010]3D_:4XM\u001d;\u0015\u0005U9\u0007\"B\u001ce\u0001\u0004A\u0007CA5m\u001b\u0005Q'BA6L\u0003\u0011i\u0017\r\u001e5\n\u00055T'A\u0003\"jO&sG/Z4fe\u0002")
public abstract class BigIntegralAvgAggFunction<T>
extends AggregateFunction<T, BigIntegralAvgAccumulator> {
    @Override
    public BigIntegralAvgAccumulator createAccumulator() {
        return new BigIntegralAvgAccumulator();
    }

    public void accumulate(BigIntegralAvgAccumulator acc, Object value) {
        if (value != null) {
            long v = BoxesRunTime.unboxToLong((Object)value);
            acc.f0 = ((BigInteger)acc.f0).add(BigInteger.valueOf(v));
            acc.f1 = BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)acc.f1) + 1L));
        }
    }

    public void retract(BigIntegralAvgAccumulator acc, Object value) {
        if (value != null) {
            long v = BoxesRunTime.unboxToLong((Object)value);
            acc.f0 = ((BigInteger)acc.f0).subtract(BigInteger.valueOf(v));
            acc.f1 = BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)acc.f1) - 1L));
        }
    }

    @Override
    public T getValue(BigIntegralAvgAccumulator acc) {
        return BoxesRunTime.unboxToLong((Object)acc.f1) == 0L ? null : (T)this.resultTypeConvert(((BigInteger)acc.f0).divide(BigInteger.valueOf(BoxesRunTime.unboxToLong((Object)acc.f1))));
    }

    public void merge(BigIntegralAvgAccumulator acc, Iterable<BigIntegralAvgAccumulator> its) {
        for (BigIntegralAvgAccumulator a : its) {
            acc.f1 = BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)acc.f1) + BoxesRunTime.unboxToLong((Object)a.f1)));
            acc.f0 = ((BigInteger)acc.f0).add((BigInteger)a.f0);
        }
    }

    public void resetAccumulator(BigIntegralAvgAccumulator acc) {
        acc.f0 = BigInteger.ZERO;
        acc.f1 = BoxesRunTime.boxToLong((long)0L);
    }

    public TypeInformation<?> getAccumulatorType() {
        return new TupleTypeInfo(((Object)((Object)new BigIntegralAvgAccumulator())).getClass(), new TypeInformation[]{BasicTypeInfo.BIG_INT_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO});
    }

    public abstract T resultTypeConvert(BigInteger var1);
}

